-- 08/30/2007 - edited for zip utility. CR_45 --Ganesh
-- values(upper('lv_script_path'),'http://www.epa.gov/storpubl/modern/scripts/DW_storet_new.js','Warehouse Application','Java Script file URL');
-- 03/05/2009 - edited by Kevin Christian STORETK (Katrina) reference java script

spool mt_wh_config_procs.log

drop table mt_wh_config;

create table mt_wh_config
(parameter_name varchar2(256),
 Parameter_value varchar2(256),
 Application varchar2(256),
 Description varchar2(4000))
Tablespace storetdata
Storage(initial 256K next 256 k);

alter table mt_wh_config
add constraint pk_mt_wh_config primary Key (parameter_name)
using index 
tablespace storetindx
storage (initial 96K next 96k);

delete from mt_wh_config 
where parameter_name IN ('RUN_WATERSHED_REFRESH','ETL_FULL_LOAD','MAX_ACTIVITIES');

delete from mt_wh_config 
where application = 'Warehouse Application';



Insert into mt_wh_config  values ('RUN_WATERSHED_REFRESH' , 'YES' , 'STORETW', 'Warehouse Summary refresh processing Flag.');
Insert into mt_wh_config  values ('ETL_FULL_LOAD' , 'NO' , 'WQX_ETL', 'WQX ETL Full or Incremental Load Flag');
Insert into mt_wh_config  values ('MAX_ACTIVITIES' , '100' , 'STORET RESULT SERVICE', 'Used to implement pagination in STORET result web service');


-- CR_44


insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('lv_program_path'),'http://iaspub.epa.gov/stormoda/','Warehouse Application','Program Path URL');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('lv_script_path'),'http://www.epa.gov/storpubl/modern/scripts/DW_storet_new.js','Warehouse Application','Java Script file URL');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('lv_image_path'),'http://www.epa.gov/storpubl/modern/images/','Warehouse Application','Image file Location -- URL');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('lv_doc_path'),'http://www.epa.gov/storpubl/modern/doc/','Warehouse Application','Document file Location -- URL');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('lv_iodir'),'/public/data/storpubl/web/modern/downloads','Warehouse Application','File I.O. Location -- URL');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('lv_download_path'),'http://www.epa.gov/storpubl/modern/downloads/','Warehouse Application','File download Location -- URL');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('smtp_host'),'unixpub.epa.gov','Warehouse Application','Simple Mail Transfer Protocol Host name');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('smtp_port'),'25','Warehouse Application','Simple Mail Transfer Protocol Port number');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('GV_STN_Immediate_LMT'),'60000','Warehouse Application','Station Immediate download record limit');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('gv_stn_Overnight_lmt'),'600000','Warehouse Application','Station Overnight download record limit');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('gv_rslt_Immediate_lmt'),'300000','Warehouse Application','Result Immediate download record limit');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('gv_rslt_Overnight_lmt'),'600000','Warehouse Application','Result Overnight download record limit');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('gv_cmprs_fl_ext'),'zip','Warehouse Application','Compression file extension. Do NOT Change.');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('gv_overnight_hour'),'20','Warehouse Application','Overnight Batch processing hour. Valid values 0 - 24.');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('gv_pending_report_hr'),'6.00','Warehouse Application','Schedule time for generating Pending Report. Format: 24 hr. Valid values 0.00 to 23:59');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('gv_STORET_email'),'storet@epa.gov','Warehouse Application','STORET email address for reporting on Monthly stats, pending reports, etc.');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('national_project_criteria'),'4','Warehouse Application','Minimum number of Organizations to which a project should be associated to be classified as National Project.');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('gv_rslt_online_lmt'),'0','Warehouse Application','Result download limit for Online processing. DO NOT CHANGE');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
  values(upper('gv_stn_online_lmt'),'0','Warehouse Application','Station download limit for Online processing. DO NOT CHANGE');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
 values(upper('gv_metadata_flag'),'enable','Warehouse Application','Flag to control Metadata Report. Valid values: enable and disable.');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
 values(upper('gv_project_blob_flag'),'disable','Warehouse Application','Flag to control Project BLOBs download with Metadata report. Valid values: enable and disable.');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
 values(upper('warehouse_version'),'2.0.7.4','Warehouse Application','STORET Warehouse version.');

insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
 values(upper('Last_Update'),'Monday, September 3rd, 2007','Warehouse Application','STORET Warehouse Last Update Date.');

--cr_45
insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
 values(upper('STORETZIP'),'/public/data/storpubl/storetzip','Warehouse Application','STORET Warehouse compression utility.');


insert into mt_wh_config (PARAMETER_NAME,PARAMETER_VALUE,APPLICATION,DESCRIPTION)
 values(upper('FILE_READ_WAIT_SEC'),'3','Warehouse Application','File attribute read wait time. Increase this if download file is created but the status is set to Failed in DW_DATA_REQUESTS.');

commit;



















-------------------

CREATE OR REPLACE PROCEDURE Sp_Fetch_Config_Value(in_param IN VARCHAR2, out_param_value OUT VARCHAR2)
-- out_PROC_STATUS OUT NUMBER)
AS
LV_OUT_PARAM_VALUE VARCHAR2(256);
BEGIN
out_param_value := NULL;
SELECT parameter_value INTO LV_out_param_value FROM MT_WH_CONFIG
WHERE UPPER(TRIM(parameter_name))= UPPER(trim(in_param));

OUT_PARAM_VALUE:=LV_OUT_PARAM_VALUE;

-- out_PROC_STATUS:=0;

EXCEPTION
WHEN OTHERS THEN
out_PARAM_VALUE:='ERROR';

END;
/

grant execute on Sp_fetch_config_value to storetw_etl_role;
grant execute on Sp_fetch_config_value to storetw_etl;

grant select on mt_wh_config to storetw_etl_role;
grant select on mt_wh_config to storetw_etl;

/*  transferred them to a new script in the procedures folder.  CR_55
--
CREATE OR REPLACE PROCEDURE Sp_Post_Processing_For_Wqx_Etl(in_DUMMY_VAL IN NUMBER, out_PROC_STATUS OUT NUMBER)
AS
BEGIN
 out_PROC_STATUS:=0;
EXCEPTION
WHEN OTHERS THEN NULL;
END;
/

grant execute on Sp_Post_Processing_For_Wqx_Etl to storetw_etl_role;
grant execute on Sp_Post_Processing_For_Wqx_Etl to storetw_etl;

CREATE OR REPLACE PROCEDURE Sp_Pre_Processing_For_Wqx_Etl(in_DUMMY_VAL IN NUMBER, out_PROC_STATUS OUT NUMBER)
AS
BEGIN
 out_PROC_STATUS:=0;

EXCEPTION
WHEN OTHERS THEN
  out_PROC_STATUS:=9999;
  NULL;
END;
/

grant execute on Sp_Pre_Processing_For_Wqx_Etl to storetw_etl_role;
grant execute on Sp_Pre_Processing_For_Wqx_Etl to storetw_etl;
*/
spool off;

/*
DECLARE 
  IN_PARAM VARCHAR2(200);
  OUT_PARAM_VALUE varchar2(256);
  OUT_PROC_STATUS NUMBER;

BEGIN 
  IN_PARAM := 'ETL_FULL_LOAD';
  OUT_PARAM_VALUE := NULL;
  OUT_PROC_STATUS := NULL;

  STORETW_811.SP_FETCH_CONFIG_VALUE ( IN_PARAM, OUT_PARAM_VALUE, OUT_PROC_STATUS );

dbms_output.put_line('out_param_value='|| out_param_value ||'
out_proc_status='||out_proc_status);

END; 
*/
