/*******************************************************
Filename		:  project_rel_tables.sql
Release 		:  c2.0
SIR			:  1515
Description		:  create and populate station_project_table table.
Author			:  Joseph Wilson
Date			:  1/9/2003
			   7-01-2003 -- changed table names from CHEM to REGULAR
Comments		:  06/13/03 updated v2.0
			   07/16/2003 v2.0B - Added Habitat and Biological project tables. WN
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
		12/24/2006 -- modified for metadata CR
05/14/2007 - edited for station weights in station_project table.  CR -station weights and station web service.
**********************************************************/
SET TRANSACTION USE ROLLBACK SEGMENT RBSBIG;

SPOOL project_rel_tables.log

/*
drop table station_project;

create table station_project 
tablespace storetdata
storage (initial 5M next 5M)
nologging
as select pr.pk_isn fk_project, st.pk_isn fk_station
from di_project pr, storet1.tsmpsa psa, fa_station st
where pr.tsmproj_is_number = psa.tsmproj_is_number
and pr.tsmproj_org_id = psa.tsmproj_org_id
and tsmstatn_is_number = station_is_number
and tsmstatn_org_id = organization_id
and st.location_point_type = '*POINT OF RECORD';

commit;
*/

DROP TABLE STATION_PROJECT CASCADE CONSTRAINTS;
--
-- STATION_PROJECT  (Table) 
--
CREATE TABLE STATION_PROJECT
 ( FK_PROJECT NUMBER NOT NULL,
 FK_STATION NUMBER NOT NULL,
 STATION_WEIGHT VARCHAR2(256 CHAR),
 WEIGHT_UNIT_CODE VARCHAR2(256 CHAR),
 STRATUM VARCHAR2(256 CHAR),
 STATION_WEIGHT_CATEGORY VARCHAR2(256 CHAR),
 SITE_STATUS VARCHAR2(256 CHAR) )
TABLESPACE STORETDATA
storage (initial 10 M next 5M) NOLOGGING NOCACHE
/

COMMENT ON TABLE STATION_PROJECT IS 'Station and project association table';
COMMENT ON COLUMN STATION_PROJECT.FK_PROJECT IS 'Foreign Key referencing DI_PROJECT.';
COMMENT ON COLUMN STATION_PROJECT.FK_STATION IS 'Foreign Key referencing DI_STATION.';
COMMENT ON COLUMN STATION_PROJECT.STATION_WEIGHT IS 'Project station weight';
COMMENT ON COLUMN STATION_PROJECT.WEIGHT_UNIT_CODE IS 'Station weight unit code.';
COMMENT ON COLUMN STATION_PROJECT.STRATUM IS 'Station weight stratum';
COMMENT ON COLUMN STATION_PROJECT.STATION_WEIGHT_CATEGORY IS 'Station weight category';
COMMENT ON COLUMN STATION_PROJECT.SITE_STATUS IS 'Station weight site status';

-- populate table

commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
INSERT INTO STATION_PROJECT
 ( FK_PROJECT,
 FK_STATION,
 STATION_WEIGHT,
 WEIGHT_UNIT_CODE,
 STRATUM,
 STATION_WEIGHT_CATEGORY,
 SITE_STATUS)
select pr.pk_isn fk_project, st.pk_isn fk_station, 
  psw.weight station_weight,
  psw.WEIGHT_UNIT_CODE WEIGHT_UNIT_CODE,
  psw.STRATUM  STRATUM,
  psw.CATEGORY station_weight_CATEGORY,
  psw.SITE_STATUS SITE_STATUS
from di_project pr, storet1.tsmpsa psa, fa_station st, storet1.tsmpsw psw
where pr.tsmproj_is_number = psa.tsmproj_is_number
and pr.tsmproj_org_id = psa.tsmproj_org_id
and psa.tsmstatn_is_number = st.station_is_number
and psa.tsmstatn_org_id = st.organization_id
and st.location_point_type = '*POINT OF RECORD'
and psa.tsmproj_is_number = psw.tsmproj_is_number (+)
and psa.tsmproj_org_id = psw.tsmproj_org_id (+)
and psa.tsmstatn_is_number = psw.tsmstatn_is_number (+)
and psa.tsmstatn_org_id =psw.tsmstatn_org_id (+)
/

COMMIT;


drop table REGULAR_RESULT_PROJECT;

create table REGULAR_RESULT_PROJECT (
fk_project number(12),
fk_result number (12))
tablespace storetdata
storage(initial 25M next 25M minextents 2 maxextents 200)
nologging
pctfree 1;

-- ADDED HABITAT_RESULT_PROJECT
drop table HABITAT_RESULT_PROJECT;

create table HABITAT_RESULT_PROJECT (
fk_project number(12),
fk_result number (12))
tablespace storetdata
storage(initial 25M next 25M minextents 2 maxextents 200)
nologging
pctfree 1;
--
-- ADDED BIOLOGICAL_RESULT_PROJECT
drop table BIOLOGICAL_RESULT_PROJECT;

create table BIOLOGICAL_RESULT_PROJECT (
fk_project number(12),
fk_result number (12))
tablespace storetdata
storage(initial 25M next 25M minextents 2 maxextents 200)
nologging
pctfree 1;
--

set serveroutput on
DECLARE

cursor orgs is
	select organization_id
	from di_org;

BEGIN

FOR v_org in orgs loop

Insert into REGULAR_RESULT_PROJECT 
select pr.pk_isn fk_project, re.pk_isn fk_result
from di_project pr, storet1.tsrfapra fap, FA_REGULAR_RESULT re
where pr.tsmproj_is_number = fap.tsmproj_is_number
and pr.tsmproj_org_id = fap.tsmproj_org_id
and fap.tsrfdact_is_number = re.activity_is_number
and fap.tsrfdact_org_id = re.organization_id
and organization_id = v_org.organization_id;

commit;
--
-- LOAD HABITAT RESULT_PROJECT
Insert into HABITAT_RESULT_PROJECT 
select pr.pk_isn fk_project, re.pk_isn fk_result
from di_project pr, storet1.tsrfapra fap, FA_HABITAT_RESULT re
where pr.tsmproj_is_number = fap.tsmproj_is_number 
and pr.tsmproj_org_id = fap.tsmproj_org_id
and fap.tsrfdact_is_number = re.activity_is_number
and fap.tsrfdact_org_id = re.organization_id
and organization_id = v_org.organization_id;

commit;
--
-- LOAD BIOLOGICAL RESULT_PROJECT
Insert into BIOLOGICAL_RESULT_PROJECT 
select pr.pk_isn fk_project, re.pk_isn fk_result
from di_project pr, storet1.tsrfapra fap, FA_BIOLOGICAL_RESULT re
where pr.tsmproj_is_number = fap.tsmproj_is_number 
and pr.tsmproj_org_id = fap.tsmproj_org_id
and fap.tsrfdact_is_number = re.activity_is_number
and fap.tsrfdact_org_id = re.organization_id
and organization_id = v_org.organization_id;

commit;

END LOOP;
END;
/

CREATE INDEX ISP_FK_FA_STATN ON STATION_PROJECT(FK_STATION)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX ISP_FK_PROJECT ON STATION_PROJECT(FK_PROJECT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IRP_FK_RESULT ON REGULAR_RESULT_PROJECT(FK_RESULT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IRP_FK_PROJECT ON REGULAR_RESULT_PROJECT(FK_PROJECT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IRP_FK_PROJECT_RESULT ON REGULAR_RESULT_PROJECT(FK_PROJECT,fk_result)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;
--
CREATE INDEX IHP_FK_RESULT ON HABITAT_RESULT_PROJECT(FK_RESULT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IHP_FK_PROJECT ON HABITAT_RESULT_PROJECT(FK_PROJECT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IHP_FK_PROJECT_RESULT ON HABITAT_RESULT_PROJECT(FK_PROJECT,fk_result)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;
--
--
CREATE INDEX IBP_FK_RESULT ON BIOLOGICAL_RESULT_PROJECT(FK_RESULT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IBP_FK_PROJECT ON BIOLOGICAL_RESULT_PROJECT(FK_PROJECT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IBP_FK_PROJECT_RESULT ON BIOLOGICAL_RESULT_PROJECT(FK_PROJECT,fk_result)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;
--
--add constraints
alter table REGULAR_RESULT_PROJECT 
add constraint re_proj_fk_result foreign key (fk_result) references FA_REGULAR_RESULT(pk_isn);

alter table REGULAR_RESULT_PROJECT 
add constraint re_proj_fk_project foreign key (fk_project) references di_project(pk_isn);
--
alter table HABITAT_RESULT_PROJECT 
add constraint hb_proj_fk_result foreign key (fk_result) references FA_HABITAT_RESULT(pk_isn);

alter table HABITAT_RESULT_PROJECT 
add constraint hb_proj_fk_project foreign key (fk_project) references di_project(pk_isn);
--
alter table BIOLOGICAL_RESULT_PROJECT 
add constraint bi_proj_fk_result foreign key (fk_result) references FA_BIOLOGICAL_RESULT(pk_isn);

alter table BIOLOGICAL_RESULT_PROJECT 
add constraint bi_proj_fk_project foreign key (fk_project) references di_project(pk_isn);

--drop columns from di_project -- sug undone for metadata CR
--alter table di_project drop column tsmproj_is_number;
--alter table di_project drop column tsmproj_org_id;

SET TRANSACTION USE ROLLBACK SEGMENT RBSBIG;
UPDATE FA_REGULAR_RESULT RE SET PROJECT_ID =
	(SELECT max(pr.PROJECT_CD)
	from di_project pr, REGULAR_RESULT_PROJECT rrp
	WHERE re.pk_isn = rrp.fk_result
	AND pr.pk_isn = rrp.fk_project
	AND pr.PROJECT_CD <> 'EPABEACH'
	);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT RBSBIG;
UPDATE FA_HABITAT_RESULT RE SET PROJECT_ID =
	(SELECT max(pr.PROJECT_CD)
	from di_project pr, HABITAT_RESULT_PROJECT hrp
	WHERE re.pk_isn = hrp.fk_result
	AND pr.pk_isn = hrp.fk_project
	AND pr.PROJECT_CD <> 'EPABEACH'
	);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT RBSBIG;
UPDATE FA_BIOLOGICAL_RESULT RE SET PROJECT_ID =
	(SELECT max(pr.PROJECT_CD)
	from di_project pr, BIOLOGICAL_RESULT_PROJECT brp
	WHERE re.pk_isn = brp.fk_result
	AND pr.pk_isn = brp.fk_project
	AND pr.PROJECT_CD <> 'EPABEACH'
	);
commit;

SPOOL OFF