/*******************************************************
Filename		:  statn_types_tables.sql
Release 		:  c2.0
SIR			:  1364, 1481
Description		:  Station types dimension tables and related objects.
Author			:  Ganesh Thadkamalla
Date			:  10/01/2002.
Comments		:  11/26/2002 - Dropped lu_geo_country table and its associations. G.Thadkamalla.
			:  07/17/2003 Add SGO_indicator and change new order. Thieu.
			:  07/21/2003 Update FA_STATION with SGO Indicator from Station Type. WN. 
		tir 1	:  08/20/2003 Decode for 'Waste sewer' had a capital 'S' for Sewer which was incorrect  WN. 
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
**********************************************************/
set echo on;
spool  statn_types_tables.log

drop sequence seq_statn_types;
create sequence seq_statn_types 
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_statn_types;
CREATE TABLE di_statn_types
(PK_ISN           NUMBER(12,0),
 PRIMARY_TYPE     VARCHAR2(256) NOT NULL,
 SECONDARY_TYPE   VARCHAR2(256),
 SORT_ORDER       NUMBER,
 SGO_INDICATOR    CHAR(1));


alter table di_statn_types
add constraint pk_statn_types primary key (pk_isn)
using index
tablespace STORETINDX
storage (initial  100K next 100K)
nologging;


set serveroutput on
declare
cursor c1 is select distinct primary_type,secondary_type from fa_station sd;

lv_sgo_indicator char(1 char);
lv_sort_order number;

begin
for c1_var in c1 loop

  lv_sort_order:=null; 
  lv_sgo_indicator:=null;

  begin
  select sort_order, attr_1 into lv_sort_order, lv_sgo_indicator
  from mt_attribute_map
  where mapping_field='STATION_TYPES'
    and wqx_name=c1_var.primary_type;
  exception when others then
    lv_sort_order:=null; 
    lv_sgo_indicator:=null;
  end;

insert into di_statn_types (pk_isn,primary_type,secondary_type,sort_order,SGO_INDICATOR)
values(seq_statn_types.nextval,c1_var.primary_type,c1_var.secondary_type,lv_sort_order, lv_sgo_indicator);

end loop;
commit;
end;
/

create index istatn_type01 on di_statn_types(primary_type,secondary_type)
tablespace STORETINDX
storage (initial 100K next 100K)
nologging;

create index istatn_type02 on di_statn_types(sort_order)
tablespace STORETINDX
storage (initial 96K next 96K)
nologging;

-- add fk to fa_station

alter table fa_station
add (fk_statn_types number(12,0));

--update fks in fa_station

declare
cursor c1 is select pk_isn fk_statn_types, PRIMARY_TYPE, SECONDARY_TYPE 
from di_statn_types ;

begin
for c1_var in c1 loop
update fa_station 
set fk_statn_types = c1_var.fk_statn_types
where PRIMARY_TYPE = c1_var.PRIMARY_TYPE
 and ( SECONDARY_TYPE = c1_var.SECONDARY_TYPE
  or secondary_type is null);
end loop;
commit;

end;
/
--SGO Indicator update FA_STATION
UPDATE FA_STATION RE SET SGO_INDICATOR =
	(SELECT SGO.SGO_INDICATOR
	FROM di_statn_types SGO
	WHERE re.fk_statn_types = SGO.pk_isn );
commit;

--fks in fa_station
alter table fa_station
add constraint fk_sd_statn_types foreign key (fk_statn_types) references di_statn_types(pk_isn);

--indexes on fks in fa_station
create index isd_sd_fk_statn_types on fa_station(fk_statn_types)
tablespace STORETINDX
storage (initial 512K next 512K)
nologging;

spool off;