/*******************************************************
Filename		:  DW_PERMISSIONS.sql
Release 		:  C2.0.2
SIR			:  1559, 1557
Description		:  Grants system privileges for web procedures.
Author			:  Joseph Wilson
Date			:  11/04/2002
			   06/17/2003 -- added result application pages
			   08/05/2003 -- added new procs since last 1.1 beta
			   08/11/2003 -- added act medium and community sampled-act intent -JW
			   11/10/2003 -- added blob and zip download pages; added JAVA permissions -JW
			   11/14/2003 -- added new JAVA permissions -JW
			   11/17/2003 -- added DW_result_download_zip and DW_station_download_zip -JW
			   01/22/2004 -- SIR 1586 - seperated grants, synonmys, and permissions into 3 scripts -JW
  12/24/2006 -- added permissions for tar utility - GT
--08/30/2007 -- added storetzip --GT.
Comments		:  
**********************************************************/
SPOOL DW_PERMISSIONS.LOG

--CONNECT system/*****@storet.sdc
--Grant JAVA permissions to run GZIP
/*  These grants are not necessary and are replaced by grant on storetzip.
EXEC Dbms_Java.Grant_Permission( -
'STORETW', -
'java.io.FilePermission', -
'/bin/gzip', -
'execute');

EXEC Dbms_Java.Grant_Permission( -
'STORETW', -
'java.io.FilePermission', -
'/bin/cp', -
'execute');

EXEC Dbms_Java.Grant_Permission( -
'STORETW', -
'java.io.FilePermission', -
'/bin/tar', -
'execute');
*/

-- grant java permissions to storetzip custom script to storetw;
-- edit the location of the script if necessary.
EXEC Dbms_Java.Grant_Permission( -
'STORETW', -
'java.io.FilePermission', -
'/public/data/storpubl/storetzip', -
'execute');

--Grant JAVA permissions to report directory
EXEC Dbms_Java.Grant_Permission( -
'STORETW', -
'java.io.FilePermission', -
'/project/storet/modern/downloads/*', -
'read ,write, delete');


grant javauserpriv to storetw;

/**
--Grant JAVA permissions to report directory --DEV
EXEC Dbms_Java.Grant_Permission( -
'WEB_USER', -
'java.io.FilePermission', -
'/project/storet/moderndev/downloads/*', -
'read ,write, execute, delete');
**/

-- 10/22/2009 MDSYS (spatial objects access)
revoke dba from storetw;


SPOOL OFF