set def off;
/*******************************************************
Filename		:  	DW_bottom_of_page.sql
Release 		:  	c2.0, C2.0.4, c2.0.6
SIR			:  	
Description		:  	Creates the standard footer for all pages of the Station
				Warehouse web application. 
Author			:  	Joseph Wilson
Date			: 	November 12, 2002; December 5, 2002
				5/2/2003 -- Added tabindex for the Help link. -C Tsang
				8/22/2003 -- Hard coded page last updated date -J Wilson
				11/07/2003 -- updated date for 2.0.1 release -J Wilson
				7/21/2004 -- updated date for 2.0.3 release -J Wilson
	02/28/2005 -- updated date for 2.0.4 release - GT
	12/24/2006 - updated date for 2.0.6 release -GT
        08/09/2007 -edited for last update date parameterization.  This value is read from mt_wh_config table. - Ganesh
Comments		:  	Utilizes the EPA Standard Web Template (no sidebar)
**********************************************************/

CREATE or REPLACE PROCEDURE DW_bottom_of_page (
help_counter number default 9999
)
AS
	help_file         varchar2(100);
lv_last_update varchar2(256):=null;

BEGIN

--fetch last update from mt_wh_config table
begin
Sp_Fetch_Config_Value('LAST_UPDATE', lv_last_update);
exception when others then
null;
end;
--Generate Help File link
help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||help_counter||'''';

--EPA Standard Footer
htp.print('
      <!-- #EndEditable --> 
			<!-- END CONTENT AREA -->
			<p align="right"><A tabindex="999" HREF="javascript:openHelp('||help_file||')">Help</A></p>
		</td>
	</tr>
</table>
<table width="95%" border="0" cellspacing="0" cellpadding="0">
	<tr> 
		<td valign="top" align="center" rowspan="4"><img src="http://www.epa.gov/epafiles/images/epafiles_misc_space.gif" 
		width="5" height="5" alt="" /></td>
		<td valign="top" width="100%" align="center"> 
			<!-- BEGIN AREA FOOTER -->
			<!-- ADD LINKS AND TEXT FOR AREA FOOTER WITHIN THIS PARAGRAPH TAG -->
			<p class="epaFooterText" align="center"></p>
			<!-- END AREA FOOTER -->
		</td>
	</tr>
	<tr> 
		<td valign="top" width="100%" align="center">&nbsp;</td>
	</tr>
	<tr> 
		<td valign="top" width="100%" align="center"> 
			<!-- BEGIN FOOTER IMAGE -->
			<img src="http://www.epa.gov/epafiles/images/epafiles_misc_dot_dkblue.gif" 
		width="460" height="4" vspace="2" alt="Begin Site Footer" /> 
			<!-- END FOOTER IMAGE -->
		</td>
	</tr>
	<tr> 
		<td valign="top" width="100%" align="center"> 
			<!-- BEGIN GLOBAL FOOTER -->
			<p class="epaFooterText"><a href="http://www.epa.gov/">EPA Home</a> 
				| <a href="http://www.epa.gov/epafiles/usenotice.htm">Privacy 
				and Security Notice</a> | <a href="http://www.epa.gov/storet/contact.html">Contact Us</a></p>
			<p class="epaFooterText"> <epadateurl> 
				<!-- <script language="JavaScript" src="http://www.epa.gov/epafiles/scripts/dateurl.js"> -->
			<script language="JavaScript">
document.write("Last updated on '|| lv_last_update ||' <br />");

// First, strip off any URL variables
var URLAddress = location.href.substring(0,(location.href.indexOf("?")>0)?location.href.indexOf("?"):location.href.length)

// Remove characters outisde the printable range as well as "<" and ">" which may indicate tags.
var newAddress = '''';
for (i=0;i<URLAddress.length;i++)
{
 if ((URLAddress.charCodeAt(i) > 31 || URLAddress.charCodeAt(i) < 127) && URLAddress.charAt(i) != ''>'' && URLAddress.charAt(i) != ''<'')
  newAddress = newAddress + URLAddress.charAt(i);
}

// write cleaned URL
document.write("URL: " + newAddress);

			</script>
				</epadateurl></p>
			<p>&nbsp;</p>
			<!-- END GLOBAL FOOTER -->
		</td>
	</tr>
</table>
<p>&nbsp;</p>
</body>
</html>
');
END;
/
Show Errors;