/*******************************************************
Filename		:  	DW_hab_result_criteria_geo.sql
Release 		:  	STORET c2.0
SIR			:  	1503
Description		:  	Creates a centralized form page that allows the user to select 
				all the most common parameters to query Habitat Results. This information
				is passed to the DW_result_count procedure.
Author			:  	Joseph Wilson/Christine Tsang
Date			: 	July 22, 2003  -- created based on DW_result_criteria_geo
                        08/15/2003 -- Replaced the word 'BETA' with 'Habitat'. -C Tsang
                        08/22/2003 -- SIR 1500 TIR#1 - Removed hidden variable D_ORG_LIST. -CT
 	12/13/2006 -- ESE-WQX_CR_6 - added station types filter. - Suganthi
Comments		:  	Calls three pop-up screens that allow the user to enter additional
				information.
**********************************************************/
SET DEF OFF;

CREATE OR REPLACE PROCEDURE DW_HAB_ResultCriteria_GEO AS

--sug added the cursor station type
CURSOR cstation_type IS
SELECT primary_type,secondary_type, PK_ISN, sort_order
FROM DI_STATN_TYPES
order by sort_order,primary_type,secondary_type;
--

--used to generate state list
CURSOR cstate IS
SELECT pk_isn, state_name
FROM DI_GEO_STATE
order by country_code desc, state_name;

program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  := 'Habitat Results by Geographic Location';

BEGIN
DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path,'document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);adjust_width_n(document.forms[1].D_STYPE_LIST,"~","61~5","None","Y");');
htp.print('<form action="DW_RESULT_COUNT" method=POST>');

-- Geographic location selection
DW_geo_select;

-- sug added Station types
-- Station Type selection
htp.print ('
<h4>Station Type</h4>
<table BORDER COLS=1 WIDTH="100%">
<tr><td align="center">
Select one or more Station Type(s)
<BR>
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="PRIMARY_TYPE                         SECONDARY_TYPE" size="69"  onFocus="javascript:this.blur()">
<BR>
<FONT face="Courier">
<SELECT NAME="D_STYPE_LIST" SIZE="10"  MULTIPLE style="font: 10pt/12pt COURIER" tabindex=15>
<OPTION SELECTED  value="ALL">Select All_________________________________________________________');

    for cstype_var in cstation_type  LOOP
    
      htp.formSelectOption(cstype_var.PRIMARY_TYPE||'~'||cstype_var.SECONDARY_TYPE, cattributes => 'value= '||cstype_var.PK_ISN);
    END LOOP;

htp.print('</SELECT>
<BR>
</TD>
</TR>
</TABLE>');
--****

-- Date range selection 
DW_date_select(15);

-- Characteristics selection
DW_char_select(39);

htp.print('
<input type="hidden" name="RESULT_TYPE" value="HABITAT">
<br>
<center>
<input type="button" value="Continue" tabindex=45 onclick="javascript: submitCriteriaResultGeo();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
<input type="button" value="Clear Form" tabindex=46 onclick="javascript: deleteAllFromCharList();document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);" title="Clear the form">
</center></form>
');
DW_bottom_of_page(21);

END;
/
SHOW ERRORS;
