/*******************************************************
Filename	:  	DW_record_data_request.sql
Release 	:  	STORET c2.0.4, C2.0.5
SIR		:  	1631,1633
Description	:  	Records data download request in dw_data_requests table.  It checks for filters used in the query by evaluating p_filters parameter before recording the request.  The description of input parameters are as follows:
  p_filters: Tilda separated list of filters used in the query with a leading tilda.
  p_filetype: Type of download (currently we have SDS, SDR, SDB, SDH).
  p_timestamp: Timestamp used in creating the download file (YYYYMMDD_HH24MISS).
  p_file_length: Download filesize in kilobytes.
Author	:  	Ganesh Thadkamalla
Date		: 	12/02/2004
    12/15/2004 - Added Peer Review comments. - GT
    07/17/2005 - Modified to accomodate Overnight/Immediate Batch related attributes. -GT.
  01/01/2007 -- edited for ALLRESULTS -GT. 

Comments	: 	This script should be run before DW_station_hub_custom.sql and DW_result_hub_custom.sql scripts, and after dw_data_request_data.sql.
***********************************************************/
--spool dw_record_data_request.sql
show user;
CREATE OR REPLACE
procedure         dw_record_data_request
	(p_filters in varchar2,
	 p_filetype in varchar2,
	 p_timestamp in varchar2,
	 p_file_length in number,
         P_record_title in varchar2 default null,
         p_request_mode in varchar2 default 'Online',
         p_email     in varchar2 default null,
         p_query     in varchar2 default null,
		 pR_query     in varchar2 default null,
		 pB_query     in varchar2 default null,
		 pH_query     in varchar2 default null,
		 p_filename  in varchar2 default null,
         p_record_count in number default null,
         p_request_id out number ,
 		 P_rrecord_title in varchar2 default null,
		 P_brecord_title in varchar2 default null,
		 P_hrecord_title in varchar2 default null,
                 p_reg_data in varchar2 default null,
                 p_bio_data in varchar2 default null,
                 p_hab_data in varchar2 default null)
as
-- added pR-query, pB_query, pH_query to the input parameters.
--Declare local variables.
-- flags for report type checkbox values
lv_REG_DATA_FLAG        dw_data_requests.REG_DATA_FLAG%type;
lv_BIO_DATA_FLAG        dw_data_requests.BIO_DATA_FLAG%type;
lv_HAB_DATA_FLAG        dw_data_requests.HAB_DATA_FLAG%type;
-- end of flag declaration for checkboxes
lv_REQUEST_TYPE      	dw_data_requests.REQUEST_TYPE%type;
lv_DATETIME             dw_data_requests.DATETIME%type;
lv_FILESIZE_kb          dw_data_requests.FILESIZE_kb%type;
lv_F_STATE              dw_data_requests.F_STATE%type;
lv_F_COUNTY             dw_data_requests.F_COUNTY%type;
lv_F_LATLONG            dw_data_requests.F_LATLONG%type;
lv_F_HUC                dw_data_requests.F_HUC%type;
lv_F_STATIONTYPE        dw_data_requests.F_STATIONTYPE%type;
lv_F_CHARACTERISTIC     dw_data_requests.F_CHARACTERISTIC%type;
lv_F_ORGANIZATION       dw_data_requests.F_ORGANIZATION%type;
lv_F_STATION            dw_data_requests.F_STATION%type;
lv_f_act_StartDate	dw_data_requests.f_act_startdate%type;
lv_f_act_medium 	dw_data_requests.f_act_medium%type;
lv_f_project		dw_data_requests.f_project%type;
lv_f_act_intent		dw_data_requests.f_act_intent%type;
lv_f_Community_sampled	dw_data_requests.f_community_sampled%type;

lv_f_Chartype	dw_data_requests.f_Chartype%type;

lv_REQUEST_MODE   dw_data_requests.REQUEST_MODE%type;
lv_REQUEST_STATUS   dw_data_requests.REQUEST_STATUS%type;
lv_EMAIL_ADDRESS    dw_data_requests.EMAIL_ADDRESS%type;
lv_NOTIFIED         dw_data_requests.NOTIFIED%type;
lv_QUERY_TEXT       dw_data_requests.QUERY_TEXT%type;
lv_QUERY_TEXT2       dw_data_requests.QUERY_TEXT2%type;
--WShed summary
lvR_QUERY_TEXT       dw_data_requests.RQUERY_TEXT%type;
lvR_QUERY_TEXT2       dw_data_requests.RQUERY_TEXT2%type;
lvB_QUERY_TEXT       dw_data_requests.BQUERY_TEXT%type;
lvB_QUERY_TEXT2       dw_data_requests.BQUERY_TEXT2%type;
lvH_QUERY_TEXT       dw_data_requests.HQUERY_TEXT%type;
lvH_QUERY_TEXT2       dw_data_requests.HQUERY_TEXT2%type;


lv_FILENAME         dw_data_requests.FILENAME%type;
lv_RECORD_COUNT     dw_data_requests.RECORD_COUNT%type;
lv_record_title     dw_data_requests.record_title%type;



--add a trailing ~ to p_filters to make search easier.
lv_filters varchar2(1000) :=p_filters||'~';
lv_request_id dw_data_requests.request_id%type;

begin
--initialize local variables.  Some of them represent filters and rest are report details.
lv_REQUEST_TYPE     	:=p_filetype;
lv_DATETIME     	:=  to_date(p_timestamp,'YYYYMMDD_HH24MISS');
lv_FILESIZE_kb          :=p_file_length;
lv_F_STATE              :=0;
lv_F_COUNTY             :=0;
lv_F_LATLONG            :=0;
lv_F_HUC                :=0;
lv_F_STATIONTYPE        :=0;
lv_F_CHARACTERISTIC     :=0;
lv_F_ORGANIZATION       :=0;
lv_F_STATION            :=0;

lv_f_act_StartDate	:=0;
lv_f_act_medium 	:=0;
lv_f_project		:=0;
lv_f_act_intent		:=0;
lv_f_Community_sampled	:=0;
lv_f_chartype:=0;

lv_REQUEST_MODE := p_request_mode;
lv_REQUEST_STATUS  := 'New';
lv_EMAIL_ADDRESS   :=p_email;
lv_NOTIFIED        := 'N';
lv_QUERY_TEXT      := substr(p_query,1,4000);
lv_QUERY_TEXT2      := substr(p_query,4001,8000);


lvR_QUERY_TEXT      := substr(pR_query,1,4000);
lvR_QUERY_TEXT2      := substr(pR_query,4001,8000);

lvB_QUERY_TEXT      := substr(pB_query,1,4000);
lvB_QUERY_TEXT2      := substr(pB_query,4001,8000);

lvH_QUERY_TEXT      := substr(pH_query,1,4000);
lvH_QUERY_TEXT2      := substr(pH_query,4001,8000);

lv_FILENAME        := p_filename;
lv_RECORD_COUNT   := p_record_count;
lv_record_title   := p_record_title;

lv_REG_DATA_FLAG := p_reg_data;
lv_BIO_DATA_FLAG := p_bio_data;
lv_HAB_DATA_FLAG := p_hab_data;

--Set local variables with appropriate data for different request modes.
if p_request_mode = 'Online' then
  lv_REQUEST_MODE := p_request_mode;
  lv_REQUEST_STATUS    :=  null;
  lv_EMAIL_ADDRESS     :=  null;
  lv_QUERY_TEXT        :=  null;
  lv_QUERY_TEXT2        :=  null;
  lvR_QUERY_TEXT        :=  null;
  lvR_QUERY_TEXT2        :=  null;
  lvB_QUERY_TEXT        :=  null;
  lvB_QUERY_TEXT2        :=  null;
  lvH_QUERY_TEXT        :=  null;
  lvH_QUERY_TEXT2        :=  null;
  lv_FILENAME          :=  null;
  lv_RECORD_COUNT      :=  null;
  lv_NOTIFIED          :=  null;
  lv_record_title      := null;
elsif p_request_mode in ('Immediate','Overnight') then
  lv_REQUEST_MODE := p_request_mode;
  lv_REQUEST_STATUS  := 'New';
  lv_EMAIL_ADDRESS   :=p_email;
  lv_NOTIFIED        := 'N';


lv_QUERY_TEXT      := substr(p_query,1,4000);
lv_QUERY_TEXT2      := substr(p_query,4001,8000);

lvR_QUERY_TEXT      := substr(pR_query,1,4000);
lvR_QUERY_TEXT2      := substr(pR_query,4001,8000);

lvB_QUERY_TEXT      := substr(pB_query,1,4000);
lvB_QUERY_TEXT2      := substr(pB_query,4001,8000);

lvH_QUERY_TEXT      := substr(pH_query,1,4000);
lvH_QUERY_TEXT2      := substr(pH_query,4001,8000);

  lv_FILENAME        := p_filename;
  lv_RECORD_COUNT   := p_record_count;
  lv_record_title   := p_record_title;
end if;

-- Review lv_filters parameter and flag local filter variables.  These variables will be used for recording in a table.
-- If no filters are used during the search, then p_filters and lv_filters will have values of '~' and '~~' respectively.  Hence, perform the filter identification only if the length of lv_filters is greater than 2.

if length(lv_filters)  > 2 then
--  htp.print('filters used : '||p_filters);
  if instr(lv_filters,'~State~') > 0 then
    lv_f_state:=1;
  end if;
  if instr(lv_filters,'~County~') > 0 then
    lv_f_county:=1;
  end if;
  if instr(lv_filters,'~LatLong~') > 0 then
    lv_f_latlong:=1;
  end if;
  if instr(lv_filters,'~HUC~') > 0 then
    lv_f_huc:=1;
  end if;
  if instr(lv_filters,'~StationType~') > 0 then
    lv_f_stationtype:=1;
  end if;
  if instr(lv_filters,'~Characteristic~') > 0 then
    lv_f_Characteristic:=1;
  end if;
  if instr(lv_filters,'~Organization~') > 0 then
    lv_f_Organization:=1;
  end if;
  if instr(lv_filters,'~Stations~') > 0 then
    lv_f_Station:=1;
  end if;
  if instr(lv_filters,'~Act_StartDate~') > 0 then
    lv_f_act_StartDate:=1;
  end if;
  if instr(lv_filters,'~Act_Medium~') > 0 then
    lv_f_act_medium:=1;
  end if;
  if instr(lv_filters,'~Project~') > 0 then
    lv_f_project:=1;
  end if;
  if instr(lv_filters,'~Act_Intent~') > 0 then
    lv_f_act_intent:=1;
  end if;
  if instr(lv_filters,'~CommunitySampled~') > 0 then
    lv_f_Community_sampled:=1;
  end if;
  if instr(lv_filters,'~Chartype~') > 0 then
    lv_f_Chartype:=1;
  end if;


end if;
htp.br;

select seq_dw_data_request_id.nextval into lv_request_id from dual;

-- Insert record into dw_data_requests.
insert into dw_data_requests
( request_id,
  REQUEST_TYPE       ,
  DATETIME           ,
  FILESIZE_KB        ,
  F_STATE            ,
  F_COUNTY           ,
  F_LATLONG          ,
  F_HUC              ,
  F_STATIONTYPE      ,
  F_CHARACTERISTIC   ,
  F_ORGANIZATION     ,
  F_STATION          ,
  f_act_StartDate    ,
  f_act_medium 	     ,
  f_project	     ,
  f_act_intent	     ,
  f_Community_sampled,
  REQUEST_MODE       ,
  REQUEST_STATUS     ,
  EMAIL_ADDRESS      ,
  QUERY_TEXT         ,
  QUERY_TEXT2         ,
  RQUERY_TEXT         ,
  RQUERY_TEXT2         ,
  BQUERY_TEXT         ,
  BQUERY_TEXT2         ,
  HQUERY_TEXT         ,
  HQUERY_TEXT2         ,
  FILENAME           ,
  RECORD_COUNT       ,
  Notified           ,
  RECORD_TITLE   ,
  R_RECORD_TITLE   ,
  B_RECORD_TITLE   ,
  H_RECORD_TITLE   ,
  f_Chartype  ,
  REG_DATA_FLAG  ,
  BIO_DATA_FLAG  ,
  HAB_DATA_FLAG)
values(lv_request_id,
  lv_REQUEST_TYPE     ,
  lv_DATETIME         ,
  lv_FILESIZE_kb      ,
  lv_F_STATE          ,
  lv_F_COUNTY         ,
  lv_F_LATLONG        ,
  lv_F_HUC            ,
  lv_F_STATIONTYPE    ,
  lv_F_CHARACTERISTIC ,
  lv_F_ORGANIZATION   ,
  lv_F_STATION        ,
  lv_f_act_StartDate  ,
  lv_f_act_medium     ,
  lv_f_project	      ,
  lv_f_act_intent     ,
  lv_f_Community_sampled ,
  lv_REQUEST_MODE       ,
  lv_REQUEST_STATUS     ,
  lv_EMAIL_ADDRESS      ,
  lv_QUERY_TEXT         ,
  lv_QUERY_TEXT2         ,
  lvR_QUERY_TEXT         ,
  lvR_QUERY_TEXT2         ,
  lvB_QUERY_TEXT         ,
  lvB_QUERY_TEXT2         ,
  lvH_QUERY_TEXT         ,
  lvH_QUERY_TEXT2         ,
  lv_FILENAME           ,
  lv_RECORD_COUNT       ,
  lv_NOTIFIED           ,
  lv_RECORD_TITLE,
  p_Rrecord_title,
  P_Brecord_title,
  p_Hrecord_title,
  lv_f_Chartype,
  lv_REG_DATA_FLAG,
  lv_BIO_DATA_FLAG,
  lv_HAB_DATA_FLAG);

commit;
p_request_id := lv_request_id;

end;
/
show errors;
