/*******************************************************
Filename		:  	DW_result_criteria_geo.sql
Release 		:  	STORET c2.0
SIR			:  	1435, 1437, 1439, 1440, 1441
Description		:  	Creates a centralized form page that allows the user to select 
				all the most common parameters to query Results. This information
				is passed to the DW_result_count procedure.
Author			:  	Joseph Wilson/Christine Tsang
Date			: 	March 3, 2003  --added new CHAR section, commented out proj and org sections
                        	03/12/2003 - Added 3 more date ranges. -C Tsang
				03/18/2003 - Replaced hard-coded date logic with call to DW_DISPLAY_CALENDAR.
						  -C Tsang
				03/24/2003 - Updated table and column names to work with updated ETL. -J Wilson
				04/10/2003 - Set up tabbing sequence.
				04/14/2003 - Reset Date fields with JavaScript. -J Wilson
				04/24/2003 - Expanded Characteristic listbox width. -CT
				04/29/2003 - Generate char alias type list with a table query instead of hardcode. -CT   
				05/01/2003 - Updated submitCriteriaResultGeo() JS function call name. -JW
				05/01/2003 - Updated help link. -BN
                        	05/23/2003 SIR 1442 TIR#2 - Changed wording in date selection box. -CT
                        	06/13/2003 - Removed hardcoded schema (SIR 1483). -CT
				06/19/2003 SIR 1504 - Replaced code for geographic, date range and characteristics selections with 
                                     procedure calls. -CT
				07/22/2003 - Added hidden var "result_type" -JW
                        08/07/2003 SIR 1443 - Added Activity Medium selection. -CT
                        08/15/2003 - Removed 'BETA' from the page title. -CT
                        08/22/2003 -- SIR 1500 TIR#1 - Removed hidden variable D_ORG_LIST. -CT
	12/13/2006 -- ESE-WQX_CR_6 - added station types filter. - Suganthi
Comments		:  	Calls three pop-up screens that allow the user to enter additional
				information.
**********************************************************/
SET DEF OFF;
CREATE OR REPLACE
PROCEDURE DW_ResultCriteria_GEO AS

--sug added the cursor station type
CURSOR cstation_type IS
SELECT primary_type,secondary_type, PK_ISN, sort_order
FROM DI_STATN_TYPES
order by sort_order,primary_type,secondary_type;

--used to generate state list
CURSOR cstate IS
SELECT pk_isn, state_name
FROM DI_GEO_STATE
order by country_code desc, state_name;

program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  :='Results by Geographic Location';

BEGIN
DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path,
 'document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);adjust_width_n(document.forms[1].D_STYPE_LIST,"~","61~5","None","Y");adjust_width_n(document.forms[1].D_MEDIUM_LIST,"~","30~","None","Y");adjust_width_n(document.forms[1].D_INTENT_LIST,"~","30~","None","Y");adjust_width_n(document.forms[1].D_COMMUNITY_LIST,"~","30~","None","Y")');
htp.print('<form action="DW_RESULT_COUNT" method=POST>');

-- Geographic location selection
DW_geo_select;


-- sug added Station types
-- Station Type selection
htp.print ('
<h4>Station Type</h4>
<table BORDER COLS=1 WIDTH="100%">
<tr><td align="center">
Select one or more Station Type(s)
<BR>
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="PRIMARY_TYPE                         SECONDARY_TYPE" size="69"  onFocus="javascript:this.blur()">
<BR>
<FONT face="Courier">
<SELECT NAME="D_STYPE_LIST" SIZE="10"  MULTIPLE style="font: 10pt/12pt COURIER" tabindex=15>
<OPTION SELECTED  value="ALL">Select All_________________________________________________________');

    for cstype_var in cstation_type  LOOP

      htp.formSelectOption(cstype_var.PRIMARY_TYPE||'~'||cstype_var.SECONDARY_TYPE, cattributes => 'value= '||cstype_var.PK_ISN);
    END LOOP;

htp.print('</SELECT>
<BR>
</TD>
</TR>
</TABLE>');



-- Date range selection
DW_date_select(15);

-- Activity Medium selection
DW_medium_select(39);

-- Intent & Community Sampled selections
DW_intent_community_select(39);

-- Characteristics selection
DW_char_select(41,'BIOLOGICAL');

htp.print('
<input type="hidden" name="RESULT_TYPE" value="ALLRESULTS">
<input type="hidden" name="SOURCE_APP" value="FILTERPAGES">
<br>
<center>
<input type="button" value="Continue" tabindex=47 onclick="javascript: submitCriteriaResultGeo();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
<input type="button" value="Clear Form" tabindex=48 onclick="javascript: deleteAllFromCharList();document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);" title="Clear the form">
</center></form>
');
DW_bottom_of_page(21);

END;
/
show errors;
