/*******************************************************************************************************************
INSTALLATION INSTRUCTIONS - Release C2.0.8.1 (September 12, 2007)

This section contains the step-by-step installation instruction to create the STORET Central Warehouse, and install the associated Web Application.  There are several noteworthy items regarding installation and batch processing:

Installation Notes:

	Edit this script for database usernames, passwords, and connect strings.

.	Set the Step 1b. variable values. These are used by WQX_ETL database changes in script install_wh_db_changes.sql

 	Edit all Extract, Transform, and Load (ETL) scripts for tablespace names.

	Scripts must be run in the order listed to ensure correct software installation.

	A rollback segment named RBSBIG must exist and be on-line.

	Oracle archiving should be turned off when running the ETL scripts.

	Log files are created for each of the Structured Query Language (SQL) scripts listed in these instructions.  These log files have parallel names and directory locations as the scripts that create them.  Log files should be checked for errors after each step of the installation process to ensure the installation completes successfully.

.	The C2.0.6 release of the Central Warehouse requires Oracle 9i (9.2.0.7) and JServer.

	Copy the storetw directory from the "Release C2.0.6\software" directory to your C:\ drive.

	The installation package is not dependent upon a specific drive letter.  If the installation package is placed on a different drive, replace "C:" with the letter of that drive in the following instructions.

. 	Install Oracle Spatial into the ETL database before running this ETL.

.	An optional script has been provided (i.e., tbs_coalesce.sql) to coalesce the STORETDATA and STORETINDX tablespaces for improved performance.  Execute this script if the storetw schema is being imported into another database (e.g., the ETL loaded storetw schema is moved to a different production database).  Connect to the database with Database Administrator (DBA) privileges to run the tbs_coalesce.sql script.

.	The following two objects store data request history.  Do not drop/modify them in production during the refresh cycle.
	  -- Table:     dw_data_requests
	  -- Sequence:  seq_dw_data_request_id

.	The following table lists configuration and global variables. Do not  drop/modify them in production during the refresh cycle.
	-- Table: MT_WH_CONFIG

Batch Processing Notes:

. 	To report on batch activity, run "dw_batch_activity_report.sql" to generate the dw_batch_activity_report.log file.  Provide report start and end dates.

.	To manually process all pending Immediate batch jobs, run "exec dw_process_pendingbatch_imm".

.	To manually process submitted batch jobs by request_id, run "exec dw_process_data_request_list('x')" where x is a comma separated list of request_ID(s).

.       Monthly Statistic (dw_monthly_stats) and Pending Request (dw_report_pending_requests) reporting, and Overnight batch processing (dw_process_batch_requests) are scheduled and run periodically without manual intervention.  They can also be run manually using the following:
          -- To manually report statistics for a given month, run "exec dw_monthly_stats(x)" where x is a valid date for the desired month.
          -- To manually report pending requests, login to STORETW and run "exec dw_report_pending_requests". 
	  -- To manually process batch jobs submitted for overnight, run "exec dw_process_batch_requests".

.	To change scheduled job timings, modify appropriate variable values in dw_glob_var.sql, run dw_glob_var.sql, then run dw_schedule_batch_jobs.sql.

.	To change online and batch processing thresholds, modify appropriate variable values in the dw_glob_var.sql, then run dw_glob_var.sql.

.  Info-ZIP v2.3 compression utility is used for STORET download load file compressions and is expected be available in /bin directory.  The excutable is /bin/zip  .

12/24/2006 grant execute on sys.utl_file to storetw;
12/24/2006 SET job_queue_processes greater than 0 in the initialization parameter file.  This is necessary to run Oracle schedule jobs.  User data requests are scheduled as Oracle scheduled jobs.
********************************************************************************************************************/

--1.	Open a SQL*Plus session.

--1b. Set the following variable values. These are used by WQX_ETL database changes in script install_wh_db_changes.sql.

set define on
SET VERIFY ON

define DBA_ACCOUNT=SYSTEM
define DBA_ACCOUNT_PASS=STO2ET

define WH_DB_CONNECTSTRING=storet.sdc
--define WH_DB_CONNECTSTRING=epad9

define WH_SCHEMA=STORETW
define WH_SCHEMA_PASS=STORETW

define WH_ETL_SCHEMA=STORETW_ETL
define WH_ETL_SCHEMA_PASS=STORETW_ETL

define WH_ETL_ROLE=STORETW_ETL_ROLE
-----------------End of step 1b. ------------

--2a.	Create storetw schema with appropriate system and object privileges.
CONNECT SYSTEM/STO2ET@storet.sdc
alter session set nls_length_semantics='CHAR';
CONNECT STORET/STO2ET@storet.sdc
alter session set nls_length_semantics='CHAR';
CONNECT STORET1/STO2ET1@storet.sdc
alter session set nls_length_semantics='CHAR';
CONNECT SYSTEM/STO2ET@storet.sdc
alter session set nls_length_semantics='CHAR';

--3.	Create the functions used by the ETL scripts.


CONNECT STORETW/STORETW@storet.sdc
alter session set nls_length_semantics='CHAR';
--14.	Create FA_REGULAR_RESULT table. 
	@C:\storetw\fa_regular_result\fa_regular_result_data1-1.sql;


DISCONNECT
EXIT