/*******************************************************
Filename		:  	DW_top_of_page.sql
Release 		:  	STORET c2.0
SIR			:  	
Description		:  	Creates the standard header and sidebar for all pages of the Station
				Warehouse web application. 
Author			:  	Joseph Wilson
Date			: 	November 12, 2002; November 27, 2002; December 5, 2002
Comments		:  	Utilizes the EPA Standard Web Template (no sidebar) and links to the 
				OWOW version of the cascading style sheet.
**********************************************************/

set def off;

CREATE OR REPLACE PROCEDURE DW_top_of_page
(
page_title 	IN varchar2, 
program_path 	OUT varchar2, 
script_path 	OUT varchar2, 
image_path  	OUT varchar2,
body_on_load 	IN varchar2 default null
)
as
host_path  	varchar2(100);
--
BEGIN

--program_path:=glob_var.lv_program_path;
script_path :=DW_glob_var.lv_script_path;
--script_path := 'http://everest.sdc-moses.com/storet/moderndev/scripts/WH_storet.js';
--image_path:=glob_var.lv_image_path;

	htp.print('
 
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
	"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd">
<html><!-- #BeginTemplate "/Templates/storet.dwt" -->
<!-- EPA Template Version 2.1.1 - 03/22/02 -->
<head>
<!-- #BeginEditable "doctitle" --> 
<title>EPA &gt; STORET &gt; '||page_title||'</title>
<meta name="Description" content="Environmental Protection Agency''s Monitoring and Assessing Water Quality website." />
<meta name="Keywords" content="" />
<SCRIPT LANGUAGE="JavaScript1.2" SRC='||script_path||'>
</SCRIPT>
<!-- #EndEditable --> 
<meta http-equiv="Content-Type" content="text/html;  charset=iso-8859-1" />
<meta http-equiv="pics-label" content=''(pics-1.1 "http://www.icra.org/ratingsv02.html" l gen true for "http://www.epa.gov" r (cz 1 lz 1 nz 1 oz 1 vz 1) "http://www.rsac.org/ratingsv01.html" l gen true for "http://www.epa.gov" r (n 0 s 0 v 0 l 0))'' />
<link rel="stylesheet" href="http://www.epa.gov/owow/styles/epafiles_epastyles.css" type="text/css" />
</head>
<body bgcolor="#FFFFFF" text="#000000" 
leftmargin="2" topmargin="0" marginwidth="2" marginheight="0" 
onload='||body_on_load||'>
<a name="pagetop"></a> 
<table width="95%" border="0" cellspacing="0" cellpadding="0">
	<tr valign="top"> 
		<td><a href="#pagecontents"><img src="http://www.epa.gov/storet/images/epafiles_misc_space.gif" 
		width="4" height="4" border="0" hspace="68" alt="Skip common site navigation and headers" /></a><br />
			<!-- START EPA SEAL -->
			<a href="http://www.epa.gov/"><img src="http://www.epa.gov/storet/images/epafiles_logo_epasealwhite.gif" 
			width="140" height="111" alt="United States Environmental Protection Agency" 
			border="0" /></a> 
			<!-- END EPA SEAL -->
		</td>
		<td width="100%"> 
			<table width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr> 
					<!-- START EPA NAME -->
					<td colspan="3" align="right"><a href="http://www.epa.gov/"><img src="http://www.epa.gov/storet/images/epafiles_ban_topepa.gif" 
					width="377" height="26" alt="United States Environmental Protection Agency" border="0" /></a></td>
					<!-- END EPA NAME -->
				</tr>
				<tr> 
					<td class="epaAreaName" rowspan="2"><img src="http://www.epa.gov/storet/images/epafiles_misc_space.gif" 
					width="5" height="5" alt="" /></td>
					<td rowspan="2" class="epaAreaName" width="100%"> 
						<!-- START AREA NAME -->
						STORET 
						<!-- END AREA NAME -->
					</td>
					<td valign="top" class="epaAreaName" align="right"><img src="http://www.epa.gov/storet/images/epafiles_ban_endtop.gif" 
					width="11" height="14" alt="" /></td>
				</tr>
				<tr> 
					<td valign="bottom" class="epaAreaName" align="right"><img src="http://www.epa.gov/storet/images/epafiles_ban_endbottom.gif" 
					width="11" height="15" alt="" /></td>
				</tr>
			</table>
			<table width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr> 
					<td><img src="http://www.epa.gov/storet/images/epafiles_misc_space.gif" 
					width="5" height="5" alt="" /></td>
					<td width="100%"> 
						<!-- BEGIN GLOBAL LINKS AND SEARCH -->
						<form name="fcol" method="post" action="http://search.epa.gov/s97is.vts" class="epaGlobal">
							<table width="100%" border="0" cellpadding="0" cellspacing="0">
								<tr> 
									<td><img src="http://www.epa.gov/storet/images/epafiles_misc_space.gif" 
									width="4" height="1" vspace="9" alt="" align="middle" /></td>
									<td width="100%" class="epaGlobalLinks"> 
										<!-- START SEARCH CONTROLS -->
										<!-- See http://www.epa.gov/epafiles/searchcode.htm
										for instructions on coding the search box -->
										<input type="hidden" name="fld" value="???" />
										<input type="hidden" name="areaname" value="STORET" />
										<input type="hidden" name="areasidebar" value="http://www.epa.gov/storet/styles/storet_sidebar.txt" />
										<input type="hidden" name="areacontacts" value="http://www.epa.gov/storet/contact.html" />
										<input type="hidden" name="areasearchurl" value="" />
										<input type="hidden" name="typeofsearch" value="" />
										<!-- THE REMAINING HIDDEN INPUTS ARE USED BY THE SEARCH ENGINE - DO NOT EDIT -->
										<input type="hidden" name="resulttemplate" value="epafiles_default.hts" />
										<input type="hidden" name="Action" value="FilterSearch" />
										<input type="hidden" name="Filter" value="sample2filt.hts" />
										<input type="hidden" name="collection" value="All" />
										<!-- END SEARCH CONTROLS -->
										<!-- START AREA SPECIFIC LINKING -->
										<a href="http://www.epa.gov/storet/whats_new.html">Recent Additions</a> |
										<a href="http://www.epa.gov/storet/contact.html">Contact Us</a> | 

										<!-- END AREA SPECIFIC LINKING -->
										<!-- LINK FOR PRINT VERSION -->
										<!-- CHARACTERS NEED TO APPEAR EXACTLY LIKE THIS - DO NOT EDIT -->
										<a href="http://www.epa.gov/cgi-bin/epaprintonly.cgi">Print 
										Version</a> 
										<!-- END PRINT VERSION -->
										<img src="http://www.epa.gov/storet/images/epafiles_misc_space.gif" 
										width="1" height="1" vspace="2" hspace="5" alt="" /> 
										Search: 
										<input name="queryText" size="10" value="" />
										<input type="image" src="http://www.epa.gov/storet/images/epafiles_btn_gosearch.gif" value="Run Search" 
										border="0" width="27" height="16" alt="Run Search" name="image" />
									</td>
								</tr>
								<tr> 
									<td colspan="2"><img src="http://www.epa.gov/storet/images/epafiles_misc_space.gif" 
									width="5" height="3" alt="" align="middle" /></td>
								</tr>
								<tr> 
									<!-- BEGIN BREADCRUMBS -->
									<td class="epaHighlightBox"><img src="http://www.epa.gov/storet/images/epafiles_misc_space.gif" 
									width="4" height="4" alt="Begin Hierarchical Links" border="0" /></td>
									<td width="100%" class="epaHighlightBox"><span class="epaBreadLinks"><epabreadcrumbs><a href="http://www.epa.gov">EPA 
										Home</a> &gt; 
										<!-- START AREA BREADCRUMBS -->
										<!-- START LINK TO AREA HOME PAGE -->
										<a href="http://www.epa.gov/water/">Water</a>
&gt; <a href="http://www.epa.gov/owow/">Wetlands, Oceans, & Watersheds</a>
&gt; <a href="http://www.epa.gov/owow/monitoring/">Monitoring and Assessing Water Quality</a>
										<!-- END LINK TO AREA HOME PAGE -->
										&gt; <a href="http://www.epa.gov/storet/index.html">STORET</a> 
&gt; Data Warehouse
										<!-- END AREA BREADCRUMBS -->
										<img src="http://www.epa.gov/storet/images/epafiles_misc_space.gif" 
									width="4" height="4" alt="End Hierarchical Links" 
									border="0" /></epabreadcrumbs></span></td>
									<!-- END BREADCRUMBS -->
								</tr>
							</table>
						</form>
						<!-- END GLOBAL LINKS AND SEARCH -->
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<table width="95%" border="0" cellspacing="0" cellpadding="0">
	<tr> 
		<!--@@@startprint@@@-->
		<td valign="top"><img src="http://www.epa.gov/storet/images/epafiles_misc_space.gif" 
		width="5" height="5" alt="" /></td>
		<!--@@@endprint@@@-->
		<td valign="top" width="100%"> 
			<!-- BEGIN HORIZONTAL TASKBAR -->
			<!-- If using a horizontal taskbar, put the code here -->
			<!-- END HORIZONTAL TASKBAR -->
			<a name="pagecontents"></a> 

			<!-- BEGIN PAGE NAME -->
			<h1 class="epaPageName"><!-- #BeginEditable "PageName" --> 
        <!-- If using a right-aligned image next to the page name, insert it here 
			- remember to include the align="right" attribute in the IMG tag -->
		<!--img alt="STORET logo" src="http://www.epa.gov/storet/images/logo_sm.gif" width="118" height="146" align="left" vspace="6" hspace="12" /-->
        <h3 align="CENTER"><font face="Arial, Helvetica, sans-serif" color="#003399">'||page_title||' (stormod_) </font></h3> 
			<!-- #EndEditable --></h1>
			<!-- END PAGE NAME -->

			<!-- BEGIN CONTENT AREA -->
			<!-- #BeginEditable "content" -->
');

END;
/
show errors