/*******************************************************
Filename		:  char_table.sql
Release 		:  c2.0
SIR			:  1365,1514
Description		:  Characteristic dimension table.
Author			:  Ganesh Thadkamalla
Date			:  10/25/2002.
Comments		:  11/25/2002 -- Deleted the Taxa chars that do not have stations. --Ganesh.
			   06/06/03 - Edited for SIR 1468. Updated tablespace_names. -Ganesh
			   01/16/04 - SIR 1586 Moved connect string to master install script -Joe	
**********************************************************/
--note tsrchar-is_number is used as primary key in this table.
spool char_table.log

-- drop commands
--drop table DI_Characteristic;

create table DI_Characteristic 
tablespace storetdata
storage (initial 10M next 10M) 
nologging 
as
select tsrchar_is_number pk_isn, 
       search_name,display_name,
       char_type_code type_code
from storet.tsrchar c
where (c.char_type_code !='T')
or (c.char_type_code ='T' 
    and exists (select 'x' from station_char sc
             where sc.FK_CHAR=c.tsrchar_is_number));
commit;

alter table STORETW.DI_Characteristic
MODIFY (CHARACTERISTIC_GROUP_TYPE NULL,display_name  NULL,search_name NULL);

-- create user def hab assessment characteristic
/*
insert into di_characteristic 
	values (999999,'USER DEFINED HABITAT CHARACTERISTIC', 'User Defined Habitat Characteristic','H');
commit;
*/
insert into di_characteristic 
(PK_ISN       ,  
SEARCH_NAME  ,  
DISPLAY_NAME,
TYPE_CODE    )
values (999999,'USER DEFINED HABITAT CHARACTERISTIC', 'User Defined Habitat Characteristic','H');
commit;


alter table DI_Characteristic
add constraint pk_char primary key (pk_isn)
using index
tablespace storetindx
storage (initial  512K next 512K);

create index ichar01 on DI_Characteristic(search_name)
tablespace storetindx
storage (initial 512K next 256K) nologging;

create bitmap index ichar02 on DI_Characteristic(type_code) nologging;

alter table station_char
add constraint fk_station_char02 foreign key (FK_char) references di_characteristic(pk_isn);

spool off;