/**************************
file: mt_attribute_map.sql
author: Ganesh Thadkamalla
CR: CR_34
Description:  Mapping table that can be used any attribute mapping between STORET and WQX Systems.  The production versions of the tsmvstc and mltyp_name tables (08/07/2007) are used in generating this script.  Any change to these tables would trigger a change to this script.
Date: 08/06/2007
02/27/2008 - DR 27. Edited the Beaches station types to match WQX. -GT
*****************************/
spool mt_attribute_map.log

drop sequence seq_mt_attribute_map;
create sequence seq_mt_attribute_map
start with 1 increment by 1 nomaxvalue nocycle cache 10;


DROP TABLE MT_ATTRIBUTE_MAP CASCADE CONSTRAINTS;
CREATE TABLE MT_ATTRIBUTE_MAP 
( PK_ISN NUMBER, 
MAPPING_FIELD VARCHAR2(256 CHAR), 
STORET_NAME VARCHAR2(256 CHAR), 
STORET_NAME2 VARCHAR2(256 CHAR), 
WQX_NAME VARCHAR2(256 CHAR), 
WQX_NAME2 VARCHAR2(256 CHAR), 
SORT_ORDER NUMBER, 
STATUS CHAR(1 CHAR), 
ATTR_1 VARCHAR2(256 CHAR), 
ATTR_2 VARCHAR2(256 CHAR), 
ATTR_3 VARCHAR2(256 CHAR), 
ATTR_DESCRIPTION VARCHAR2(1000 CHAR) ) 
TABLESPACE STORETDATA LOGGING NOCACHE NOPARALLEL;

grant select on mt_attribute_map to storetw_etl_role;

ALTER TABLE MT_ATTRIBUTE_MAP
ADD CONSTRAINT PK_MT_ATTR_MAP PRIMARY KEY (PK_ISN)
USING INDEX
TABLESPACE STORETINDX;

create index i_mt_attr_02 on mt_attribute_map(mapping_field,STORET_NAME,STORET_NAME2)
TABLESPACE STORETINDX;


INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
1, 'STATION_TYPES', 'River/Stream', 'None', 'River/Stream', NULL, 1, 'Y', 'S', NULL
, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
2, 'STATION_TYPES', 'Lake', 'None', 'Lake', NULL, 2, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
3, 'STATION_TYPES', 'Great Lake', 'None', 'Great Lake', NULL, 3, 'Y', 'S', NULL, NULL
, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
4, 'STATION_TYPES', 'Ocean', 'None', 'Ocean', NULL, 7, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
5, 'STATION_TYPES', 'Estuary', 'None', 'Estuary', NULL, 8, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
6, 'STATION_TYPES', 'Well', 'None', 'Well', NULL, 4, 'Y', 'G', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
7, 'STATION_TYPES', 'Spring', 'None', 'Spring', NULL, 11, 'Y', 'G', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
8, 'STATION_TYPES', 'Cave', 'None', 'Cave', NULL, 12, 'Y', 'G', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
9, 'STATION_TYPES', 'Land', 'None', 'Land', NULL, 17, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 

-- DR 27 - Following are updated with WQX names for Beaches station types.


INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
57, 'STATION_TYPES', 'BEACH Program Site', 'Channelized stream', 'BEACH Program Site-Channelized stream'
, NULL, 28, 'Y', NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
58, 'STATION_TYPES', 'BEACH Program Site', 'Estuary', 'BEACH Program Site-Estuary'
, NULL, 28, 'Y', NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
59, 'STATION_TYPES', 'BEACH Program Site', 'Great Lake', 'BEACH Program Site-Great Lake'
, NULL, 28, 'Y', NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
60, 'STATION_TYPES', 'BEACH Program Site', 'Lake', 'BEACH Program Site-Lake', NULL
, 28, 'Y', NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
61, 'STATION_TYPES', 'BEACH Program Site', 'Land runoff', 'BEACH Program Site-Land runoff'
, NULL, 28, 'Y', NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
62, 'STATION_TYPES', 'BEACH Program Site', 'Land', 'BEACH Program Site-Land', NULL
, 28, 'Y', NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
63, 'STATION_TYPES', 'BEACH Program Site', 'Ocean', 'BEACH Program Site-Ocean', NULL
, 28, 'Y', NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
64, 'STATION_TYPES', 'BEACH Program Site', 'River/Stream', 'BEACH Program Site-River/Stream'
, NULL, 28, 'Y', NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 


INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
10, 'STATION_TYPES', 'Wetland', 'Estuarine, emergent', 'Wetland Estuarine-Emergent'
, NULL, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
11, 'STATION_TYPES', 'Wetland', 'Estuarine, scrub-shrub', 'Wetland Estuarine-Scrub-Shrub'
, NULL, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
12, 'STATION_TYPES', 'Wetland', 'Estuarine, forested', 'Wetland Estuarine-Forested'
, NULL, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
13, 'STATION_TYPES', 'Wetland', 'Riverine, emergent', 'Wetland Riverine-Emergent'
, NULL, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
14, 'STATION_TYPES', 'Wetland', 'Lacustrine, emergent', 'Wetland Lacustrine-Emergent'
, NULL, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
15, 'STATION_TYPES', 'Wetland', 'Palustrine, moss-lichen', 'Wetland Palustrine-Moss-Lichen'
, NULL, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
16, 'STATION_TYPES', 'Wetland', 'Palustrine, emergent', 'Wetland Palustrine-Emergent'
, NULL, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
17, 'STATION_TYPES', 'Wetland', 'Palustrine, shrub-scrub', 'Wetland Palustrine-Shrub-Scrub'
, NULL, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
18, 'STATION_TYPES', 'Wetland', 'Palustrine, forested', 'Wetland Palustrine-Forested'
, NULL, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
19, 'STATION_TYPES', 'Canal', 'Irrigation', 'Canal Irrigation', NULL, 10, 'Y', 'S'
, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
20, 'STATION_TYPES', 'Canal', 'Drainage', 'Canal Drainage', NULL, 10, 'Y', 'S', NULL
, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
21, 'STATION_TYPES', 'Canal', 'Transport', 'Canal Transport', NULL, 10, 'Y', 'S', NULL
, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
22, 'STATION_TYPES', 'Facility', 'Industrial', 'Facility Industrial', NULL, 5, 'Y'
, 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
23, 'STATION_TYPES', 'Facility', 'Municipal Sewage (POTW)', 'Facility Municipal Sewage (POTW)'
, NULL, 5, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
24, 'STATION_TYPES', 'Facility', 'Municipal Water Supply (PWS)', 'Facility Public Water Supply (PWS)'
, NULL, 5, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
25, 'STATION_TYPES', 'Facility', 'Privately Owned non-industrial', 'Facility Privately Owned Non-industrial'
, NULL, 5, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
26, 'STATION_TYPES', 'Facility', 'Other/combined', 'Facility Other', NULL, 5, 'Y'
, 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
27, 'STATION_TYPES', 'Constructed Wetland', 'None', 'Constructed Wetland', NULL, 14
, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
28, 'STATION_TYPES', 'Mine/mine discharge', 'None', 'Mine/Mine Discharge', NULL, 24
, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
29, 'STATION_TYPES', 'Channelized stream', 'None', 'Channelized Stream', NULL, 9, 'Y'
, 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
30, 'STATION_TYPES', 'Storm sewer', 'None', 'Storm Sewer', NULL, 21, 'Y', 'O', NULL
, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
31, 'STATION_TYPES', 'Waste sewer', 'None', 'Waste Sewer', NULL, 22, 'Y', 'O', NULL
, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
32, 'STATION_TYPES', 'Combined sewer', 'None', 'Combined Sewer', NULL, 23, 'Y', 'O'
, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
33, 'STATION_TYPES', 'Reservoir', 'None', 'Reservoir', NULL, 15, 'Y', 'S', NULL, NULL
, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
34, 'STATION_TYPES', 'Riverine impoundment', 'None', 'Riverine Impoundment', NULL
, 16, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
35, 'STATION_TYPES', 'Landfill', 'None', 'Landfill', NULL, 19, 'Y', 'O', NULL, NULL
, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
36, 'STATION_TYPES', 'Gallery', 'None', 'Gallery', NULL, 25, 'Y', 'G', NULL, NULL
, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
37, 'STATION_TYPES', 'Waste pit', 'None', 'Waste Pit', NULL, 20, 'Y', 'O', NULL, NULL
, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
38, 'STATION_TYPES', 'Land runoff', 'None', 'Land Runoff', NULL, 18, 'Y', 'O', NULL
, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
39, 'STATION_TYPES', 'CERCLA Superfnd Site', 'None', 'CERCLA Superfund Site', NULL
, 6, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
40, 'STATION_TYPES', 'Wetland', 'Undifferentiated', 'Wetland Undifferentiated', NULL
, 13, 'Y', 'S', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
41, 'STATION_TYPES', 'Mine/mine discharge', 'Adit (mine entrance)', 'Mine/Mine Discharge Adit (Mine Entrance)'
, NULL, 24, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
42, 'STATION_TYPES', 'Mine/mine discharge', 'Tailings Pile', 'Mine/Mine Discharge Tailings Pile'
, NULL, 24, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
43, 'STATION_TYPES', 'Mine/mine discharge', 'Waste Rock Pile', 'Mine/Mine Discharge Waste Rock Pile'
, NULL, 24, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
44, 'STATION_TYPES', 'CERCLA Superfnd Site', 'Survey Monument', 'CERCLA Superfund Site Survey Monument'
, NULL, 6, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
45, 'STATION_TYPES', 'CERCLA Superfnd Site', 'Spigot / Faucet', 'CERCLA Superfund Site Spigot / Faucet'
, NULL, 6, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
46, 'STATION_TYPES', 'CERCLA Superfnd Site', 'Borehole', 'CERCLA Superfund Site Borehole'
, NULL, 6, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
47, 'STATION_TYPES', 'CERCLA Superfnd Site', 'Test Pit', 'CERCLA Superfund Site Test Pit'
, NULL, 6, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
48, 'STATION_TYPES', 'Land', 'Flood Plain', 'Land Flood Plain', NULL, 17, 'Y', 'O'
, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
49, 'STATION_TYPES', 'Floodwater', 'None', 'Floodwater', NULL, NULL, 'Y', NULL, NULL
, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
50, 'STATION_TYPES', 'Floodwater', 'Urban', 'Floodwater Urban', NULL, NULL, 'Y', NULL
, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
51, 'STATION_TYPES', 'Floodwater', 'Non Urban', 'Floodwater Non Urban', NULL, NULL
, 'Y', NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
52, 'STATION_TYPES', 'Floodwater', 'Debris', 'Floodwater Debris', NULL, NULL, 'Y'
, NULL, NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
53, 'STATION_TYPES', 'Facility', 'Community PWS', 'Facility Community PWS', NULL, 5
, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
54, 'STATION_TYPES', 'Facility', 'Non-transient PWS', 'Facility Non-transient PWS'
, NULL, 5, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
55, 'STATION_TYPES', 'Facility', 'Transient PWS', 'Facility Transient PWS', NULL, 5
, 'Y', 'O', NULL, NULL, 'Attr_1 is SGO/Indicator'); 
INSERT INTO MT_ATTRIBUTE_MAP ( PK_ISN, MAPPING_FIELD, STORET_NAME, STORET_NAME2, WQX_NAME,
WQX_NAME2, SORT_ORDER, STATUS, ATTR_1, ATTR_2, ATTR_3, ATTR_DESCRIPTION ) VALUES ( 
56, 'STATION_TYPES', 'Land', 'Glacier', 'Land Glacier', NULL, 17, 'Y', 'O', NULL, NULL
, 'Attr_1 is SGO/Indicator'); 


commit;
 

drop sequence seq_mt_attribute_map;
DECLARE
LV_MAX_PKISN NUmBER;
BEGIN
SELECT MAX(PK_ISN) INTO LV_MAX_PKISN FROM MT_ATTRIBUTE_MAP;

LV_MAX_PKISN:=LV_MAX_PKISN+1;

EXECUTE IMMEDIATE 'create sequence seq_mt_attribute_map
start with '||LV_MAX_PKISN||' increment by 1 nomaxvalue nocycle cache 10';

END;
/

SELECT seq_mt_attribute_map.NEXTVAL FROM DUAL;

SPOOL OFF;