/*******************************************************
Filename		:  	DW_result_criteria_project.sql
Release 		:  	STORET c2.0
SIR			:  	1442, 1435, 1436, 1437
Description		:  	Creates a centralized form page that allows the user to query results based on  
				a selected Project and other common parameters.
Author			:  	Joseph Wilson/Christine Tsang
Date			: 	March 17, 2003  --updated fonts
                        03/17/2003 - Added date selection. -C Tsang
				03/18/2003 - Replaced hard-coded date logic with call to DW_DISPLAY_CALENDAR.
						  -C Tsang
				03/20/2003 - Mod to reset project when org changes. -C Tsang
				03/24/2003 - Updated table and column names to work with updated ETL. -J Wilson
				04/10/2003 - Set up tabbing sequence. -CT
				04/18/2003 - Reset Date fields with JavaScript. -J Wilson
				04/24/2003 - Expanded Characteristic listbox width. -CT
				04/29/2003 - Generate char alias type list with a table query instead of hardcode. -CT   
                        05/01/2003 - Pass '23' to footer routine to be used as a bookmark for the Help. - W Nash sir 1459
                        05/23/2003 SIR 1442 TIR#2 - Changed wording in date selection box. -CT
                        06/13/2003 - Removed hardcoded schema (SIR 1483). -CT
				06/20/2003 SIR 1504 - Replaced code for date range and characteristics selections with procedure calls. -CT 
                        07/22/2003 - Replaced code for project selection with procedure call. -CT
				07/24/2003 - Added hidden var "result_type" -JW
                        08/07/2003 SIR 1443 - Added Activity Medium selection. -CT
                        08/15/2003 - Removed 'BETA' from the page title. -CT
	12/13/2006 -- ESE-WQX_CR_6 - added station types filter. - Suganthi
Comments		:  	Calls a pop-up window for Project selection.
**********************************************************/

SET DEF OFF;

CREATE or REPLACE PROCEDURE DW_ResultCriteria_PROJECT AS

--sug added the cursor station type
CURSOR cstation_type IS
SELECT primary_type,secondary_type, PK_ISN, sort_order
FROM DI_STATN_TYPES
order by sort_order,primary_type,secondary_type;
--***

program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  :='Regular Results by Project';

BEGIN
DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path,
'adjust_width_n(document.forms[1].D_ORG_LIST,"~","15~60","None","N");document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);adjust_width_n(document.forms[1].D_STYPE_LIST,"~","61~5","None","Y");adjust_width_n(document.forms[1].D_MEDIUM_LIST,"~","30~","None","Y")');
htp.print('<form action="DW_RESULT_COUNT" method=POST>');

-- Organization/Project selection
DW_project_select;

-- sug added Station types
-- Station Type selection
htp.print ('
<h4>Station Type</h4>
<table BORDER COLS=1 WIDTH="100%">
<tr><td align="center">
Select one or more Station Type(s)
<BR>
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="PRIMARY_TYPE                         SECONDARY_TYPE" size="69"  onFocus="javascript:this.blur()">
<BR>
<FONT face="Courier">
<SELECT NAME="D_STYPE_LIST" SIZE="10"  MULTIPLE style="font: 10pt/12pt COURIER" tabindex=15>
<OPTION SELECTED  value="ALL">Select All_________________________________________________________');

    for cstype_var in cstation_type  LOOP
    
      htp.formSelectOption(cstype_var.PRIMARY_TYPE||'~'||cstype_var.SECONDARY_TYPE, cattributes => 'value= '||cstype_var.PK_ISN);
    END LOOP;

htp.print('</SELECT>
<BR>
</TD>
</TR>
</TABLE>');
--*******

-- Date range selection 
DW_date_select(10);

-- Activity Medium selection
DW_medium_select(35);

-- Characteristics selection
DW_char_select(36);

htp.print('
<input type="hidden" name="RESULT_TYPE" value="REGULAR">
<br>
<center>
<input type="button" value="Continue" tabindex=43 onclick="javascript: submitCriteria2();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
<input type="button" value="Clear Form" tabindex=44 onclick="javascript: deleteAllFromCharList(); document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);" title="Clear the form">
</center></form>
');
DW_bottom_of_page(23);

END;
/
SHOW ERRORS;