CREATE OR REPLACE PROCEDURE DW_Result_Hub_Custom
(v_FromStmt		IN	VARCHAR2 DEFAULT NULL,
v_WhereStmt		IN 	VARCHAR2 DEFAULT NULL,
vR_FromStmt		IN	VARCHAR2 default null,
vR_WhereStmt		IN 	VARCHAR2 default null,
vB_FromStmt		IN	VARCHAR2 default null,
vB_WhereStmt		IN 	VARCHAR2 default null,
vH_FromStmt		IN	VARCHAR2 default null,
vH_WhereStmt		IN 	VARCHAR2 default null,
v_ResultCount		IN 	VARCHAR2,
v_rule_optimization	IN	VARCHAR2,
v_report_type		IN	CHAR,
v_filters		IN	VARCHAR2,
v_mode 			IN	VARCHAR2,
v_email			IN      VARCHAR2 default 'No_Email_Provided',
v_prefix		in      varchar2 default 'EPA',
v_Columns 		owa_util.vc_arr,
--v_ActColumns	owa_util.ident_arr,
report_type 		varchar2 :='CUSTOM'
)
AS

-- WShed Summary: added vr_fromstmt, vr_wherestmt,vB_fromstmt, vB_wherestmt,vH_fromstmt, vH_wherestmt AND made v_fromstmt and v_wherestmt default null.
-- sug metadata variables [META DATA]
v_SelectStmt            VARCHAR2(32000);
v_SQLStmt               VARCHAR2(32000);
v_CursorID              INTEGER;
v_ReturnRow             VARCHAR2(32000);
v_mdfilename            VARCHAR2(30);
v_Dummy                 INTEGER;
v_filename_ts           VARCHAR2(30);
v_filename              VARCHAR2(30);
v_orgidlist             owa_util.ident_arr;
v_zip_file                number := 0;
i                       INTEGER;
lv_command varchar2(1000);

v_zip_rc                number := 0;
v_file_name             varchar2(200);
--v_exists 		      boolean;
--v_file_length 		number;
--v_blocksize 		number;
v_time_start		number;
v_time_current		number;
in_command               varchar2(200);

--*******

v_exists 		boolean;
v_file_length 		number;
v_blocksize 		number;

program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100);
--v_request_id            number;
--
--The out_file variable will contain the entire URL of the file created within
--the called download procedures.
--
out_file	  	varchar2(200);

lv_file_name varchar2(100);
lv_filetype varchar2(3);
lv_timestamp varchar2(20);
lv_file_length number;

lv_request_id dw_data_requests.request_id%type;
lv_email dw_data_requests.email_address%type;
lv_prefix varchar2(3);

--******[META DATA]
v_tarfile varchar2(100);
lV_PROJECT_BLOBS varchar2(4000);

--WShed Summary
vR_SelectStmt            VARCHAR2(32000);
vR_SQLStmt               VARCHAR2(32000);
vR_filename              VARCHAR2(30);

vB_SelectStmt            VARCHAR2(32000);
vB_SQLStmt               VARCHAR2(32000);
vB_filename              VARCHAR2(30);

vH_SelectStmt            VARCHAR2(32000);
vH_SQLStmt               VARCHAR2(32000);
vH_filename              VARCHAR2(30);

lv_basefile varchar2(256);


BEGIN

    -- NOT EDITED FOR WShed summary.  Online processing is discontinued
    if v_mode = 'Online' then
	page_title :='Download Results';
	--*****
	--commented aspart of metadata report sug [META DATA]
	--DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
	--*****
	htp.print('<form action="DW_result_download_zip" method=POST>');
	htp.para;
	htp.para;
	htp.para;
	htp.print('<center>');
--htp.print(v_wherestmt);
	IF report_type = 'CUSTOM' THEN
        --*****
	  --commented as part of metadata report sug [META DATA]
  	  --htp.print('You have requested to download monitoring Results');

          -- sug retrieve organization id  [META DATA]
          v_SelectStmt := 'SELECT distinct FA.organization_id';
          v_SQLStmt := v_SelectStmt||' '||v_FromStmt||' '||v_WhereStmt;

          v_CursorID := DBMS_SQL.OPEN_CURSOR;
          DBMS_SQL.PARSE(v_CursorID, v_SQLStmt, DBMS_SQL.NATIVE);
          DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
          v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

          i := 1;
          LOOP
              IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
		EXIT;
              END IF;
          DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
          v_orgidlist(i) := v_ReturnRow;
          i :=	i+1;
          END LOOP;
          DBMS_SQL.CLOSE_CURSOR(v_CursorID);


          v_filename_ts := TO_CHAR(SYSDATE,'YYYYMMDD_HH24MISS');
          --v_mdfilename := 'SDR'||v_filename_ts||'_MD.txt';

          IF v_report_type = 'BIOLOGICAL' THEN
            lv_filetype:='SDB';
          ELSIF v_report_type = 'HABITAT' THEN
            lv_filetype:='SDH';
          else
           lv_filetype:='SDR';
          end if;
            v_filename := lv_filetype||v_filename_ts||'.txt';
            v_mdfilename := lv_filetype||v_filename_ts||'_MD.txt';
            v_tarfile:= lv_filetype||v_filename_ts||'.tar';

         DW_RESULT_METADATA(v_orgidlist,v_mdfilename,lV_PROJECT_BLOBS);


        --DW_result_download_custom(v_FromStmt,v_WhereStmt,v_rule_optimization,v_report_type,v_Columns,'NONE',null,null,v_mode,v_ResultCount,v_filters,out_file,lv_request_id);

        -- sug replaced v_filename instead of 'NONE'
        DW_result_download_custom(v_FromStmt,v_WhereStmt,vR_FromStmt,vR_WhereStmt,vB_FromStmt,vB_WhereStmt,vH_FromStmt,vH_WhereStmt,v_rule_optimization,v_report_type,v_Columns,v_filename,null,null,v_mode,v_ResultCount,v_filters,out_file,lv_request_id);

        -- sug tar the files
  --      v_zip_file  := execmd('/bin/tar -cf '||DW_glob_var.lv_iodir||v_tarfile||' '|| DW_glob_var.lv_iodir||v_filename||' '||DW_glob_var.lv_iodir||v_mdfilename);
    --htp.print('start of tar '||to_char(sysdate,'hh24:mi:ss.ss'));
      lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||' '|| DW_glob_var.lv_iodir||'/'||v_filename||' '||DW_glob_var.lv_iodir||'/'||v_mdfilename;

          --          dw_result_download_zip(lv_command,v_tarfile);

      v_zip_rc := execmd(lv_command);

	v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+ TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
	LOOP
		utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,v_tarfile,v_exists,v_file_length,v_blocksize);
		v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+ TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
	EXIT WHEN v_file_length > 0 OR ABS(v_time_start-v_time_current)> 0.01667;
	END LOOP;

	v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+TO_CHAR(SYSDATE,'SS')/3600);
	LOOP
		v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+ TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
	EXIT WHEN ABS(v_time_start-v_time_current)> 0.004;
	END LOOP;

      --    htp.print('end of tar '||to_char(sysdate,'hh24:mi:ss.ss'));
        --sug pass the v_zip_file.
        --dw_result_download_zip(v_zip_file);
	lv_command:='/bin/gzip '||DW_glob_var.lv_iodir||'/'||v_tarfile;
        --lv_command:='/bin/gzip '||DW_glob_var.lv_iodir||'/'||v_filename;

--         dw_result_download_zip(lv_command,v_tarfile||'.gz');
         dw_result_download_zip(lv_command,v_tarfile||dw_glob_var.gv_cmprs_fl_ext);
        -- htp.print('end of gzip'||to_char(sysdate,'hh24:mi:ss.ss'));
       	END IF;

       --******
/*  commented as part of metadata report (sug)
DW_result_download_custom(v_FromStmt,v_WhereStmt,v_rule_optimization,v_report_type,v_Columns,'NONE',null,null,v_mode,v_ResultCount,v_filters,out_file,lv_request_id);
	END IF;
	utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,out_file,v_exists,v_file_length,v_blocksize);
	htp.print('<br><br>The size of your report download is <B>'||ROUND(v_file_length/1024,1)||'KB</B>');
	htp.Br;
	htp.Br;
	htp.anchor(out_file,htf.bold('Download your file now...'));
	htp.Br;
	lv_file_length:=ROUND(v_file_length/1024,1);
      htp.Br;
	htp.print('or, for large files, you may click below to compress before download');
	htp.Br;
	htp.Br;
	htp.print('<a HREF="javascript:document.forms[1].submit();">Compress data file now...</a>');
	htp.print('</center>');
	htp.print('<input type="hidden" name="out_file" value='||out_file||'>');
	htp.print('</center>');

*/

	--********
	--sug [META DATA] commented as part of metadata Report
	--DW_bottom_of_page(7);
	--*********
  --sir1633

  elsif v_mode in ('Immediate','Overnight') then
      if v_email is null then
        lv_email:='NoEmailProvided';
      else
        lv_email:=v_email;
      end if;
      if v_prefix is null then
        lv_prefix:='EPA';
      else
        lv_prefix:=v_prefix;
      end if;

    -- record Overnight/Immediate request and return a filename.
	page_title :='Result Data request via '||v_mode||' batch process';

	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
           htp.print('<center>');

	IF report_type = 'CUSTOM' THEN
		htp.print('You have requested for a custom result download via '||v_mode||' batch processing.');
		--WSHED SUMMARY
DW_result_download_custom(v_FromStmt,v_WhereStmt,vR_FromStmt,vR_WhereStmt,vB_FromStmt,vB_WhereStmt,vH_FromStmt,vH_WhereStmt,v_rule_optimization,v_report_type,v_Columns,'NONE',lv_email,lv_prefix,v_mode,v_ResultCount,v_filters,out_file,lv_request_id);

v_tarfile:=replace(out_file,'.txt','.tar');
lv_basefile:=replace(out_file,'.txt','');

	END IF;
          htp.print('The Request is successfully submitted.  A confirmation is sent to the email address you provided.');
          htp.br;
	  htp.br;
          htp.br;
          htp.print('<table cols=1 align="center" border=0>
           <tr><td align=Center><B>Request Information </B> </td></tr>
           <tr><td align=left>Request ID    : '||lv_request_id||'  </td></tr>
           <tr><td align=left>Request Type  : Result Download  </td></tr>
           <tr><td align=left>Record Count  : '||v_ResultCount  ||'  </td></tr>
           <tr><td align=left>Request Mode  : '||v_mode   ||' batch </td></tr>
           <tr><td align=left>File Name     : '||lv_basefile||'.'||dw_glob_var.gv_cmprs_fl_ext ||'  </td></tr>
           <tr><td align=left>URL     : '||dw_glob_var.lv_download_path||lv_basefile||'.'||dw_glob_var.gv_cmprs_fl_ext ||'  </td></tr>
           <tr><td align=left>Email Address : '||lv_email||'  </td></tr>
           <tr><td> </td> </tr>
           <tr><td align=left>You will be notified when the request is processed.   </td></tr>
         </table>');

            htp.print('<form><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></form></center>');
--TEST
/*

FOR i IN 1 .. v_Columns.LAST LOOP
HTP.PRINT(V_COLUMNS(i));
END LOOP;
*/
--END OF TEST
	DW_bottom_of_page(7);

  end if;

END;
/

