CREATE OR REPLACE PROCEDURE DW_STATION_download_custom
(v_FromStmt			IN	VARCHAR2,
v_WhereStmt			IN	VARCHAR2,
v_Columns			IN	owa_util.ident_arr,
v_filename                	IN	varchar2,
P_email				IN	VARCHAR2,
p_prefix			in      varchar2,
v_mode				IN	VARCHAR2,
p_record_count			in	number,
v_filters			in 	varchar2,
out_file			OUT	varchar2,
request_id 			out     number
) AS
--The out_file variable, the output of this routine, contains the entire URL of
--the file created herein for the online processing.  For Overnight/Immediate processing only the file name, not the virtual path.

-- File handler while creating a file using utl_file package.
my_out_file		UTL_FILE.FILE_TYPE;
--
--Name of downloadable file that will be created on the server.  This
--file name will be generated based on the current date and time.
out_file_name		VARCHAR2(30);
iodir         		VARCHAR2(100);
download_path 		VARCHAR2(100);
lv_rows       		NUMBER;

v_pk_isn		NUMBER(12);
v_Dummy			INTEGER;
v_CursorID		INTEGER;
v_SQLStmt		VARCHAR2(32000);
v_SelectStmt		VARCHAR2(32000);
v_ReturnRow   		VARCHAR2(32000);
v_Print_Name		VARCHAR2(40);
v_Print_Names_List	VARCHAR2(32000);
v_FromStmtNew 		VARCHAR2(32000);
v_WhereStmtNew 		VARCHAR2(32000);
v_CurrentColumn		VARCHAR2(200);

--flags used to ensure a table is not included twice in the FROM clause
f_LU_STATN_TYPES 	BOOLEAN := FALSE;
f_LU_GEO_STATE 		BOOLEAN := FALSE;

v_exists 		boolean;
v_blocksize 		number;

LV_FILE_LENGTH number;
LV_FILE_NAME varchar2(50);
LV_FILETYPE varchar2(3);
LV_TIMESTAMP varchar2(20);
v_stn_report_number	number;

lv_request_id dw_data_requests.request_id%type;
jn binary_integer;

CURSOR c_ReportColumn IS
	SELECT print_name,col_name
		FROM APP_COLUMN_NAME
		WHERE stn_report_number = v_stn_report_number
		ORDER BY stn_col_order;

lv_outfile_display varchar2(200);

BEGIN
rollback;

v_SelectStmt := 'SELECT DISTINCT(FA.pk_isn),';
v_FromStmtNew := v_FromStmt;
v_WhereStmtNew := v_WhereStmt;
--include appropriate tables based on columns selected
	FOR i IN 1 .. v_Columns.LAST LOOP
		v_stn_report_number := TO_NUMBER(v_Columns(i));
		--OPEN c_ReportColumn;
		FOR ReportColumn in c_ReportColumn LOOP
			--v_SelectStmt := v_SelectStmt ||ReportColumn.col_name||'||''~''||';
			--SELECT print_name INTO v_print_name
			--	FROM APP_COLUMN_NAME2
			--	WHERE col_name = v_Columns(i);
			v_CurrentColumn := ReportColumn.col_name;
			v_print_names_list := v_print_names_list||ReportColumn.print_name||'~';

		IF ReportColumn.col_name = 'PRIMARY_TYPE' OR ReportColumn.col_name = 'SECONDARY_TYPE' THEN
			IF f_LU_STATN_TYPES = FALSE THEN
				v_FromStmtNew := v_FromStmtNew||',DI_STATN_TYPES st';
				v_WhereStmtNew := v_WhereStmtNew||' AND fk_statn_types = st.pk_isn (+)';
				f_LU_STATN_TYPES := TRUE;
			END IF;
		END IF;
		IF ReportColumn.col_name = 'HD.ID_CODE' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM hd';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_mad_hdatum = hd.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'SHD.ID_CODE' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM shd';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_std_hdatum = shd.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'GEOPOSITIONING_METHOD' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HMETHOD hm';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_mad_hmethod = hm.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'ORGANIZATION_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_ORG og';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_org = og.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'ELEVATION_DATUM' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_VDATUM vd';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_mad_vdatum = vd.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'ELEVATION_METHOD' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_VMETHOD vm';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_mad_vmethod = vm.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'STATE_NAME' OR ReportColumn.col_name = 'COUNTRY_NAME' THEN
			IF f_LU_GEO_STATE = FALSE THEN
				v_FromStmtNew := v_FromStmtNew||',DI_GEO_STATE gs';
				v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_state = gs.pk_isn (+)';
				f_LU_GEO_STATE := TRUE;
			END IF;
		END IF;
		IF ReportColumn.col_name = 'COUNTY_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_GEO_COUNTY gc';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_county = gc.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME' AND ReportColumn.print_name = 'Hydrologic Unit Name' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_DB_CAT ca';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_db_cat = ca.pk_isn (+)';
			v_CurrentColumn:= 'ca.'||ReportColumn.col_name;
		END IF;
	      -- added for Generated_HUName
		IF ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME' AND
                     ReportColumn.print_name = 'Generated Hydrologic Unit Name' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_DB_CAT ca2';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_gen_db_cat = ca2.pk_isn (+)';
			v_CurrentColumn:= 'ca2.'||ReportColumn.col_name;
		END IF;
		IF ReportColumn.col_name = 'PRIMARY_ESTUARY' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_ESTRY_PRIMARY ep';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_estry_primary = ep.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'SECONDARY_ESTUARY' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_ESTRY_SECONDARY es';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_estry_secondary = es.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'FA.BLOB_ID' THEN
			v_CurrentColumn := 'DECODE(FA.BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.BLOB_ID)''';
		END IF;
		--CLOSE c_ReportColumn;
		v_SelectStmt := v_SelectStmt ||v_CurrentColumn||'||''~''||';
		END LOOP;
	END LOOP;

v_SelectStmt := RTRIM(v_SelectStmt,'||''~''||');
v_print_names_list := RTRIM(v_print_names_list,'||''~''||');

--v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD'' ORDER BY organization_id, station_id';
v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;


--checking to see if a filename is passed
if (v_filename <> 'NONE') then
	out_file_name := v_filename;
else
	-- Generating a unique name for creating a file on the server.
	out_file_name := TO_CHAR(SYSDATE,'YYYYMMDD_HH24MISS');
--	out_file_name := 'SDS'||out_file_name||'.txt' ;
--v2062
        out_file_name := out_file_name||'.txt' ;
end if;

-- set file related parameters.
  lv_file_length:=null;
  lv_file_name:=out_file_name;
  lv_filetype:='SDS';
--  lv_timestamp:=substr(out_file_name,4,15);
--v2062
  lv_timestamp:=substr(out_file_name,1,15);

  download_path := DW_GLOB_VAR.LV_DOWNLOAD_PATH;
  -- out_file is an out parameter.  It holds URL of the downloadable file that
  -- will be created by this procedure.
  if v_mode = 'Online' then
    out_file:=download_path||out_file_name;
  elsif v_mode in ('Overnight','Immediate') then
    out_file:=p_prefix||'_'||out_file_name;
  lv_file_name:=p_prefix||'_'||out_file_name;
  end if;

--htp.print(v_sqlstmt||'<br>'||v_print_names_list);
if v_mode = 'Online' then
  v_CursorID := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(v_CursorID, v_SQLStmt, DBMS_SQL.NATIVE);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_pk_isn, 12);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 2, v_ReturnRow, 32000);

  v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

  --
  -- File handler used by utl_file package.
  --
  iodir := DW_GLOB_VAR.LV_IODIR;
  my_out_file := UTL_FILE.FOPEN(iodir,out_file_name,'W',30000);
  --
  UTL_FILE.PUT_LINE(my_out_file,v_print_names_list);
  LOOP
    IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
	EXIT;
    END IF;
      DBMS_SQL.COLUMN_VALUE(v_CursorID, 2, v_ReturnRow);
      UTL_FILE.PUT_LINE(my_out_file,v_ReturnRow);
  END LOOP;
   DBMS_SQL.CLOSE_CURSOR(v_CursorID);
   UTL_FILE.FCLOSE(my_out_file);


end if;

-- Online - find the length of the file after closing the file
  if v_mode = 'Online' then
    utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,out_file,v_exists,lv_file_length,v_blocksize);
    --htp.print('<br><br>The size of your report download is <b>'||ROUND(lv_file_length/1024,1)||'KB</b>');
    lv_file_length:=ROUND(lv_file_length/1024,1);
  else
    lv_file_length:=null;
  end if;
-- Call the Dw_record_data_request to record the request.

--lv_outfile_display:='Data_'||replace(out_file,'.txt','_Stations.txt');
lv_outfile_display:=replace(out_file,'.txt','');
 
  dw_record_data_request(v_filters,lv_filetype,lv_timestamp,lv_file_length,v_print_names_list,V_MODE,P_email,v_SQLStmt,null,null,null,lv_file_name,p_record_count,lv_request_id);

    if v_mode = 'Immediate' THEN
      --dbms_job.SUBMIT(jn,'dw_process_data_request('||lv_request_id||');',sysdate + 1/1440);
      dbms_job.SUBMIT(jn,'dw_process_data_request('||lv_request_id||');');
      --dbms_output.put_line(jn);
      update dw_data_requests
       set job_queue_id = jn,
           processed_date=sysdate
       where request_id = lv_request_id;
      commit;
    end if;

  if v_mode in ('Overnight','Immediate') then
    dw_mail_pkg.send
    ( p_sender_email => dw_glob_var.gv_storet_email,
       p_from => 'STORET Web Site <'||dw_glob_var.gv_storet_email||'>',
       p_to => dw_mail_pkg.array( p_email),
       p_subject => 'STORET data request submitted (PROCESSING).  Request_ID: '||lv_request_id,
       p_body =>
'Your request for Station Download is submitted for '||v_mode||' batch processing.

Following is your request information:

Request ID    :  '||lv_request_id ||'
Request Type  :  Station Download
Record Count  :  '||p_record_count ||'
Request Mode  :  '||v_mode ||' batch
File Name     :  '||lv_outfile_display||'.'||dw_glob_var.gv_cmprs_fl_ext  ||'
URL           :  '||download_path||lv_outfile_display||'.'||dw_glob_var.gv_cmprs_fl_ext  ||'
Email provided:  '||p_email ||'

You will be notified when the request is processed.');
  end if;
request_id:= lv_request_id;

EXCEPTION
  WHEN UTL_FILE.INVALID_PATH THEN DBMS_OUTPUT.PUT_LINE ('INVALID PATH');
  commit;
  WHEN UTL_FILE.INVALID_MODE THEN DBMS_OUTPUT.PUT_LINE ('INVALID MODE');
  commit;
  WHEN UTL_FILE.INVALID_FILEHANDLE THEN
  commit;
    DBMS_OUTPUT.PUT_LINE ('INVALID FILEHANDLE');
  WHEN UTL_FILE.INVALID_OPERATION THEN
    DBMS_OUTPUT.PUT_LINE ('INVALID OPERATION');
  commit;
  WHEN UTL_FILE.READ_ERROR THEN DBMS_OUTPUT.PUT_LINE ('BAD READ');
  commit;
  WHEN UTL_FILE.WRITE_ERROR THEN DBMS_OUTPUT.PUT_LINE ('BAD WRITE');
  commit;
  WHEN UTL_FILE.INTERNAL_ERROR THEN DBMS_OUTPUT.PUT_LINE ('INTERNAL');
  commit;
  when others then
  dbms_output.put_line(sqlerrm);
END;
/

