/*******************************************************
Filename		:  	SP_UPDATE_TRIBAL_IN_RESULTS.sql
Release 		:  	
SIR			:  	CR-16
Description		:  	Updates results tables to keep 'tribal' in sync with station_char table
Author		        :	Tim Holtz
Date			: 	July 13, 2007
Comments		:  	Output arguments are:
				- upon successful execution:
					out_status='SUCCESS'
					out_message=null
				- upon execution failure:
					out_status='FAILURE'
					out_message=SQLERRM

**********************************************************/
SET DEF OFF;

create or replace
PROCEDURE SP_UPDATE_TRIBAL_IN_RESULTS (
	out_status out varchar2,
	out_message out varchar2) AS

x VARCHAR2(1); -- to test exception...

BEGIN

out_status := 'SUCCESS';
out_message := null;

-- update tribal columns in fa_biological_result
Update fa_biological_result b
Set TRIBAL_WATER_QUALITY_MEASURE ='Y'
WHERE exists (select 1 from station_char sc
    Where sc.fk_fa_statn=b.fk_station
      And sc.fk_char=b.fk_char
      And sc.TRIBAL_WATER_QUALITY_MEASURE ='Y');
COMMIT;

Update fa_biological_result b
Set TRIBAL_WATER_QUALITY_MEASURE ='N'
WHERE not exists (select 1 from station_char sc
    Where sc.fk_fa_statn=b.fk_station
      And sc.fk_char=b.fk_char
      And sc.TRIBAL_WATER_QUALITY_MEASURE ='Y');
COMMIT;

-- update tribal columns in fa_habitat_result
Update fa_habitat_result h
Set TRIBAL_WATER_QUALITY_MEASURE ='Y'
WHERE exists (select 1 from station_char sc
    Where sc.fk_fa_statn=h.fk_station
      And sc.fk_char=h.fk_char
      And sc.TRIBAL_WATER_QUALITY_MEASURE ='Y');
COMMIT;

Update fa_habitat_result h
Set TRIBAL_WATER_QUALITY_MEASURE ='N'
WHERE not exists (select 1 from station_char sc
    Where sc.fk_fa_statn=h.fk_station
      And sc.fk_char=h.fk_char
      And sc.TRIBAL_WATER_QUALITY_MEASURE ='Y');
COMMIT;

-- update tribal columns in fa_regular_result
Update fa_regular_result r
Set TRIBAL_WATER_QUALITY_MEASURE ='Y'
WHERE EXISTS (SELECT 1 FROM STATION_CHAR SC
      Where sc.fk_fa_statn=r.fk_station
        And sc.fk_char=r.fk_char
        And sc.TRIBAL_WATER_QUALITY_MEASURE ='Y');
COMMIT;

Update fa_regular_result r
Set TRIBAL_WATER_QUALITY_MEASURE ='N'
WHERE not exists (select 1 from station_char sc
    Where sc.fk_fa_statn=r.fk_station
      And sc.fk_char=r.fk_char
      And sc.TRIBAL_WATER_QUALITY_MEASURE ='Y');
COMMIT;

-- update tribal columns in station_char
Update fa_station s
Set TRIBAL_WATER_QUALITY_MEASURE ='Y'
WHERE exists (select 1 from station_char sc
    Where sc.fk_fa_statn=s.pk_isn
      And sc.TRIBAL_WATER_QUALITY_MEASURE ='Y');
COMMIT;

Update fa_station s
Set TRIBAL_WATER_QUALITY_MEASURE ='N'
WHERE not exists (select 1 from station_char sc
    Where sc.fk_fa_statn=s.pk_isn
      And sc.TRIBAL_WATER_QUALITY_MEASURE ='Y');
COMMIT;

-- to test exception...
--select sc.TRIBAL_WATER_QUALITY_MEASURE into x from station_char sc
--    Where sc.TRIBAL_WATER_QUALITY_MEASURE ='Y';

RETURN; 

exception
    when OTHERS THEN
	out_status := 'FAILURE';
	out_message := SQLERRM;

RETURN;

END SP_UPDATE_TRIBAL_IN_RESULTS;
/
SHOW ERRORS;