spool char_table1.log

-- drop commands
drop table DI_Char;

create table DI_Char 
tablespace storetdata
storage (initial 10M next 10M) 
nologging 
as
select tsrchar_is_number pk_isn, 
       display_name "CHARACTERISTIC_GROUP_TYPE",
       search_name,display_name,
       char_type_code type_code
from storet.tsrchar c
where (c.char_type_code !='T')
or (c.char_type_code ='T' 
    and exists (select 'x' from station_char sc
             where sc.FK_CHAR=c.tsrchar_is_number));
commit;

-- 11/02/2009 CR kevin
alter table STORETW.DI_Char
MODIFY (CHARACTERISTIC_GROUP_TYPE NULL,display_name  NULL,search_name NULL);

-- create user def hab assessment characteristic
/*
insert into di_char 
	values (999999,'USER DEFINED HABITAT CHARACTERISTIC', 'User Defined Habitat Characteristic','H');
commit;
*/
insert into di_char 
(PK_ISN       ,  
SEARCH_NAME  ,  
DISPLAY_NAME,
TYPE_CODE    )
values (999999,'USER DEFINED HABITAT CHARACTERISTIC', 'User Defined Habitat Characteristic','H');
commit;


alter table DI_Char
add constraint pk_char1 primary key (pk_isn)
using index
tablespace storetindx
storage (initial  512K next 512K);

create index ichar011 on DI_Char(search_name)
tablespace storetindx
storage (initial 512K next 256K) nologging;

create bitmap index ichar012 on DI_Char(type_code) nologging;


-- CHARACTERISTIC_GROUP_TYPE
spool off;