spool column_comments.log
--pre statistics
select 'Total_Column_count: '||count(*) Total_Column_count from user_col_comments;
select 'Total Columns with comments: '||count(*) Total_Column_count from user_col_comments
where trim(comments) is not null;

select 'Total Columns without comments: '||count(*) Total_Column_count from user_col_comments
where trim(comments) is null;

comment on column APP_COLUMN_NAME.BIO_COL_ORDER is 'Attribute order within a group reporting element for Biological Results' ;
--comment on column APP_COLUMN_NAME.BIO_COL_ORDER is 'Attribute order within a group reporting element for Biological Results' ;
comment on column APP_COLUMN_NAME.BIO_ELEMENT_DEFAULT is 'Default element selection flag for Biological Result report customization.' ;
comment on column APP_COLUMN_NAME.BIO_REPORT_NUMBER is 'A number representing element display order for Biological Result report customization.' ;
comment on column APP_COLUMN_NAME.COL_NAME is 'Name of the reporting element as in physical table structure.' ;
comment on column APP_COLUMN_NAME.ELEMENT_NAME is 'Name of element (individual or group) to be used in report customization page.' ;
comment on column APP_COLUMN_NAME.HAB_COL_ORDER is 'Attribute order within a group reporting element for Habitat Results' ;
comment on column APP_COLUMN_NAME.HAB_ELEMENT_DEFAULT is 'Default element selection flag for Habitat Result report customization.' ;
comment on column APP_COLUMN_NAME.HAB_REPORT_NUMBER is 'A number representing element display order for Habitat Result report customization.' ;
comment on column APP_COLUMN_NAME.HELP_LINK is 'STORET help page internal anchor name.  This will help point to specific location in the help document.' ;
comment on column APP_COLUMN_NAME.PRINT_NAME is 'Name of the element to be used for reporting (download file).' ;
comment on column APP_COLUMN_NAME.REG_COL_ORDER is 'Attribute order within a group reporting element for Regular Results' ;
comment on column APP_COLUMN_NAME.REG_ELEMENT_DEFAULT is 'Default element selection flag for Regular Result report customization.' ;
comment on column APP_COLUMN_NAME.REG_REPORT_NUMBER is 'A number representing element display order for Regular Result report customization.' ;
comment on column APP_COLUMN_NAME.STN_COL_ORDER is 'Attribute order within a group reporting element for Station reporting.' ;
comment on column APP_COLUMN_NAME.STN_ELEMENT_DEFAULT is 'Default element selection flag for Station report customization.' ;
comment on column APP_COLUMN_NAME.STN_REPORT_NUMBER is 'A number representing element display order for Station report customization.' ;
comment on column BIOLOGICAL_RESULT_PROJECT.FK_PROJECT is 'Foreign Key referencing DI_PROJECT.' ;
comment on column BIOLOGICAL_RESULT_PROJECT.FK_RESULT is 'Foreign Key referencing DI_RESULT.' ;
comment on column DI_ACTIVITY_INTENT.ACTIVITY_INTENT is 'The primary reason the Field Activity occurred.   Note: This is mandatory for Biological Medium, and not available for other media.' ;
comment on column DI_ACTIVITY_INTENT.PK_ISN is 'Primary Key. Generated using sequence object SEQ_ACTIVITY_INTENT.' ;
comment on column DI_ACTIVITY_MATRIX.MATRIX_CODE is 'A cryptic code which represents the sampled matrix.  Used as a shorthand or abbreviation to represent the Sampled Matrix in batch data update runs. ' ;
comment on column DI_ACTIVITY_MATRIX.MATRIX_DESCRIPTION is 'Full description or definition of the sampled matrix.' ;
comment on column DI_ACTIVITY_MATRIX.MATRIX_NAME is 'The short name of the Sample Matrix. Used in populating the drop down list on data entry windows.' ;
comment on column DI_ACTIVITY_MATRIX.PK_ISN is 'Primary Key. Generated using sequence object SEQ_ACTIVITY_MATRIX.' ;
comment on column DI_ACTIVITY_MEDIUM.ACTIVITY_MEDIUM is 'The name of the medium or matrix where the Field Activity occurred.' ;
comment on column DI_ACTIVITY_MEDIUM.PK_ISN is 'Primary Key. Generated using sequence object SEQ_ACTIVITY_MEDIUM.' ;
comment on column DI_BIOPART.BIOPART_NAME is 'The foreign key to TSRBIOPT inplements "One Biopart (tissue, organ) may be the subject tissue for many Field Activities/Samples whose medium is biological and whose intent is Tissue.' ;
comment on column DI_BIOPART.PK_ISN is 'Primary Key. Generated using sequence object SEQ_BIOPART.' ;
comment on column DI_CHARACTERISTIC.DISPLAY_NAME is 'The name of the environmental characteristic as it is to be displayed on windows and reports.' ;
comment on column DI_CHARACTERISTIC.PK_ISN is 'Primary Key. Generated using sequence object SEQ_CHARACTERISTIC.' ;
comment on column DI_CHARACTERISTIC.SEARCH_NAME is 'The standardized form of the name as determined by EPA for use in searching the list of environmental characteristics.  All caps for consistent search results.' ;
comment on column DI_CHARACTERISTIC.TYPE_CODE is 'A code indicating type of characteristic.' ;
comment on column DI_COMMUNITY_SAMPLED.ACTIVITY_COMMUNITY is 'The name of the Biological Community from which the Sample was taken.   Note: This is only valid when MEDIUM_TYPE_NAME is BIOLOGICAL and INTENT_TYPE_NAME is TAXON ABUNDANCE.' ;
comment on column DI_COMMUNITY_SAMPLED.PK_ISN is 'Primary Key. Generated using sequence object SEQ_COMMUNITY_SAMPLED.' ;
comment on column DI_DATE.DAY_NUMBER_IN_MONTH is 'Day number in the month' ;
comment on column DI_DATE.DAY_NUMBER_OVERALL is 'Cumulative Day number with reference to 01/01/1900.' ;
comment on column DI_DATE.DAY_OF_WEEK is 'Day of the Week' ;
comment on column DI_DATE.FISCAL_PERIOD is 'Calender fiscal year starts on January 1st and ends on December 31st.' ;
comment on column DI_DATE.FULL_DATE is 'Day, month and year of the date.' ;
comment on column DI_DATE.LAST_DAY_IN_MONTH_FLAG is 'Flag indicating last day of the month.' ;
comment on column DI_DATE.MONTH is 'Month of the year' ;
comment on column DI_DATE.MONTH_NUMBER_OVERALL is 'Cumulative number of the month with reference to 01/01/1900.' ;
comment on column DI_DATE.PK_ISN is 'Primary Key. Generated using sequence object SEQ_DATE.' ;
comment on column DI_DATE.QUARTER is 'Quarter of the year.' ;
comment on column DI_DATE.WEEKDAY_FLAG is 'Weekday flag.  Monday through Friday are weekdays.' ;
comment on column DI_DATE.WEEK_NUMBER_IN_YEAR is 'Number of the week in the year.' ;
comment on column DI_DATE.WEEK_NUMBER_OVERALL is 'Cumulative number of the week with reference to 01/01/1900.' ;
comment on column DI_DB_CAT.HYDROLOGIC_UNIT_CODE is 'The Federal Information Processing Standard (FIPS) code for Hydrologic Units, as defined in FIPS Publication 103.' ;
comment on column DI_DB_CAT.HYDROLOGIC_UNIT_NAME is 'The Federal Information Processing Standard (FIPS) name associated with code established for Hydrologic Units, as defined in FIPS Publication 103.' ;
comment on column DI_DB_CAT.PK_ISN is 'Primary Key. Generated using sequence object SEQ_COMMUNITY_SAMPLED.' ;
comment on column DI_GEO_COUNTY.COUNTY_NAME is 'The name of the county or county equivalent (when applicable).' ;
comment on column DI_GEO_COUNTY.FIPS_COUNTY_CODE is 'The 3-character Federal Information Processing Standard (FIPS) code representing the county or county equivalent (when applicable).' ;
comment on column DI_GEO_COUNTY.FK_GEO_STATE is 'Foreign Key referencing DI_GEO_STATE.' ;
comment on column DI_GEO_COUNTY.PK_ISN is 'Primary Key. Generated using sequence object SEQ_COMMUNITY_SAMPLED.' ;
comment on column DI_GEO_STATE.COUNTRY_CODE is 'The 2-character Federal Information Processing Standard (FIPS) code (ref FIPS Pub 10-3) representing the Country.' ;
comment on column DI_GEO_STATE.COUNTRY_NAME is 'The name of the Country.' ;
comment on column DI_GEO_STATE.FIPS_STATE_CODE is 'The 2-character Federal Information Processing Standard (FIPS) code representing the State, Province, or equivalent.' ;
comment on column DI_GEO_STATE.PK_ISN is 'Primary Key. Generated using sequence object SEQ_COMMUNITY_SAMPLED.' ;
comment on column DI_GEO_STATE.STATE_NAME is 'The name of the State, Province, or equivalent.' ;
comment on column DI_GEO_STATE.STATE_POSTAL_CODE is 'The official USPS 2-character postal abbreviation for the State, Province, or equivalent.' ;
comment on column DI_GROUP_TYPE.BIO_GROUP_TYPE is 'The name of the kind of group.  Examples include:  1. population census by taxon (non- duplicative species count)    2. Coliform bacteria census by taxon    3. Single taxon frequency class    4. Single taxon group summary    5. Single taxon individual' ;
comment on column DI_GROUP_TYPE.PK_ISN is 'Primary Key. Generated using sequence object SEQ_GROUP_TYPE.' ;
comment on column DI_ORG.DESCRIPTION is 'The text describing details of the Organization that users may wish to provide.  For example, this text may be used to describe the purpose, mission, or goals of the Organization.' ;
comment on column DI_ORG.ORGANIZATION_DESCRIPTION is 'The text describing details of the Organization that users may wish to provide.  For example, this text may be used to describe the purpose, mission, or goals of the Organization.' ;
comment on column DI_ORG.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column DI_ORG.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column DI_ORG.ORGANIZATION_NAME is 'The formal full-length name of the Organization.' ;
comment on column DI_ORG.ORGANIZATION_TYPE is 'The code that describes the type of Organization.' ;
comment on column DI_ORG.PARENT_ORG is 'The formal full name of a higher level organization which directs, is responsible for, or has authority over the activities and operations of the data-owning organization.' ;
comment on column DI_ORG.PK_ISN is 'Primary Key. Generated using sequence object SEQ_OGR.' ;
comment on column DI_PROJECT.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column DI_PROJECT.OBTAIN_PLAN is 'Project Obtain Plan' ;
comment on column DI_PROJECT.PK_ISN is 'Primary Key. Generated using sequence object SEQ_PROJECT.' ;
comment on column DI_PROJECT.PLANNED_DURATION is 'The expected elapsed time of the project.  Examples:  2 Year,  Historical,  Ongoing' ;
comment on column DI_PROJECT.PROJECT_CD is 'The code (combination of text or numbers) used by the owning Organization to uniquely identify the Project or Survey.' ;
comment on column DI_PROJECT.PROJECT_DESCRIPTION is 'The description assigned by the owning Organization to the Project or Survey.' ;
comment on column DI_PROJECT.PROJECT_DESIGN is 'The design assigned by the owning Organization to the Project or Survey.' ;
comment on column DI_PROJECT.PROJECT_NAME is 'The name assigned by the owning Organization to the Project or Survey.' ;
comment on column DI_PROJECT.PURPOSE is 'The purpose assigned by the owning Organization to the Project or Survey.' ;
comment on column DI_PROJECT.QUALITY_ASSURANCE is 'Project Quality Assurance information.' ;
comment on column DI_PROJECT.QUALITY_OBJECTIVES is 'The quality objectives assigned by the owning Organization to the Project or Survey.' ;
comment on column DI_PROJECT.SOURCE_SYSTEM is 'Source system acronym from which the record was extracted, transformed and loaded into Warehouse.' ;
comment on column DI_PROJECT.SOURCE_UID is 'Source Systems Unique Identifier for the record in question.' ;
comment on column DI_PROJECT.START_DATE is 'The date (in format MM-DD-YYYY) on which a Project or Survey is scheduled to begin.' ;
comment on column DI_PROJECT.STUDY_AREA is 'The study area assigned by the owning Organization to the Project or Survey.' ;
comment on column DI_PROJECT.TSMPROJ_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column DI_PROJECT.TSMPROJ_ORG_ID is 'The user-defined code that uniquely identifies the Organization to which each occurrence of this table applies. This identifying attribute has been added to this table for purposes of application security. Security is driven by user access to a given Organization(s).' ;
comment on column DI_STATN_TYPES.PK_ISN is 'Primary Key. Generated using sequence object SEQ_STATN_TYPES.' ;
comment on column DI_STATN_TYPES.PRIMARY_TYPE is 'The code that represents the primary type designation of a Station.' ;
comment on column DI_STATN_TYPES.SECONDARY_TYPE is 'The code that represents the secondary type designation of a Station.  Not every combination requires a Secondary Type.' ;
comment on column DI_STATN_TYPES.SGO_INDICATOR is 'Surface, Ground, Other indicator. Each of the primary station types were mapped to one of these three values.' ;
comment on column DI_STATN_TYPES.SORT_ORDER is 'Sort order for station type selection box on web pages' ;
comment on column DI_SUBJECT_TAXON.ACTIVITY_SUBJECT_TAXON is 'Subject Taxon identifies the organism that composes the sample when the activity intent is Tissue or Individual.' ;
comment on column DI_SUBJECT_TAXON.PK_ISN is 'Primary Key. Generated using sequence object SEQ_SUBJECT_TAXON.' ;
comment on column DW_DATA_REQUESTS.DATETIME is 'Timestamp when the request from warehouse was performed.' ;
comment on column DW_DATA_REQUESTS.EMAIL_ADDRESS is 'Text or codes which are used to specify an Electronic Address for an Organization or an individual.' ;
comment on column DW_DATA_REQUESTS.FILENAME is 'Name of report file.' ;
comment on column DW_DATA_REQUESTS.FILESIZE_KB is 'File size in Kilobytes.' ;
comment on column DW_DATA_REQUESTS.F_ACT_INTENT is 'Flag to indicate if Activity Intent was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_ACT_MEDIUM is 'Flag to indicate if Activity Medium was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_ACT_STARTDATE is 'Flag to indicate if Activity Start Date was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_CHARACTERISTIC is 'Flag to indicate if Characteristics was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_COMMUNITY_SAMPLED is 'Flag to indicate if community sampled was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_COUNTY is 'Flag to indicate if County was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_HUC is 'Flag to indicate if  Hydrologic Unit Code was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_LATLONG is 'Flag to indicate if Latitude and Longitude were used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_ORGANIZATION is 'Flag to indicate if Organization was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_PROJECT is 'Flag to indicate if Project was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_STATE is 'Flag to indicate if State was used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_STATION is 'Flag to indicate if Stations were used in the query filters.' ;
comment on column DW_DATA_REQUESTS.F_STATIONTYPE is 'Flag to indicate if Station Types were used in the query filters.' ;
comment on column DW_DATA_REQUESTS.JOB_QUEUE_ID is 'Batch Job queue ID. Issued by Oracle system when a job is schedule to run.' ;
comment on column DW_DATA_REQUESTS.NOTIFIED is 'Flag to indicate if application user is notified of the batch job.' ;
comment on column DW_DATA_REQUESTS.PROCESSED_DATE is 'Batch Job processed date.' ;
comment on column DW_DATA_REQUESTS.QUERY_TEXT is 'The 4000 characters of the query generated based on application users request.' ;
comment on column DW_DATA_REQUESTS.QUERY_TEXT2 is 'The next 4000 characters of the query generated based on application users request.' ;
comment on column DW_DATA_REQUESTS.RECORD_COUNT is 'Report Record count of the user query.' ;
comment on column DW_DATA_REQUESTS.RECORD_TITLE is 'Record Title for the creating the Report download file. This is generated based on the user selections in report customization on Summary page.' ;
comment on column DW_DATA_REQUESTS.REQUEST_ID is 'User report request ID. Generated by the application using a sequence number.' ;
comment on column DW_DATA_REQUESTS.REQUEST_MODE is 'Report request mode. Immediate and Overnight are valid Batch request options.  Online is used for interactive data request.' ;
comment on column DW_DATA_REQUESTS.REQUEST_STATUS is 'Status of the Batch request.' ;
comment on column DW_DATA_REQUESTS.REQUEST_TYPE is 'Report request type representing the available report types for data download. (Example: Biological, Regular, Habitat, station, etc.)' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_CATEGORY is 'A descriptor used to distinguish different kinds of samples and different kinds of Measurements and Observations.  The permitted value list is controlled by the choice of TYPE_NAME (above), with the entries in TSMPRMVL for CATEGORY_TYPE_NAME_M used for activities of type Msr/Obs, while CATEGORY_TYPE_NAME_S is used for activities of type Sample.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_COMMUNITY is 'The name of the Biological Community from which the Sample was taken.   Note: This is only valid when MEDIUM_TYPE_NAME is BIOLOGICAL and INTENT_TYPE_NAME is TAXON ABUNDANCE.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_DEPTH is 'Distance from the surface to the point in the water column at which the activity is conducted.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_DEPTH_REF_POINT is 'The text that describes the reference point from which the depth is measured, typically "Surface".' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_DEPTH_UNIT is 'Activity Depth Unit' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_ID is 'User provided string that identifies the activity with in his/her organization.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_INTENT is 'The primary reason the Field Activity occurred.   Note: This is mandatory for Biological Medium, and not available for other media..' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_ISN is 'STORET Activitys internal serial number.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_IS_NUMBER is 'STORET Activitys internal serial number.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_LATITUDE is 'Latitue at which activity occurred.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_LONGITUDE is 'Longitude at which activity occurred.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_LOWER_DEPTH is 'This measure is associated with an activity that is normally conducted over or within a vertical depth range within the water column. This attribute is a measure of the distance from the surface to the lower boundary of the zone within which the activity is conducted or over which the activity is integrated.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_MEDIUM is 'The name of the medium or matrix where the Field Activity occurred.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_REL_DEPTH is 'Activity relative depth from the reference point' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_START_DATE_TIME is 'For Samples Collected or for Measurements/Observations made - the date that the Field Activity began.  For Samples Created from other samples - the date on which a sample is created by compositing, splitting, or subsampling from a parent sample.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_STOP_DATE_TIME is 'Date and time at which the Activity was stopped.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_SUBJECT_TAXON is 'Subject Taxon identifies the organism that composes the sample when the activity intent is Tissue or Individual.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_TYPE is 'Type of Activity.  Example: Sample or Measurement/Observation.' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_UPPER_DEPTH is 'This measure is associated with an activity that is normally conducted over or within a vertical depth range within the water column. This attribute is a measure of the distance from the surface to the upper boundary of the zone within which the activity is conducted or over which the activity is integrated.' ;
comment on column FA_BIOLOGICAL_RESULT.ACT_BLOB_ID is 'Activity Binary Large Object identifier.' ;
comment on column FA_BIOLOGICAL_RESULT.ACT_BLOB_TITLE is 'User-defined Title defining or describing the BLOB Content.' ;
comment on column FA_BIOLOGICAL_RESULT.ACT_START_TIME_ZONE is 'Activity Start Time Zone' ;
comment on column FA_BIOLOGICAL_RESULT.ACT_STD_HDATUM is 'Activity Standard Horizontal Datum.  The user provided data is converted to this standard datum during the ETL.' ;
comment on column FA_BIOLOGICAL_RESULT.ACT_STD_LATITUDE is 'Activity Latitude measure in Activity Standard Horizontal Datum.' ;
comment on column FA_BIOLOGICAL_RESULT.ACT_STD_LONGITUDE is 'Activity Longitude measure in Activity Standard Horizontal Datum.' ;
comment on column FA_BIOLOGICAL_RESULT.ACT_STOP_TIME_ZONE is 'Activity Stop Time Zone.' ;
comment on column FA_BIOLOGICAL_RESULT.AMPERAGE_MEASURE is 'The magnitude of the current (amperes) produced by the electroshock equipment used to collect the Sample.' ;
comment on column FA_BIOLOGICAL_RESULT.ANALYSIS_DATE_TIME is 'Sample Analysis Date and time stamp' ;
comment on column FA_BIOLOGICAL_RESULT.ANALYSIS_TIME_ZONE is 'The time zone for which the time of day is reported.  Any of the longitudinal divisions of the earths surface in which a standard time is kept. Each zone observes a clock time one hour earlier than the zone immediately to the east.' ;
comment on column FA_BIOLOGICAL_RESULT.ANALYTICAL_METHOD_LIST_AGENCY is 'Analytical method list agency' ;
comment on column FA_BIOLOGICAL_RESULT.ANALYTICAL_METHOD_LIST_VER is 'Analytical method list version.' ;
comment on column FA_BIOLOGICAL_RESULT.ANALYTICAL_PROCEDURE_ID is 'The abbreviated name or identifying code of the analytical procedure.' ;
comment on column FA_BIOLOGICAL_RESULT.ANALYTICAL_PROCEDURE_SOURCE is 'The name of the Analytical Procedure Owner.  Examples include the American Society for Testing Materials, the United States Geological Survey, and the Environmental Protection Agency.' ;
comment on column FA_BIOLOGICAL_RESULT.BIAS is 'A consistent deviation of measured values from the true value, caused by systematic errors in a procedure, as determined by applying identical procedures to a specimen of known properties.' ;
comment on column FA_BIOLOGICAL_RESULT.BIOPART_NAME is 'The foreign key to TSRBIOPT inplements "One Biopart (tissue, organ) may be the subject tissue for many Field Activities/Samples whose medium is biological and whose intent is Tissue.' ;
comment on column FA_BIOLOGICAL_RESULT.BIO_GROUP_COUNT_TYPE is 'Biological Group count Type' ;
comment on column FA_BIOLOGICAL_RESULT.BIO_GROUP_DESCRIPTION is 'Biological Group Description.' ;
comment on column FA_BIOLOGICAL_RESULT.BIO_GROUP_ID is 'Biological Group ID' ;
comment on column FA_BIOLOGICAL_RESULT.BIO_GROUP_SUBJECT_TXN is 'Biological Group Subject Taxon.' ;
comment on column FA_BIOLOGICAL_RESULT.BIO_GROUP_TYPE is 'The name of the kind of group.  Examples include:  1. population census by taxon (non- duplicative species count)    2. Coliform bacteria census by taxon    3. Single taxon frequency class    4. Single taxon group summary    5. Single taxon individual' ;
comment on column FA_BIOLOGICAL_RESULT.BIO_RCI_UNITS is 'Biological RCI units' ;
comment on column FA_BIOLOGICAL_RESULT.BLOB_ID is 'Blob ID. Id used to fetch Document Graphic.' ;
comment on column FA_BIOLOGICAL_RESULT.BLOB_TITLE is 'User-defined Title defining or describing the BLOB Content.' ;
comment on column FA_BIOLOGICAL_RESULT.BOAT_SPEED is 'The relative speed, through the water, of the boat during Sample collection.' ;
comment on column FA_BIOLOGICAL_RESULT.CAS_NUMBER is 'EPA CAS number.' ;
comment on column FA_BIOLOGICAL_RESULT.CELL_FORM is 'Cell form' ;
comment on column FA_BIOLOGICAL_RESULT.CELL_SHAPE is 'The cell shape of the phytoplankton organism. For example, a chrysophyta can have a form and a shape.' ;
comment on column FA_BIOLOGICAL_RESULT.CHARACTERISTIC_NAME is 'Name of physical/chemical, biological and habitat characteristics.  It is also called Substance Name in Substance Registry System.' ;
comment on column FA_BIOLOGICAL_RESULT.COMMON_CLASS_DESC is 'Common Class Descriptor' ;
comment on column FA_BIOLOGICAL_RESULT.CONFIDENCE_LEVEL is 'Result Confidence level.' ;
comment on column FA_BIOLOGICAL_RESULT.CONF_LVL_CORR_BIAS is 'A code indicating whether the confidence level has been corrected for Bias.' ;
comment on column FA_BIOLOGICAL_RESULT.CONTAINER_DESC is 'Description of the Sample collection Container.' ;
comment on column FA_BIOLOGICAL_RESULT.CORRECTION_INDICATOR is 'Correction Indicator.' ;
comment on column FA_BIOLOGICAL_RESULT.CURRENT_TYPE_CODE is 'The code that represents the type of current produced by the electroshock equipment.' ;
comment on column FA_BIOLOGICAL_RESULT.DETECTION_LIMIT is 'Result value detection limit' ;
comment on column FA_BIOLOGICAL_RESULT.DETECTION_LIMIT_DESCRIPTION is 'Result value detection value description.' ;
comment on column FA_BIOLOGICAL_RESULT.DILUTION_INDICATOR is 'Sample dilution indicator.' ;
comment on column FA_BIOLOGICAL_RESULT.DISTANCE_MEASURE_FROM is 'Distance measured from the location.' ;
comment on column FA_BIOLOGICAL_RESULT.DISTANCE_MEASURE_TO is 'Distance measured to the location.' ;
comment on column FA_BIOLOGICAL_RESULT.DURATION_BASIS is 'Duration Basis' ;
comment on column FA_BIOLOGICAL_RESULT.ELECTROSHOCK_COMMENT is 'Electroshock comment' ;
comment on column FA_BIOLOGICAL_RESULT.EPA_REG_NUMBER is 'EPA registry number. ' ;
comment on column FA_BIOLOGICAL_RESULT.FEEDING_GROUP is 'Feeding group' ;
comment on column FA_BIOLOGICAL_RESULT.FIELD_GEAR_ID is 'Field Gear ID' ;
comment on column FA_BIOLOGICAL_RESULT.FIELD_PROCEDURE_ID is 'The abbreviated name or identifying code of the analytical procedure.' ;
comment on column FA_BIOLOGICAL_RESULT.FIELD_SET is 'Field Set.' ;
comment on column FA_BIOLOGICAL_RESULT.FISHED_DISTANCE is 'The distance over which the trawl was operated for Sample collection.' ;
comment on column FA_BIOLOGICAL_RESULT.FISHED_DURATION is 'Fished duration.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_ACT_INTENT is 'Foreign Key referencing DI_ACT_INTENT.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_ACT_MAD_HDATUM is 'Foreign Key referencing DI_MAD_HDATUM.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_ACT_MAD_HMETHOD is 'Foreign Key referencing DI_ACT_MAD_HMETHOD.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_ACT_MEDIUM is 'Foreign Key referencing DI_ACT_MEDIUM.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_BIOPART is 'Foreign Key referencing DI_BIOPART.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_CHAR is 'Foreign Key referencing DI_CHAR.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_COMMUNITY_SAMPLED is 'Foreign Key referencing DI_COMMUNITY_SAMPLED.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_DATE_ACT_START is 'Foreign Key referencing DI_DATE_ACT_START.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_DB_CAT is 'Foreign Key referencing DI_DB_CAT.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_GEN_DB_CAT is 'Foreign Key referencing DI_GEN_DB_CAT.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_GEO_COUNTY is 'Foreign Key referencing DI_GEO_COUNTY.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_GEO_STATE is 'Foreign Key referencing DI_GEO_STATE.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_GROUP_TYPE is 'Foreign Key referencing DI_GROUP_TYPE.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_STATION is 'Foreign Key referencing DI_STATION.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_STATN_TYPES is 'Foreign Key referencing DI_STATN_TYPES.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_STN_ACT_PT is 'Foreign Key referencing DI_STN_ACT_PT.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_SUBJECT_TAXON is 'Foreign Key referencing DI_SUBJECT_TAXON.' ;
comment on column FA_BIOLOGICAL_RESULT.FK_UNIT_CONVERSION is 'Foreign Key referencing DI_UNIT_CONVERSION.' ;
comment on column FA_BIOLOGICAL_RESULT.GEAR_CONFIG_ID is 'The code that identifies a Gear Configuration within the Organization.   Note: Must be unique within the Organization.  Used as a shorthand or abbreviation to represent the Gear Configuration in batch data update runs. ' ;
comment on column FA_BIOLOGICAL_RESULT.GENERATED_HUC is 'Generated HUC. If user provided the optional Hydrologic Unit Code, the HUC is generated based on the station location information.' ;
comment on column FA_BIOLOGICAL_RESULT.GROUP_DESC_LIFESTAGE is 'Group description Lifestage' ;
comment on column FA_BIOLOGICAL_RESULT.GROUP_DESC_SEX is 'Group Description Sex' ;
comment on column FA_BIOLOGICAL_RESULT.HABIT is 'Habit' ;
comment on column FA_BIOLOGICAL_RESULT.HYDROLOGIC_UNIT_CODE is 'The Federal Information Processing Standard (FIPS) code for Hydrologic Units, as defined in FIPS Publication 103.' ;
comment on column FA_BIOLOGICAL_RESULT.INDIVIDUAL_NUMBER is 'System assigned sequence number to the individual in accordance with the total number of individuals reported by the user. Once assigned, this number does not change and cannot be changed/deleted.   Each defined group of individuals gets an increasing series of "individual numbers" for the identification of individual specimens from the original group. Results then describe the specific individual.' ;
comment on column FA_BIOLOGICAL_RESULT.ITIS_NUMBER is 'Integrated Taxonomy Information system number.' ;
comment on column FA_BIOLOGICAL_RESULT.LAB_BATCH_ID is 'The code that represents the laboratory batch ID for a result or a group of results. Batch ID may be used to link with Laboratory Data files, which may contain useful information further describing the reported result.' ;
comment on column FA_BIOLOGICAL_RESULT.LAB_CERTIFIED is 'Laboratory Certification information' ;
comment on column FA_BIOLOGICAL_RESULT.LAB_ID is 'Laboratory Identification' ;
comment on column FA_BIOLOGICAL_RESULT.LAB_NAME is 'Laboratory Name' ;
comment on column FA_BIOLOGICAL_RESULT.LAB_REMARK is 'Laboratory Remark' ;
comment on column FA_BIOLOGICAL_RESULT.LOCATION_POINT_TYPE is 'Location Point Type' ;
comment on column FA_BIOLOGICAL_RESULT.LOWER_BOUND_AMOUNT is 'Lower bound amount' ;
comment on column FA_BIOLOGICAL_RESULT.LOWER_QUANTITATION_LIMIT is 'Lower Quantitation Limit' ;
comment on column FA_BIOLOGICAL_RESULT.MAP_SCALE is 'Map Scale' ;
comment on column FA_BIOLOGICAL_RESULT.NUMBER_IN_GROUP is 'Number in the Group' ;
comment on column FA_BIOLOGICAL_RESULT.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column FA_BIOLOGICAL_RESULT.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column FA_BIOLOGICAL_RESULT.ORIENTATION_TO_CURRENT is 'Orientation to Current' ;
comment on column FA_BIOLOGICAL_RESULT.PARTICLE_SIZE is 'User defined free text describing the particle size class for which the associated result is defined..' ;
comment on column FA_BIOLOGICAL_RESULT.PASS_COUNT is 'Pass Count' ;
comment on column FA_BIOLOGICAL_RESULT.PASS_LENGTH is 'Pass length' ;
comment on column FA_BIOLOGICAL_RESULT.PHYS_BIO_INDICATOR is 'Indicator of Physical and Biological result type.' ;
comment on column FA_BIOLOGICAL_RESULT.PIPE_NUMBER is 'Pipe Number' ;
comment on column FA_BIOLOGICAL_RESULT.PK_ISN is 'Primary Key. Generated using sequence object SEQ_BIOLOGICAL_RESULT.' ;
comment on column FA_BIOLOGICAL_RESULT.POINT_NAME is 'User-specified free text name by which a specific absolute location point will be known.' ;
comment on column FA_BIOLOGICAL_RESULT.POINT_SEQUENCE_NUMBER is 'The number that indicates the sequence position of current point among a group of points. For example, if several points are recorded to mark the boundary of a station, the sequence number specifies the order in which the system should "connect the dots."' ;
comment on column FA_BIOLOGICAL_RESULT.POLLUTION_TOLERANCE is 'Pollution tolerance.' ;
comment on column FA_BIOLOGICAL_RESULT.PRECISION is 'Estimate of the maximum possible error in the result. (e.g., Counting error in determining radiological beta particle counts.)' ;
comment on column FA_BIOLOGICAL_RESULT.PRESRV_STRGE_PRCDR is 'Free text description providing additional information about the handling, transport, preservation, and storage of the sample.' ;
comment on column FA_BIOLOGICAL_RESULT.PRIMARY_CLASS_DESC is 'Primary Class Descriptor' ;
comment on column FA_BIOLOGICAL_RESULT.PULSE_RATE is 'The number of times the electric current is interrupted in one second during use of the gear. Units are pulse/second.' ;
comment on column FA_BIOLOGICAL_RESULT.RECOVERY_INDICATOR is 'Recovery Indicator' ;
comment on column FA_BIOLOGICAL_RESULT.REL_CURRENT_DIR is 'Relative current direction' ;
comment on column FA_BIOLOGICAL_RESULT.REL_WIND_DIR is 'Relative wind direction' ;
comment on column FA_BIOLOGICAL_RESULT.REPLICATE_ANALYSIS_COUNT is 'Replication Analysis count' ;
comment on column FA_BIOLOGICAL_RESULT.REPLICATE_NUMBER is 'User-assigned number applied to samples of the same type, medium, etc. to differentiate between them (e.g., Water Replicate 1 and Water Replicate 2, etc.)   Note: This applies only to certain Activity Categories for Samples (replicate, field replicate, depletion replicate, sample created from sample) and Measurements (measurement replicate)- not Observations.' ;
comment on column FA_BIOLOGICAL_RESULT.RESULT_COMMENT is 'Result comment' ;
comment on column FA_BIOLOGICAL_RESULT.RESULT_IS_NUMBER is 'Result table internal serial number' ;
comment on column FA_BIOLOGICAL_RESULT.RESULT_UNIT is 'result value unit code' ;
comment on column FA_BIOLOGICAL_RESULT.RESULT_VALUE is 'result value' ;
comment on column FA_BIOLOGICAL_RESULT.RESULT_VALUE_STATUS is 'Result value status' ;
comment on column FA_BIOLOGICAL_RESULT.RESULT_VALUE_TEXT is 'Result Value in text' ;
comment on column FA_BIOLOGICAL_RESULT.RESULT_VALUE_TYPE is 'Result value type' ;
comment on column FA_BIOLOGICAL_RESULT.SAMPLE_FRACTION_TYPE is 'Sample Fraction Type' ;
comment on column FA_BIOLOGICAL_RESULT.SAMPLING_DURATION is 'The length of time the Trap or Net is considered to be operational (i.e., collecting)' ;
comment on column FA_BIOLOGICAL_RESULT.SECONDARY_CLASS_DESC is 'Secondary Class descriptor' ;
comment on column FA_BIOLOGICAL_RESULT.SGO_INDICATOR is 'Station SGO Indicator' ;
comment on column FA_BIOLOGICAL_RESULT.SMPRP_TRANSPORT_STORAGE_DESC is 'Sample preparation transport storage description' ;
comment on column FA_BIOLOGICAL_RESULT.SOURCE_SYSTEM is 'Source system acronym from which the record was extracted, transformed and loaded into Warehouse.' ;
comment on column FA_BIOLOGICAL_RESULT.SOURCE_UID is 'Related Source System Unique Identifier.' ;
comment on column FA_BIOLOGICAL_RESULT.STATION_ID is 'Station identifier.' ;
comment on column FA_BIOLOGICAL_RESULT.STATION_NAME is 'Station name' ;
comment on column FA_BIOLOGICAL_RESULT.STATION_VISIT_ID is 'Station Visit identifier' ;
comment on column FA_BIOLOGICAL_RESULT.STATISTIC_TYPE is 'A statistic or calculation type which describes the reported result (e.g., average, mode, median, MPN (Most Probable Number).' ;
comment on column FA_BIOLOGICAL_RESULT.STD_UNIT is 'Result value Standard unit' ;
comment on column FA_BIOLOGICAL_RESULT.STD_VALUE is 'Result standard value' ;
comment on column FA_BIOLOGICAL_RESULT.STN_HDATUM is 'Station Horizontal Datum' ;
comment on column FA_BIOLOGICAL_RESULT.STN_LATITUDE is 'Station Latitude measure' ;
comment on column FA_BIOLOGICAL_RESULT.STN_LONGITUDE is 'A statistic or calculation type which describes the reported result (e.g., average, mode, median, MPN).' ;
comment on column FA_BIOLOGICAL_RESULT.STN_STD_HDATUM is 'Station Standard Horizontal Datum' ;
comment on column FA_BIOLOGICAL_RESULT.STN_STD_LATITUDE is 'Station Latitude measure in standard Hdatum' ;
comment on column FA_BIOLOGICAL_RESULT.STN_STD_LONGITUDE is 'Station Longitude measure in standard Hdatum' ;
comment on column FA_BIOLOGICAL_RESULT.TEMPERATURE_BASIS_LEVEL is 'A statistic or calculation type which describes the reported result (e.g., average, mode, median, MPN).' ;
comment on column FA_BIOLOGICAL_RESULT.TEMP_PRESERVN_TYPE is 'A default for the name of the type of temperature based physical preservation.' ;
comment on column FA_BIOLOGICAL_RESULT.TEXT_RESULT is 'Text result' ;
comment on column FA_BIOLOGICAL_RESULT.TOTAL_ENERGZD_TIME is 'Total time during the sample collection event that the electrodes were in the water and effective voltage was applied.  For pulsed or intermittent electroshock procedures, this is not the same as elapsed time.' ;
comment on column FA_BIOLOGICAL_RESULT.TRAP_NET_COMMENT is 'User-defined text that provides further information about the Trap or Net Operation.' ;
comment on column FA_BIOLOGICAL_RESULT.TRAWL_COMMENT is 'User-defined text that provides further information about the Trawl Operation.' ;
comment on column FA_BIOLOGICAL_RESULT.TRIP_ID is 'Field Trip Identifier' ;
comment on column FA_BIOLOGICAL_RESULT.TRIP_NAME is 'Field Trip name' ;
comment on column FA_BIOLOGICAL_RESULT.TROPHIC_LEVEL is 'For entries representing taxa, a code representing the trophic level with which the reported taxon is typically assigned.' ;
comment on column FA_BIOLOGICAL_RESULT.TR_START_DEPTH is 'The measure of the starting depth of a Well Interval as calculated from the reference point expressed in feet or meters.' ;
comment on column FA_BIOLOGICAL_RESULT.TR_START_HDATUM is 'Trawl start Horizontal Datum' ;
comment on column FA_BIOLOGICAL_RESULT.TR_START_LATITUDE is 'Trawl Start Latitude measure' ;
comment on column FA_BIOLOGICAL_RESULT.TR_START_LONGITUDE is 'Trawl Start Longtitude measure' ;
comment on column FA_BIOLOGICAL_RESULT.TR_START_POINT_NAME is 'Trawl Start Point Name' ;
comment on column FA_BIOLOGICAL_RESULT.TR_START_STD_HDATUM is 'Trawl Start Standard Horizontal Datum' ;
comment on column FA_BIOLOGICAL_RESULT.TR_START_STD_LATITUDE is 'Trawl Start Standard Latitude measure' ;
comment on column FA_BIOLOGICAL_RESULT.TR_START_STD_LONGITUDE is 'Trawl Start Standard Longitude measure' ;
comment on column FA_BIOLOGICAL_RESULT.TR_STOP_DEPTH is 'The measure of the stop (ending) depth of a Well Interval as calculated from the reference point expressed in feet or meters.' ;
comment on column FA_BIOLOGICAL_RESULT.TR_STOP_HDATUM is 'Trawl Stop Horizontal Datum' ;
comment on column FA_BIOLOGICAL_RESULT.TR_STOP_LATITUDE is 'Trawl Stop Latitude' ;
comment on column FA_BIOLOGICAL_RESULT.TR_STOP_LONGITUDE is 'Trawl Stop Longitude' ;
comment on column FA_BIOLOGICAL_RESULT.TR_STOP_POINT_NAME is 'Point Name of Trawl Stop location' ;
comment on column FA_BIOLOGICAL_RESULT.TR_STOP_STD_HDATUM is 'Standard Horizontal Datum for Trawl Stop location' ;
comment on column FA_BIOLOGICAL_RESULT.TR_STOP_STD_LATITUDE is 'Standard Latitude value for Trawl Stop Location' ;
comment on column FA_BIOLOGICAL_RESULT.TR_STOP_STD_LONGITUDE is 'Standard Longitude value for Trawl Stop Location' ;
comment on column FA_BIOLOGICAL_RESULT.TSRUOM_ORG_ID is 'The TSMORGAN portion of the foreign key to TSRUOM.' ;
comment on column FA_BIOLOGICAL_RESULT.UPPER_BOUND_AMOUNT is 'Upper bound amount' ;
comment on column FA_BIOLOGICAL_RESULT.UPPER_QUANTITATION_LIMIT is 'upper quantitation limit' ;
comment on column FA_BIOLOGICAL_RESULT.UPR_LWR_DEPTH_UNIT is 'Unit code for Upper and Lower depth measure' ;
comment on column FA_BIOLOGICAL_RESULT.VISIT_START_DATE_TIME is 'Station Visit Start Date time' ;
comment on column FA_BIOLOGICAL_RESULT.VISIT_START_TIME_ZONE is 'Station Visit Start Time Zone' ;
comment on column FA_BIOLOGICAL_RESULT.VISIT_STOP_DATE_TIME is 'Station Visit Stop Date time' ;
comment on column FA_BIOLOGICAL_RESULT.VISIT_STOP_TIME_ZONE is 'Station Visit Stop Time Zone' ;
comment on column FA_BIOLOGICAL_RESULT.VOLTAGE_MEASURE is 'The magnitude of the electro-motive force (volts) applied to the electroshock equipment used to collect the Sample.' ;
comment on column FA_BIOLOGICAL_RESULT.VOLTINISM is 'Voltinism information' ;
comment on column FA_BIOLOGICAL_RESULT.WEIGHT_BASIS_TYPE is 'Weight Basis type' ;
comment on column FA_BIOLOGICAL_RESULT.WELL_NUMBER is 'Well Number ' ;
"comment on column FA_BLOB.BLOB_CONTENT is 'The content of this specific BLOB. The BLOB may contain a graphical or textual file of type JPG, BMP, GIF, TXT, or PDF.
' ;"
comment on column FA_BLOB.BLOB_TITLE is 'User-defined Title defining or describing the BLOB Content.' ;
comment on column FA_BLOB.BLOB_TYPE is 'Type of Blob (Document/Graphic)' ;
comment on column FA_BLOB.D_LAST_UPDATE_TS is 'A system-generated value that represents the calendar date and time on which this information was posted to the data base or when a subsequent modification was made.' ;
comment on column FA_BLOB.D_USERID_CODE is 'A code that identifies the specific person making changes to the data.' ;
comment on column FA_BLOB.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column FA_BLOB.SOURCE_SYSTEM is 'Source system acronym from which the record was extracted, transformed and loaded into Warehouse.' ;
comment on column FA_BLOB.SOURCE_TABLE_UID is 'Source system Table UID' ;
comment on column FA_BLOB.SOURCE_UID is 'Unique Identifier of the record in the Source system.' ;
comment on column FA_BLOB.TABLE_NAME is 'The name of the Oracle Table referenced or further described by thjis BLOB.' ;
comment on column FA_BLOB.TSMBLOB_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column FA_BLOB.TSMBLOB_ORG_ID is 'The user-defined code that uniquely identifies the Organization to which each occurrence of this table applies. This identifying attribute has been added to this table for purposes of application security. Security is driven by user access to a given Organization(s).' ;
comment on column FA_BLOB.TSMPROJ_IS_NUMBER is 'The foreign key to TSMPROJ implements "One Project may be described by one or more (actually only one) BLOBs."  The BLOB may consist of the entire Project Plan Document in PDF format.' ;
comment on column FA_BLOB.TSMPROJ_ORG_ID is 'The TSMORGAN portion of the foreign key to TSMPROJ.' ;
comment on column FA_BLOB.TSMSTATN_IS_NUMBER is 'The foreign key to TSMSTATN implements "One Station may be further described by one or more (actually only one) BLOBs."  The BLOB may contain a photograph of the area comprising the monitored site.' ;
comment on column FA_BLOB.TSMSTATN_ORG_ID is 'The TSMORGAN portion of the foreign key to TSMSTATN.' ;
comment on column FA_BLOB.TSRCITN_IS_NUMBER is 'The foreign key to TSRCITN implements "One Literature Citation may be further described by one or more (actually only one) BLOBs."  The BLOB may contain the entire document being cited.' ;
comment on column FA_BLOB.TSRCITN_ORG_ID is 'The TSMORGAN portion of the foreign key to TSRCITN.' ;
comment on column FA_BLOB.TSRFDACT_IS_NUMBER is 'The foreign key to TSRFDACT implements "One Field Activity may be alternatively described by one or more (actually only one) BLOBs."' ;
comment on column FA_BLOB.TSRFDACT_ORG_ID is 'The TSMORGAN portion of the foreign key to TSRFDACT.' ;
comment on column FA_BLOB.TSROPPRD_IS_NUMBER is 'The foreign key to TSROPPRD implements "One Operating Period may be alternatively described by one or more (actually only one) BLOBs."' ;
comment on column FA_BLOB.TSROPPRD_ORG_ID is 'The TSMORGAN portion of the foreign key to TSROPPRD.' ;
comment on column FA_BLOB.TSRRSULT_IS_NUMBER is 'The foreign key to TSRRSULT implements "One Result may be further described by one or more (actually only one)  BLOBs."  The BLOB might be a photograph, or a graphic reproduction of a laboratory result (e.g. GCMS Spectrograph).' ;
comment on column FA_BLOB.TSRRSULT_ORG_ID is 'The TSMORGAN portion of the foreign key to TSRRSULT.' ;
comment on column FA_BLOB.TSRSTVST_IS_NUMBER is 'The foreign key to TSRSTVST implements "One Station Visit may be further described by one or more (actually only one) BLOBs."  The BLOB may contain a photograph obtained during the visit.' ;
comment on column FA_BLOB.TSRSTVST_ORG_ID is 'The TSMORGAN portion of the foreign key to TSRSTVST.' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_CATEGORY is 'A descriptor used to distinguish different kinds of samples and different kinds of Measurements and Observations.  The permitted value list is controlled by the choice of TYPE_NAME (above), with the entries in TSMPRMVL for CATEGORY_TYPE_NAME_M used for activities of type Msr/Obs, while CATEGORY_TYPE_NAME_S is used for activities of type Sample.' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_ID is 'Activity Identifier' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_ISN is 'Field activity internal serial number.' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_IS_NUMBER is 'Field activity internal serial number.' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_LATITUDE is 'activity Latitude measure' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_LONGITUDE is 'Activity Longitude measure.' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_START_DATE_TIME is 'For Samples Collected or for Measurements/Observations made - the date that the Field Activity began.  For Samples Created from other samples - the date on which a sample is created by compositing, splitting, or subsampling from a parent sample.' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_STOP_DATE_TIME is 'Field activity stop date time information.' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_TYPE is 'Field activity type.' ;
comment on column FA_HABITAT_RESULT.ACT_BLOB_ID is 'Activity BLOB ID' ;
comment on column FA_HABITAT_RESULT.ACT_BLOB_TITLE is 'User-defined Title defining or describing the BLOB Content.' ;
comment on column FA_HABITAT_RESULT.ACT_START_TIME_ZONE is 'Activity Start Time Zone' ;
comment on column FA_HABITAT_RESULT.ACT_STD_HDATUM is 'Activity Standard Horizontal Datum.  The user provided data is converted to this standard datum during the ETL.' ;
comment on column FA_HABITAT_RESULT.ACT_STD_LATITUDE is 'Activity Standard Latitude' ;
comment on column FA_HABITAT_RESULT.ACT_STD_LONGITUDE is 'Activity Standard Longitude' ;
comment on column FA_HABITAT_RESULT.ACT_STOP_TIME_ZONE is 'Activity Stop Time Zone.' ;
comment on column FA_HABITAT_RESULT.ANALYSIS_DATE_TIME is 'Sample Analysis Date and time stamp' ;
comment on column FA_HABITAT_RESULT.ANALYSIS_TIME_ZONE is 'The time zone for which the time of day is reported.  Any of the longitudinal divisions of the earths surface in which a standard time is kept. Each zone observes a clock time one hour earlier than the zone immediately to the east.' ;
comment on column FA_HABITAT_RESULT.ANALYTICAL_PROCEDURE_ID is 'The abbreviated name or identifying code of the analytical procedure.' ;
comment on column FA_HABITAT_RESULT.ANALYTICAL_PROCEDURE_SOURCE is 'The name of the Analytical Procedure Owner.  Examples include the American Society for Testing Materials, the United States Geological Survey, and the Environmental Protection Agency.' ;
comment on column FA_HABITAT_RESULT.BIAS is 'A consistent deviation of measured values from the true value, caused by systematic errors in a procedure, as determined by applying identical procedures to a specimen of known properties.' ;
comment on column FA_HABITAT_RESULT.BLOB_ID is 'BLOB identifier.' ;
comment on column FA_HABITAT_RESULT.BLOB_TITLE is 'User-defined Title defining or describing the BLOB Content.' ;
comment on column FA_HABITAT_RESULT.CHARACTERISTIC_NAME is 'Name of physical/chemical, biological and habitat characteristics.  It is also called Substance Name in Substance Registry System.' ;
comment on column FA_HABITAT_RESULT.CONFIDENCE_LEVEL is 'Result Confidence level.' ;
comment on column FA_HABITAT_RESULT.CONF_LVL_CORR_BIAS is 'A code indicating whether the confidence level has been corrected for Bias.' ;
comment on column FA_HABITAT_RESULT.CORRECTION_INDICATOR is 'Correction Indicator.' ;
comment on column FA_HABITAT_RESULT.DETECTION_LIMIT is 'detection limit' ;
comment on column FA_HABITAT_RESULT.DETECTION_LIMIT_DESCRIPTION is 'detection limit description' ;
comment on column FA_HABITAT_RESULT.DILUTION_INDICATOR is 'dilution indicator' ;
comment on column FA_HABITAT_RESULT.DISTANCE_MEASURE_FROM is 'Distance measured from the location.' ;
comment on column FA_HABITAT_RESULT.DISTANCE_MEASURE_TO is 'Distance measured to the location.' ;
comment on column FA_HABITAT_RESULT.DURATION_BASIS is 'Duration Basis' ;
comment on column FA_HABITAT_RESULT.EPA_REG_NUMBER is 'EPA registry number. ' ;
comment on column FA_HABITAT_RESULT.FIELD_SET is 'Field Set.' ;
comment on column FA_HABITAT_RESULT.FK_ACT_MAD_HDATUM is 'Foreign Key referencing DI_ACT_MAD_HDATUM.' ;
comment on column FA_HABITAT_RESULT.FK_ACT_MAD_HMETHOD is 'Foreign Key referencing DI_ACT_MAD_HMETHOD.' ;
comment on column FA_HABITAT_RESULT.FK_CHAR is 'Foreign Key referencing DI_CHAR.' ;
comment on column FA_HABITAT_RESULT.FK_DATE_ACT_START is 'Foreign Key referencing DI_DATE_ACT_START.' ;
comment on column FA_HABITAT_RESULT.FK_DB_CAT is 'Foreign Key referencing DI_DB_CAT.' ;
comment on column FA_HABITAT_RESULT.FK_GEN_DB_CAT is 'Foreign Key referencing DI_GEN_DB_CAT.' ;
comment on column FA_HABITAT_RESULT.FK_GEO_COUNTY is 'Foreign Key referencing DI_GEO_COUNTY.' ;
comment on column FA_HABITAT_RESULT.FK_GEO_STATE is 'Foreign Key referencing DI_GEO_STATE.' ;
comment on column FA_HABITAT_RESULT.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column FA_HABITAT_RESULT.FK_STATION is 'Foreign Key referencing DI_STATION.' ;
comment on column FA_HABITAT_RESULT.FK_STATN_TYPES is 'Foreign Key referencing DI_STATN_TYPES.' ;
comment on column FA_HABITAT_RESULT.FK_STN_ACT_PT is 'Foreign Key referencing DI_STN_ACT_PT.' ;
comment on column FA_HABITAT_RESULT.FK_UNIT_CONVERSION is 'Foreign Key referencing DI_UNIT_CONVERSION.' ;
comment on column FA_HABITAT_RESULT.GENERATED_HUC is 'Generated HUC. If user provided the optional Hydrologic Unit Code, the HUC is generated based on the station location information.' ;
comment on column FA_HABITAT_RESULT.HABITAT_CLASS_NAME is 'The name of the portion of the habitat which is being evaluated. e.g., Bank erosion, bank stability, stream flow characteristics, cloud cover, and others.    The habitat index, or overall score assigned to the habitat assessment, is usually included in the list of characteristics as a method of displaying its value.' ;
comment on column FA_HABITAT_RESULT.HYDROLOGIC_UNIT_CODE is 'The Federal Information Processing Standard (FIPS) code for Hydrologic Units, as defined in FIPS Publication 103.' ;
comment on column FA_HABITAT_RESULT.LAB_BATCH_ID is 'The code that represents the laboratory batch ID for a result or a group of results. Batch ID may be used to link with Laboratory Data files, which may contain useful information further describing the reported result.' ;
comment on column FA_HABITAT_RESULT.LAB_CERTIFIED is 'Laboratory Certification information' ;
comment on column FA_HABITAT_RESULT.LAB_ID is 'Laboratory Identification' ;
comment on column FA_HABITAT_RESULT.LAB_NAME is 'Laboratory Name' ;
comment on column FA_HABITAT_RESULT.LAB_REMARK is 'Laboratory Remark' ;
comment on column FA_HABITAT_RESULT.LOCATION_POINT_TYPE is 'Location Point Type' ;
comment on column FA_HABITAT_RESULT.LOWER_QUANTITATION_LIMIT is 'Lower Quantitation Limit' ;
comment on column FA_HABITAT_RESULT.MAP_SCALE is 'map scale' ;
comment on column FA_HABITAT_RESULT.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column FA_HABITAT_RESULT.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column FA_HABITAT_RESULT.PIPE_NUMBER is 'pipe number' ;
comment on column FA_HABITAT_RESULT.PK_ISN is 'Primary Key. Generated using sequence object SEQ_HABITAT_RESULT.' ;
comment on column FA_HABITAT_RESULT.POINT_NAME is 'User-specified free text name by which a specific absolute location point will be known.' ;
comment on column FA_HABITAT_RESULT.POINT_SEQUENCE_NUMBER is 'The number that indicates the sequence position of current point among a group of points. For example, if several points are recorded to mark the boundary of a station, the sequence number specifies the order in which the system should "connect the dots."' ;
comment on column FA_HABITAT_RESULT.PRECISION is 'Estimate of the maximum possible error in the result. (e.g., Counting error in determining radiological beta particle counts.)' ;
comment on column FA_HABITAT_RESULT.RECOVERY_INDICATOR is 'Recovery Indicator' ;
comment on column FA_HABITAT_RESULT.REPLICATE_ANALYSIS_COUNT is 'replicate analysis count' ;
comment on column FA_HABITAT_RESULT.REPLICATE_NUMBER is 'User-assigned number applied to samples of the same type, medium, etc. to differentiate between them (e.g., Water Replicate 1 and Water Replicate 2, etc.)   Note: This applies only to certain Activity Categories for Samples (replicate, field replicate, depletion replicate, sample created from sample) and Measurements (measurement replicate)- not Observations.' ;
comment on column FA_HABITAT_RESULT.RESULT_COMMENT is 'result comment' ;
comment on column FA_HABITAT_RESULT.RESULT_IS_NUMBER is 'result internal serial number' ;
comment on column FA_HABITAT_RESULT.RESULT_UNIT is 'result value unit code' ;
comment on column FA_HABITAT_RESULT.RESULT_VALUE is 'result value' ;
comment on column FA_HABITAT_RESULT.RESULT_VALUE_STATUS is 'result value status' ;
comment on column FA_HABITAT_RESULT.RESULT_VALUE_TEXT is 'result value text' ;
comment on column FA_HABITAT_RESULT.RESULT_VALUE_TYPE is 'result vaue type' ;
comment on column FA_HABITAT_RESULT.SAMPLE_FRACTION_TYPE is 'Sample Fraction Type' ;
comment on column FA_HABITAT_RESULT.SGO_INDICATOR is 'Station SGO Indicator' ;
comment on column FA_HABITAT_RESULT.STATION_ID is 'Station identifier.' ;
comment on column FA_HABITAT_RESULT.STATION_NAME is 'Station name' ;
comment on column FA_HABITAT_RESULT.STATION_VISIT_ID is 'Station Visit identifier' ;
comment on column FA_HABITAT_RESULT.STATISTIC_TYPE is 'A statistic or calculation type which describes the reported result (e.g., average, mode, median, MPN).' ;
comment on column FA_HABITAT_RESULT.STD_UNIT is 'Standard Unit code' ;
comment on column FA_HABITAT_RESULT.STD_VALUE is 'Standard Value' ;
comment on column FA_HABITAT_RESULT.STN_HDATUM is 'Station Horizontal Datum' ;
comment on column FA_HABITAT_RESULT.STN_LATITUDE is 'Station Latitude measure' ;
comment on column FA_HABITAT_RESULT.STN_LONGITUDE is 'A statistic or calculation type which describes the reported result (e.g., average, mode, median, MPN).' ;
comment on column FA_HABITAT_RESULT.STN_STD_HDATUM is 'Station Standard Horizontal Datum' ;
comment on column FA_HABITAT_RESULT.STN_STD_LATITUDE is 'Station Standard Latitude measure' ;
comment on column FA_HABITAT_RESULT.STN_STD_LONGITUDE is 'Station Standard Longitude measure' ;
comment on column FA_HABITAT_RESULT.TEMPERATURE_BASIS_LEVEL is 'A statistic or calculation type which describes the reported result (e.g., average, mode, median, MPN).' ;
comment on column FA_HABITAT_RESULT.TEXT_RESULT is 'Text result' ;
comment on column FA_HABITAT_RESULT.TRIP_ID is 'Field Trip Identifier' ;
comment on column FA_HABITAT_RESULT.TRIP_NAME is 'upper quantitation limit' ;
comment on column FA_HABITAT_RESULT.UPPER_QUANTITATION_LIMIT is 'upper quantitation limit' ;
comment on column FA_HABITAT_RESULT.VISIT_START_DATE_TIME is 'Station visit start date time' ;
comment on column FA_HABITAT_RESULT.VISIT_START_TIME_ZONE is 'Station Visit Start Time Zone' ;
comment on column FA_HABITAT_RESULT.VISIT_STOP_DATE_TIME is 'station visit stop date time' ;
comment on column FA_HABITAT_RESULT.VISIT_STOP_TIME_ZONE is 'Station Visit Stop Time Zone' ;
comment on column FA_HABITAT_RESULT.WEIGHT_BASIS_TYPE is 'Weight Basis type' ;
comment on column FA_HABITAT_RESULT.WELL_NUMBER is 'Well Number ' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_CATEGORY is 'A descriptor used to distinguish different kinds of samples and different kinds of Measurements and Observations.  The permitted value list is controlled by the choice of TYPE_NAME (above), with the entries in TSMPRMVL for CATEGORY_TYPE_NAME_M used for activities of type Msr/Obs, while CATEGORY_TYPE_NAME_S is used for activities of type Sample.' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_DEPTH is 'Distance from the surface to the point in the water column at which the activity is conducted.' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_DEPTH_REF_POINT is 'The text that describes the reference point from which the depth is measured, typically "Surface".' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_DEPTH_UNIT is 'Field Activity depth unit' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_ID is 'Field Activity Identifier' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_INTENT is 'The primary reason the Field Activity occurred.   Note: This is mandatory for Biological Medium, and not available for other media..' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_ISN is 'Field activity internal serial number.' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_IS_NUMBER is 'Field activity internal serial number.' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_LATITUDE is 'Field activity latitude measure' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_LONGITUDE is 'Field activity Longitude measure' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_LOWER_DEPTH is 'This measure is associated with an activity that is normally conducted over or within a vertical depth range within the water column. This attribute is a measure of the distance from the surface to the lower boundary of the zone within which the activity is conducted or over which the activity is integrated.' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_MATRIX is 'Activity matrix' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_MEDIUM is 'The name of the medium or matrix where the Field Activity occurred.' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_REL_DEPTH is 'Activity relative depth from the reference point' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_START_DATE_TIME is 'For Samples Collected or for Measurements/Observations made - the date that the Field Activity began.  For Samples Created from other samples - the date on which a sample is created by compositing, splitting, or subsampling from a parent sample.' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_STOP_DATE_TIME is 'Activity Stop Date time' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_TYPE is 'Field activity type.' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_UPPER_DEPTH is 'This measure is associated with an activity that is normally conducted over or within a vertical depth range within the water column. This attribute is a measure of the distance from the surface to the upper boundary of the zone within which the activity is conducted or over which the activity is integrated.' ;
comment on column FA_REGULAR_RESULT.ACT_BLOB_ID is 'Activity BLOB identifier' ;
comment on column FA_REGULAR_RESULT.ACT_BLOB_TITLE is 'User-defined Title defining or describing the BLOB Content.' ;
comment on column FA_REGULAR_RESULT.ACT_START_TIME_ZONE is 'Field activity start time zone' ;
comment on column FA_REGULAR_RESULT.ACT_STD_HDATUM is 'field activity standard horizontal datum' ;
comment on column FA_REGULAR_RESULT.ACT_STD_LATITUDE is 'Field activity standard latitude measure' ;
comment on column FA_REGULAR_RESULT.ACT_STD_LONGITUDE is 'Field activity Standard Longitude measure' ;
comment on column FA_REGULAR_RESULT.ACT_STOP_TIME_ZONE is 'Field activity stop time zone' ;
comment on column FA_REGULAR_RESULT.ANALYSIS_DATE_TIME is 'Sample Analysis Date and time stamp' ;
comment on column FA_REGULAR_RESULT.ANALYSIS_TIME_ZONE is 'The time zone for which the time of day is reported.  Any of the longitudinal divisions of the earths surface in which a standard time is kept. Each zone observes a clock time one hour earlier than the zone immediately to the east.' ;
comment on column FA_REGULAR_RESULT.ANALYTICAL_METHOD_LIST_AGENCY is 'Analytical method list agency' ;
comment on column FA_REGULAR_RESULT.ANALYTICAL_METHOD_LIST_VER is 'Analytical method list version' ;
comment on column FA_REGULAR_RESULT.ANALYTICAL_PROCEDURE_ID is 'The abbreviated name or identifying code of the analytical procedure.' ;
comment on column FA_REGULAR_RESULT.ANALYTICAL_PROCEDURE_SOURCE is 'The name of the Analytical Procedure Owner.  Examples include the American Society for Testing Materials, the United States Geological Survey, and the Environmental Protection Agency.' ;
comment on column FA_REGULAR_RESULT.BIAS is 'A consistent deviation of measured values from the true value, caused by systematic errors in a procedure, as determined by applying identical procedures to a specimen of known properties.' ;
comment on column FA_REGULAR_RESULT.BLOB_ID is '' ;
comment on column FA_REGULAR_RESULT.BLOB_TITLE is 'User-defined Title defining or describing the BLOB Content.' ;
comment on column FA_REGULAR_RESULT.CAS_NUMBER is 'EPA CAS number.' ;
comment on column FA_REGULAR_RESULT.CHARACTERISTIC_NAME is 'Name of physical/chemical, biological and habitat characteristics.  It is also called Substance Name in Substance Registry System.' ;
comment on column FA_REGULAR_RESULT.CONFIDENCE_LEVEL is 'confidence level' ;
comment on column FA_REGULAR_RESULT.CONF_LVL_CORR_BIAS is 'A code indicating whether the confidence level has been corrected for Bias.' ;
comment on column FA_REGULAR_RESULT.CONTAINER_DESC is 'sample collection container description' ;
comment on column FA_REGULAR_RESULT.CORRECTION_INDICATOR is 'Correction Indicator.' ;
comment on column FA_REGULAR_RESULT.DETECTION_LIMIT is 'detection limit' ;
comment on column FA_REGULAR_RESULT.DETECTION_LIMIT_DESCRIPTION is 'detection limit description' ;
comment on column FA_REGULAR_RESULT.DILUTION_INDICATOR is 'dilution indicator' ;
comment on column FA_REGULAR_RESULT.DISTANCE_MEASURE_FROM is 'Distance measured from the location.' ;
comment on column FA_REGULAR_RESULT.DISTANCE_MEASURE_TO is 'Distance measured to the location.' ;
comment on column FA_REGULAR_RESULT.DURATION_BASIS is 'Duration Basis' ;
comment on column FA_REGULAR_RESULT.EPA_REG_NUMBER is 'EPA registry number. ' ;
comment on column FA_REGULAR_RESULT.FIELD_GEAR_ID is 'Field Gear ID' ;
comment on column FA_REGULAR_RESULT.FIELD_PROCEDURE_ID is 'The abbreviated name or identifying code of the analytical procedure.' ;
comment on column FA_REGULAR_RESULT.FIELD_SET is 'Field Set.' ;
comment on column FA_REGULAR_RESULT.FK_ACT_MAD_HDATUM is 'Foreign Key referencing DI_ACT_MAD_HDATUM.' ;
comment on column FA_REGULAR_RESULT.FK_ACT_MAD_HMETHOD is 'Foreign Key referencing DI_ACT_MAD_HMETHOD.' ;
comment on column FA_REGULAR_RESULT.FK_ACT_MATRIX is 'Foreign Key referencing DI_ACT_MATRIX.' ;
comment on column FA_REGULAR_RESULT.FK_ACT_MEDIUM is 'Foreign Key referencing DI_ACT_MEDIUM.' ;
comment on column FA_REGULAR_RESULT.FK_CHAR is 'Foreign Key referencing DI_CHAR.' ;
comment on column FA_REGULAR_RESULT.FK_DATE_ACT_START is 'Foreign Key referencing DI_DATE_ACT_START.' ;
comment on column FA_REGULAR_RESULT.FK_DB_CAT is 'Foreign Key referencing DI_DB_CAT.' ;
comment on column FA_REGULAR_RESULT.FK_GEN_DB_CAT is 'Foreign Key referencing DI_GEN_DB_CAT.' ;
comment on column FA_REGULAR_RESULT.FK_GEO_COUNTY is 'Foreign Key referencing DI_GEO_COUNTY.' ;
comment on column FA_REGULAR_RESULT.FK_GEO_STATE is 'Foreign Key referencing DI_GEO_STATE.' ;
comment on column FA_REGULAR_RESULT.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column FA_REGULAR_RESULT.FK_STATION is 'Foreign Key referencing DI_STATION.' ;
comment on column FA_REGULAR_RESULT.FK_STATN_TYPES is 'Foreign Key referencing DI_STATN_TYPES.' ;
comment on column FA_REGULAR_RESULT.FK_STN_ACT_PT is 'Foreign Key referencing DI_STN_ACT_PT.' ;
comment on column FA_REGULAR_RESULT.FK_UNIT_CONVERSION is 'Foreign Key referencing DI_UNIT_CONVERSION.' ;
comment on column FA_REGULAR_RESULT.GEAR_CONFIG_ID is 'The code that identifies a Gear Configuration within the Organization.   Note: Must be unique within the Organization.  Used as a shorthand or abbreviation to represent the Gear Configuration in batch data update runs. ' ;
comment on column FA_REGULAR_RESULT.GENERATED_HUC is 'Generated HUC. If user provided the optional Hydrologic Unit Code, the HUC is generated based on the station location information.' ;
comment on column FA_REGULAR_RESULT.HYDROLOGIC_UNIT_CODE is 'The Federal Information Processing Standard (FIPS) code for Hydrologic Units, as defined in FIPS Publication 103.' ;
comment on column FA_REGULAR_RESULT.ITIS_NUMBER is 'Integrated Taxonomy Information system number.' ;
comment on column FA_REGULAR_RESULT.LAB_BATCH_ID is 'The code that represents the laboratory batch ID for a result or a group of results. Batch ID may be used to link with Laboratory Data files, which may contain useful information further describing the reported result.' ;
comment on column FA_REGULAR_RESULT.LAB_CERTIFIED is 'Laboratory Certification information' ;
comment on column FA_REGULAR_RESULT.LAB_ID is 'Laboratory Identification' ;
comment on column FA_REGULAR_RESULT.LAB_NAME is 'Laboratory Name' ;
comment on column FA_REGULAR_RESULT.LAB_REMARK is 'Laboratory Remark' ;
comment on column FA_REGULAR_RESULT.LOCATION_POINT_TYPE is 'Location Point Type' ;
comment on column FA_REGULAR_RESULT.LOWER_QUANTITATION_LIMIT is 'Lower Quantitation Limit' ;
comment on column FA_REGULAR_RESULT.MAP_SCALE is 'map scale' ;
comment on column FA_REGULAR_RESULT.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column FA_REGULAR_RESULT.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column FA_REGULAR_RESULT.PARTICLE_SIZE is 'User defined free text describing the particle size class for which the associated result is defined..' ;
comment on column FA_REGULAR_RESULT.PIPE_NUMBER is 'Pipe Number' ;
comment on column FA_REGULAR_RESULT.PK_ISN is 'Primary Key. Generated using sequence object SEQ_REGULAR_RESULT.' ;
comment on column FA_REGULAR_RESULT.POINT_NAME is 'User-specified free text name by which a specific absolute location point will be known.' ;
comment on column FA_REGULAR_RESULT.POINT_SEQUENCE_NUMBER is 'The number that indicates the sequence position of current point among a group of points. For example, if several points are recorded to mark the boundary of a station, the sequence number specifies the order in which the system should "connect the dots."' ;
comment on column FA_REGULAR_RESULT.PORTABLE_DATA_LOGGER is 'Portable Data Logger' ;
comment on column FA_REGULAR_RESULT.PRECISION is 'Estimate of the maximum possible error in the result. (e.g., Counting error in determining radiological beta particle counts.)' ;
comment on column FA_REGULAR_RESULT.PRESRV_STRGE_PRCDR is 'Free text description providing additional information about the handling, transport, preservation, and storage of the sample.' ;
comment on column FA_REGULAR_RESULT.RECOVERY_INDICATOR is 'Recovery Indicator' ;
comment on column FA_REGULAR_RESULT.REPLICATE_ANALYSIS_COUNT is 'replicate analysis count' ;
comment on column FA_REGULAR_RESULT.REPLICATE_NUMBER is 'User-assigned number applied to samples of the same type, medium, etc. to differentiate between them (e.g., Water Replicate 1 and Water Replicate 2, etc.)   Note: This applies only to certain Activity Categories for Samples (replicate, field replicate, depletion replicate, sample created from sample) and Measurements (measurement replicate)- not Observations.' ;
comment on column FA_REGULAR_RESULT.RESULT_COMMENT is 'Result Comment' ;
comment on column FA_REGULAR_RESULT.RESULT_IS_NUMBER is 'result internal serial number' ;
comment on column FA_REGULAR_RESULT.RESULT_UNIT is 'Result Unit code' ;
comment on column FA_REGULAR_RESULT.RESULT_VALUE is 'Result value' ;
comment on column FA_REGULAR_RESULT.RESULT_VALUE_STATUS is 'Result value status' ;
comment on column FA_REGULAR_RESULT.RESULT_VALUE_TEXT is 'Result value text' ;
comment on column FA_REGULAR_RESULT.RESULT_VALUE_TYPE is 'Result Value type' ;
comment on column FA_REGULAR_RESULT.SAMPLE_FRACTION_TYPE is 'Sample Fraction Type' ;
comment on column FA_REGULAR_RESULT.SGO_INDICATOR is 'Station SGO Indicator' ;
comment on column FA_REGULAR_RESULT.SMPRP_TRANSPORT_STORAGE_DESC is 'Sample preparation transport storage description' ;
comment on column FA_REGULAR_RESULT.SOURCE_SYSTEM is 'Source system acronym from which the record was extracted, transformed and loaded into Warehouse.' ;
comment on column FA_REGULAR_RESULT.SOURCE_UID is 'Unique Identifier of the record in the Source system.' ;
comment on column FA_REGULAR_RESULT.STATION_ID is 'Station identifier.' ;
comment on column FA_REGULAR_RESULT.STATION_NAME is 'Station Name' ;
comment on column FA_REGULAR_RESULT.STATION_VISIT_ID is 'Station Visit identifier' ;
comment on column FA_REGULAR_RESULT.STATISTIC_TYPE is 'A statistic or calculation type which describes the reported result (e.g., average, mode, median, MPN).' ;
comment on column FA_REGULAR_RESULT.STD_UNIT is 'Standard Unit code' ;
comment on column FA_REGULAR_RESULT.STD_VALUE is 'Standard Value' ;
comment on column FA_REGULAR_RESULT.STN_HDATUM is 'Station Horizontal Datum' ;
comment on column FA_REGULAR_RESULT.STN_LATITUDE is 'Station Latitude measure.' ;
comment on column FA_REGULAR_RESULT.STN_LONGITUDE is 'A statistic or calculation type which describes the reported result (e.g., average, mode, median, MPN).' ;
comment on column FA_REGULAR_RESULT.STN_STD_HDATUM is 'Station Standard Horizontal Datum' ;
comment on column FA_REGULAR_RESULT.STN_STD_LATITUDE is 'Station Standard Latitude measure' ;
comment on column FA_REGULAR_RESULT.STN_STD_LONGITUDE is 'Station Standard Longitude measure' ;
comment on column FA_REGULAR_RESULT.TEMPERATURE_BASIS_LEVEL is 'A statistic or calculation type which describes the reported result (e.g., average, mode, median, MPN).' ;
comment on column FA_REGULAR_RESULT.TEMP_PRESERVN_TYPE is 'A default for the name of the type of temperature based physical preservation.' ;
comment on column FA_REGULAR_RESULT.TEXT_RESULT is 'Text result' ;
comment on column FA_REGULAR_RESULT.TRIP_ID is 'Field Trip Identifier' ;
comment on column FA_REGULAR_RESULT.TRIP_NAME is 'Field Trip name' ;
comment on column FA_REGULAR_RESULT.UPPER_QUANTITATION_LIMIT is 'upper quantitation limit' ;
comment on column FA_REGULAR_RESULT.UPR_LWR_DEPTH_UNIT is 'Unit code for Upper and Lower depth measure' ;
comment on column FA_REGULAR_RESULT.VISIT_START_DATE_TIME is 'Station visit start date time' ;
comment on column FA_REGULAR_RESULT.VISIT_START_TIME_ZONE is 'Station Visit Start Time Zone' ;
comment on column FA_REGULAR_RESULT.VISIT_STOP_DATE_TIME is 'station visit stop date time' ;
comment on column FA_REGULAR_RESULT.VISIT_STOP_TIME_ZONE is 'Station Visit Stop Time Zone' ;
comment on column FA_REGULAR_RESULT.WEIGHT_BASIS_TYPE is 'Weight Basis type' ;
comment on column FA_REGULAR_RESULT.WELL_NUMBER is 'Well Number ' ;
comment on column FA_STATION.BLOB_ID is 'BLOB identifier.' ;
comment on column FA_STATION.BLOB_TITLE is 'User-defined Title defining or describing the BLOB Content.' ;
comment on column FA_STATION.DESCRIPTION_TEXT is 'The Organization user-defined description of a Station. May include distance to left shore or right shore to the Station.' ;
comment on column FA_STATION.ELEVATION is 'The date (in format MM-DD-YYYY) when elevation measurement was determined.' ;
comment on column FA_STATION.FK_COUNTRY_CODE is 'Foreign Key referencing DI_COUNTRY_CODE.' ;
comment on column FA_STATION.FK_DB_CAT is 'Foreign Key referencing DI_DB_CAT.' ;
comment on column FA_STATION.FK_ELEVATION_DATUM is 'Foreign Key referencing DI_ELEVATION_DATUM.' ;
comment on column FA_STATION.FK_ELEVATION_METHOD is 'Foreign Key referencing DI_ELEVATION_METHOD.' ;
comment on column FA_STATION.FK_ESTRY_PRIMARY is 'Foreign Key referencing DI_ESTRY_PRIMARY.' ;
comment on column FA_STATION.FK_ESTRY_SECONDARY is 'Foreign Key referencing DI_ESTRY_SECONDARY.' ;
comment on column FA_STATION.FK_GEN_DB_CAT is 'Foreign Key referencing DI_GEN_DB_CAT.' ;
comment on column FA_STATION.FK_GEOPOSITIONING_METHOD is 'Foreign Key referencing DI_GEOPOSITIONING_METHOD.' ;
comment on column FA_STATION.FK_GEO_COUNTY is 'Foreign Key referencing DI_GEO_COUNTY.' ;
comment on column FA_STATION.FK_GEO_STATE is 'Foreign Key referencing DI_GEO_STATE.' ;
comment on column FA_STATION.FK_HORIZONTAL_DATUM is 'Foreign Key referencing DI_HORIZONTAL_DATUM.' ;
comment on column FA_STATION.FK_MAD_HDATUM is 'Foreign Key referencing DI_MAD_HDATUM.' ;
comment on column FA_STATION.FK_MAD_HMETHOD is 'Foreign Key referencing DI_MAD_HMETHOD.' ;
comment on column FA_STATION.FK_MAD_VDATUM is 'Foreign Key referencing DI_MAD_VDATUM.' ;
comment on column FA_STATION.FK_MAD_VMETHOD is 'Foreign Key referencing DI_MAD_VMETHOD.' ;
comment on column FA_STATION.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column FA_STATION.FK_PRIMARY_ESTUARY is 'Foreign Key referencing DI_PRIMARY_ESTUARY.' ;
comment on column FA_STATION.FK_PRIMARY_TYPE is 'Foreign Key referencing DI_PRIMARY_TYPE.' ;
comment on column FA_STATION.FK_SECONDARY_ESTUARY is 'Foreign Key referencing DI_SECONDARY_ESTUARY.' ;
comment on column FA_STATION.FK_SECONDARY_TYPE is 'Foreign Key referencing DI_SECONDARY_TYPE.' ;
comment on column FA_STATION.FK_STATE_POSTAL_CODE is 'Foreign Key referencing DI_STATE_POSTAL_CODE.' ;
comment on column FA_STATION.FK_STATN_TYPES is 'Foreign Key referencing DI_STATN_TYPES.' ;
comment on column FA_STATION.FK_STD_HDATUM is 'Foreign Key referencing DI_STD_HDATUM.' ;
comment on column FA_STATION.FRS_KEY_IDENTIFIER is 'FRS Key identifier' ;
comment on column FA_STATION.GENERATED_HUC is 'Generated HUC. If user provided the optional Hydrologic Unit Code, the HUC is generated based on the station location information.' ;
comment on column FA_STATION.GREAT_LAKE_NAME is 'Great Lake Name' ;
comment on column FA_STATION.HYDROLOGIC_UNIT_CODE is 'The Federal Information Processing Standard (FIPS) code for Hydrologic Units, as defined in FIPS Publication 103.' ;
comment on column FA_STATION.LATITUDE is 'Latitude measure' ;
comment on column FA_STATION.LOCATION_POINT_TYPE is 'Location Point Type' ;
comment on column FA_STATION.LONGITUDE is 'longitude measure' ;
comment on column FA_STATION.MAP_SCALE is 'map scale' ;
comment on column FA_STATION.NAICS_CODE is 'The CODE that represents a subdivision of an industry that accomodates user needs in the United States (North American U.S. National Industry Classification Code).' ;
comment on column FA_STATION.NATV_AMERICAN_LAND_NAME is 'Native American Land Name' ;
comment on column FA_STATION.NRCS_WATERSHED_ID is 'NRCS Watershed_ID' ;
comment on column FA_STATION.OCEAN_NAME is 'Ocean Name' ;
comment on column FA_STATION.ON_REACH_IND is 'On Reach Indicator' ;
comment on column FA_STATION.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column FA_STATION.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column FA_STATION.OTHER_ESTUARY_NAME is 'The other/local name of the Estuary. Permits user to assign an alternate name to the estuary. When estuary is selected as "OTHER", this is the primary name.' ;
comment on column FA_STATION.PIPE_NUMBER is 'Pipe Number' ;
comment on column FA_STATION.PK_ISN is 'Primary Key. Generated using sequence object SEQ_STATION.' ;
comment on column FA_STATION.POINT_NAME is 'User-specified free text name by which a specific absolute location point will be known.' ;
comment on column FA_STATION.POINT_SEQUENCE_NUMBER is 'The number that indicates the sequence position of current point among a group of points. For example, if several points are recorded to mark the boundary of a station, the sequence number specifies the order in which the system should "connect the dots."' ;
comment on column FA_STATION.RF1_MILEAGE is 'The upstream mileage from the downstream end of the associated RF1 River Reach segment to the site being described. The mileage measure may not be greater than the total mileage of the associated RF1 River Reach segment. (If the total mileage is missing in the RF1 River Reach do not enforce that rule.)' ;
comment on column FA_STATION.RF1_SEGMENT_CODE is 'RF1 Segment code' ;
comment on column FA_STATION.RF1_SEGMENT_NAME is 'RF1 Segment Name' ;
comment on column FA_STATION.SGO_INDICATOR is 'Station SGO Indicator' ;
comment on column FA_STATION.SOURCE_SYSTEM is 'Source system acronym from which the record was extracted, transformed and loaded into Warehouse.' ;
comment on column FA_STATION.SOURCE_UID is 'Unique Identifier of the record in the Source system.' ;
comment on column FA_STATION.SPRING_OTHER_NAME is 'Spring Other Name' ;
comment on column FA_STATION.SPRING_PERMANENCE is 'Spring Permanence' ;
comment on column FA_STATION.SPRING_TYPE_IMPROVEMENT is 'Spring Type Improvement' ;
comment on column FA_STATION.SPRING_USGS_GEOLOGIC_UNIT is 'Spring USGS Geologic Unit' ;
comment on column FA_STATION.SPRING_USGS_LITHOLOGIC_UNIT is 'Spring USGS Lithologic Unit' ;
comment on column FA_STATION.STATION_ID is 'Station identifier.' ;
comment on column FA_STATION.STATION_IS_NUMBER is 'station internal serial number' ;
comment on column FA_STATION.STATION_NAME is 'Station name' ;
comment on column FA_STATION.STATION_VISITED is 'Station Visited indicator' ;
comment on column FA_STATION.STD_LATITUDE is 'Standard Latitude value' ;
comment on column FA_STATION.STD_LONGITUDE is 'Standard longitude value ' ;
comment on column FA_STATION.TSMALP_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column FA_STATION.WELL_NAME is 'Well name' ;
comment on column FA_STATION.WELL_NUMBER is 'Well Number ' ;
comment on column HABITAT_RESULT_PROJECT.FK_PROJECT is 'Foreign Key referencing DI_PROJECT.' ;
comment on column HABITAT_RESULT_PROJECT.FK_RESULT is 'Foreign Key referencing DI_RESULT.' ;
comment on column LU_CHAR_ALIAS.CHAR_ALIAS is 'Characteristic alias name' ;
comment on column LU_CHAR_ALIAS.FK_CHARACTERISTIC is 'Foreign Key referencing DI_CHARACTERISTIC.' ;
comment on column LU_CHAR_ALIAS.FK_CHAR_ALIAS_TYPE is 'Foreign Key referencing DI_CHAR_ALIAS_TYPE.' ;
comment on column LU_CHAR_ALIAS.PK_ISN is 'Primary Key. Generated using sequence object SEQ_CHAR_ALIAS.' ;
comment on column LU_CHAR_ALIAS_TYPE.CHAR_ALIAS_TYPE_CATEGORY is 'characteristic alias type category' ;
comment on column LU_CHAR_ALIAS_TYPE.CHAR_ALIAS_TYPE_NAME is 'characteristic alias type name' ;
comment on column LU_CHAR_ALIAS_TYPE.PK_ISN is 'Primary Key. Generated using sequence object SEQ_CHAR_ALIAS_TYPE.' ;
comment on column LU_ESTRY_PRIMARY.PK_ISN is 'Primary Key. Generated using sequence object SEQ_ESTRY_PRIMARY.' ;
comment on column LU_ESTRY_PRIMARY.PRIMARY_ESTUARY is 'primary estuary name' ;
comment on column LU_ESTRY_SECONDARY.PK_ISN is 'Primary Key. Generated using sequence object SEQ_ESTRY_SECONDARY.' ;
comment on column LU_ESTRY_SECONDARY.SECONDARY_ESTUARY is 'seconary estuary name' ;
comment on column LU_EXTERNAL_REF_SCHEME.DESCRIPTION_TEXT is 'The text that provides detailed information about how Stations are numbered or otherwise identified using a stated external reference scheme.' ;
comment on column LU_EXTERNAL_REF_SCHEME.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column LU_EXTERNAL_REF_SCHEME.PK_ISN is 'Primary Key. Generated using sequence object SEQ_EXTERNAL_REF_SCHEME.' ;
comment on column LU_EXTERNAL_REF_SCHEME.REF_SCHEME_ACRONYM is 'Reference scheme acronym' ;
comment on column LU_EXTERNAL_REF_SCHEME.REF_SCHEME_NAME is 'Reference Scheme name' ;
comment on column LU_MAD_HDATUM.HORIZONTAL_DATUM is 'Horizontal Datum' ;
comment on column LU_MAD_HDATUM.ID_CODE is 'A cryptic ID code assigned through EPA Locational Data Policy to represent the Method or Datum referenced.' ;
comment on column LU_MAD_HDATUM.PK_ISN is 'Primary Key. Generated using sequence object SEQ_MAD_HDATUM.' ;
comment on column LU_MAD_HMETHOD.GEOPOSITIONING_METHOD is 'Geopositionig Method' ;
comment on column LU_MAD_HMETHOD.ID_CODE is 'A cryptic ID code assigned through EPA Locational Data Policy to represent the Method or Datum referenced.' ;
comment on column LU_MAD_HMETHOD.PK_ISN is 'Primary Key. Generated using sequence object SEQ_MAD_HMETHOD.' ;
comment on column LU_MAD_VDATUM.ELEVATION_DATUM is 'A permanently established horizontal plane, surface, or level to which soundings, ground elevations, depths, water surface elevations, and tidal data are referred.' ;
comment on column LU_MAD_VDATUM.ID_CODE is 'A cryptic ID code assigned through EPA Locational Data Policy to represent the Method or Datum referenced.' ;
comment on column LU_MAD_VDATUM.PK_ISN is 'Primary Key. Generated using sequence object SEQ_MAD_VDATUM.' ;
comment on column LU_MAD_VMETHOD.ELEVATION_METHOD is 'The code that represents the method used to determine elevation of a point of interest.' ;
comment on column LU_MAD_VMETHOD.ID_CODE is 'A cryptic ID code assigned through EPA Locational Data Policy to represent the Method or Datum referenced.' ;
comment on column LU_MAD_VMETHOD.PK_ISN is 'Primary Key. Generated using sequence object SEQ_MAD_VMETHOD.' ;
comment on column LU_STATION_ALIAS.FK_REF_SCHEME is 'Foreign Key referencing DI_REF_SCHEME.' ;
comment on column LU_STATION_ALIAS.FK_STATION is 'Foreign Key referencing DI_STATION.' ;
comment on column LU_STATION_ALIAS.PK_ISN is 'Primary Key. Generated using sequence object SEQ_STATION_ALIAS.' ;
comment on column LU_STATION_ALIAS.STATION_LABEL is 'Station Label' ;
comment on column LU_UNIT_CONVERSION.CONVERSION_FACTOR is 'Conversion Factor' ;
comment on column LU_UNIT_CONVERSION.DESCRIPTION_TEXT is 'Conversion description text' ;
comment on column LU_UNIT_CONVERSION.PK_ISN is 'Primary Key. Generated using sequence object SEQ_UNIT_CONVERSION.' ;
comment on column LU_UNIT_CONVERSION.SHORT_FORM_NAME is 'The abbreviation for the name of the unit of measure.' ;
comment on column LU_UNIT_CONVERSION.TARGET_UNIT is 'Unit Conversion Target Unit' ;
comment on column LU_UNIT_CONVERSION.UOM_TYPE is 'The category that represents the broad class of a related set of units.   Examples: Volume, Concentration, Mass, Area, Velocity, Flow, Length/width/height, Temperature, Energy, Work/power' ;
comment on column MD_ANALYTICAL_PROC.ANLPR_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_ANALYTICAL_PROC.CITATION is 'A bibliographic reference cited to provide additional information concerning an Organizations procedures, methods and/or data.' ;
comment on column MD_ANALYTICAL_PROC.EQUIPMENT_NAME is 'Equipment Name' ;
comment on column MD_ANALYTICAL_PROC.FK_ORG is 'Foreign Key referencing FK_ORG.' ;
comment on column MD_ANALYTICAL_PROC.NATIONAL_PROC_ID is 'National Procedure Identifier' ;
comment on column MD_ANALYTICAL_PROC.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column MD_ANALYTICAL_PROC.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_ANALYTICAL_PROC.PK_ISN is 'Primary Key. Generated using sequence object SEQ_ANALYTICAL_PROC.' ;
comment on column MD_ANALYTICAL_PROC.PROCEDURE_ID is 'The abbreviated name or identifying code of the analytical procedure.' ;
comment on column MD_ANALYTICAL_PROC.PROCEDURE_NAME is 'The full title of the analytical procedure.' ;
comment on column MD_ANALYTICAL_PROC.PROCEDURE_SOURCE is 'The name of the Analytical Procedure Owner.  Examples include the American Society for Testing Materials, the United States Geological Survey, and the Environmental Protection Agency.' ;
comment on column MD_CITATION.AUTHOR is 'The full name(s) of author(s) of the publication being cited.' ;
comment on column MD_CITATION.CITATION_ID is 'The user-defined code that uniquely identifies the Organization to which each occurrence of this table applies. This identifying attribute has been added to this table for purposes of application security. Security is driven by user access to a given Organization(s).' ;
comment on column MD_CITATION.CITATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_CITATION.COMMENTS is 'User-defined text that provides further information about the Citation.' ;
comment on column MD_CITATION.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column MD_CITATION.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column MD_CITATION.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_CITATION.PBLSHR_ORG_NAME is 'The name of the organization which issued the publication being cited.' ;
comment on column MD_CITATION.PK_ISN is 'Primary Key. Generated using sequence object SEQ_CITATION.' ;
comment on column MD_CITATION.PUBLISHING_YEAR is 'The copyright year of the publication being cited.' ;
comment on column MD_CITATION.REFERENCE_ID is 'A code or identifier used by the Organization which owns the CITATION to identify it within their organization. Should be unique within the ORG.' ;
comment on column MD_CITATION.TITLE is 'The official name of the publication being cited.' ;
comment on column MD_CITATION.VOL_AND_PAGE is 'Specific volume and page numbers within the literature cited which apply to data supported by the CITATION.  "ALL" may be entered to indicate a reference to the entire publication.' ;
comment on column MD_COOP.COOP_ORGANIZATION_NAME is 'The formal full-length name of the Cooperating Organization.  Example: University of Hawaii' ;
comment on column MD_COOP.COOP_ORG_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_COOP.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column MD_COOP.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column MD_COOP.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_COOP.PK_ISN is 'Primary Key. Generated using sequence object SEQ_COOP.' ;
comment on column MD_COOP.PRIMARY_CONTACT_NAME is 'The name of the point of contact for the Cooperating Organization who has knowledge of the relationship between the Cooperating Organization and the data-owning Organization.' ;
comment on column MD_COOP_ADDRESS.ADDRESS_FOUR_TEXT is 'Cooperating address text line 4' ;
comment on column MD_COOP_ADDRESS.ADDRESS_ONE_TEXT is 'The first line of an Address which usually denotes the company or individual name.' ;
comment on column MD_COOP_ADDRESS.ADDRESS_THREE_TEXT is 'The third line of an Address usually denotes the street address including street name and type, house/office number, or sector designation.' ;
comment on column MD_COOP_ADDRESS.ADDRESS_TWO_TEXT is 'The second line of an Address usually denotes the mail routing code, p.o. box number, or suite but can also contain company name in addition.' ;
comment on column MD_COOP_ADDRESS.COOP_ADDR_IS_NUMBER is 'Cooperating organization address internal serial number' ;
comment on column MD_COOP_ADDRESS.COOP_ADDR_TYPE is 'cooperating address type' ;
comment on column MD_COOP_ADDRESS.COOP_ORG_IS_NUMBER is 'cooperating org internal serial number' ;
comment on column MD_COOP_ADDRESS.COUNTRY_CODE is 'The 2-character Federal Information Processing Standard (FIPS) code (ref FIPS Pub 10-3) representing the Country.' ;
comment on column MD_COOP_ADDRESS.FK_COOP is 'Foreign Key referencing DI_COOP.' ;
comment on column MD_COOP_ADDRESS.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column MD_COOP_ADDRESS.PK_ISN is 'Primary Key. Generated using sequence object SEQ_COOP_ADDRESS.' ;
comment on column MD_COOP_ADDRESS.START_DATE is 'The date (in format MM-DD-YYYY) on which a Project or Survey is scheduled to begin.' ;
comment on column MD_COOP_EADDRESS.ADDRESS_ONE_TEXT is 'The first line of an Address which usually denotes the company or individual name.' ;
comment on column MD_COOP_EADDRESS.ADDRESS_TWO_TEXT is 'The second line of an Address usually denotes the mail routing code, p.o. box number, or suite but can also contain company name in addition.' ;
comment on column MD_COOP_EADDRESS.COOP_EADDR_IS_NUMBER is 'cooperating organization electronic address internal serial number' ;
comment on column MD_COOP_EADDRESS.COOP_EADDR_TYPE is 'cooperating organization electronic address type' ;
comment on column MD_COOP_EADDRESS.COOP_ORG_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_COOP_EADDRESS.FK_COOP is 'Foreign Key referencing DI_COOP.' ;
comment on column MD_COOP_EADDRESS.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column MD_COOP_EADDRESS.PK_ISN is 'Primary Key. Generated using sequence object SEQ_COOP_EADDRESS.' ;
comment on column MD_LAB.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column MD_LAB.LAB_ID is 'Laboratory Identification' ;
comment on column MD_LAB.LAB_IS_NUMBER is 'The foreign key to TSRLAB implements "One Laboratory may have many addresses."' ;
comment on column MD_LAB.LAB_NAME is 'laboratory name' ;
comment on column MD_LAB.ORGANIZATION_ID is 'The TSMORGAN portion of the key in TSRLAB.' ;
comment on column MD_LAB.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_LAB.PK_ISN is 'Primary Key. Generated using sequence object SEQ_LAB.' ;
comment on column MD_LAB_ADDRESS.ADDRESS_FOUR_TEXT is 'The name of the city, state, and zip code in an Address.' ;
comment on column MD_LAB_ADDRESS.ADDRESS_ONE_TEXT is 'The first line of an Address which usually denotes the company or individual name.' ;
comment on column MD_LAB_ADDRESS.ADDRESS_THREE_TEXT is 'The third line of an Address usually denotes the street address including street name and type, house/office number, or sector designation.' ;
comment on column MD_LAB_ADDRESS.ADDRESS_TWO_TEXT is 'The second line of an Address usually denotes the mail routing code, p.o. box number, or suite but can also contain company name in addition.' ;
comment on column MD_LAB_ADDRESS.ADDRESS_TYPE is 'The code designating the type of Address.' ;
comment on column MD_LAB_ADDRESS.ADDR_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_LAB_ADDRESS.COUNTRY_CODE is 'The code for the country in an Address.' ;
comment on column MD_LAB_ADDRESS.FK_LAB is 'Foreign Key referencing DI_LAB.' ;
comment on column MD_LAB_ADDRESS.LAB_IS_NUMBER is 'The foreign key to TSRLAB implements "One Laboratory may have many addresses."' ;
comment on column MD_LAB_ADDRESS.ORGANIZATION_ID is 'The user-defined code that uniquely identifies the Organization to which each occurrence of this table applies. This identifying attribute has been added to this table for purposes of application security. Security is driven by user access to a given Organization(s).' ;
comment on column MD_LAB_ADDRESS.PK_ISN is 'Primary Key. Generated using sequence object SEQ_LAB_ADDRESS.' ;
comment on column MD_LAB_ADDRESS.START_DATE is 'The date (in format MM-DD-YYYY) the Address became effective.  FIELD NOT IN USE.' ;
comment on column MD_LAB_EADDRESS.ADDRESS_ONE_TEXT is 'The first line of an Address which usually denotes the company or individual name.' ;
comment on column MD_LAB_EADDRESS.ADDRESS_TWO_TEXT is 'The second line of an Address usually denotes the mail routing code, p.o. box number, or suite but can also contain company name in addition.' ;
comment on column MD_LAB_EADDRESS.EADDR_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_LAB_EADDRESS.FK_LAB is 'Foreign Key referencing DI_LAB.' ;
comment on column MD_LAB_EADDRESS.LAB_ADDR_TYPE is 'The code designating the type of Address.' ;
comment on column MD_LAB_EADDRESS.LAB_IS_NUMBER is 'The foreign key to TSRLAB implements "One Laboratory may have many Electronic Addresses."' ;
comment on column MD_LAB_EADDRESS.ORGANIZATION_ID is 'The user-defined code that uniquely identifies the Organization to which each occurrence of this table applies. This identifying attribute has been added to this table for purposes of application security. Security is driven by user access to a given Organization(s).' ;
comment on column MD_LAB_EADDRESS.PK_ISN is 'Primary Key. Generated using sequence object SEQ_LAB_EADDRESS' ;
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.CITATION is 'A bibliographic reference cited to provide additional information concerning an Organizations procedures, methods and/or data.' ;
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.LSPP_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.LSPP_SOURCE is 'When Nationally owned, the formal name of the organization which publishes the official description of the procedure.  e.g. American Public Health Association.' ;
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.PK_ISN is 'Primary Key. Generated using sequence object SEQ_LAB_SAMPLE_PREP_PROCEDURE.' ;
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.PROCEDURE_ID is 'The abbreviated name or identifying code of the analytical procedure.' ;
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.PROCEDURE_NAME is 'The full title of the analytical procedure.' ;
comment on column MD_ORG_ADDRESS.ADDRESS_TYPE is 'The code designating the type of Address.' ;
comment on column MD_ORG_ADDRESS.ADDR_FOUR_TEXT is 'The name of the city, state, and zip code in an Address.' ;
comment on column MD_ORG_ADDRESS.ADDR_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_ORG_ADDRESS.ADDR_ONE_TEXT is 'The first line of an Address which usually denotes the company or individual name.' ;
comment on column MD_ORG_ADDRESS.ADDR_THREE_TEXT is 'The third line of an Address usually denotes the street address including street name and type, house/office number, or sector designation.' ;
comment on column MD_ORG_ADDRESS.ADDR_TWO_TEXT is 'The second line of an Address usually denotes the mail routing code, p.o. box number, or suite but can also contain company name in addition.' ;
comment on column MD_ORG_ADDRESS.COUNTRY_CODE is 'The code for the country in an Address.' ;
comment on column MD_ORG_ADDRESS.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column MD_ORG_ADDRESS.ORGANIZATION_ID is 'The user-defined code that uniquely identifies the Organization to which each occurrence of this table applies. This identifying attribute has been added to this table for purposes of application security. Security is driven by user access to a given Organization(s).' ;
comment on column MD_ORG_ADDRESS.ORGANIZATION_IS_NUMBER is 'The foreign key to TSMORGAN implements "One Organization may have many addresses."' ;
comment on column MD_ORG_ADDRESS.PK_ISN is 'Primary Key. Generated using sequence object SEQ_ORG_ADDRESS.' ;
comment on column MD_ORG_ADDRESS.SOURCE_SYSTEM is 'Source system acronym from which the record was extracted, transformed and loaded into Warehouse.' ;
comment on column MD_ORG_ADDRESS.SOURCE_UID is 'Unique Identifier of the record in the Source system.' ;
comment on column MD_ORG_ADDRESS.START_DATE is 'The date (in format MM-DD-YYYY) the Address became effective.  FIELD NOT IN USE.' ;
comment on column MD_ORG_EADDRESS.ADDRESS_ONE_TEXT is 'The first line of an Address which usually denotes the company or individual name.' ;
comment on column MD_ORG_EADDRESS.ADDRESS_TWO_TEXT is 'The second line of an Address usually denotes the mail routing code, p.o. box number, or suite but can also contain company name in addition.' ;
comment on column MD_ORG_EADDRESS.ADDRESS_TYPE is 'The code designating the type of Address.' ;
comment on column MD_ORG_EADDRESS.EADDR_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_ORG_EADDRESS.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column MD_ORG_EADDRESS.ORGANIZATION_ID is 'The user-defined code that uniquely identifies the Organization to which each occurrence of this table applies. This identifying attribute has been added to this table for purposes of application security. Security is driven by user access to a given Organization(s).' ;
comment on column MD_ORG_EADDRESS.ORGANIZATION_IS_NUMBER is 'The foreign key to TSMORGAN implements "One Organization may have many electronic addresses."' ;
comment on column MD_ORG_EADDRESS.PK_ISN is 'Primary Key. Generated using sequence object SEQ_ORG_EADDRESS.' ;
comment on column MD_ORG_EADDRESS.SOURCE_ORGPH_UID is 'source organization phone Uid' ;
comment on column MD_ORG_EADDRESS.SOURCE_SYSTEM is 'Source system acronym from which the record was extracted, transformed and loaded into Warehouse.' ;
comment on column MD_ORG_EADDRESS.SOURCE_UID is 'Unique Identifier of the record in the Source system.' ;
comment on column MD_PROGRAM.DESCRIPTION is 'A text description of the referenced Method or Datum.' ;
comment on column MD_PROGRAM.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column MD_PROGRAM.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column MD_PROGRAM.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_PROGRAM.PK_ISN is 'Primary Key. Generated using sequence object SEQ_PROGRAM.' ;
comment on column MD_PROGRAM.PROGRAM_IS_NUMBER is 'Program internal serial number' ;
comment on column MD_PROGRAM.PROGRAM_NAME is 'program name' ;
comment on column MD_PROGRAM.PROGRAM_TYPE is 'program type' ;
comment on column MD_PROGRAM.PROJECT_ID is 'Project identifier. This is uniquer with in an organization.' ;
comment on column MD_PROGRAM.PROJECT_NAME is 'The name assigned by the owning Organization to the Project or Survey.' ;
comment on column MD_SAMPLE_GEAR.CONFIG_ID is 'configuation identifier' ;
comment on column MD_SAMPLE_GEAR.CONFIG_NAME is 'configuration name' ;
comment on column MD_SAMPLE_GEAR.FIELD_GEAR_ID is 'Field Gear ID' ;
comment on column MD_SAMPLE_GEAR.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column MD_SAMPLE_GEAR.GEAR_GROUP_NAME is 'Gear Group name' ;
comment on column MD_SAMPLE_GEAR.GEAR_NAME is 'Gear name' ;
comment on column MD_SAMPLE_GEAR.ORGANIZATION_ID is 'Organization identifier' ;
comment on column MD_SAMPLE_GEAR.ORGANIZATION_IS_NUMBER is 'The foreign key to TSMPRMVL implements "One Permitted Value may be the Container Color for many Samples.' ;
comment on column MD_SAMPLE_GEAR.PK_ISN is 'Primary Key. Generated using sequence object SEQ_SAMPLE_GEAR.' ;
comment on column MD_SAMPLE_GEAR.SPECIFICATION_TEXT is 'Sample gear specification text' ;
comment on column MD_SAMPLE_PRESRV.CONTAINER_COLOR is 'Default description of the color of the container used to collect and transport the sample.' ;
comment on column MD_SAMPLE_PRESRV.CONTAINER_SIZE is 'A default for the measure of the size of the container for a Sample.' ;
comment on column MD_SAMPLE_PRESRV.CONTAINER_SIZE_UNIT is 'The code that represents the default units in which the container size is expressed.' ;
comment on column MD_SAMPLE_PRESRV.CONTAINER_TYPE is 'A default for the name of the type of temperature based physical preservation.' ;
comment on column MD_SAMPLE_PRESRV.FK_ORG is 'Foreign Key referencing FK_ORG.' ;
comment on column MD_SAMPLE_PRESRV.ORGANIZATION_ID is 'The TSMORGAN portion of the foreign key to TSMPRMVL.' ;
comment on column MD_SAMPLE_PRESRV.ORGANIZATION_IS_NUMBER is 'The foreign key to TSMPRMVL implements "One Permitted Value may be the Container Color for many Samples.' ;
comment on column MD_SAMPLE_PRESRV.PK_ISN is 'Primary Key. Generated using sequence object SEQ_SAMPLE_PRESRV.' ;
comment on column MD_SAMPLE_PRESRV.PRESRV_DESC is 'Sample preservation description' ;
comment on column MD_SAMPLE_PRESRV.SAMPLE_ID is 'Sample preservation sample Identifier' ;
comment on column MD_SAMPLE_PRESRV.SAMPLE_NAME is 'Sample preservation Sample name' ;
comment on column MD_SAMPLE_PRESRV.SDP_ORGANIZATION_IS_NUMBER is 'Sample preservation organization internal serial number' ;
comment on column MD_SAMPLE_PRESRV.TEMP_PRESERVATION is 'A default for the name of the type of temperature based physical preservation.' ;
comment on column MD_SAMPLE_PROC.CITATION is 'A bibliographic reference cited to provide additional information concerning an Organizations procedures, methods and/or data.' ;
comment on column MD_SAMPLE_PROC.DESCRIPTION is 'Sample procedure description' ;
comment on column MD_SAMPLE_PROC.FK_ORG is 'Foreign Key referencing DI_ORG.' ;
comment on column MD_SAMPLE_PROC.FLDPR_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_SAMPLE_PROC.GEAR_GP_NAME is 'Sample procedure gear group name' ;
comment on column MD_SAMPLE_PROC.ORGANIZATION_ID is 'The user-defined code that uniquely identifies an Organization.  Organization IDs are registered centrally with STORET so that they are guaranteed to be unique on the National level.  They become part of the Oracle Key on every row in the STORET database that belongs to the Organization.' ;
comment on column MD_SAMPLE_PROC.ORGANIZATION_IS_NUMBER is 'A system-generated value used to uniquely identify an occurrence of this table.' ;
comment on column MD_SAMPLE_PROC.PK_ISN is 'Primary Key. Generated using sequence object SEQ_SAMPLE_PROC..' ;
comment on column MD_SAMPLE_PROC.PROCEDURE_ID is 'The abbreviated name or identifying code of the analytical procedure.' ;
comment on column MD_SAMPLE_PROC.PROCEDURE_NAME is 'The full title of the analytical procedure.' ;
comment on column MV_REGULAR_RESULT_ALL.COUNT_ALL is 'materialized view. Result count for query performance.' ;
comment on column MV_REGULAR_RESULT_CHAR."COUNT(PK_ISN)" is 'materialzed view for result counts by characteristics.' ;
comment on column MV_REGULAR_RESULT_CHAR.FK_CHAR is 'Foreign Key referencing DI_CHAR.' ;
comment on column MV_REGULAR_RESULT_CHAR_COUNTY."COUNT(PK_ISN)" is 'Materialized view for result counts by characteristic and county.' ;
comment on column MV_REGULAR_RESULT_CHAR_COUNTY.FK_CHAR is 'Foreign Key referencing DI_CHAR.' ;
comment on column MV_REGULAR_RESULT_CHAR_COUNTY.FK_GEO_COUNTY is 'Foreign Key referencing DI_GEO_COUNTY.' ;
comment on column MV_REGULAR_RESULT_CHAR_STATE."COUNT(PK_ISN)" is 'Materialized view for result counts by characteristic and state' ;
comment on column MV_REGULAR_RESULT_CHAR_STATE.FK_CHAR is 'Foreign Key referencing DI_CHAR.' ;
comment on column MV_REGULAR_RESULT_CHAR_STATE.FK_GEO_STATE is 'Foreign Key referencing DI_GEO_STATE.' ;
comment on column MV_REGULAR_RESULT_COUNTY."COUNT(PK_ISN)" is 'Materialized view for result counts by county' ;
comment on column MV_REGULAR_RESULT_COUNTY.FK_GEO_COUNTY is 'Foreign Key referencing DI_GEO_COUNTY.' ;
comment on column MV_REGULAR_RESULT_STATE."COUNT(PK_ISN)" is '' ;
comment on column MV_REGULAR_RESULT_STATE.FK_GEO_STATE is 'Foreign Key referencing DI_GEO_STATE.' ;
comment on column REGULAR_RESULT_PROJECT.FK_PROJECT is 'Foreign Key referencing DI_PROJECT.' ;
comment on column REGULAR_RESULT_PROJECT.FK_RESULT is 'Foreign Key referencing DI_RESULT.' ;
comment on column STATION_CHAR.ACT_MAX_START_DATE is 'Activity maximum Start Date' ;
comment on column STATION_CHAR.ACT_MIN_START_DATE is 'Activity Minimum Start Date' ;
comment on column STATION_CHAR.BIOLOGICAL_COUNT is 'Biological result count' ;
comment on column STATION_CHAR.CHAR_TYPE_CODE is 'A code indicating type of characteristic.' ;
comment on column STATION_CHAR.DISPLAY_NAME is 'The name of the environmental characteristic as it is to be displayed on windows and reports.' ;
comment on column STATION_CHAR.FK_CHAR is 'Foreign Key referencing DI_CHAR.' ;
comment on column STATION_CHAR.FK_FA_STATN is 'Foreign Key referencing DI_FA_STATN.' ;
comment on column STATION_CHAR.HABITAT_COUNT is 'Habitat result count' ;
comment on column STATION_CHAR.REGULAR_COUNT is 'Regular result count' ;
comment on column STATION_CHAR.RESULT_COUNT is 'Total Result count' ;
comment on column STATION_CHAR.SEARCH_NAME is 'The name by which an Organization refers to a Station.  For unambiguous search results, always contains the all upper-case form of the Name.' ;
comment on column STATION_PROJECT.FK_PROJECT is 'Foreign Key referencing DI_PROJECT.' ;
comment on column STATION_PROJECT.FK_STATION is 'Foreign Key referencing DI_STATION.' ;
comment on column DI_PROJECT.BLOB_ID is 'Project Blob ID' ;
comment on column DI_PROJECT.BLOB_TITLE is 'Project blob Title' ;
comment on column FA_BIOLOGICAL_RESULT.ACTIVITY_COMMENT is 'Activity comment' ;
comment on column FA_BLOB.BLOB_CONTENT is 'Binary Large Object content' ;
comment on column FA_HABITAT_RESULT.ACTIVITY_COMMENT is 'Activity comment' ;
comment on column FA_REGULAR_RESULT.ACTIVITY_COMMENT is 'Activity comment' ;
comment on column FA_REGULAR_RESULT.BLOB_ID is 'BLOB Identifier' ;
comment on column FA_STATION_MAP.GENERATED_HUC is 'Generated Hydrologic unit code' ;
comment on column FA_STATION_MAP.HORIZONTAL_DATUM is 'Horizontal Datum' ;
comment on column FA_STATION_MAP.HUC is 'Hydrologic unit code' ;
comment on column FA_STATION_MAP.HYDRO_UNIT_NAME is 'Hydrologic unit name' ;
comment on column FA_STATION_MAP.LATITUDE is 'latitude measure' ;
comment on column FA_STATION_MAP.LONGITUDE is 'longitude measure' ;
comment on column FA_STATION_MAP.ORG_ID is 'organization identifier' ;
comment on column FA_STATION_MAP.ORG_NAME is 'organization name' ;
comment on column FA_STATION_MAP.PRIMARY_TYPE is 'station primary type' ;
comment on column FA_STATION_MAP.SECONDARY_TYPE is 'station secondary type' ;
comment on column FA_STATION_MAP.STATION_ID is 'station identifier' ;
comment on column FA_STATION_MAP.STATION_NAME is 'station name' ;
comment on column FA_STATION_WEB."Converted Horizontal Datum" is 'Conversted Horizontal Datum' ;
comment on column FA_STATION_WEB."Converted Latitude" is 'Converted Latitude measure' ;
comment on column FA_STATION_WEB."Converted Longitude" is 'conversted Longitude measure' ;
comment on column FA_STATION_WEB."Country Name" is 'Country Name' ;
comment on column FA_STATION_WEB."County" is 'County Name' ;
comment on column FA_STATION_WEB."Description Text" is 'Station Description text' ;
comment on column FA_STATION_WEB."Elevation" is 'Station Location elevation' ;
comment on column FA_STATION_WEB."Elevation Datum" is 'Elevation Datum' ;
comment on column FA_STATION_WEB."Elevation Method" is 'Elevation method' ;
comment on column FA_STATION_WEB."FRS Key Identifier" is 'FRS Key Identifier' ;
comment on column FA_STATION_WEB."Generated Hydrologic Unit Code" is 'Generated Hydrologic unit code' ;
comment on column FA_STATION_WEB."Generated Hydrologic Unit Name" is 'Generated Hydrologic unit Name' ;
comment on column FA_STATION_WEB."Geopositioning Method" is 'Geopositioning Method' ;
comment on column FA_STATION_WEB."Great Lake Name" is 'Great Lake Name' ;
comment on column FA_STATION_WEB."Horizontal Datum" is 'Horizontal Datum' ;
comment on column FA_STATION_WEB."Hydrologic Unit Code" is 'Hydrologic Unit code' ;
comment on column FA_STATION_WEB."Hydrologic Unit Name" is 'Hydrologic Unit name' ;
comment on column FA_STATION_WEB."Latitude" is 'latitude measure' ;
comment on column FA_STATION_WEB."Location Point Type" is 'Location point type' ;
comment on column FA_STATION_WEB."Longitude" is 'longtitude measure' ;
comment on column FA_STATION_WEB."Map Scale" is 'map scale' ;
comment on column FA_STATION_WEB."NAICS Code" is 'NAICS code' ;
comment on column FA_STATION_WEB."NRCS Watershed ID" is 'NRCS watershed Identifier' ;
comment on column FA_STATION_WEB."Natv American Land Name" is 'Native American Land Name' ;
comment on column FA_STATION_WEB."Ocean Name" is 'Ocean Name' ;
comment on column FA_STATION_WEB."On Reach Ind" is 'On reach indicator' ;
comment on column FA_STATION_WEB."Org ID" is 'organization identifier' ;
comment on column FA_STATION_WEB."Org Name" is 'Oraganization name' ;
comment on column FA_STATION_WEB."Other Estuary Name" is 'Other Estuary Name' ;
comment on column FA_STATION_WEB."Permanence" is 'Permanence' ;
comment on column FA_STATION_WEB."Pipe Number" is 'Pipe Number' ;
comment on column FA_STATION_WEB."Point Name" is 'Location point name' ;
comment on column FA_STATION_WEB."Point Sequence Number" is 'Location Point sequence number' ;
comment on column FA_STATION_WEB."Primary Estuary" is 'Primary Estuary name' ;
comment on column FA_STATION_WEB."Primary Type" is 'station primary type' ;
comment on column FA_STATION_WEB."RF1 Mileage" is 'RF1 Mileage' ;
comment on column FA_STATION_WEB."RF1 Segment Code" is 'RF1 Segment code' ;
comment on column FA_STATION_WEB."RF1 Segment Name" is 'RF1 Segment Name' ;
comment on column FA_STATION_WEB."S/G/O Indicator" is 'Station SGO indicator' ;
comment on column FA_STATION_WEB."Secondary Estuary" is 'Secondary Estuary' ;
comment on column FA_STATION_WEB."Secondary Type" is 'Station secondary type' ;
comment on column FA_STATION_WEB."Spring Other Name" is 'Spring Other name' ;
comment on column FA_STATION_WEB."Spring Type Improvement" is 'Spring type improvement' ;
comment on column FA_STATION_WEB."State" is 'state name' ;
comment on column FA_STATION_WEB."Station ID" is 'station identifier' ;
comment on column FA_STATION_WEB."Station Name" is 'station name' ;
comment on column FA_STATION_WEB."USGS Geologic Unit Code-Name" is 'USGS geologic unit code name' ;
comment on column FA_STATION_WEB."USGS Lithologic Unit Code-Name" is 'USGS Lithologic unit code name' ;
comment on column FA_STATION_WEB."Well Name" is 'well name' ;
comment on column FA_STATION_WEB."Well Number" is 'well number' ;
comment on column MV_REGULAR_RESULT_CHAR."COUNT(PK_ISN)" is 'Materialized view result count by characteristics' ;
comment on column MV_REGULAR_RESULT_CHAR_COUNTY."COUNT(PK_ISN)" is 'Materialized view result count by characteristics and county' ;
comment on column MV_REGULAR_RESULT_CHAR_STATE."COUNT(PK_ISN)" is 'Materialized view result count by characteristics and state' ;
comment on column MV_REGULAR_RESULT_COUNTY."COUNT(PK_ISN)" is 'Materialized view result count by county' ;
comment on column MV_REGULAR_RESULT_STATE."COUNT(PK_ISN)" is 'materialized view result count by state' ;
commit;

--defect #

comment on column MD_ANALYTICAL_PROC.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_ANALYTICAL_PROC.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_CITATION.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_CITATION.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_COOP.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_COOP.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_COOP_ADDRESS.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_COOP_ADDRESS.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_COOP_EADDRESS.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_COOP_EADDRESS.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_LAB.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_LAB.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_LAB_ADDRESS.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_LAB_ADDRESS.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_LAB_EADDRESS.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_LAB_EADDRESS.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_LAB_SAMPLE_PREP_PROCEDURE.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_PROGRAM.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_PROGRAM.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_SAMPLE_GEAR.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_SAMPLE_GEAR.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_SAMPLE_PRESRV.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_SAMPLE_PRESRV.SOURCE_UID is 'Metadata source record unique identifier';
comment on column MD_SAMPLE_PROC.SOURCE_SYSTEM is 'Metadata source system acronym';
comment on column MD_SAMPLE_PROC.SOURCE_UID is 'Metadata source record unique identifier';

comment on column DI_PROJECT.BLOB_ID is 'Project binary large object unique identifier';
comment on column DI_PROJECT.BLOB_TITLE is 'Project binary large object title';


--post statistics
select 'Total_Column_count: '||count(*) Total_Column_count from user_col_comments;
select 'Total Columns with comments: '||count(*) Total_Column_count from user_col_comments
where trim(comments) is not null;

select 'Total Columns without comments: '||count(*) Total_Column_count from user_col_comments
where trim(comments) is null;

set pagesize 1000
Prompt 'Columns without comment.';
select table_name,column_name from user_col_comments
where trim(comments) is null
order by 1,2;
spool off;