/*******************************************************
Filename		:  project_rel_tables.sql
Release 		:  c2.0
SIR			:  1515
Description		:  create and populate station_project_table table.
Author			:  Joseph Wilson
Date			:  1/9/2003
			   7-01-2003 -- changed table names from CHEM to REGULAR
Comments		:  06/13/03 updated v2.0
			   07/16/2003 v2.0B - Added Habitat and Biological project tables. WN
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
		12/24/2006 -- modified for metadata CR
05/14/2007 - edited for station weights in station_project table.  CR -station weights and station web service.
**********************************************************/
SET TRANSACTION USE ROLLBACK SEGMENT RBSBIG;

SPOOL project_rel_tables22.log

drop table REGULAR_RESULT_PROJECT;

create table REGULAR_RESULT_PROJECT (
fk_project number(12),
fk_result number (12))
tablespace storetdata
storage(initial 25M next 25M minextents 2 maxextents 200)
nologging
pctfree 1;


set serveroutput on
DECLARE

cursor orgs is
	select organization_id
	from di_org;

BEGIN

FOR v_org in orgs loop

Insert into REGULAR_RESULT_PROJECT 
select pr.pk_isn fk_project, re.pk_isn fk_result
from di_project pr, storet1.tsrfapra fap, FA_REGULAR_RESULT re
where pr.tsmproj_is_number = fap.tsmproj_is_number
and pr.tsmproj_org_id = fap.tsmproj_org_id
and fap.tsrfdact_is_number = re.activity_is_number
and fap.tsrfdact_org_id = re.organization_id
and organization_id = v_org.organization_id;

commit;

END LOOP;
END;
/

CREATE INDEX IRP_FK_RESULT ON REGULAR_RESULT_PROJECT(FK_RESULT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IRP_FK_PROJECT ON REGULAR_RESULT_PROJECT(FK_PROJECT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IRP_FK_PROJECT_RESULT ON REGULAR_RESULT_PROJECT(FK_PROJECT,fk_result)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;
--
--
--add constraints
--alter table REGULAR_RESULT_PROJECT 
--add constraint re_proj_fk_result foreign key (fk_result) references FA_REGULAR_RESULT(pk_isn);

--alter table REGULAR_RESULT_PROJECT 
--add constraint re_proj_fk_project foreign key (fk_project) references di_project(pk_isn);
--

SET TRANSACTION USE ROLLBACK SEGMENT RBSBIG;
PROMPT -- Regular Results Assign BEACH_ID / PROJECT_ID (max)
UPDATE FA_REGULAR_RESULT RE SET PROJECT_ID =
	(SELECT max(pr.PROJECT_CD)
	from di_project pr, REGULAR_RESULT_PROJECT rrp
	WHERE re.pk_isn = rrp.fk_result
	AND pr.pk_isn = rrp.fk_project
	AND pr.PROJECT_CD <> 'EPABEACH'
	);
commit;

SPOOL OFF