set feedback off;
set linesize 160
set trimspool on
set pagesize 0
set heading off;

spool disable_constraints_gen.sql
select 'alter table storetw.'||table_name||' modify constraint '||constraint_name||' disable;'
from user_constraints
where constraint_type='R'
/
spool off;


set feedback on;
set echo on;
spool disable_constraints_gen.log
select 'Database '||name from v$database;
select 'Schema owner : '||user from dual;

select 'Disabling referential constraints at '||to_char(sysdate,'dd-mon-yyyy hh24:mi:ss') from dual;
prompt pre constraints disable status
select status,count(*) from user_constraints
where constraint_type='R'
group by status;
--disable constraints
@disable_constraints_gen.sql

prompt post constraints disable status

select status,count(*) from user_constraints
where constraint_type='R'
group by status;
spool off;
