set feed off
set echo off
set trimspool on
set linesize 200
set pagesize 200
--set colsep '~'
--connect storetw/storetw@storet.sdc
spool c:/storetw/dw_statistics.txt
set head off
select 'table names and row counts' from dual;
set head on
select table_name, num_rows from tabs order by table_name;
set head off
select 'regular result table column names and null counts' from dual;
set head on
select column_name,num_nulls from cols where table_name = 'FA_REGULAR_RESULT'
	order by num_nulls;
set head off
select 'biological result table column names and null counts' from dual;
set head on
select column_name,num_nulls from cols where table_name = 'FA_BIOLOGICAL_RESULT'
	order by num_nulls;
set head off
select 'habitat result table column names and null counts' from dual;
set head on
select column_name,num_nulls from cols where table_name = 'FA_HABITAT_RESULT'
	order by num_nulls;
set head off
select 'station table column names and null counts' from dual;
set head on
select column_name,num_nulls from cols where table_name = 'FA_STATION'
	order by num_nulls;
set head off
select 'table names and indexes' from dual;
set head on
select table_name, index_name from user_indexes order by table_name, index_name;
set head off
select 'table names and constraints' from dual;
set head on
select table_name, constraint_name, constraint_type from user_constraints order by table_name, constraint_name;
--
select count(characteristic_name) "Null Characteristics" from fa_regular_result
where characteristic_name is null;
--
drop table station_char_temp;
--
drop table FA_STATION_WEB;
drop table FA_STATION_MAP;
--
create table FA_STATION_WEB
tablespace storetdata
storage (initial 25M next 25M)
as
SELECT 
FA.ORGANIZATION_ID "Org ID", FA.STATION_ID "Station ID", 
FA.STATION_NAME "Station Name", og.ORGANIZATION_NAME "Org Name", st.PRIMARY_TYPE 
"Primary Type", st.SECONDARY_TYPE "Secondary Type", FA.SGO_INDICATOR "S/G/O Indicator", 
FA.WELL_NUMBER "Well Number", FA.WELL_NAME "Well Name", FA.PIPE_NUMBER "Pipe Number", 
FA.NAICS_CODE "NAICS Code", FA.SPRING_TYPE_IMPROVEMENT "Spring Type Improvement", 
FA.SPRING_PERMANENCE "Permanence", FA.SPRING_USGS_GEOLOGIC_UNIT "USGS Geologic Unit Code-Name", 
FA.SPRING_OTHER_NAME "Spring Other Name", FA.SPRING_USGS_LITHOLOGIC_UNIT 
"USGS Lithologic Unit Code-Name", FA.LOCATION_POINT_TYPE "Location Point Type", 
FA.POINT_SEQUENCE_NUMBER "Point Sequence Number", FA.POINT_NAME "Point Name", 
FA.LATITUDE "Latitude", FA.LONGITUDE "Longitude", hd.HORIZONTAL_DATUM "Horizontal Datum", 
FA.STD_LATITUDE "Converted Latitude", FA.STD_LONGITUDE "Converted Longitude", hds.HORIZONTAL_DATUM "Converted Horizontal Datum",
hm.GEOPOSITIONING_METHOD "Geopositioning Method", FA.MAP_SCALE "Map Scale", 
FA.ELEVATION "Elevation", vd.ELEVATION_DATUM "Elevation Datum", vm.ELEVATION_METHOD 
"Elevation Method", COUNTRY_NAME "Country Name", gs.STATE_NAME "State", gc.COUNTY_NAME 
"County", ca.HYDROLOGIC_UNIT_CODE "Hydrologic Unit Code", ca.HYDROLOGIC_UNIT_NAME 
"Hydrologic Unit Name", cag.HYDROLOGIC_UNIT_CODE "Generated Hydrologic Unit Code", cag.HYDROLOGIC_UNIT_NAME 
"Generated Hydrologic Unit Name", FA.RF1_SEGMENT_CODE "RF1 Segment Code", FA.RF1_SEGMENT_NAME 
"RF1 Segment Name", FA.RF1_MILEAGE "RF1 Mileage", FA.ON_REACH_IND "On Reach Ind", 
FA.NRCS_WATERSHED_ID "NRCS Watershed ID", ep.PRIMARY_ESTUARY "Primary Estuary", 
es.SECONDARY_ESTUARY "Secondary Estuary", FA.OTHER_ESTUARY_NAME "Other Estuary Name", 
FA.GREAT_LAKE_NAME "Great Lake Name", FA.OCEAN_NAME "Ocean Name", 
FA.NATV_AMERICAN_LAND_NAME "Natv American Land Name", FA.FRS_KEY_IDENTIFIER 
"FRS Key Identifier", FA.DESCRIPTION_TEXT "Description Text"
FROM 
FA_STATION FA,DI_STATN_TYPES st,LU_MAD_HDATUM hd,LU_MAD_HDATUM hds,LU_MAD_HMETHOD hm,
LU_MAD_VDATUM vd,LU_MAD_VMETHOD vm,DI_GEO_STATE gs,DI_GEO_COUNTY gc,
DI_DB_CAT ca,DI_DB_CAT cag,LU_ESTRY_PRIMARY ep,LU_ESTRY_SECONDARY es,DI_ORG og
WHERE 
FA.fk_org = og.pk_isn (+) AND FA.fk_gen_db_cat = cag.pk_isn (+) AND 
FA.fk_db_cat = ca.pk_isn (+) AND FA.fk_estry_primary = ep.pk_isn (+) AND 
FA.fk_estry_secondary = es.pk_isn (+) AND fk_statn_types = st.pk_isn (+) AND 
fk_mad_hdatum = hd.pk_isn (+) AND fk_std_hdatum = hds.pk_isn (+) AND 
fk_mad_hmethod = hm.pk_isn (+) AND 
FA.fk_mad_vdatum = vd.pk_isn (+) AND FA.fk_mad_vmethod = vm.pk_isn (+) AND 
FA.fk_geo_state = gs.pk_isn (+) AND FA.fk_geo_county = gc.pk_isn (+)  AND
FA.LOCATION_POINT_TYPE='*POINT OF RECORD' 
/

select count(*) station_count from storetw.fa_station_web;

drop table FA_STATION_MAP;
create table FA_STATION_MAP
tablespace storetdata
storage (initial 25M next 25M)
as
SELECT 
FA.ORGANIZATION_ID "Org_ID", FA.STATION_ID "Station_ID", 
FA.STATION_NAME "Station_Name", st.PRIMARY_TYPE 
"Primary_Type", st.SECONDARY_TYPE "Secondary_Type", 
FA.LATITUDE "Latitude", FA.LONGITUDE "Longitude", hd.HORIZONTAL_DATUM "Horizontal Datum", 
ca.HYDROLOGIC_UNIT_CODE "HUC", cag.HYDROLOGIC_UNIT_CODE "Generated_HUC"
FROM 
FA_STATION FA,DI_STATN_TYPES st,LU_MAD_HDATUM hd,LU_MAD_HDATUM hds,LU_MAD_HMETHOD hm,
LU_MAD_VDATUM vd,LU_MAD_VMETHOD vm,DI_GEO_STATE gs,DI_GEO_COUNTY gc,
DI_DB_CAT ca,DI_DB_CAT cag,LU_ESTRY_PRIMARY ep,LU_ESTRY_SECONDARY es,DI_ORG og
WHERE 
FA.fk_org = og.pk_isn (+) AND FA.fk_gen_db_cat = cag.pk_isn (+) AND 
FA.fk_db_cat = ca.pk_isn (+) AND FA.fk_estry_primary = ep.pk_isn (+) AND 
FA.fk_estry_secondary = es.pk_isn (+) AND fk_statn_types = st.pk_isn (+) AND 
fk_mad_hdatum = hd.pk_isn (+) AND fk_std_hdatum = hds.pk_isn (+) AND 
fk_mad_hmethod = hm.pk_isn (+) AND 
FA.fk_mad_vdatum = vd.pk_isn (+) AND FA.fk_mad_vmethod = vm.pk_isn (+) AND 
FA.fk_geo_state = gs.pk_isn (+) AND FA.fk_geo_county = gc.pk_isn (+)  AND
FA.LOCATION_POINT_TYPE='*POINT OF RECORD' 
/

ALTER TABLE fa_station_map 
set unused ("Description Text","FRS Key Identifier","Natv American Land Name","Ocean Name");
ALTER TABLE fa_station_map 
set unused ("Great Lake Name","Other Estuary Name","Secondary Estuary","Primary Estuary","NRCS Watershed ID","RF1 Segment Name","RF1 Mileage","On Reach Ind");
ALTER TABLE fa_station_map 
set unused ("RF1 Segment Code","County","State","Country Name","Elevation Method","Geopositioning Method","Map Scale","Elevation","Elevation Datum");
ALTER TABLE fa_station_map 
set unused ("Converted Latitude","Converted Longitude","Converted Horizontal Datum");
ALTER TABLE fa_station_map 
set unused ("S/G/O Indicator","Well Number","Well Name","Pipe Number","NAICS Code","Spring Type Improvement","Permanence","USGS Geologic Unit Code-Name"); 
ALTER TABLE fa_station_map 
set unused ("Spring Other Name","USGS Lithologic Unit Code-Name","Location Point Type","Point Sequence Number","Point Name");
select count(*) station_count from storetw.fa_station_map;


select table_name,chain_cnt from user_tables
where chain_cnt > 0;

-- select * from fa_station
-- where rowid in
-- (select b.row_id
-- from
-- (select min(rowid) row_id,organization_id,station_id from storetw.fa_station where location_point_type='*POINT OF RECORD' group by organization_id,station_id) a,
-- (select max(rowid) row_id,organization_id,station_id from storetw.fa_station where location_point_type='*POINT OF RECORD' group by organization_id,station_id) b
-- where a.station_id = b.station_id
--       and  a.organization_id = b.organization_id
--       and  a.row_id<>b.row_id
-- )
-- order by organization_id,station_id
-- /

-- select wb.pk_isn, wb.organization_id, wb. station_id from
-- (select * from fa_station
-- where rowid in
-- (select b.row_id
-- from
-- (select min(rowid) row_id,organization_id,station_id from storetw.fa_station where location_point_type='*POINT OF RECORD' group by organization_id,station_id) a,
-- (select max(rowid) row_id,organization_id,station_id from storetw.fa_station where location_point_type='*POINT OF RECORD' group by organization_id,station_id) b
-- where a.station_id = b.station_id
--       and  a.organization_id = b.organization_id
--       and  a.row_id<>b.row_id
-- )
-- ) wa, fa_station wb
-- where wa.organization_id=wb.organization_id and 
--       wa.station_id=wb.station_id and
--       wb.location_point_type='*POINT OF RECORD'
-- /

def DB_T       = STORETW
set feedback off
set verify off
set serveroutput on
set termout on
exec dbms_output.put_line('Starting build select of columns to be altered for &DB_T');
exec dbms_output.put_line('Dropping Temporary table if exist otherwise Please ignore the error');
drop table sem_tab
/
create table sem_tab(s_owner varchar2(40),
                     s_table_name varchar2(40),
                     s_column_name varchar2(40),
                     s_data_type varchar2(40),
                     s_char_length number)
/
insert into sem_tab
  select C.owner, C.table_name, C.column_name, C.data_type, C.char_length
    from all_tab_columns C, all_tables T
   where C.owner = T.owner
     and T.owner in ('&DB_T')
     and C.table_name = T.table_name
     and C.table_name not in (select table_name from all_external_tables)
     and C.table_name not LIKE ('BIN$%')
     and C.data_type in ('VARCHAR2', 'CHAR')
  -- You can exclude or include tables or schemas as you wish, by adjusting
  -- "and T.owner not in" as per your requirements
/
commit
/
spool off
set pagesize 0
set linesize 100
spool SCHEMA_mod_col.sql
PROMPT SET ECHO ON
PROMPT SET TIME ON
-- select * from sem_tab;
select 'ALTER TABLE ' || s_owner || '.' || s_table_name || ' modify (' || '"'||s_column_name||'"' || ' ' || s_data_type ||'(' || s_char_length || ' CHAR));' from sem_tab;
spool off

exec dbms_output.put_line('    ');
exec dbms_output.put_line('--------------------->  Please review and run &DB_T._mod_col.sql script');
exec dbms_output.put_line('    ');
@SCHEMA_mod_col.sql

