/*******************************************************
Filename		:  estry_tables.sql
Release 		:  c2.0
SIR			:  1473
Description		:  Estuary look up table and related object creation.  This object will be used for reporting.
Author			:  Ganesh Thadkamalla
Date			:  10/01/2002
			   09/02/2003 -- remove null values from look-up tables -JW
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
--12/27/2007 added Kevin changes and commented out the fa_station_map and fa_station_wweb table DDL and DML statements. Defect# 987
Comments		:  
**********************************************************/

set echo on;
spool  estry_tables.log

drop sequence seq_estry_primary;
drop sequence seq_estry_secondary;

create sequence seq_estry_primary
start with 1 increment by 1 nomaxvalue nocycle cache 10;

create sequence seq_estry_secondary
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table lu_estry_primary;
create table lu_estry_primary
(pk_isn number(12,0),
 primary_estuary varchar2(30)
);

drop table lu_estry_secondary;
create table lu_estry_secondary
(pk_isn number(12,0),
 secondary_estuary varchar2(30)
);

alter table lu_estry_primary
add constraint pk_estry_primary primary key (pk_isn)
using index
tablespace STORETINDX
storage (initial  100K next 100K)
nologging;

alter table lu_estry_secondary
add constraint pk_estry_secondary primary key (pk_isn)
using index
tablespace STORETINDX
storage (initial  100K next 100K)
nologging;

--add data to lu_estry_primary
set serveroutput on
declare
cursor c1 is select distinct primary_estuary from fa_station
	where primary_estuary is not null;

begin
for c1_var in c1 loop
insert into lu_estry_primary (pk_isn,primary_estuary)
values(seq_estry_primary.nextval,c1_var.primary_estuary);
end loop;
commit;
end;
/

--add data to lu_estry_secondary
set serveroutput on
declare
cursor c1 is select distinct secondary_estuary from fa_station
	where secondary_estuary is not null;

begin
for c1_var in c1 loop
insert into lu_estry_secondary (pk_isn,secondary_estuary )
values(seq_estry_secondary.nextval,c1_var.secondary_estuary);
end loop;
commit;
end;
/
commit;
create index iestry_primary01 on lu_estry_primary(primary_estuary)
tablespace STORETINDX
storage (initial 100K next 100K)
nologging;

create index iestry_secondary01 on lu_estry_secondary(secondary_estuary)
tablespace STORETINDX
storage (initial 100K next 100K)
nologging;

-- add fk to fa_station

alter table fa_station
add (fk_estry_primary number(12,0),
     fk_estry_secondary number(12,0));

--update fks in fa_station

declare
cursor c1 is select * from lu_estry_primary;
cursor c2 is select * from lu_estry_secondary;

begin
for c1_var in c1 loop
update fa_station 
set fk_estry_primary = c1_var.pk_isn
where primary_estuary = c1_var.primary_estuary
  and primary_estuary is not null;
end loop;
commit;

for c2_var in c2 loop
update fa_station 
set fk_estry_secondary = c2_var.pk_isn
where secondary_estuary = c2_var.secondary_estuary 
 and  secondary_estuary is not null;
end loop;
commit;
end;
/
--fks in fa_station
alter table fa_station
add constraint fk_sd_estry_primary foreign key (fk_estry_primary) references lu_estry_primary(pk_isn);
alter table fa_station
add constraint fk_sd_estry_secondary foreign key (fk_estry_secondary) references lu_estry_secondary(pk_isn);


--indexes on fks in fa_station
create index isd_fk_estry_primary on fa_station(fk_estry_primary)
tablespace STORETINDX
storage (initial 500K next 500K)
nologging;

create index isd_fk_estry_secondary on fa_station(fk_estry_secondary)
tablespace STORETINDX
storage (initial 500K next 500K)
nologging;

--
  
spool off;