/*******************************************************
Filename :  fa_---_result_custody_id.sql
Release  :  c2.0.3
SIR	 :  
Description :  Populate act_std_lat act_std_long and act_std_datum fk
Author	 :  Ganesh Thadkamalla
Date	 :  06/10/2004.
Comments :  Oracle Spatial option should be installed on the ETL database
before runing this script.

Following are the rules implemented.

1) Coordinates with WGS72,WGS84 and NAD27 datums are converted to NAD83 datum. 
The converted columns are populated in appropriate STD. columns.
2) For activity points and station points other than Point of Record, the
station's Point of Record country/state assignment is used for NAD27 conversion to NAD83.
If Station Point of Record have no state/country assignments, then the coordinate
and datum information is copied to STD columns with out any conversion.
3) Coordinates with any other datums are copied to appropirate STD columns.
____________
Datum conversion srid codes are read from etl_glob_var package.
**********************************************************/
alter session set nls_length_semantics='CHAR';
set time on
spool fa_---_result_custody_id3.log
-- Append custody_id columns to activity_id 

--cR_42 fdact.ID_CODE (12) + (244) =256
alter table FA_HABITAT_RESULT modify ACTIVITY_ID varchar2(256);
SET TRANSACTION USE ROLLBACK SEGMENT RBSBIG;
UPDATE FA_HABITAT_RESULT RE SET ACTIVITY_ID = substr(rtrim(ACTIVITY_ID) || 
	(SELECT Nvl2(act.ID_CODE,' \\Custody_ID: ',Null)||CHAIN_OF_CUSTODY_ID
	from storet1.tsrfdact act
	WHERE re.ORGANIZATION_ID = act.tsrfdact_org_id
	AND re.ACTIVITY_IS_NUMBER = act.tsrfdact_is_number
	AND NULLIF(substr(act.CHAIN_OF_CUSTODY_ID,1,1),' ') is NOT Null
--	AND act.CHAIN_OF_CUSTODY_ID is NOT Null
	),1,256);
commit;
--
--debug sql
--SELECT TSRFDACT_IS_NUMBER||Nvl2(act.CHAIN_OF_CUSTODY_ID,' \\ Custody_ID: ',Null)||CHAIN_OF_CUSTODY_ID
--	from storet1.tsrfdact act
--	WHERE NULLIF(substr(act.CHAIN_OF_CUSTODY_ID,1,1),' ') is NOT Null
--	;

spool usgs_BUNKER.txt
UPDATE "STORETW"."FA_REGULAR_RESULT"RE
  	SET activity_meas_qual_code = nvl(rtrim(replace(substr(result_comment,1,2),'.','')),Null) 
  	      where rtrim(re.organization_id) = 'BUNKER'
 	      AND rtrim(project_id) = 'BH OU 3' ;
commit;
UPDATE "STORETW"."FA_REGULAR_RESULT"RE
  	SET activity_meas_qual_code = nvl(rtrim(replace(substr(result_comment,1,2),'.','')),Null) 
  	      where rtrim(re.organization_id) = 'BUNKER'
 	      AND rtrim(project_id) = 'USGS 100';
commit;
UPDATE "STORETW"."FA_REGULAR_RESULT"RE
  	SET activity_meas_qual_code = nvl(rtrim(replace(substr(result_comment,1,2),'.','')),Null) 
  	      where rtrim(re.organization_id) = 'BUNKER'
 	      AND rtrim(project_id) = 'BH OU 2' ;
commit;
UPDATE "STORETW"."FA_REGULAR_RESULT"RE
  	SET activity_meas_qual_code = nvl(rtrim(replace(substr(result_comment,1,2),'.','')),Null) 
  	      where rtrim(re.organization_id) = 'BUNKER'
 	      AND rtrim(project_id) = 'BEMPSED' ;
commit;
spool off;
set time off
