/*******************************************************
Filename		:  FA_BIO_RESULT_data2.sql
Release 		:  c2.0, c2.0.4
SIR			:  1495
Description		:  Adds additional data element to the FA_BIOLOGICAL_RESULT fact table.
Author			:  Christine Tsang
Date			:  7/8/2003
	7/29/2003 - changed update for EPA reg #.
	8/13/2003 - added logic to set activity attributes for 'Composite-with Parents' samples.
	8/13/2003 - Separated update of non-sti subject taxons from the other fields.
	8/26/2003 - SIR 1495 TIR#4 - Corrected updates of net tow and net non-tow.
	   TIR#5 - Modified code for common_class_desc.
	   TIR#6 - Modified code for characteristic_name.  
	01/16/04 - SIR 1586 Moved connect string to master install script -JW
	1-21-2004 --added station location point information (new fk to fa_station) -JW
	05/26/04 --add STD value and unit and updated UOM logic -JW
	06/09/2004 - added std datum columns -GT
	6/21/2004 --updated unit conversion to user result_value_text and to test 0 values -JW
	7/19/2004 --added std unit and value code for all_bio_group_non_sti_results records -JW
	08/28/2044 - change tsruom_is_number to FK_UNIT_CONVERSION -JW
	09/27/2004 - fa_statn_types is read from fa_station table. -GT
 	01/19/2005 - result_comment and text result update are edited to use long_temp table created.  This table has description_text fixed for SIR 1677. - GT
	01/19/2005 - SIR1677 converted chr(10) to chr(182) for columns identified by the SIR. - GT.
	02/15/2005 - SIR1677 TIR01.  modified 3 updates to join tsrcalt for evaluating type_name. -GT.
	06/07/2005 - SIR1706. Update generated_huc, fk_db_cat and fk_gen_db_cat with fa_station's generated_huc, fk_db_cat and fk_gen_db_cat column data respectively.  -GT
 	06/09/2005 - Edited to remove references to tsrchals and tsrchar tables. - GT

Comments		:  Run this script after create_bio_temp_tables.sql.
**********************************************************/
spool FA_BIOLOGICAL_RESULT_data2.log

set serveroutput on
set time on


prompt "SAMPLE PRES INFO"
update FA_BIOLOGICAL_RESULT re
set (container_desc,TEMP_PRESERVN_TYPE,presrv_strge_prcdr) = (
	select container_desc,TEMP_PRESERVN_TYPE,presrv_strge_prcdr
	from bio_sample_pres_temp smple
	where re.activity_is_number = smple.tsrfdact_is_number
	and re.organization_id = smple.tsrfdact_org_id);
commit;

--Populate station location point information (updated 01-21-2004)
update fa_biological_result re
set (fk_stn_act_pt) = (
	select pk_isn
	from fa_station st
	where re.tsmalp_is_number = st.tsmalp_is_number
	and re.organization_id = st.organization_id);

commit;

update fa_biological_result re
set (fk_stn_act_pt) = (fk_station)
where fk_stn_act_pt is null;

commit;

spool off