/*******************************************************
Filename :  update_bio_temp_tables2.sql
Release  :  c2.0.3
SIR	 :  
Description :  Populate tr_start and tr_stop standard columns.
Author	 :  Ganesh Thadkamalla
Date	 :  06/30/2004.
Comments :  Oracle Spatial option should be installed on the ETL database
before runing this script.

Following are the rules implemented.

1) Coordinates with WGS72,WGS84 and NAD27 datums are converted to NAD83 datum. 
The converted columns are populated in appropriate STD. columns.
2) For activity points and station points other than Point of Record, the
station's Point of Record country/state assignment is used for NAD27 conversion to NAD83.
If Station Point of Record have no state/country assignments, then the coordinate
and datum information is copied to STD columns with out any conversion.
3) Coordinates with any other datums are copied to appropirate STD columns.
------------------
Datum conversion srid codes are read from etl_glob_var package.
**********************************************************/
spool update_bio_temp_tables2.log
-- Add std_ columns to biofdact_temp2 

alter table biofdact_temp2
add (TR_START_STD_LATITUDE NUMBER(9,7),
     tr_start_std_longitude number(10,7),
     tr_start_std_hdatum char(12),
     TR_STOP_STD_LATITUDE NUMBER(9,7),
     tr_stop_std_longitude number(10,7),
     tr_stop_std_hdatum char(12));


--pl/sql procedure to calculate trawl std_latitude and std_longitude.
set serveroutput on
declare
  cursor cact is
  select ft.ACTIVITY_is_number,ft.organization_id,
   ft.TR_START_LATITUDE,ft.TR_START_LONGITUDE,ft.TR_START_HDATUM,
   ft.TR_STOP_LATITUDE,ft.TR_STOP_LONGITUDE,ft.TR_STOP_HDATUM,
   ft.station_is_number
  from biofdact_temp2 ft
  where ft.tr_start_latitude is not null
     or ft.tr_stop_latitude is not null;

  --local variables
  --trawl start related.
  lv_start_std_lat biofdact_temp2.TR_START_STD_LATITUDE%type;
  lv_start_std_long biofdact_temp2.TR_START_STD_LONGITUDE%type;
  lv_start_hdatum biofdact_temp2.TR_START_HDATUM%type;
  lv_start_std_hdatum biofdact_temp2.TR_START_STD_HDATUM%type:=null;
  lv_start_convert number(1) := 0;

  -- trawl stop related.
  lv_stop_std_lat biofdact_temp2.TR_STOP_STD_LATITUDE%type;
  lv_stop_std_long biofdact_temp2.TR_STOP_STD_LONGITUDE%type;
  lv_stop_hdatum biofdact_temp2.TR_STOP_HDATUM%type;
  lv_stop_std_hdatum biofdact_temp2.TR_STOP_STD_HDATUM%type:=null;
  lv_stop_convert number(1) := 0;


  -- reusable variables.  
  lv_srid number(6,0);
  LV_COUNTRY_CODE fa_station.country_code%type := '00';
  LV_STATE_POSTAL_CODE fa_station.state_postal_code%type:='00';
  lv_nad83 biofdact_temp2.ACT_STD_HDATUM%type:='NAD83';
  lv_cntr number:=0;
  -- geometry objects
  geom1 mdsys.sdo_geometry;
  geom2 mdsys.sdo_geometry;

begin
-- Oracle srid for datum that need to be converted.
--WGS72    		8306 
--WGS84    		8307 
--NAD27    		8260
--NAD27 US - Alaska  	8254
--NAD27 cANADA  	8256
--NAD27 MEXICO  	8263
--Puerto Rico ???
-- fk of nad83

  for cact_var in cact loop
   -- Processing trawl start coordinates
   -- initialize variables
   lv_start_convert:=0;
   lv_srid:=null;
   -- Determine if conversion is needed. If so, identify the source SRID.
   if cact_var.TR_START_LATITUDE is null then
    -- flag for no conversion or update.
    lv_start_convert := -1;
   elsif cact_var.tr_start_hdatum  = 'WGS72' then
    lv_srid := etl_glob_var.srid_wgs72;
    lv_start_convert := 1;
   elsif cact_var.tr_start_hdatum  = 'WGS84' then
  -- WGS84 is same as NAD83.
    lv_srid := etl_glob_var.srid_wgs84;
    lv_start_convert := 1;
   elsif cact_var.tr_start_hdatum  = 'NAD27' then
     -- query for country_code and state_postal_code.
     BEGIN
      lv_country_code :=null;
      lv_state_postal_code :=null;
      select country_code, state_postal_code 
      into lv_country_code,lv_state_postal_code
      from fa_station fas
      where fas.station_is_number = cact_var.station_is_number
       and fas.organization_id = cact_var.organization_id
       and fas.location_point_type = '*POINT OF RECORD';

     EXCEPTION WHEN NO_DATA_FOUND THEN
       LV_COUNTRY_CODE := '00';
       LV_STATE_POSTAL_CODE :='00';
     END;

     if lv_country_code='CN' then     
       lv_srid :=etl_glob_var.srid_NAD27_CANADA;
       lv_start_convert := 1;
     elsif lv_country_code='MX' then     
        lv_srid:=etl_glob_var.srid_NAD27_MEXICO;
       lv_start_convert := 1;
     elsif lv_country_code='US' and lv_state_postal_code='AK' then     
       lv_srid := etl_glob_var.srid_NAD27_Alaska;
       lv_start_convert := 1;
     elsif lv_country_code='US' then
       lv_srid:=etl_glob_var.srid_NAD27;
       lv_start_convert := 1;
     elsif (lv_country_code = '00' or lv_state_postal_code = '00') then
       lv_start_convert := 0;
       lv_srid:=null;
     else
       lv_start_convert := 0;
       lv_srid:=null;
     end if;  
   else
    lv_start_convert:=0;
    lv_srid:=null;
   end if;

   -- initial lv_start_std_lat and lv_start_std_long 
   lv_start_std_lat :=null;
   lv_start_std_long :=null;

   if lv_start_convert = 1 then
    geom1:=null;
    geom2:=null;
    geom1:= mdsys.sdo_geometry(2001,lv_srid,
             mdsys.sdo_point_type(cact_var.TR_START_longitude,
                   cact_var.TR_START_latitude,null),
                 null,null);
    --geom2:=mdsys.sdo_cs.transform(geom1, to_srid=>8265); --convert to nad 83
    geom2:=mdsys.sdo_cs.transform(geom1, to_srid=>etl_glob_var.srid_NAD83); --convert to nad 83
    --pull the x/y back out
    lv_start_std_long:=geom2.sdo_point.x;
    lv_start_std_lat:=geom2.sdo_point.y;
    lv_start_std_hdatum := lv_nad83;
   elsif (lv_start_convert = 0 )then
     lv_start_std_lat := cact_var.tr_start_latitude;
     lv_start_std_long:=cact_var.tr_start_LONGITUDE;
     lv_start_std_hdatum := cact_var.tr_start_hdatum;
   elsif lv_start_convert = -1 then
     lv_start_std_lat := cact_var.tr_start_latitude;
     lv_start_std_long:=cact_var.tr_start_LONGITUDE;  
     lv_start_std_hdatum := cact_var.tr_start_hdatum;
   end if;

----------------------
   -- Processing trawl stop coordinates
   -- initialize variables
   lv_stop_convert:=0;
   lv_srid:=null;
   -- Determine if conversion is needed. If so, identify the source SRID.
   if cact_var.TR_stop_LATITUDE is null then
    -- flag for no conversion or update.
    lv_stop_convert := -1;
   elsif cact_var.tr_stop_hdatum  = 'WGS72' then
    lv_srid := etl_glob_var.srid_wgs72;
    lv_stop_convert := 1;
   elsif cact_var.tr_stop_hdatum  = 'WGS84' then
  -- WGS84 is same as NAD83.
    lv_srid := etl_glob_var.srid_wgs84;
    lv_stop_convert := 1;
   elsif cact_var.tr_stop_hdatum  = 'NAD27' then
     -- query for country_code and state_postal_code.
     BEGIN
      lv_country_code :=null;
      lv_state_postal_code :=null;
      select country_code, state_postal_code 
      into lv_country_code,lv_state_postal_code
      from fa_station fas
      where fas.station_is_number = cact_var.station_is_number
       and fas.organization_id = cact_var.organization_id
       and fas.location_point_type = '*POINT OF RECORD';

     EXCEPTION WHEN NO_DATA_FOUND THEN
       LV_COUNTRY_CODE := '00';
       LV_STATE_POSTAL_CODE :='00';
     END;

     if lv_country_code='CN' then     
       lv_srid :=etl_glob_var.srid_NAD27_CANADA;
       lv_stop_convert := 1;
     elsif lv_country_code='MX' then     
       lv_srid:=etl_glob_var.srid_NAD27_MEXICO;
       lv_stop_convert := 1;
     elsif lv_country_code='US' and lv_state_postal_code='AK' then     
       lv_srid := etl_glob_var.srid_NAD27_Alaska;
       lv_stop_convert := 1;
     elsif lv_country_code='US' then
       lv_srid:=etl_glob_var.srid_NAD27;
       lv_stop_convert := 1;
     elsif (lv_country_code = '00' or lv_state_postal_code = '00') then
       lv_stop_convert := 0;
       lv_srid:=null;
     else
       lv_stop_convert := 0;
       lv_srid:=null;
     end if;  
   else
    lv_stop_convert:=0;
    lv_srid:=null;
   end if;

   -- initial lv_stop_std_lat and lv_stop_std_long 
     lv_stop_std_lat :=null;
     lv_stop_std_long :=null;
   if lv_stop_convert = 1 then
     geom1:= mdsys.sdo_geometry(2001,lv_srid,
             mdsys.sdo_point_type(cact_var.TR_STOP_longitude,
                   cact_var.TR_STOP_latitude,null),
                 null,null);
     geom2:=mdsys.sdo_cs.transform(geom1, to_srid=>etl_glob_var.srid_NAD83); --convert to nad 83
     --pull the x/y back out
     lv_stop_std_long:=geom2.sdo_point.x;
     lv_stop_std_lat:=geom2.sdo_point.y;
     lv_stop_std_hdatum := lv_nad83;
   elsif (lv_stop_convert = 0 )then
     lv_stop_std_lat := cact_var.tr_stop_latitude;
     lv_stop_std_long:=cact_var.tr_stop_LONGITUDE;
     lv_stop_std_hdatum := cact_var.tr_stop_hdatum;
   elsif lv_stop_convert = -1 then
     lv_stop_std_lat := cact_var.tr_stop_latitude;
     lv_stop_std_long:=cact_var.tr_stop_LONGITUDE;
     lv_stop_std_hdatum := cact_var.tr_stop_hdatum;
   end if;


   if lv_start_convert = -1 and lv_stop_convert = -1 then
     null;
   else 
    update biofdact_temp2 c
    set TR_START_STD_LATITUDE =lv_start_std_lat,
        tr_start_std_longitude =lv_start_std_long,
        tr_start_std_hdatum =lv_start_std_hdatum,
        TR_STOP_STD_LATITUDE =lv_stop_std_lat,
        tr_stop_std_longitude =lv_stop_std_long,
        tr_stop_std_hdatum=lv_stop_std_hdatum
    where c.activity_is_number = cact_var.activity_is_number
      and c.organization_id = cact_var.organization_id;
   end if; 

    -- perform intermediate commits.
    lv_cntr:=lv_cntr+1;
    if lv_cntr > 3000 then
      commit;
      lv_cntr:=0;
    end if;

  end loop;

  commit;
end;
/
show errors


spool off;