/*******************************************************
Filename		:  FA_REGULAR_RESULT_data2.sql
Release 		:  c2.0
SIR			:  1497, 1614, 1619
Description		:  Adds additional data element to the FA_REGULAR_RESULT fact table.
Author			:  Joseph Wilson/Ganesh Thadkamalla
Date			:  3/28/2003
			   4/2003 - Edited to replace some org_id columns with organization_id --GAnesh.
			   7-01-2003 --changed names from CHEM to REGULAR; added new 2.0 columns and removed outdated -JW
			   7-03-2003 --updated dates to single date/time values -JW
			   7-10-2003 --added units to detection_limit -JW
			   7-15-2003 --added SAMPLE_FRACTION_TYPE -JW
			   7-16-2003 --added CAS # and ITIS # -JW
			   7-21-2003 --added new sample pres elements; changed name to SGO indicator -JW
			   7-29-2003 --added EPA REG # -JW
			   8-04-2003 --updated result comment and text result to user long_temp table; updated field_set -JW
			   8-11-2003 --updated SAMPLE PRES ELEMENTS update -JW
                     	   8-13-2003 --added logic to set activity attributes for 'Composite-with Parents' samples. -C Tsang
			   1-07-2004 --added station location point information (new fk to fa_station) -JW
			   1/16/2004 --SIR 1586 Moved connect string to master install script -JW
			   1/22/2004 --removed sublogs and added echo command -JW
			   5/18/2004 --added unit conversion update -JW
			   5/24/2004 --combined UOM and conversion updates to improve performance -JW
			   6/09/2004 - added std datum columns updates. -GT
			   6/18/2004 --updated char alias update logic to improve performance -JW
			   6/21/2004 --updated unit conversion to user result_value_text and to test 0 values -JW
	8/28/2004 --change tsruom_is_number to FK_UNIT_CONVERSION -JW
	8/10/2004 --updated char alias code to use tsrcalt table -JW
	09/27/2004 - fa_statn_types is read from fa_station table. -GT
	01/21/2005 - SIR 1677 carriage return character to paragraph marker for cas_number,epa_reg_number, itis_number, etc. - GT.
	06/07/2005 - SIR1702. Add generated_HUC related columns.-GT
 	06/09/2005 - Edited to remove references to tsrchals and tsrchar tables. - GT

Comments		:  new version of this script that uses seperate update statements at the table level.  This was done to reduce the number of update statements to improve performance time.  

**********************************************************/
spool FA_REGULAR_RESULT_data22.log
set serveroutput on
set time on
set echo on


SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
--

SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
UPDATE FA_REGULAR_RESULT RE SET (CHARACTERISTIC_NAME, cas_number) =
	(SELECT display_name, cas_number 
	FROM di_characteristic CHR
	WHERE re.FK_CHAR = CHR.pk_isn);
commit;

--CHAR system defined (overlay user defined)
UPDATE FA_HABITAT_RESULT RE SET CHARACTERISTIC_NAME =
	(SELECT CHR.DISPLAY_NAME	
	FROM storetw.di_characteristic CHR
	WHERE re.FK_CHAR = CHR.pk_isn)
   where fk_hcsc is null ;
commit;

--EPA registry num (edited for SIR 1677)
update FA_HABITAT_RESULT re
set re.EPA_REG_NUMBER = (
     select translate(als.char_alias,chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(96)||chr(94))  
     from storetw.lu_char_alias als , storetw.lu_char_alias_type calt
     where re.fk_char = als.fk_characteristic
       and als.fk_char_alias_type = calt.pk_isn
       and calt.char_alias_type_name = 'EPA ID (SUBSTANCE REGISTRY)');
commit;
--

-- Changed 8/26/2003 - added species number
prompt "CHAR"
UPDATE FA_BIOLOGICAL_RESULT RE SET CHARACTERISTIC_NAME =
	(SELECT CHR.DISPLAY_NAME||' '||re.SPECIES_NUMBER	
	FROM storetw.di_characteristic CHR
	WHERE re.FK_CHAR = CHR.pk_isn);
commit;

-- Changed 8/26/2003
update FA_BIOLOGICAL_RESULT re
set (re.common_class_desc, re.characteristic_name) = (
      select chr.display_name,
             chr.display_name||'  '||re.LOWER_BOUND_AMOUNT||' -> '
                             ||re.UPPER_BOUND_AMOUNT||' '||re.BIO_RCI_UNITS
	FROM storetw.di_characteristic CHR
	WHERE re.FK_CHAR = CHR.pk_isn)
where re.phys_bio_indicator = 'P';
commit;

--following 3 updates are edited to join tsrcalt for resolving type_name.
prompt "CHARACTERISTIC ALIASES"
update FA_BIOLOGICAL_RESULT re
set re.CAS_NUMBER = (
     select translate(als.char_alias ,chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(96)||chr(94))
     from storetw.lu_char_alias als , storetw.lu_char_alias_type calt
     where re.fk_char = als.fk_characteristic
       and als.fk_char_alias_type = calt.pk_isn
       and calt.char_alias_type_name = 'CAS NUMBER');
commit;

update FA_BIOLOGICAL_RESULT re
set re.EPA_REG_NUMBER = (
     select translate(als.char_alias,chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(96)||chr(94)) 
     from storetw.lu_char_alias als , storetw.lu_char_alias_type calt
     where re.fk_char = als.fk_characteristic
       and als.fk_char_alias_type = calt.pk_isn
       and calt.char_alias_type_name = 'EPA ID (SUBSTANCE REGISTRY)');
commit;

update FA_BIOLOGICAL_RESULT re
set re.ITIS_NUMBER = (
     select translate(als.char_alias ,chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(96)||chr(94))
     from storetw.lu_char_alias als , storetw.lu_char_alias_type calt
     where re.fk_char = als.fk_characteristic
       and als.fk_char_alias_type = calt.pk_isn
       and calt.char_alias_type_name = 'ITIS TAXON SERIAL NUMBER');
commit;

spool off
set echo off