/*******************************************************
Filename :  update_temp_tables.sql
Release  :  c2.0.3
SIR	 :  
Description :  Populate act_std_lat act_std_long and act_std_datum fk
Author	 :  Ganesh Thadkamalla
Date	 :  06/10/2004.
Comments :  Oracle Spatial option should be installed on the ETL database
before runing this script.

Following are the rules implemented.

1) Coordinates with WGS72,WGS84 and NAD27 datums are converted to NAD83 datum. 
The converted columns are populated in appropriate STD. columns.
2) For activity points and station points other than Point of Record, the
station's Point of Record country/state assignment is used for NAD27 conversion to NAD83.
If Station Point of Record have no state/country assignments, then the coordinate
and datum information is copied to STD columns with out any conversion.
3) Coordinates with any other datums are copied to appropirate STD columns.
____________
Datum conversion srid codes are read from etl_glob_var package.
**********************************************************/
spool update_temp_tables22.log
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
-- Add std_act_ columns to fdact_temp2 

alter table fdact_temp2
add (act_STD_HDATUM char(12),
     act_std_latitude number(9,7),
     act_std_longitude number(10,7));

-- create index on fdact_temp2(fk_mad_hdatum) for querries.
create index ift2_mad_hdatum 
on fdact_temp2(fk_act_mad_hdatum) 
tablespace storetindx
storage (initial 10M next 5M)
nologging;

create index ift2_station_is_number 
on fdact_temp2(station_is_number,organization_id) 
tablespace storetindx
storage (initial 10M next 5M)
nologging;

--pl/sql procedure to calculate act_std_latitude and act_std_longitude.
set serveroutput on
declare
  cursor cact is
  select ft.ACTIVITY_is_number,ft.organization_id,
   ft.activity_latitude,ft.activity_longitude,
        hd.id_code , ft.station_is_number,ft.fk_act_mad_hdatum
  from fdact_temp2 ft,
       lu_mad_hdatum hd
  where ft.fk_act_mad_hdatum = hd.pk_isn (+);

  -- geometry objects
  geom1 mdsys.sdo_geometry;
  geom2 mdsys.sdo_geometry;
  --local variables
  lv_lat fdact_temp2.ACT_STD_LATITUDE%type;
  lv_long fdact_temp2.ACT_STD_LONGITUDE%type;
  LV_COUNTRY_CODE fa_station.country_code%type := '00';
  LV_STATE_POSTAL_CODE fa_station.state_postal_code%type:='00';
  lv_act_std_mad_hdatum fdact_temp2.ACT_STD_HDATUM%type :=null;
  lv_nad83 fdact_temp2.ACT_STD_HDATUM%type:='NAD83';
  lv_cntr number:=0;
  lv_convert number(1) := 0;
  lv_srid number(6,0);


begin
-- Oracle srid for datum that need to be converted.
--WGS72    		8306 
--WGS84    		8307 
--NAD27    		8260
--NAD27 US - Alaska  	8254
--NAD27 cANADA  	8256
--NAD27 MEXICO  	8263
--Puerto Rico ???

  for cact_var in cact loop
   -- initialize variables
   lv_convert:=0;
   lv_srid:=null;
   -- Determine if conversion is needed. If so, identify the source SRID.
   if cact_var.activity_latitude is null then
    -- flag for no conversion or update.
    lv_convert := -1;
   elsif cact_var.id_code  = 'WGS72' then
    --lv_srid := 8306;
    lv_srid := etl_glob_var.srid_wgs72;
    lv_convert := 1;
   elsif cact_var.id_code  = 'WGS84' then
  -- WGS84 is same as NAD83.
    --lv_srid := 8307;
    lv_srid := etl_glob_var.srid_wgs84;
    lv_convert := 1;
   elsif cact_var.id_code  = 'NAD27' then
     -- query for country_code and state_postal_code.
     BEGIN
      lv_country_code :=null;
      lv_state_postal_code :=null;
      select country_code, state_postal_code 
      into lv_country_code,lv_state_postal_code
      from fa_station fas
      where fas.station_is_number = cact_var.station_is_number
       and fas.organization_id = cact_var.organization_id
       and fas.location_point_type = '*POINT OF RECORD';

     EXCEPTION WHEN NO_DATA_FOUND THEN
       LV_COUNTRY_CODE := '00';
       LV_STATE_POSTAL_CODE :='00';
     END;

     if lv_country_code='CN' then     
       --lv_srid := 8256;
       lv_srid :=etl_glob_var.srid_NAD27_CANADA;
       lv_convert := 1;
     elsif lv_country_code='MX' then     
       --lv_srid := 8263;
       lv_srid:=etl_glob_var.srid_NAD27_MEXICO;
       lv_convert := 1;
     elsif lv_country_code='US' and lv_state_postal_code='AK' then     
       --lv_srid := 8254;
       lv_srid := etl_glob_var.srid_NAD27_Alaska;
       lv_convert := 1;
     elsif lv_country_code='US' then
       --lv_srid := 8260;
       lv_srid:=etl_glob_var.srid_NAD27;
       lv_convert := 1;

     elsif (lv_country_code = '00' or lv_state_postal_code = '00') then
       lv_convert := 0;
       lv_srid:=null;
     else
       lv_convert := 0;
       lv_srid:=null;
     end if;  
   else
    lv_convert:=0;
    lv_srid:=null;
   end if;

   if lv_convert = 1 then
    --initialize variables.
    geom1 := null;
    geom2 := null;
    lv_lat :=null;
    lv_long :=null;

    geom1:= mdsys.sdo_geometry(2001,lv_srid,
             mdsys.sdo_point_type(cact_var.activity_longitude,
                   cact_var.activity_latitude,null),
                 null,null);
    geom2:=mdsys.sdo_cs.transform(geom1, to_srid=>etl_glob_var.srid_NAD83); --convert to nad 83
    --pull the x/y back out
    lv_long:=geom2.sdo_point.x;
    lv_lat:=geom2.sdo_point.y;
    lv_act_std_mad_hdatum := lv_nad83;
    -- update 
    update fdact_temp2 c
    set c.act_std_latitude = lv_lat,
        c.act_std_longitude = lv_long,
        c.act_STD_HDATUM = lv_act_std_mad_hdatum
    where c.activity_is_number = cact_var.activity_is_number
      and c.organization_id = cact_var.organization_id;
   elsif (lv_convert = 0 )then
    update fdact_temp2 c
    set c.act_std_latitude = cact_var.activity_latitude,
        c.act_std_longitude = cact_var.activity_longitude,
        c.act_STD_HDATUM = cact_var.id_code
    where c.activity_is_number = cact_var.activity_is_number
      and c.organization_id = cact_var.organization_id;
   elsif lv_convert = -1 then
     null;  --null data no action needed.
   end if;

    -- perform intermediate commits.
    lv_cntr:=lv_cntr+1;
    if lv_cntr > 3000 then
      commit;
      lv_cntr:=0;
    end if;

  end loop;

  commit;
end;
/
show errors


spool off;