/*******************************************************
Filename		:  fa_statn_table.sql
Release 		:  c2.0, C2.0.4
SIR			:  1498, 1648
Description		:  Create fact table fa_statn.  
Author			:  Ganesh Thadkamalla
Date			:  10/25/2002.
Comments		:  6/9/03 - Station_details_view is created locally. SIRs 1488, 1475.  fa_statn_data2.sql is merged into this script. --Ganesh.
                    	  07/03/2003 V2.0B sir 1498 BN/TN - Added Well Name, NAICS code, Spring type improvement, permanence, usgs_geologic unit, other
                                                    name, and usgs lithologic_unit, point name and blob title. 
			   7/21/2003 - updated column name to sgo_indicator
			   8-04-2003 - removed population of station_visited flag -JW
			   8-13-2003 - filter DEMOTEST data
			   8-26-2003 - populate stn_visited column -JW
			   8-28-2003 - tir 001 - changed Station_visited datatype from VARCHAR2(3) to CHAR(3)
			   9-02-2003 - moved stn_visited population to char_station_table script -JW
			   1-07-2004 - added TSMALP_IS_NUMBER and created an index on it -JW
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
			   07/28/04 - added DESCRIPTION_TEXT to the station table -JW
	12/02/2004 - sir 1648. correct station longitude values according to SIR. - GT
     12/27/2006 - Defect987. comment out _map and _web tables.
	07/11/07 - CR-16 add TRIBAL column - tholtz
	07/16/2007 - changed column name to TribalWaterQualityMeasure - tholtz
08/06/2007 - CR 43. Edited for station type synch. -GT.
**********************************************************/

spool fa_statn_table.log

-- drop commands.
drop sequence seq_fa_statn;
--truncate table fa_statn;
drop table fa_statn;

--PK sequence.
create sequence seq_fa_statn
start with 1 increment by 1 nomaxvalue nocycle cache 10;

create table fa_statn
(PK_ISN                                     NUMBER not null,
STATION_ID                                         CHAR(15),
STATION_NAME                                       VARCHAR2(60),
ORGANIZATION_ID                                    CHAR(8),
LOCATION_POINT_TYPE                                CHAR(16),
POINT_SEQUENCE_NUMBER                              NUMBER(4),
WELL_NUMBER                                        CHAR(15),
PIPE_NUMBER                                        CHAR(15),
LATITUDE                                           NUMBER(9,7),
LONGITUDE                                          NUMBER(10,7),
MAP_SCALE                                          VARCHAR2(20),
ELEVATION                                          CHAR(15),
ELEV_UNITS                                         CHAR(15),
COUNTRY_CODE                                       CHAR(2),
FIPS_STATE_CODE                                    CHAR(2),
STATE_POSTAL_CODE                                  CHAR(2),
FIPS_COUNTY_CODE                                   CHAR(3),
HYDROLOGIC_UNIT_CODE                               CHAR(8),
GENERATED_HUC					   CHAR(8),
RF1_SEGMENT_CODE                                   VARCHAR2(3),
RF1_SEGMENT_NAME                                   VARCHAR2(30),
RF1_MILEAGE                                        NUMBER(5,2),
ON_REACH_IND                                       CHAR(1),
NRCS_WATERSHED_ID                                  CHAR(8),
OTHER_ESTUARY_NAME                                 VARCHAR2(30),
GREAT_LAKE_NAME                                    CHAR(15),
OCEAN_NAME                                         CHAR(14),
NATV_AMERICAN_LAND_NAME                            VARCHAR2(40),
FRS_KEY_IDENTIFIER                                 VARCHAR2(36),
STATION_VISITED                                    CHAR(3),
STATION_IS_NUMBER                                  NUMBER(12),
ORGANIZATION_IS_NUMBER                             NUMBER(12),
STATION_GROUP_TYPE                                       VARCHAR2(256),
PRIMARY_TYPE                                       VARCHAR2(256),
SECONDARY_TYPE                                     VARCHAR2(256),
HORIZONTAL_DATUM                                   VARCHAR2(254),
GEOPOSITIONING_METHOD                              VARCHAR2(254),
ELEVATION_DATUM                                    VARCHAR2(254),
ELEVATION_METHOD                                   VARCHAR2(254),
PRIMARY_ESTUARY                                    VARCHAR2(30),
SECONDARY_ESTUARY                                  VARCHAR2(30),
SGO_INDICATOR                                      CHAR(1),
WELL_NAME                                          VARCHAR2(40),
NAICS_CODE                                         VARCHAR2(30),
SPRING_TYPE_IMPROVEMENT                            CHAR(14),
SPRING_PERMANENCE                                  CHAR(12),
SPRING_USGS_GEOLOGIC_UNIT                          VARCHAR2(100),
SPRING_OTHER_NAME                                  VARCHAR2(120),
SPRING_USGS_LITHOLOGIC_UNIT                        VARCHAR2(135),
POINT_NAME                                         VARCHAR2(30),
BLOB_TITLE                                         VARCHAR2(60),
TSMALP_IS_NUMBER				   NUMBER,
DESCRIPTION_TEXT				VARCHAR2(4000))                             
tablespace storetdata
storage (initial 25M next 10M) 
nologging;



insert into fa_statn
(pk_isn,STATION_ID,STATION_NAME,ORGANIZATION_ID,LOCATION_POINT_TYPE,POINT_SEQUENCE_NUMBER,
WELL_NUMBER,PIPE_NUMBER,LATITUDE,LONGITUDE,MAP_SCALE,ELEVATION,ELEV_UNITS,
HYDROLOGIC_UNIT_CODE,GENERATED_HUC,RF1_SEGMENT_CODE,RF1_SEGMENT_NAME,
RF1_MILEAGE,ON_REACH_IND,NRCS_WATERSHED_ID,OTHER_ESTUARY_NAME,GREAT_LAKE_NAME,OCEAN_NAME,
NATV_AMERICAN_LAND_NAME,FRS_KEY_IDENTIFIER,STATION_IS_NUMBER,ORGANIZATION_IS_NUMBER,
STATION_GROUP_TYPE,PRIMARY_TYPE,SECONDARY_TYPE,HORIZONTAL_DATUM,GEOPOSITIONING_METHOD,ELEVATION_DATUM,ELEVATION_METHOD,
PRIMARY_ESTUARY,SECONDARY_ESTUARY,WELL_NAME,SPRING_TYPE_IMPROVEMENT,SPRING_PERMANENCE,
SPRING_USGS_GEOLOGIC_UNIT,SPRING_OTHER_NAME,SPRING_USGS_LITHOLOGIC_UNIT,POINT_NAME,BLOB_TITLE,NAICS_CODE,
COUNTRY_CODE,FIPS_STATE_CODE,STATE_POSTAL_CODE,FIPS_COUNTY_CODE,TSMALP_IS_NUMBER,DESCRIPTION_TEXT)
select 
seq_fa_statn.nextval,
STATN.IDENTIFICATION_CD    			STATION_ID,
RTRIM(STATN.NAME)                 		STATION_NAME,
ORGAN.ORG_ID               			ORGANIZATION_ID,
--ORGAN.NAME                 			ORGANIZATION_NAME,
--
--Leave comment for possible future implementation
--
--DECODE(VSTC.SECONDARY_TYPE_CD,' ','',vstc.secondary_type_cd)   	SECONDARY_TYPE,
ALP.TYPE_CODE					LOCATION_POINT_TYPE,
ALP.SEQUENCE_NUMBER				POINT_SEQUENCE_NUMBER,
--ALP.POINT_NAME                            LOCATION_POINT_NAME,
WELL.ID_NUMBER					WELL_NUMBER,
PIPE.ID_NUMBER					PIPE_NUMBER,
LAT_DEC_DEG_MSR        				LATITUDE,
LONG_DEC_DEG_MSR			            LONGITUDE,
ALP.GEOPSTNG_SCALE_TXT				MAP_SCALE,
ALP.ELEVATION_MSR||ALP.ELVTN_UNT_CD     	ELEVATION,
ALP.ELVTN_UNT_CD			     	ELEV_UNITS,
--nvl(GEOPA.COUNTRY_NAME,'---')        		COUNTRY_NAME,
--NVL(GEOPA.STATE_NAME,'---')			STATE_NAME,
--NVL(GEOPA.COUNTY_NAME,'---')			COUNTY_NAME,
FHU.HYDROLOGIC_UNIT_CD				HYDROLOGIC_UNIT_CODE,
FHU.HYDROLOGIC_UNIT_CD				GENERATED_HUC,
--FHU.NAME					HYDROLOGIC_UNIT_NAME,
NVL(RRR.SEGMENT_CODE,'---')			RF1_SEGMENT_CODE,
NVL(RRR.NAME,'---')		  		RF1_SEGMENT_NAME,
ALP.RF1_MILEAGE					RF1_MILEAGE,
ALP.ON_RIVER_REACH_IND				ON_REACH_IND,
NVL(ALP.NRCS_WTRSD_ID_NUM,'---')		NRCS_WATERSHED_ID,
O_ESTRY.OTHER_ESTUARY_NAME			OTHER_ESTUARY_NAME,
GLL.NAME					GREAT_LAKE_NAME,
OCNLC.NAME					OCEAN_NAME,
nvl(NAL.NAME,'---')              	    	NATV_AMERICAN_LAND_NAME,
--statn.BLOB_TITLE				"DOCUMENT/GRAPHIC",
STATN.EPA_KEY_IDENTIFIER			FRS_KEY_IDENTIFIER,
--DECODE(f_station_visited(statn.tsmstatn_is_number,statn.tsmstatn_org_id),0,'NO',1,'YES')  STATION_VISITED,
STATN.TSMSTATN_IS_NUMBER   			STATION_IS_NUMBER,
ORGAN.TSMORGAN_IS_NUMBER 			ORGANIZATION_IS_NUMBER,
--VSTC.PRIMARY_TYPE_CD       			PRIMARY_TYPE,
--VSTC.SECONDARY_TYPE_CD			   	SECONDARY_TYPE, --01/30/2000
NVL(MTAM.wqx_name,DECODE (UPPER(SECONDARY_TYPE_CD),NULL, INITCAP(TRIM(PRIMARY_TYPE_CD)),
  'NONE', INITCAP(TRIM(PRIMARY_TYPE_CD)), 
INITCAP(TRIM(PRIMARY_TYPE_CD)||' '||TRIM(SECONDARY_TYPE_CD)))) STATION_GROUP_TYPE,
NVL(MTAM.wqx_name,DECODE (UPPER(SECONDARY_TYPE_CD),NULL, INITCAP(TRIM(PRIMARY_TYPE_CD)),
  'NONE', INITCAP(TRIM(PRIMARY_TYPE_CD)), 
INITCAP(TRIM(PRIMARY_TYPE_CD)||' '||TRIM(SECONDARY_TYPE_CD)))) PRIMARY_TYPE,
null,  --VSTC.SECONDARY_TYPE_CD			   	SECONDARY_TYPE, --01/30/2000
f_mad(ALP.GEOPSTNG_DATUM_CD,'HORIZONTAL','DATUM') HORIZONTAL_DATUM,
f_mad(ALP.GEOPSTNG_METHOD_CD,'HORIZONTAL','METHOD') GEOPOSITIONING_METHOD,
f_mad(ALP.ELEVATION_DATUM_CD,'VERTICAL','DATUM') ELEVATION_DATUM,
f_mad(ALP.ELVTN_METHOD_CD,'VERTICAL','METHOD') ELEVATION_METHOD,
f_estry(o_estry.tsmestry_org_id,o_estry.tsmestry_is_number,'P') PRIMARY_ESTUARY,
f_estry(o_estry.tsmestry_org_id,o_estry.tsmestry_is_number,'S') SECONDARY_ESTUARY,
WELL.NAME							WELL_NAME,
SPRNG.IMPROVEMENT_CODE                                          SPRING_TYPE_IMPROVEMENT,
SPRNG.PERMANENCE_CODE                                           SPRING_PERMANENCE,
GEOUN.TSMGEOUN_CD || ' ' || GEOUN.NAME				SPRING_USGS_GEOLOGIC_UNIT,
SPRNG.OTHR_GEO_UNIT_NM						SPRING_OTHER_NAME,
LTHUN.TSMLTHUN_CD || ' ' || LTHUN.NAME				SPRING_USGS_LITHOLOGIC_UNIT,
ALP.POINT_NAME							POINT_NAME,
STATN.BLOB_TITLE						BLOB_TITLE,
FNAICS(STATN.TSMSTATN_IS_NUMBER,STATN.TSMSTATN_ORG_ID)          NAICS_CODE,
GEOPA.COUNTRY_CODE       					COUNTRY_CODE,
GEOPA.STATE_FIPS_CODE		   				FIPS_STATE_CODE,
GEOPA.STATE_POSTAL_CODE   					STATE_POSTAL_CODE,
GEOPA.FIPS_COUNTY_CODE						FIPS_COUNTY_CODE,
ALP.TSMALP_IS_NUMBER,
translate(STATN.DESCRIPTION_TEXT,chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(96)||chr(94)) DESCRIPTION_TEXT
FROM
storet1.TSMSTATN  		STATN,
storet1.TSMORGAN  		ORGAN,
storet.TSMVSTC   	VSTC,
storet1.TSMALP    		ALP,
storet.TSMFHU    	FHU,
storet.TSMRRR    	RRR,
storet.TSMGEOPA  	GEOPA,
storet.TSMNAL    	NAL,
storet1.TSMWELL		WELL,
storet1.TSMPIPE		PIPE,
storet1.TSMESTLC		O_ESTRY,
storet1.TSMOCNLC		OCNLC,
storet1.TSMGLL		GLL,
storet1.tsmsprng              SPRNG,
storet.TSMGEOUN               GEOUN,
storet.TSMLTHUN		LTHUN,
storetw.mt_attribute_map	MTAM	
WHERE  STATN.TSMSTATN_ORG_ID 		= ORGAN.ORG_ID
AND  STATN.TSMVSTC_IS_NUMBER 		= VSTC.TSMVSTC_IS_NUMBER (+)
AND  STATN.TSMVSTC_ORG_ID 		= VSTC.TSMVSTC_ORG_ID (+)
AND VSTC.PRIMARY_TYPE_CD = MTAM.STORET_name (+)
AND VSTC.SECONDARY_TYPE_CD=MTAM.STORET_NAME2(+)
AND MTAM.MAPPING_FIELD (+) ='STATION_TYPES'
AND  ALP.TSMWELL_IS_NUMBER 		= WELL.TSMWELL_IS_NUMBER (+)
AND  ALP.TSMWELL_ORG_ID			= WELL.TSMWELL_ORG_ID (+)
AND  STATN.TSMSTATN_IS_NUMBER 		= ALP.TSMSTATN0IS_NUMBER
AND  STATN.TSMSTATN_ORG_ID 		= ALP.TSMSTATN0ORG_ID
AND  ALP.TSMPIPE_IS_NUMBER 		= PIPE.TSMPIPE_IS_NUMBER(+)
AND  ALP.TSMPIPE_ORG_ID			= PIPE.TSMPIPE_ORG_ID (+)
AND  ALP.TSMFHU_IS_NUMBER 		= FHU.TSMFHU_IS_NUMBER (+)
AND  ALP.TSMFHU_ORG_ID 			= FHU.TSMFHU_ORG_ID (+)
AND  ALP.TSMRRR_IS_NUMBER 		= RRR.TSMRRR_IS_NUMBER (+)
AND  ALP.TSMRRR_ORG_ID 			= RRR.TSMRRR_ORG_ID (+)
AND  ALP.TSMGEOPA_IS_NUMBER 		= GEOPA.TSMGEOPA_IS_NUMBER (+)
AND  ALP.TSMGEOPA_ORG_ID 		= GEOPA.TSMGEOPA_ORG_ID (+)
AND  ALP.TSMNAL_CD 			= NAL.TSMNAL_CD (+)
AND  ALP.TSMNAL_STATE 			= NAL.TSMNAL_STATE (+)
AND  ALP.TSMNAL_ORG_ID 		        = NAL.TSMNAL_ORG_ID (+)
AND  ALP.TSMALP_IS_NUMBER		= O_ESTRY.TSMALP_IS_NUMBER (+)
AND  ALP.TSMALP_ORG_ID			= O_ESTRY.TSMALP_ORG_ID (+)
AND  ALP.TSMALP_IS_NUMBER		= OCNLC.TSMALP_IS_NUMBER (+)
AND  ALP.TSMALP_ORG_ID			= OCNLC.TSMALP_ORG_ID (+)
AND  ALP.TSMALP_IS_NUMBER		= GLL.TSMALP_IS_NUMBER (+)
AND  ALP.TSMALP_ORG_ID			= GLL.TSMALP_ORG_ID (+)
AND  STATN.TSMSTATN_IS_NUMBER           = SPRNG.TSMSTATN_IS_NUMBER (+)
AND  STATN.TSMSTATN_ORG_ID              = SPRNG.TSMSTATN_ORG_ID (+)
AND  SPRNG.TSMGEOUN_CD			= GEOUN.TSMGEOUN_CD (+)
AND  SPRNG.TSMGEOUN_ORG_ID		= GEOUN.TSMGEOUN_ORG_ID (+)
AND  SPRNG.TSMLTHUN_CD			= LTHUN.TSMLTHUN_CD (+)
AND  SPRNG.TSMLTHUN_ORG_ID		= LTHUN.TSMLTHUN_ORG_ID (+);

commit;

select chr(126),'==>',chr(94) from dual;
update storetw.fa_statn sta
set sta.STATION_NAME = translate(sta.STATION_NAME,chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(96)||chr(94))
;
commit;

-- update storetw.fa_statn sta
-- set sta.DESCRIPTION_TEXT = translate(sta.DESCRIPTION_TEXT,chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(96)||chr(94))
-- WHERE ( ( sta."ORGANIZATION_ID" = '11NPSWRD' ) AND ( sta."STATION_ID" = 'ROMO_BG_LPOND' ) )
-- ;
-- commit;

-- Creating Primary Key
alter table fa_statn
add constraint pk_station primary key (pk_isn)
using index
tablespace storetindx
storage(initial 3m next 1m) nologging;       


create index sd_sid_oid on                         
fa_statn(station_id,organization_id)        
tablespace storetindx                             
storage(initial 3m next 3m) nologging;   

-- fa_statn_cleanup1.log
-- cleanup of duplicate *POINT OF RECORD rows.
select organization_id,station_id,count(*)
from storetw.fa_statn
where location_point_type='*POINT OF RECORD'
GROUP BY organization_id,station_id
HAVING COUNT(*) > 1
/


delete from STORETW.fa_statn
where rowid in
(
select b.row_id
from
(select max(rowid) row_id, organization_id,station_id from STORETW.fa_statn SI where location_point_type='*POINT OF RECORD' GROUP BY organization_id,station_id HAVING COUNT(*) > 1) a, (select min(rowid) row_id, organization_id,station_id from STORETW.fa_statn SI where location_point_type='*POINT OF RECORD' GROUP BY organization_id,station_id HAVING COUNT(*) > 1) b where a.station_id=b.station_id and a.organization_id=b.organization_id
and a.row_id<>b.row_id
);

COMMIT;

select organization_id,station_id,count(*)
from storetw.fa_statn
where location_point_type='*POINT OF RECORD'
GROUP BY organization_id,station_id
HAVING COUNT(*) > 1
/

-- fa_statn_cleanup1.log



-- create indexes.
create index sd_sisn_oid on                        
fa_statn(station_is_number,organization_id) 
tablespace storetindx                             
storage(initial 3M next 3M) nologging;                       
                                                   
create index sd_pt_st on                           
fa_statn(primary_type,secondary_type)       
tablespace storetindx                             
storage(initial 3M next 3M) nologging;                       
                                                   
create index sd_oid on                             
fa_statn(organization_id)                   
tablespace storetindx                             
storage(initial 3m next 3m) nologging;                       
                                                   
create index sd_lat on                             
fa_statn(latitude)                          
tablespace storetindx                             
storage(initial 3m next 3m) nologging;                       
                                                   
create index sd_long on                            
fa_statn(longitude)                         
tablespace storetindx                             
storage(initial 3m next 3m) nologging;                       

                                                   
--create index sd_sid_oid on                         
--fa_statn(station_id,organization_id)        
--tablespace storetindx                             
--storage(initial 3m next 3m) nologging;   

create index sd_oisn on                         
fa_statn(organization_is_number)        
tablespace storetindx                             
storage(initial 3m next 3m) nologging;       

create index sd_oid_alp on                         
fa_statn(organization_id,tsmalp_is_number)        
tablespace storetindx                             
storage(initial 3m next 3m) nologging;   

--SIR 1648
--alter table fa_statn RENAME COLUMN longitude TO bk_longitude ;
  alter table fa_statn add ( bk_longitude number(10,7) );  
	update fa_statn set bk_longitude = longitude;
	commit;
	update fa_statn set longitude = -1*longitude 
	where LONGITUDE > 0 and organization_id not in ('21GUAM','21GUBCH','21AQ');
	commit;
--
select count(pk_isn) "Station_Long_Problems"
     from fa_statn
where LONGITUDE > 0 and organization_id not in ('21GUAM','21GUBCH','21AQ');
---Aug 13, 2003
delete fa_statn
where ORGANIZATION_ID = 'DEMOTEST';

commit;

--
select 'Note:  Following select should not yield any rows. If it returns rows then there is problem with fdact_temp2 data.' from dual;

select TSMALP_IS_NUMBER,organization_id,count(*)
from fa_statn
group by TSMALP_IS_NUMBER,organization_id
having count(*)  > 1;

select 'Following delete statement fixes the storet1.tsmorgan data by deleting duplicate rows by keeping max(rowid)' from dual;

delete from fa_statn a
where a.rowid < (select max(b.rowid) from fa_statn b
         where b.TSMALP_IS_NUMBER = a.TSMALP_IS_NUMBER
           and b.organization_id = a.organization_id);

commit;


--
alter table fa_statn add PROJECT_ID char(8);

-- for CR-16; tholtz
Alter table fa_statn add TRIBAL_WATER_QUALITY_MEASURE CHAR(1 CHAR);
Alter table fa_statn add HORIZONTAL_ACCURACY CHAR(15 CHAR);

spool off;
