/*******************************************************
Filename		:  co_op_eaddr.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Cooperating Organization Electronic Address table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/16/2006.
Comments		:  
**********************************************************/

/******************************************************************************
Create sequences for MetaData Cooperating Organization Electronic Address table
*******************************************************************************/
set echo on 
spool co_op_eaddr.log

--drop sequence seq_md_coop_eaddress;

create sequence seq_md_coop_eaddress
start with 1 increment by 1 nomaxvalue nocycle cache 10;
/****************************************************************
Create MetaData Cooperating Organization Electronic Address table
*****************************************************************/
--drop table md_coop_eaddress;

create table md_coop_eaddress
( pk_isn number(12,0),
  coop_eaddr_is_number number(12,0) not null,
  organization_id VARCHAR2(256 char) not null,
  coop_eaddr_type VARCHAR2(256 char) not null,
  address_one_text VARCHAR2(256 char) not null ,
  address_two_text VARCHAR2(256 char),
  coop_org_is_number number(12,0));


alter table md_coop_eaddress
add constraint pk_co_org_eaddr primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;


create index iecoorgid on md_coop_eaddress(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;
/* moved to after insert

alter table md_coop_eaddress
add( fk_coop number(12,0));

update md_coop_eaddress oe
set fk_coop =(select pk_isn from md_coop op
              where op.coop_org_is_number=oe.coop_org_is_number
              and op.organization_id = oe.organization_id)
where oe.coop_org_is_number is not null;
commit;

create index iecoop on md_coop_eaddress(fk_coop)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_coop_eaddress
add constraint fk_md_ecoop foreign key (fk_coop) references md_coop(pk_isn);

commit;
*/

/*****************************************************************************
Populate MetaData Cooperating Organization  Electronic Address table with data.
******************************************************************************/
set serveroutput on
declare 
cursor c_coop_eaddr is 
select TSMEADDR_IS_NUMBER,TSMEADDR_ORG_ID,TYPE_CODE,ADDRESS_TEXT,COMMENT_TEXT,TSMCPORG_IS_NUMBER
from storet1.tsmeaddr EA,storetw.md_coop CO
where EA.tsmcporg_is_number = CO.coop_org_is_number
and EA.tsmcporg_org_id =CO.organization_id;

begin
  for c_var in c_coop_eaddr loop
    insert into md_coop_eaddress
    (pk_isn,coop_eaddr_is_number,organization_id,coop_eaddr_type,address_one_text,address_two_text,coop_org_is_number)
    values
    (seq_md_coop_eaddress.nextval,c_var.tsmeaddr_is_number,c_var.tsmeaddr_org_id,c_var.type_code,c_var.address_text,c_var.comment_text,c_var.tsmcporg_is_number);
  end loop;
end;
/

alter table md_coop_eaddress
add( fk_coop number(12,0));

update md_coop_eaddress oe
set fk_coop =(select pk_isn from md_coop op
              where op.coop_org_is_number=oe.coop_org_is_number
              and op.organization_id = oe.organization_id)
where oe.coop_org_is_number is not null;
commit;

create index iecoop on md_coop_eaddress(fk_coop)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_coop_eaddress
add constraint fk_md_ecoop foreign key (fk_coop) references md_coop(pk_isn);

commit;

alter table md_coop_eaddress add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_coop_eaddress add SOURCE_UID NUMBER(20);
commit;

alter table md_coop_eaddress modify coop_eaddr_is_number number(12,0)  null;

alter table md_coop_eaddress modify address_one_text VARCHAR2(256 char) null;



spool off;
