/********************************************************
Filename		:  lab.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Laboratory table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/19/2006.
Comments		:  
**********************************************************/

/**********************************************
Create sequences for MetaData Laboratory table
***********************************************/
set echo on 
spool lab.log
--drop sequence seq_md_lab;

create sequence seq_md_lab
start with 1 increment by 1 nomaxvalue nocycle cache 10;
/********************************
Create MetaData Laboratory table
*********************************/
--drop table  md_lab;

create table md_lab
( pk_isn number(12,0),
  lab_is_number number(12,0) not null,
  organization_id VARCHAR2(256 char) not null,
  organization_is_number number(12,0),
  lab_id VARCHAR2(256 char) not null,
  lab_name VARCHAR2(256 char) not null);
  
alter table md_lab
add constraint pk_lab primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index lab_org_no on md_lab(organization_is_number)
tablespace STORETINDX
storage(initial 512k next 512k)
nologging;

create index lab_orgid on md_lab(organization_id)
tablespace STORETINDX
storage(initial 512k next 512k)
nologging;

commit;
/* moved to after data insert
alter table md_lab
add( fk_org number(12,0));

update md_lab l
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=l.organization_is_number)
where l.organization_is_number is not null;
commit;

create index ilabfk on md_lab(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_lab
add constraint fk_md_lab foreign key (fk_org) references di_org(pk_isn);

commit;
*/
/********************************************
Populate MetaData Laboratory table with data.
*********************************************/

set serveroutput on
declare 
cursor c_lab is 
select TSRLAB_IS_NUMBER,TSRLAB_ORG_ID,TSMORGAN_IS_NUMBER,ID_CODE,NAME
from storet1.tsrlab; 

begin
  for c_var in c_lab loop
    insert into md_lab
    (pk_isn,lab_is_number,organization_id,organization_is_number,lab_id,lab_name)
    values
    (seq_md_lab.nextval,c_var.tsrlab_is_number,c_var.tsrlab_org_id,c_var.tsmorgan_is_number,c_var.id_code,c_var.name);
  end loop;
end;
/
show errors;
commit;

alter table md_lab
add( fk_org number(12,0));

update md_lab l
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=l.organization_is_number)
where l.organization_is_number is not null;
commit;

create index ilabfk on md_lab(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_lab
add constraint fk_md_lab foreign key (fk_org) references di_org(pk_isn);

commit;

alter table md_lab add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_lab add SOURCE_UID NUMBER(20);
commit;

alter table md_lab modify lab_is_number number(12,0) null;


spool off;

