/*********************************************************
Filename		:  lab_eaddr.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Laboratory Electronic Address table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/19/2006.
Comments		:  
**********************************************************/

/****************************************************************
Create sequences for MetaData Laboratory Electronic Address table
*****************************************************************/
set echo on 
spool lab_eaddr.log

--drop sequence seq_md_lab_eaddr;

create sequence seq_md_lab_eaddr
start with 1 increment by 1 nomaxvalue nocycle cache 10;

/****************************************************************
Create MetaData Laboratory Electronic Address table
*****************************************************************/
--drop table md_lab_eaddress;

create table md_lab_eaddress
( pk_isn number(12,0),
  eaddr_is_number number(12,0) not null,
  organization_id VARCHAR2(256 char) not null,
  lab_addr_type VARCHAR2(256 char) not null,
  address_one_text VARCHAR2(256 char) not null,
  address_two_text VARCHAR2(256 char),
  lab_is_number number(12,0));


alter table md_lab_eaddress
add constraint pk_lab_eaddr primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index ielborgid on md_lab_eaddress(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;
/* moved after insert statement

alter table md_lab_eaddress
add( fk_lab number(12,0));

update md_lab_eaddress le
set fk_lab =(select pk_isn from md_lab lb
             where lb.lab_is_number=le.lab_is_number
             and lb.organization_id = le.organization_id)
where le.lab_is_number is not null;
commit;

create index ielab on md_lab_eaddress(fk_lab)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_lab_eaddress
add constraint fk_md_elab foreign key (fk_lab) references md_lab(pk_isn);

commit;
*/

/***************************************************************
Populate MetaData Laboratory Electronic Address table with data.
****************************************************************/
set serveroutput on
declare 
cursor c_lab_eaddr is 
select TSMEADDR_IS_NUMBER,TSMEADDR_ORG_ID,TYPE_CODE,ADDRESS_TEXT,COMMENT_TEXT,TSRLAB_IS_NUMBER
from storet1.tsmeaddr EA,storetw.md_lab LB
where EA.tsrlab_is_number = LB.lab_is_number
and EA.tsrlab_org_id =LB.organization_id;

begin
  for c_var in c_lab_eaddr loop
    insert into md_lab_eaddress
    (pk_isn,eaddr_is_number,organization_id,lab_addr_type,address_one_text,address_two_text,lab_is_number)
    values
    (seq_md_lab_eaddr.nextval,c_var.tsmeaddr_is_number,c_var.tsmeaddr_org_id,c_var.type_code,c_var.address_text,c_var.comment_text,c_var.tsrlab_is_number);
  end loop;
end;
/

alter table md_lab_eaddress
add( fk_lab number(12,0));

update md_lab_eaddress le
set fk_lab =(select pk_isn from md_lab lb
             where lb.lab_is_number=le.lab_is_number
             and lb.organization_id = le.organization_id)
where le.lab_is_number is not null;
commit;

create index ielab on md_lab_eaddress(fk_lab)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_lab_eaddress
add constraint fk_md_elab foreign key (fk_lab) references md_lab(pk_isn);

commit;

alter table md_lab_eaddress add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_lab_eaddress add SOURCE_UID NUMBER(20);
commit;

alter table md_lab_eaddress modify eaddr_is_number number(12,0) null;


spool off;

