/*******************************************************
Filename		:  lab_sample_prep_proc.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Lab Sample Preparation Procedure table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/15/2006.
Comments		:  
**********************************************************/

/*******************************************************************
Create sequences for MetaData Lab Sample Preparation Procedure table
********************************************************************/
set echo on 
spool lab_sample_prep_proc.log
--drop sequence seq_md_lab_spp;

create sequence seq_md_lab_spp
start with 1 increment by 1 nomaxvalue nocycle cache 10;
/******************************************************
Create MetaData Lab Sample Preparation Procedure table
*******************************************************/
--drop table md_lab_sample_prep_procedure;

create table md_lab_sample_prep_procedure
( pk_isn number(12,0),
  organization_id VARCHAR2(256 char) not null,
  lspp_is_number number(12,0) not null,
  lspp_source VARCHAR2(256 char),
  procedure_id VARCHAR2(256 char) not null,
  procedure_name VARCHAR2(256 char) not null,
  citation VARCHAR2(4000 char));
  
alter table md_lab_sample_prep_procedure
add constraint pk_lab_spp primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index ilspporgid on md_lab_sample_prep_procedure(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;
/* moved after the insert
alter table md_lab_sample_prep_procedure add organization_is_number number(8,0);

update md_lab_sample_prep_procedure sp
set organization_is_number = (select organization_is_number 
                              from di_org o
                              where o.organization_id = sp.organization_id);
commit;


                              
alter table md_lab_sample_prep_procedure
add( fk_org number(12,0));

update md_lab_sample_prep_procedure lp
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=lp.organization_is_number)
where lp.organization_is_number is not null;
commit;

create index ilsppfk on md_lab_sample_prep_procedure(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_lab_sample_prep_procedure
add constraint fk_md_lspp foreign key (fk_org) references di_org(pk_isn);                        

commit;

*/
/************************************************************************
Populate MetaData Sample Lab Sample Preparation Procedure table with data.
*************************************************************************/
set serveroutput on
declare
CITATION_DESC VARCHAR2(4000);
cursor c_lab_spp is 
select TSRLSPP_ORG_ID,TSRLSPP_IS_NUMBER,SOURCE_ACR,PREPARATION_ID,NAME,TSRCITN_ORG_ID,TSRCITN_IS_NUMBER
from storet1.tsrlspp
where TSRLSPP_ORG_ID !='ZZZZZZZZ'; 

begin
 
for c1 in c_lab_spp loop
  begin
    select decode(CI.IDENTIFICATION_CD,null,null,trim(CI.IDENTIFICATION_CD)||',')||decode(CI.AUTHOR_NAME,null,null,trim(CI.AUTHOR_NAME)||',')||decode(CI.PUBLICATION_YEAR,null,null,trim(CI.PUBLICATION_YEAR)||',')||decode(CI.TITLE_NAME,null,null,trim(CI.TITLE_NAME)||',')||decode(CI.JRNL_OR_PBLSHR_NM,null,null,trim(CI.JRNL_OR_PBLSHR_NM)||',')||decode(CI.VOL_AND_PG_NUM,null,null,trim(CI.VOL_AND_PG_NUM)) INTO CITATION_DESC
    from storet1.tsrcitn CI
    where CI.tsrcitn_org_id = c1.tsrcitn_org_id 
    and CI.tsrcitn_is_number = c1.tsrcitn_is_number;
  exception when no_data_found then 
    CITATION_DESC:=null;
    null;
  end;
    insert into md_lab_sample_prep_procedure
    (pk_isn,organization_id,lspp_is_number,lspp_source,procedure_id,procedure_name,citation)
    values
    (seq_md_lab_spp.nextval,c1.tsrlspp_org_id,c1.tsrlspp_is_number,c1.source_acr,c1.preparation_id,c1.name,citation_desc);
end loop;

commit;
end;
/
show errors;
commit;

alter table md_lab_sample_prep_procedure add organization_is_number number(8,0);

update md_lab_sample_prep_procedure sp
set organization_is_number = (select organization_is_number 
                              from di_org o
                              where o.organization_id = sp.organization_id);
commit;
                              
alter table md_lab_sample_prep_procedure
add( fk_org number(12,0));

update md_lab_sample_prep_procedure lp
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=lp.organization_is_number)
where lp.organization_is_number is not null;
commit;

create index ilsppfk on md_lab_sample_prep_procedure(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_lab_sample_prep_procedure
add constraint fk_md_lspp foreign key (fk_org) references di_org(pk_isn);                        

commit;

alter table md_lab_sample_prep_procedure add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_lab_sample_prep_procedure add SOURCE_UID NUMBER(20);
commit;

alter table md_lab_sample_prep_procedure modify lspp_is_number number(12,0) null;



spool off;
