/*******************************************************
Filename		:  org_phy_addr.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Organization Address table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/9/2006.
Comments		:  
**********************************************************/

/*******************************************************
Create sequences for MetaData Organization Address table.
**********************************************************/
set echo on 
spool org_phy_addr.log
--drop sequence seq_md_org_address;

create sequence seq_md_org_address
start with 1 increment by 1 nomaxvalue nocycle cache 10;

/*******************************************************
Create MetaData Organization Address table
**********************************************************/
--drop table md_org_address;

create table md_org_address
( pk_isn number(12,0),
 organization_id VARCHAR2(256 char) not null,
  addr_is_number number(12,0) not null,
  organization_is_number number(12,0) not null,
  address_type VARCHAR2(256 char) not null,
  addr_one_text VARCHAR2(256 char),
  addr_two_text VARCHAR2(256 char),
  addr_three_text VARCHAR2(256 char),
  addr_four_text VARCHAR2(256 char),
  country_code VARCHAR(256 char),
  start_date DATE);
  
alter table md_org_address
add constraint pk_org_addr primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index iorgid on md_org_address(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

/* moved to end of insert block


alter table md_org_address
add( fk_org number(12,0));

update md_org_address oa
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=oa.organization_is_number)
where oa.organization_is_number is not null;
commit;

create index iaorg on md_org_address(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_org_address
add constraint fk_md_org foreign key (fk_org) references di_org(pk_isn);

*/
/*******************************************************
Populate MetaData Organization Address table with data.
**********************************************************/

set serveroutput on
declare 
cursor c_org_addr is 
select  TSMADDR_ORG_ID,TSMADDR_IS_NUMBER,TSMORGAN_IS_NUMBER,TYPE_CODE,LINE_ONE_TEXT,LINE_TWO_TEXT,LINE_THREE_TEXT,LINE_FOUR_TEXT,COUNTRY_CODE,START_DATE 
from storet1.tsmaddr AD,storetw.di_org DO
where AD.tsmorgan_is_number = DO.organization_is_number; 

begin
  for c_var in c_org_addr loop
    insert into md_org_address
    (pk_isn,organization_id,addr_is_number,organization_is_number,address_type,addr_one_text,addr_two_text,addr_three_text,addr_four_text,country_code,start_date)
    values
    (seq_md_org_address.nextval,c_var.tsmaddr_org_id,c_var.tsmaddr_is_number,c_var.tsmorgan_is_number,c_var.type_code,c_var.line_one_text,c_var.line_two_text,c_var.line_three_text,c_var.line_four_text,c_var.country_code,c_var.start_date);
  end loop;
 commit;
end;
/
show errors
commit;



alter table md_org_address
add( fk_org number(12,0));

update md_org_address oa
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=oa.organization_is_number)
where oa.organization_is_number is not null;
commit;

create index iaorg on md_org_address(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_org_address
add constraint fk_md_org foreign key (fk_org) references di_org(pk_isn);

alter table md_org_address add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_org_address add SOURCE_UID NUMBER(20);
commit;


alter table md_org_address modify addr_is_number number(12,0) null;

alter table md_org_address modify organization_is_number number(12,0) null;



spool off;
