/*********************************************************
Filename		:  program_table.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Organization Program table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/14/2006.
Comments		:  
**********************************************************/

/********************************************************
Create sequences for MetaData Organization Program table
*********************************************************/
set echo on 
spool program_table.log
--drop sequence seq_md_program;

create sequence seq_md_program
start with 1 increment by 1 nomaxvalue nocycle cache 10;
/*********************************************************
Create MetaData Organization Program table
**********************************************************/
--drop table md_program;

create table md_program
( pk_isn number(12,0),
  organization_id VARCHAR2(256 char) not null,
  program_is_number number(12,0) not null,
  program_type VARCHAR2(256 char) not null ,
  program_name VARCHAR2(256 char) not null,
  description VARCHAR2(4000 char),
  organization_is_number number(12,0),
  project_id VARCHAR2(256 char) not null,
  project_name VARCHAR2(256 char)not null);
  
  
alter table md_program
add constraint pk_program primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index iprgorgid on md_program(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;
/* moved to end of insert
alter table  md_program
add( fk_org number(12,0));

update md_program pr
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=pr.organization_is_number)
where pr.organization_is_number is not null;
commit;

create index iprofk on md_program(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_program
add constraint fk_md_pgm foreign key (fk_org) references di_org(pk_isn);

commit;

*/

/*************************************************************
Populate MetaData Organization Program table with data.
**************************************************************/

set serveroutput on
declare
v_type CHAR(3);
v_prog_name VARCHAR2(60);
v_org_is_number NUMBER(12,0);
v_id_cd CHAR(8);
v_proj_name VARCHAR2(60);
v_desc VARCHAR2(4000);

cursor c_prog_proj is 
select TSMPROGM_ORG_ID,TSMPROGM_IS_NUMBER,TSMPROJ_ORG_ID,TSMPROJ_IS_NUMBER
from storet1.tsmprpra; 

begin
 
for c1 in c_prog_proj loop
  begin
    select TYPE_CODE,NAME,TSMORGAN_IS_NUMBER INTO v_type,v_prog_name,v_org_is_number
    from storet1.tsmprogm PM
    where PM.tsmprogm_org_id = c1.tsmprogm_org_id 
    and PM.tsmprogm_is_number = c1.tsmprogm_is_number;
  exception when no_data_found then 
    v_type:=null;
    v_prog_name:=null;
    v_org_is_number:=null;
    null;
  end;
  
  begin
    select IDENTIFICATION_CD,NAME INTO v_id_cd,v_proj_name
    from storet1.tsmproj PR
    where PR.tsmproj_org_id = c1.tsmproj_org_id 
    and PR.tsmproj_is_number = c1.tsmproj_is_number;
  exception when no_data_found then 
    v_id_cd:=null;
    v_proj_name:=null;
    null;
 end;
   
   begin
    select DESCRIPTION_TEXT INTO v_desc
    from storet1.tsmgntxt GN
    where GN.tsmprogm_org_id = c1.tsmprogm_org_id 
    and GN.tsmprogm_is_number = c1.tsmprogm_is_number;
  exception when no_data_found then 
    v_desc:=null;
    null;
  end;
     
    insert into md_program
    (pk_isn,organization_id,program_is_number,program_type,program_name,description,organization_is_number,project_id,project_name)
    values
    (seq_md_program.nextval,c1.tsmprogm_org_id,c1.tsmprogm_is_number,v_type,v_prog_name,v_desc,v_org_is_number,v_id_cd,v_proj_name);
end loop;
commit;
end;
/
show errors;
commit;
alter table  md_program
add( fk_org number(12,0));

update md_program pr
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=pr.organization_is_number)
where pr.organization_is_number is not null;
commit;

create index iprofk on md_program(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_program
add constraint fk_md_pgm foreign key (fk_org) references di_org(pk_isn);

commit;

alter table md_program add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_program add SOURCE_UID NUMBER(20);
commit;

alter table md_program modify program_is_number number(12,0) null;


spool off;