/********************************************************
Filename		:  sample_gear.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Sample Gear and Equipment Configuration table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/13/2006.
Comments		:  
**********************************************************/


/*************************************************************************
Create sequences for MetaData Sample Gear and Equipment Configuration table
**************************************************************************/
set echo on 
spool sample_gear.log
--drop sequence seq_md_sample_gear;

create sequence seq_md_sample_gear
start with 1 increment by 1 nomaxvalue nocycle cache 10;

/*********************************************************
Create MetaData Sample Gear and Equipment Configuration table
**********************************************************/
--drop table md_sample_gear;

create table md_sample_gear
( pk_isn number(12,0),
  organization_id VARCHAR2(256 char) not null,
  organization_is_number NUMBER(12,0),
  gear_group_name VARCHAR2(256 char) not null,
  field_gear_id VARCHAR2(256 char) not null,
  gear_name VARCHAR2(256 char) not null,
  config_id VARCHAR2(256 char) not null,
  config_name VARCHAR2(256 char) not null,
  specification_text VARCHAR2(4000 char));
  
  
alter table md_sample_gear
add constraint pk_sample_gear primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

commit;

create index isgorgid on md_sample_gear(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;
/* moved to end of insert block

alter table md_sample_gear
add( fk_org number(12,0));

update md_sample_gear sp
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=sp.organization_is_number)
where sp.organization_is_number is not null;
commit;

create index isgfk on md_sample_gear(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_sample_gear
add constraint fk_md_sg foreign key (fk_org) references di_org(pk_isn);

commit;

*/
/************************************************************************
Populate MetaData Sample Gear and Equipment Configuration table with data.
************************************************************************/

set serveroutput on
declare 
v_desc VARCHAR2(4000);

cursor c_sample_gear is 
select CF.TSRGRCFG_ORG_ID,CF.TSMORGAN_IS_NUMBER,CF.TSRGRCFG_IS_NUMBER,FG.TYPE_NAME,FG.ID_CODE,FG.NAME,CF.ID_CODE V_CONFIG_ID,CF.NAME V_CONFIG_NAME
from storet.tsrfldgr FG,storet1.tsrgrcfg CF
where FG.tsrfldgr_is_number = CF.tsrfldgr_is_number
and FG.tsrfldgr_org_id = CF.tsrfldgr_org_id;

begin
  for c1 in c_sample_gear loop
   
    begin
    select GN.DESCRIPTION_TEXT INTO v_desc
    from storet1.tsmgntxt GN
    where GN.tsrgrcfg_is_number = c1.tsrgrcfg_is_number
    and GN.tsrgrcfg_org_id = c1.tsrgrcfg_org_id;
  exception when no_data_found then 
    v_desc:=null;
    null;
    end;
    
           
    insert into md_sample_gear
    (pk_isn,organization_id,organization_is_number,gear_group_name,field_gear_id,gear_name,config_id,config_name,specification_text)
    values
    (seq_md_sample_gear.nextval,c1.tsrgrcfg_org_id,c1.tsmorgan_is_number,c1.type_name,c1.id_code,c1.name,c1.v_config_id,c1.v_config_name,v_desc);
    end loop;
    commit;
end;
/
show errors;
commit;


alter table md_sample_gear
add( fk_org number(12,0));

update md_sample_gear sp
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=sp.organization_is_number)
where sp.organization_is_number is not null;
commit;

create index isgfk on md_sample_gear(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_sample_gear
add constraint fk_md_sg foreign key (fk_org) references di_org(pk_isn);

commit;

alter table md_sample_gear add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_sample_gear add SOURCE_UID NUMBER(20);
commit;

alter table md_sample_gear modify field_gear_id VARCHAR2(256 char) null;

alter table md_sample_gear modify config_id VARCHAR2(256 char) null;

alter table md_sample_gear modify config_name VARCHAR2(256 char) null;

alter table md_sample_gear modify gear_group_name VARCHAR2(256 char) null;


spool off;

