/*******************************************************
Filename		:  sample_preservation.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Sample Preservation and Storage Profile table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/12/2006.
Comments		:  
**********************************************************/

/**************************************************************************
Create sequences for MetaData Sample Preservation and Storage Profile table
**************************************************************************/
set echo on 
spool sample_preservation.log
drop sequence seq_md_sample_presrv;

create sequence seq_md_sample_presrv
start with 1 increment by 1 nomaxvalue nocycle cache 10;


/*******************************************************
Create MetaData Sample Preservation and Storage Profile table
**********************************************************/
drop table md_sample_presrv;

create table md_sample_presrv
( pk_isn number(12,0),
  organization_id VARCHAR2(256 char) not null,
  sdp_organization_is_number number(12,0) not null,
  organization_is_number number(12,0),
  sample_id VARCHAR2(256 char) not null,
  sample_name VARCHAR2(256 char) not null,
  container_type VARCHAR2(256 char),
  container_color VARCHAR2(256 char),
  container_size number(6,2),
  container_size_unit VARCHAR2(256 char),
  temp_preservation VARCHAR2(256 char),
  presrv_desc VARCHAR2(1999 char));


alter table md_sample_presrv
add constraint pk_sample_presrv primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index ispporgid on md_sample_presrv(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;
/* moved to end of insert block

alter table md_sample_presrv
add( fk_org number(12,0));

update md_sample_presrv p
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=p.organization_is_number)
where p.organization_is_number is not null;
commit;

create index isppfk on md_sample_presrv(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_sample_presrv
add constraint fk_md_spp foreign key (fk_org) references di_org(pk_isn);

commit;
*/

/************************************************************************
Populate MetaData Sample Preservation and Storage Profile table with data.
************************************************************************/

set serveroutput on
declare 
cursor c_sample_presrv is 
select TSRSDP_ORG_ID,TSRSDP_IS_NUMBER,TSMORGAN_IS_NUMBER,ID_CODE,NAME,CONTAINER_TYPE_NM,CONTAINER_COLOR,CONTAINER_SIZE_MSR,CONTAINER_SIZE_UN,TEMP_PRESRV_TYPE,PRESRV_STRGE_PRCDR
from storet1.tsrsdp; 

begin
  for c1 in c_sample_presrv loop
    insert into md_sample_presrv
    (pk_isn,organization_id,sdp_organization_is_number,organization_is_number,sample_id,sample_name,container_type,container_color,container_size,container_size_unit,temp_preservation,presrv_desc)
    values
    (seq_md_sample_presrv.nextval,c1.tsrsdp_org_id,c1.tsrsdp_is_number,c1.tsmorgan_is_number,c1.id_code,c1.name,c1.container_type_nm,c1.container_color,c1.container_size_msr,c1.container_size_un,c1.temp_presrv_type,c1.presrv_strge_prcdr);
  end loop;
  commit;
end;
/
show errors
commit;


alter table md_sample_presrv
add( fk_org number(12,0));

update md_sample_presrv p
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=p.organization_is_number)
where p.organization_is_number is not null;
commit;

create index isppfk on md_sample_presrv(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_sample_presrv
add constraint fk_md_spp foreign key (fk_org) references di_org(pk_isn);

commit;

alter table md_sample_presrv add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_sample_presrv add SOURCE_UID NUMBER(20);
commit;

alter table md_sample_presrv modify sample_name VARCHAR2(256 char) null;

alter table md_sample_presrv modify sdp_organization_is_number number(12,0) null;




spool off;
