/*******************************************************
Filename		:  org_tables.sql
Release 		:  c2.0
SIR			:  1367, 1480
Description		:  Creates Org dimension table and related constraints and populates data.
Author			:  Ganesh Thadkamalla
Date			:  10/01/2002.
Comments		:  11/26/2002 - Droped lu_geo_country table and its associations. G.Thadkamalla.
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
**********************************************************/

spool org_tables.log
set echo on
drop sequence seq_org;
-- currently this sequence is not being used in the script.
create sequence seq_org
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_org;

create table di_org
(pk_isn number(12,0),
 ORGanization_ID  CHAR(8) not null,
 organization_NAME   VARCHAR2(60) not null,
 organization_is_number number(8)
);

alter table di_org
add constraint pk_org primary key (pk_isn)
using index
tablespace STORETINDX
storage (initial 300k next 300k)
nologging;

--******************************************************************
-- sug added the new columns organization_type,description,parent_org
alter table di_org add organization_type VARCHAR2(256 char);
alter table di_org add description VARCHAR2(256 char);
alter table di_org add parent_org VARCHAR2(256 char);
--******************************************************************

select 'Note:  Following select should not yield any rows. If it returns rows then there is problem with fdact_temp2 data.' from dual;

select tsmorgan_is_number,org_id,count(*)
from storet1.tsmorgan
group by tsmorgan_is_number,org_id
having count(*)  > 1;

select 'Following delete statement fixes the storet1.tsmorgan data by deleting duplicate rows by keeping max(rowid)' from dual;

delete from storet1.tsmorgan a
where a.rowid < (select max(b.rowid) from storet1.tsmorgan b
         where b.tsmorgan_is_number = a.tsmorgan_is_number
           and b.org_id = a.org_id);

commit;

set serveroutput on
declare 
cursor c_org is 
select ORG_ID,name,TSMORGAN_IS_NUMBER 
from storet1.tsmorgan o
where exists (select 'x' from fa_station f
             where f.ORGANIZATION_IS_NUMBER=o.tsmorgan_is_number);

begin
 for c_var in c_org loop
  insert into di_org
    (pk_isn,organization_id,organization_name,organization_is_number)
  values
    (seq_org.nextval, c_var.org_id,c_var.name,c_var.tsmorgan_is_number);
 end loop;
end;
/


alter table fa_station
add( fk_org number(12,0));

update fa_station f
set fk_org = (select pk_isn from di_org o
              where o.organization_is_number=f.organization_is_number)
where f.organization_is_number is not null;
commit;

create index isd_org1 on fa_station(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

create index iorgtemp1 on di_org(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table fa_station
add constraint fk_sd_org foreign key (fk_org) references di_org(pk_isn);

--***************************************************************
-- sug updated the organization type 

update di_org do
set (organization_type,description,parent_org) = (select type_code,description_text,parent_org from storet1.tsmorgan so
              where so.tsmorgan_is_number=do.organization_is_number)
where do.organization_is_number is not null;
commit;
--*****************************************************************

alter table di_org rename column description to organization_description;

select 'Note:  Following select should not yield any rows. If it returns rows then there is problem with fdact_temp2 data.' from dual;

select organization_is_number,organization_id,count(*)
from di_org
group by organization_is_number,organization_id
having count(*)  > 1;

select 'Following delete statement fixes the storet1.tsmorgan data by deleting duplicate rows by keeping max(rowid)' from dual;

delete from di_org a
where a.rowid < (select max(b.rowid) from di_org b
         where b.organization_is_number = a.organization_is_number
           and b.organization_id = a.organization_id);

commit;


spool off;