set echo off
set linesize 102
set pagesize 9999
set heading off
set trimspool on
spool org_summ_stormod.txt
SELECT 'Summary Usage for Modernized STORET   '||
         RTRIM(to_char(sysdate,'Day'))||', '||
          RTRIM(to_char(sysdate,'Month'))||' '||
           RTRIM(to_char(sysdate,'DD'))||', '||
            RTRIM(to_char(sysdate,'YYYY')) from dual;
COLUMN TITLE format a60
COLUMN COUNT format '999,999,999'
SELECT ' 1. Number of User-owned Databases Registered in STORET' "TITLE",
             count(distinct tsmsoi_serial_id) "COUNT"
from storet1.tsmsoi 
;
SELECT ' 2. Number of Organizations Registered in STORET' "TITLE",
             count(distinct tsmsoi_org_id) "COUNT"
from storet1.tsmsoi 
;
SELECT ' 3. Number of Organizations With Stations' "TITLE", 
             count(distinct tsmstatn_org_id) "COUNT"
FROM storet1.tsmstatn
WHERE tsmstatn_org_id not in('DEMOTEST','ZZZZZZZZ')
;
SELECT ' 4. Total Number of Stations' "TITLE", 
             count(*) "COUNT"
FROM storet1.tsmstatn
WHERE tsmstatn_org_id not in('DEMOTEST','ZZZZZZZZ')
;
SELECT ' 5. Number of Organizations With Station Visits' "TITLE",
             count(distinct tsrstvst_org_id) "COUNT"
FROM storet1.tsrstvst
WHERE tsrstvst_org_id not in('DEMOTEST','ZZZZZZZZ')
;
SELECT ' 6. Total Number of Station Visits' "TITLE",
             count(*) "COUNT"
FROM storet1.tsrstvst
WHERE tsrstvst_org_id not in('DEMOTEST','ZZZZZZZZ')
;
SELECT ' 7. Number of Organizations With Results' "TITLE", 
count(distinct tsrrsult_org_id) "COUNT"
FROM storet1.tsrrsult
WHERE tsrrsult_org_id not in('DEMOTEST','ZZZZZZZZ')
;
SELECT ' 8. Total Number of Results' "TITLE", 
            count(*) "COUNT"
FROM storet1.tsrrsult
WHERE tsrrsult_org_id not in('DEMOTEST','ZZZZZZZZ')
;
COLUMN NAME format A70 word_wrapped
COLUMN STATION noprint
COLUMN Number format '999,999,999'
SELECT
     o.org_id                                         "AGENCY",
     '  '||RTRIM(NVL(o.name,'<Un-named Org>'))        "NAME",
     'STATIONS'                                       "Counting",
     count(*)                                          "Number",
     ' '
FROM 
     storet1.tsmstatn  s,
     storet1.tsmorgan  o
WHERE 
         s.tsmorgan_is_number=o.tsmorgan_is_number
     AND o.org_id not in('DEMOTEST','ZZZZZZZZ')
GROUP BY
     o.org_id,
     o.name
UNION
SELECT
     o.org_id                                         "AGENCY",
     ' '||RTRIM(NVL(a.line_one_text,'<no address given>'))||','||
     RTRIM(a.line_two_text)||','||
     RTRIM(a.line_three_text)||','||
     RTRIM(a.line_four_text)||','||
     RTRIM(a.state_postal_code)
                                                      "NAME",
     'VISITS'                                         "Counting",
     count(*)                                          "Number",
     CHR(10)
FROM 
     storet1.tsrstvst  v,
     storet1.tsmorgan  o,
     storet1.tsmaddr   a
WHERE 
         a.type_code(+)='Mailing'
     AND v.tsrstvst_org_id=o.org_id
     AND a.tsmorgan_is_number(+)=o.tsmorgan_is_number
     AND o.org_id not in('DEMOTEST','ZZZZZZZZ')
GROUP BY
     o.org_id,
     a.line_one_text,
     a.line_two_text,
     a.line_three_text,
     a.line_four_text,
     a.state_postal_code
ORDER BY 1,3
;
DROP		FUNCTION STORETW.FLBRMK ;
DROP		FUNCTION STORETW.FNAICS ;
DROP		FUNCTION STORETW.F_BIOPT ;
DROP		FUNCTION STORETW.F_CHAR_NAME ;
DROP		FUNCTION STORETW.F_ESTRY ;
DROP		FUNCTION STORETW.F_FIELDSET ;
DROP		FUNCTION STORETW.F_MAD ;
DROP		FUNCTION STORETW.F_PRMVL ;
DROP		FUNCTION STORETW.F_STATION_VISITED ;
spool off;
