/*******************************************************
Filename		:  start.sql
Release 		:  STORET v2.0B.1
SIR			:  All SIRs
Description		:  Grant system privileges to storet & storet1
Author		:  Ganesh B. Thadkamalla
Date			:  03/05/2001
Modified by		:  Ganesh B. Thadkamalla
Modified Date	:  
Comments		:  
**********************************************************/

SET ECHO OFF
set time on
-- Altering users STORET,STORET1 to set passwords to default passwords.
connect system/sto2et@STORET.SDC
spool start.log
-- alter user storet identified by sto2et;
-- alter user storet1 identified by sto2et1;
-- alter user storuser identified by sto2user;
-- alter user storet identified by storet;
-- alter user storet1 identified by storet1;
-- alter user storuser identified by storuser;
--
--Granting Create Session,create table privilege to STORET schema/user.
--
set echo on
-- grant create session to storet;
-- grant create table to storet;

-- grant create session to storet1;
-- grant create table to storet1;

-- grant create procedure, create trigger to storet,storet1;

-- disconnect
-- spool off;

Create Table CDUS_2005
as
SELECT '123456789012' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON-DD HH:MI:SS') "RUN_DATE", MAX(TSMSTATN_ORG_ID) "Org_Id", COUNT(*) "Count" FROM STORET1.TSMSTATN
GROUP BY TSMSTATN_ORG_ID
;

Truncate Table CDUS_2005;

Insert into CDUS_2005
SELECT 'STATION' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", MAX(TSMSTATN_ORG_ID) " Org_Id", COUNT(*) "Count" FROM STORET1.TSMSTATN
GROUP BY TSMSTATN_ORG_ID
;

Insert into CDUS_2005
SELECT 'VISIT' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", MAX(TSRSTVST_ORG_ID), COUNT(*) FROM STORET1.TSRSTVST
GROUP BY TSRSTVST_ORG_ID
;

Insert into CDUS_2005
SELECT 'ACTIVITY' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", MAX(TSRFDACT_ORG_ID), COUNT(*) FROM STORET1.TSRFDACT
GROUP BY TSRFDACT_ORG_ID
;

Insert into CDUS_2005
SELECT 'TRIP' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", MAX(TSRTRIP_ORG_ID), COUNT(*) FROM STORET1.TSRTRIP
GROUP BY TSRTRIP_ORG_ID
;

Insert into CDUS_2005
SELECT 'LOCATION' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", MAX(TSMALP_ORG_ID), COUNT(*) FROM STORET1.TSMALP
GROUP BY TSMALP_ORG_ID
;

Insert into CDUS_2005
SELECT 'SAMPLE' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", MAX(TSRFDACT_ORG_ID), COUNT(*) FROM STORET1.TSRSMPLE
GROUP BY TSRFDACT_ORG_ID
;

Insert into CDUS_2005
SELECT 'RESULT' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", MAX(TSRRSULT_ORG_ID), COUNT(*) FROM STORET1.TSRRSULT
GROUP BY TSRRSULT_ORG_ID
;
COMMIT;

--
--

Insert into CDUS_2005
SELECT 'STATION' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'TOTAL' " Org_Id", sum(CDUS_2005."Count") "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'STATION' 
;

Insert into CDUS_2005
SELECT 'VISIT' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'TOTAL' " Org_Id", sum(CDUS_2005."Count") "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'VISIT' 
;

Insert into CDUS_2005
SELECT 'ACTIVITY' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'TOTAL' " Org_Id", sum(CDUS_2005."Count") "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'ACTIVITY' 
;

Insert into CDUS_2005
SELECT 'TRIP' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'TOTAL' " Org_Id", sum(CDUS_2005."Count") "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'TRIP' 
;

Insert into CDUS_2005
SELECT 'SAMPLE' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'TOTAL' " Org_Id", sum(CDUS_2005."Count") "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'SAMPLE' 
;

Insert into CDUS_2005
SELECT 'RESULT' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'TOTAL' " Org_Id", sum(CDUS_2005."Count") "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'RESULT' 
;
COMMIT;
--
--
Insert into CDUS_2005
SELECT 'ORG_RSLT' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'TOTAL' " Org_Id", count(CDUS_2005."Count") "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'RESULT' 
;
COMMIT;

Insert into CDUS_2005
SELECT 'ORG_STN' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'TOTAL' " Org_Id", count(CDUS_2005."Count") "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'STATION' 
;
COMMIT;

Insert into CDUS_2005
SELECT 'ORG_IDS' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'TOTAL' " Org_Id", count(org_id) "Count" FROM STORET1.TSMORGAN
;
COMMIT;

--
--

Insert into CDUS_2005
SELECT 'STATION' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'NAT_AVG' " Org_Id", round(avg(CDUS_2005."Count")) "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'STATION' 
;

Insert into CDUS_2005
SELECT 'VISIT' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'NAT_AVG' " Org_Id", round(avg(CDUS_2005."Count")) "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'VISIT' 
;

Insert into CDUS_2005
SELECT 'ACTIVITY' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'NAT_AVG' " Org_Id", round(avg(CDUS_2005."Count")) "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'ACTIVITY' 
;

Insert into CDUS_2005
SELECT 'TRIP' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'NAT_AVG' " Org_Id", round(avg(CDUS_2005."Count")) "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'TRIP' 
;

Insert into CDUS_2005
SELECT 'SAMPLE' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'NAT_AVG' " Org_Id", round(avg(CDUS_2005."Count")) "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'SAMPLE' 
;

Insert into CDUS_2005
SELECT 'RESULT' "Table_Name", TO_CHAR(SYSDATE, 'YYYY-MON') "RUN_DATE", 'NAT_AVG' " Org_Id", round(avg(CDUS_2005."Count")) "Count" FROM CDUS_2005
WHERE CDUS_2005."Table_Name"= 'RESULT' 
;
COMMIT;

set heading off
select * from cdus_2005
order by "Org_Id"
;
set heading on

insert into storet.cdus_2005_july
select * from cdus_2005;
--
-- Cumulative Count Comparison Starting in JUNE
-- insert into storet.cdus_2005_july
-- select * from cdus_2005;
--
spool off
@c20-install.sql
