/*******************************************************
Filename		:  create_storetw.sql
Release 		:  c2.0.2, C2.0.4
SIR			:  1586
Description		:  Create schema STORETW
Author			:  Ganesh Thadkamalla/Joseph Wilson
Date			:  1/22/2004
Comments		:  6/9/03 -- Added explicit grants to storetw on storet and storet1 tables.
			   6/20/03 -- revoke create session
			   8/11/03 -- added materialized view grants -JW
			   1/22/04 -- split storetw creation into 3 scripts -JW
	02/04/2005 - moved revoke create session to calling script. -GT
**********************************************************/
spool create_storetw.log
--connect system/sto2et@storet.sdc
DROP USER STORETW CASCADE ;
CREATE USER "STORETW"  PROFILE "DEFAULT" IDENTIFIED BY "storetw" 
    DEFAULT 
    TABLESPACE "STORETDATA" TEMPORARY 
    TABLESPACE "TEMPORARY_DATA" QUOTA UNLIMITED 
    ON STORETdata QUOTA UNLIMITED 
    ON STORETINDX ACCOUNT UNLOCK;
grant CREATE SESSION to storetw;


--DROP USER STORETWEB CASCADE ;
CREATE USER "STORETWEB"  PROFILE "DEFAULT" IDENTIFIED BY "storetweb" 
    DEFAULT 
    TABLESPACE "STORETDATA" TEMPORARY 
    TABLESPACE "TEMPORARY_DATA" QUOTA UNLIMITED 
    ON STORETdata QUOTA UNLIMITED 
    ON STORETINDX ACCOUNT UNLOCK;
grant CREATE SESSION to storetweb;
grant CREATE SYNONYM to storetweb;


grant ALTER SESSION to storetw;
grant CREATE CLUSTER to storetw;
grant CREATE INDEXTYPE to storetw;
grant CREATE OPERATOR to storetw;
grant CREATE PROCEDURE to storetw;
grant CREATE SEQUENCE to storetw;
grant CREATE SESSION to storetw;
grant CREATE SYNONYM to storetw;
grant CREATE TABLE to storetw;
grant CREATE TRIGGER to storetw;
grant CREATE TYPE to storetw;
grant CREATE VIEW to storetw;
grant create materialized view to storetw;
grant query rewrite to storetw;
grant create session to storet, storet1;
GRANT EXP_FULL_DATABASE, IMP_FULL_DATABASE TO STORETW;

-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
DROP ROLE STORET_USER;
DROP ROLE STORET1_USER;
create ROLE STORET_USER;
create ROLE STORET1_USER;


DROP USER STORET CASCADE ;
create user STORET identified by STO2ET ;
alter user STORET default tablespace STORETDATA;
alter user STORET quota unlimited on STORETDATA;
alter user STORET quota unlimited on STORETINDX;
grant CONNECT, RESOURCE, DBA to STORET;

DROP USER STORET1 CASCADE ;
create user STORET1 identified by STO2ET1 ;
alter user STORET1 default tablespace STORETDATA;
alter user STORET1 quota unlimited on STORETDATA;
alter user STORET1 quota unlimited on STORETINDX;
grant CONNECT, RESOURCE, DBA to STORET1;


alter user SYSTEM temporary tablespace TEMPORARY_DATA;
alter user STORET temporary tablespace TEMPORARY_DATA;
alter user STORUSER temporary tablespace TEMPORARY_DATA;
alter user STORETW temporary tablespace TEMPORARY_DATA;
alter user STORET1 temporary tablespace TEMPORARY_DATA;

alter user STORET quota unlimited on STORET_TABS;
alter user STORET quota unlimited on STORET_INDS;
alter user STORET1 quota unlimited on STORET1_TABS;
alter user STORET1 quota unlimited on STORET1_INDS;
alter user STORET1 quota unlimited on STORET1_LOBS;


--create user PO8 identified by PO8 ;
--alter user PO8 default tablespace USER_DATA;
--alter user PO8 temporary tablespace TEMPORARY_DATA;
--grant CONNECT, RESOURCE, DBA to PO8;


DROP USER STORET_OWNER CASCADE ;
create user STORET_OWNER identified by STORET_OWNER ;
alter user STORET_OWNER default tablespace APPL_DATA;
alter user STORET_OWNER temporary tablespace TEMPORARY_DATA;
alter user STORET_OWNER quota unlimited on APPL_DATA;
alter user STORET_OWNER quota unlimited on APPL_INDEX;
grant CONNECT, RESOURCE, DBA to STORET_OWNER ;
DROP USER LWL CASCADE ;
create user LWL identified by LWL ;
alter user LWL default tablespace APPL_DATA;
alter user LWL temporary tablespace TEMPORARY_DATA;
alter user LWL quota unlimited on APPL_DATA;
alter user LWL quota unlimited on APPL_INDEX;
grant CONNECT, RESOURCE, DBA to LWL ;


DROP USER USERv1 CASCADE ;
CREATE USER USERv1 IDENTIFIED BY USERv1
DEFAULT TABLESPACE USER_DATA
TEMPORARY TABLESPACE TEMPORARY_DATA
QUOTA UNLIMITED ON USER_DATA;
--
GRANT EXP_FULL_DATABASE, IMP_FULL_DATABASE TO USERv1;
--
GRANT CONNECT TO USERv1 WITH ADMIN OPTION;
--
GRANT STORETv1_USER TO USERv1 WITH ADMIN OPTION;
--
GRANT STORETv11_USER TO USERv1 WITH ADMIN OPTION;
--
Grant CREATE USER TO USERv1;
--
--
DROP USER USERv2 CASCADE ;
CREATE USER USERv2 IDENTIFIED BY USERv2
DEFAULT TABLESPACE USER_DATA
TEMPORARY TABLESPACE TEMPORARY_DATA
QUOTA UNLIMITED ON USER_DATA;
--
GRANT EXP_FULL_DATABASE, IMP_FULL_DATABASE TO USERv2;
--
GRANT CONNECT TO USERv2 WITH ADMIN OPTION;
--
GRANT STORETv2_USER TO USERv2 WITH ADMIN OPTION;
--
GRANT STORETv21_USER TO USERv2 WITH ADMIN OPTION;
--
Grant CREATE USER TO USERv2;
--
--
DROP USER STORETW CASCADE ;
CREATE USER "STORETW"  PROFILE "DEFAULT" IDENTIFIED BY "storetw" 
    DEFAULT 
    TABLESPACE "STORETDATA" TEMPORARY 
    TABLESPACE "TEMPORARY_DATA" QUOTA UNLIMITED 
    ON STORETdata QUOTA UNLIMITED 
    ON STORETINDX ACCOUNT UNLOCK;

DROP USER STORETWEB CASCADE ;
CREATE USER "STORETWEB"  PROFILE "DEFAULT" IDENTIFIED BY "storetweb" 
    DEFAULT 
    TABLESPACE "STORETDATA" TEMPORARY 
    TABLESPACE "TEMPORARY_DATA" QUOTA UNLIMITED 
    ON STORETdata QUOTA UNLIMITED 
    ON STORETINDX ACCOUNT UNLOCK;

grant ALTER SESSION to storetw;
grant CREATE CLUSTER to storetw;
grant CREATE INDEXTYPE to storetw;
grant CREATE OPERATOR to storetw;
grant CREATE PROCEDURE to storetw;
grant CREATE SEQUENCE to storetw;
grant CREATE SESSION to storetw;
grant CREATE SYNONYM to storetw;
grant CREATE TABLE to storetw;
grant CREATE TRIGGER to storetw;
grant CREATE TYPE to storetw;
grant CREATE VIEW to storetw;
grant create materialized view to storetw;
grant query rewrite to storetw;
grant create session to storet, storet1;
GRANT EXP_FULL_DATABASE, IMP_FULL_DATABASE TO STORETW;
CREATE USER STORUSER IDENTIFIED BY STORUSER;
ALTER USER STORUSER DEFAULT TABLESPACE USER_DATA;
ALTER USER STORUSER TEMPORARY TABLESPACE TEMPORARY_DATA;
ALTER USER STORUSER QUOTA 96K ON USER_DATA;
--
GRANT EXP_FULL_DATABASE TO STORUSER;
--
GRANT CONNECT TO STORUSER WITH ADMIN OPTION;
--
GRANT STORET_USER TO STORUSER WITH ADMIN OPTION;
--
GRANT STORET1_USER TO STORUSER WITH ADMIN OPTION;
--
GRANT CREATE SYNONYM TO STORUSER;
--
GRANT CREATE USER TO STORUSER;
--
--

-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
--


-- Coalesce storetdata and storetindx tablespaces;
alter tablespace TEMPORARY_DATA coalesce;
alter tablespace TEMPORARY_DATA coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace TSROLLBACK coalesce;
alter tablespace TSROLLBACK coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace TSROLLBACK coalesce;
alter tablespace TSROLLBACK coalesce;
--
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
--


-- Coalesce storetdata and storetindx tablespaces;
alter tablespace TEMPORARY_DATA coalesce;
alter tablespace TEMPORARY_DATA coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace TSROLLBACK coalesce;
alter tablespace TSROLLBACK coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace TSROLLBACK coalesce;
alter tablespace TSROLLBACK coalesce;
--
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
--


-- Coalesce storetdata and storetindx tablespaces;
alter tablespace TEMPORARY_DATA coalesce;
alter tablespace TEMPORARY_DATA coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace TSROLLBACK coalesce;
alter tablespace TSROLLBACK coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace TSROLLBACK coalesce;
alter tablespace TSROLLBACK coalesce;
--
spool off;
exit
