spool table_comments.log
--pre statistics;
select count(*) from user_tab_comments;

select 'Table with comments: ' ||count(*) from user_tab_comments
where trim(comments) is not null;

select 'Table with no comments: ' ||count(*) from user_tab_comments
where trim(comments) is null;
--

comment on table APP_COLUMN_NAME is 'Warehouse Application column/Attribute Names' ;
comment on table BIOLOGICAL_RESULT_PROJECT is 'Biological Result and Project association table' ;
comment on table DI_ACTIVITY_INTENT is 'Activity Intent Dimension table' ;
comment on table DI_ACTIVITY_MATRIX is 'Activity matrix dimension table' ;
comment on table DI_ACTIVITY_MEDIUM is 'Activity medium dimension table' ;
comment on table DI_BIOPART is 'Biopart dimension table' ;
comment on table DI_CHARACTERISTIC is 'Characteristic dimension table' ;
comment on table DI_COMMUNITY_SAMPLED is 'Community Sampled dimension table' ;
comment on table DI_DATE is 'Date dimension table' ;
comment on table DI_DB_CAT is 'Drainage Basin Cataloging unit dimension table' ;
comment on table DI_GEO_COUNTY is 'Geological county dimension table' ;
comment on table DI_GEO_STATE is 'Geological State dimension table' ;
comment on table DI_GROUP_TYPE is 'Group type dimension table' ;
comment on table DI_ORG is 'Organization dimension table' ;
comment on table DI_PROJECT is 'Project dimension table' ;
comment on table DI_STATN_TYPES is 'Station types dimension table' ;
comment on table DI_SUBJECT_TAXON is 'Subject Taxon dimension table' ;
comment on table DW_DATA_REQUESTS is 'User Data request table' ;
comment on table FA_BIOLOGICAL_RESULT is 'Biological Result fact table' ;
comment on table FA_BLOB is 'Binary Large Object fact table' ;
comment on table FA_HABITAT_RESULT is 'Habitat result fact table' ;
comment on table FA_REGULAR_RESULT is 'Regular result fact table' ;
comment on table FA_STATION is 'Station fact table' ;
comment on table FA_STATION_MAP is 'Station map fact table' ;
comment on table FA_STATION_WEB is 'Station Web fact table' ;
comment on table HABITAT_RESULT_PROJECT is 'Habitat result and project association table' ;
comment on table LU_CHAR_ALIAS is 'Characteristic alias lookup table' ;
comment on table LU_CHAR_ALIAS_TYPE is 'characteristic alias type lookup table' ;
comment on table LU_ESTRY_PRIMARY is 'Primary estuary lookup table' ;
comment on table LU_ESTRY_SECONDARY is 'secondary estuary lookup table' ;
comment on table LU_EXTERNAL_REF_SCHEME is 'External Reference scheme lookup table' ;
comment on table LU_MAD_HDATUM is 'Horizontal Datum lookup table' ;
comment on table LU_MAD_HMETHOD is 'Horizontal Method lookup table' ;
comment on table LU_MAD_VDATUM is 'Vertical Datum lookup table' ;
comment on table LU_MAD_VMETHOD is 'Vertical Method lookup table' ;
comment on table LU_STATION_ALIAS is 'Station alias lookup table' ;
comment on table LU_UNIT_CONVERSION is 'Unit conversion lookup table' ;
comment on table MD_ANALYTICAL_PROC is 'Analytical procedure metadata table' ;
comment on table MD_CITATION is 'Citation metadata table' ;
comment on table MD_COOP is 'Cooperating Organization metadata table' ;
comment on table MD_COOP_ADDRESS is 'Cooperating Organization address metadata table' ;
comment on table MD_COOP_EADDRESS is 'Cooperating Organization electronic address metadata table' ;
comment on table MD_LAB is 'Laboratory metadata table' ;
comment on table MD_LAB_ADDRESS is 'Laboratory address metadata table' ;
comment on table MD_LAB_EADDRESS is 'Laboratory electronic address metadata table' ;
comment on table MD_LAB_SAMPLE_PREP_PROCEDURE is 'Laboratory sample preparation procedure metadata table' ;
comment on table MD_ORG_ADDRESS is 'Organization address metadata table' ;
comment on table MD_ORG_EADDRESS is 'Organization electronic address metadata table' ;
comment on table MD_PROGRAM is 'Program metadata table' ;
comment on table MD_SAMPLE_GEAR is 'Sample Gear metadata table' ;
comment on table MD_SAMPLE_PRESRV is 'Sample preservation metadata table' ;
comment on table MD_SAMPLE_PROC is 'Sample procedure metadata table' ;
comment on table MV_REGULAR_RESULT_ALL is 'Regular Result All materialized view' ;
comment on table MV_REGULAR_RESULT_CHAR is 'Regular result char materialized view' ;
comment on table MV_REGULAR_RESULT_CHAR_COUNTY is 'Regular result char county materialized view' ;
comment on table MV_REGULAR_RESULT_CHAR_STATE is 'Regular result char state materialized view' ;
comment on table MV_REGULAR_RESULT_COUNTY is 'Regular result county materialized view' ;
comment on table MV_REGULAR_RESULT_STATE is 'Regular result state materialized view' ;
comment on table REGULAR_RESULT_PROJECT is 'Regular result and project association table' ;
comment on table STATION_CHAR is 'Station and characteristic association table' ;
comment on table STATION_PROJECT is 'Station and project association table' ;

--post statistics;
select count(*) from user_tab_comments;

select 'Table with comments: ' ||count(*) from user_tab_comments
where trim(comments) is not null;

select 'Table with no comments: ' ||count(*) from user_tab_comments
where trim(comments) is null;

select table_name from user_tab_comments
where trim(comments) is null;



spool off;