/*******************************************************
Filename		:  update TSRUOM.sql
Release 		:  C2.0.5 
SIR			:  1690
Description		:  Updates the TSRUOM table for unit conversion through DBFIX020.
Author			:  Stephen Smith
Date			:  04-11-2005 -SS
Comments		:  Only temperatures have specific adjustment factors.
			:  "Granules" associated with DBFIX020 is unique and is handled by exception logic of this script.
			:  Seawater density units as intended for release with DBFIX021 are unique and handled by exception logic of this script.
**********************************************************/
set echo off
spool update_TSRUOM.log

--connect system/sto2et@storet

--Pre-statistics
describe storet.TSRUOM;
select count (*) from storet.TSRUOM;

--Add columns for Unit Conversion
alter table storet.TSRUOM
	add (TARGET_UNIT CHAR(10), CONVERSION_FACTOR NUMBER, ADJUSTMENT_FACTOR NUMBER DEFAULT 0);

COMMIT;
	
--Add target unit and conversion factor columns to the storet.TSRUOM table
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 190 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.0001 where tsruom_is_number= 191 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 1 where tsruom_is_number= 192 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 193 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.83612736 where tsruom_is_number= 197 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 4046.8564224 where tsruom_is_number= 199 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 3429904 where tsruom_is_number= 274 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.01 where tsruom_is_number= 273 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 2589988.110336 where tsruom_is_number= 198 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.09290304 where tsruom_is_number= 196 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.00064516 where tsruom_is_number= 195 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 10000 where tsruom_is_number= 194 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'drips/min',CONVERSION_FACTOR = 1 where tsruom_is_number= 241 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 35.31467 where tsruom_is_number= 239 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000004087345685 where tsruom_is_number= 240 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000115740740741 where tsruom_is_number= 140 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0166666666666667 where tsruom_is_number= 139 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 1 where tsruom_is_number= 138 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.00003531467 where tsruom_is_number= 141 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000000098096296 where tsruom_is_number= 143 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0005885777786915 where tsruom_is_number= 145 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 1.54722865226337 where tsruom_is_number= 151 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000015472286522 where tsruom_is_number= 150 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000371334876543 where tsruom_is_number= 149 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0022280092592592 where tsruom_is_number= 148 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.133680555555556 where tsruom_is_number= 147 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000098096296449 where tsruom_is_number= 146 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0353146667214886 where tsruom_is_number= 144 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000005885777786 where tsruom_is_number= 142 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.00423608088930031 where tsruom_is_number= 153 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0508329706716038 where tsruom_is_number= 152 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0098096305555555 where tsruom_is_number= 255 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.588577833333333 where tsruom_is_number= 254 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 190.4794272 where tsruom_is_number= 158 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.000002204623 where tsruom_is_number= 157 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.000052910952 where tsruom_is_number= 156 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.00317465712 where tsruom_is_number= 155 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.1904794272 where tsruom_is_number= 154 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 1 where tsruom_is_number= 165 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 24 where tsruom_is_number= 164 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 1440 where tsruom_is_number= 163 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 86400 where tsruom_is_number= 162 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.002204623 where tsruom_is_number= 161 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.052910952 where tsruom_is_number= 160 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 3.17465712 where tsruom_is_number= 159 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'per m',CONVERSION_FACTOR = 1 where tsruom_is_number= 238 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'nu',CONVERSION_FACTOR = 1 where tsruom_is_number= 71 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 0.0000000393700787 where tsruom_is_number= 60 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 0.0393700787401575 where tsruom_is_number= 61 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 0.0000000039370079 where tsruom_is_number= 59 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 0.393700787401575 where tsruom_is_number= 62 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 39.3700787401575 where tsruom_is_number= 64 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 1 where tsruom_is_number= 66 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 36 where tsruom_is_number= 68 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 72913.38588 where tsruom_is_number= 70 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 63360 where tsruom_is_number= 69 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 12 where tsruom_is_number= 67 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 39370.0787401575 where tsruom_is_number= 65 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 3.93700787401575 where tsruom_is_number= 63 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'None',CONVERSION_FACTOR = 1 where tsruom_is_number= 1 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'TU',CONVERSION_FACTOR = 1 where tsruom_is_number= 266 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mmol/m2/dy',CONVERSION_FACTOR = 1 where tsruom_is_number= 277 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mmol/m2/dy',CONVERSION_FACTOR = 24 where tsruom_is_number= 246 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m3/day',CONVERSION_FACTOR = 1 where tsruom_is_number= 50 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m3/day',CONVERSION_FACTOR = 24 where tsruom_is_number= 49 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m3/day',CONVERSION_FACTOR = 1000 where tsruom_is_number= 52 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m3/day',CONVERSION_FACTOR = 24000 where tsruom_is_number= 51 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 10 where tsruom_is_number= 253 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 2.7378507871321 where tsruom_is_number= 58 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 0.306871064953512 where tsruom_is_number= 57 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 1000 where tsruom_is_number= 56 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 24000 where tsruom_is_number= 55 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 1 where tsruom_is_number= 54 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 24 where tsruom_is_number= 53 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 0.000000000001 where tsruom_is_number= 2 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 0.000000001 where tsruom_is_number= 3 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 4 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 5 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 1 where tsruom_is_number= 6 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 1000 where tsruom_is_number= 7 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 28.349523125 where tsruom_is_number= 8 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 453.59237 where tsruom_is_number= 9 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 907184.74 where tsruom_is_number= 10 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 11 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'Mole/l',CONVERSION_FACTOR = 1 where tsruom_is_number= 48 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'Mole/l',CONVERSION_FACTOR = 1 where tsruom_is_number= 47 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'Mole/l',CONVERSION_FACTOR = 1 where tsruom_is_number= 45 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'meq/L',CONVERSION_FACTOR = 1000 where tsruom_is_number= 46 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'meq/L',CONVERSION_FACTOR = 1 where tsruom_is_number= 205 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'meq/L',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 204 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mmol/kg',CONVERSION_FACTOR = 1 where tsruom_is_number= 247 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mmol/kg',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 256 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'umol/m2/dy',CONVERSION_FACTOR = 86.4 where tsruom_is_number= 265 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'umol',CONVERSION_FACTOR = 1 where tsruom_is_number= 264 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'umol/S/m2',CONVERSION_FACTOR = 1 where tsruom_is_number= 261 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mm3/l',CONVERSION_FACTOR = 1000 where tsruom_is_number= 245 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 12 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 13 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1 where tsruom_is_number= 14 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000 where tsruom_is_number= 15 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.000000001 where tsruom_is_number= 16 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 17 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 18 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1 where tsruom_is_number= 19 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000 where tsruom_is_number= 20 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 21 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 244 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000000 where tsruom_is_number= 243 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 242 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 22 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1 where tsruom_is_number= 23 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000 where tsruom_is_number= 24 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 25 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000000 where tsruom_is_number= 26 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 17118.0600684945 where tsruom_is_number= 279 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 735462.367317422 where tsruom_is_number= 252 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 25400 where tsruom_is_number= 105 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 13595.0980644332 where tsruom_is_number= 104 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 345315.576675011 where tsruom_is_number= 103 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 703069.579991084 where tsruom_is_number= 102 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 101.971621297792 where tsruom_is_number= 109 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 13595.0980644332 where tsruom_is_number= 108 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 10332274.5279988 where tsruom_is_number= 107 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 1000 where tsruom_is_number= 106 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 1000 where tsruom_is_number= 32 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 1 where tsruom_is_number= 31 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 30 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 29 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 0.000000001 where tsruom_is_number= 28 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 0.000000000001 where tsruom_is_number= 27 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 0.0003238315531757 where tsruom_is_number= 122 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 1 where tsruom_is_number= 121 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 120 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 0.251995761068425 where tsruom_is_number= 119 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 0.0002388458966275 where tsruom_is_number= 118 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mw',CONVERSION_FACTOR = 0.000746 where tsruom_is_number= 117 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mw',CONVERSION_FACTOR = 1 where tsruom_is_number= 116 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mw',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 115 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mw',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 114 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'TON',CONVERSION_FACTOR = 1 where tsruom_is_number= 268 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'units/cm',CONVERSION_FACTOR = 1 where tsruom_is_number= 278 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '% by vol',CONVERSION_FACTOR = 1 where tsruom_is_number= 101 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '% by wt',CONVERSION_FACTOR = 1 where tsruom_is_number= 100 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '%',CONVERSION_FACTOR = 1 where tsruom_is_number= 99 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'PSS',CONVERSION_FACTOR = 1 where tsruom_is_number= 263 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ADMI value',CONVERSION_FACTOR = 1 where tsruom_is_number= 259 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'fibers/l',CONVERSION_FACTOR = 1 where tsruom_is_number= 218 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'PCU',CONVERSION_FACTOR = 1 where tsruom_is_number= 208 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 2000 where tsruom_is_number= 249 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 38 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1 where tsruom_is_number= 39 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 41 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1000 where tsruom_is_number= 40 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 37 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1000 where tsruom_is_number= 36 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1 where tsruom_is_number= 35 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 34 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 33 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'Deg',CONVERSION_FACTOR = 0.00027777777777778 where tsruom_is_number= 137 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'Deg',CONVERSION_FACTOR = 0.0166666666666667 where tsruom_is_number= 136 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'Deg',CONVERSION_FACTOR = 1 where tsruom_is_number= 135 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'uE/m2/sec',CONVERSION_FACTOR = 1 where tsruom_is_number= 134 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ft-candles',CONVERSION_FACTOR = 1 where tsruom_is_number= 130 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'JCU',CONVERSION_FACTOR = 1 where tsruom_is_number= 129 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'NTU',CONVERSION_FACTOR = 1 where tsruom_is_number= 128 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'JTU',CONVERSION_FACTOR = 1 where tsruom_is_number= 127 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'FTU',CONVERSION_FACTOR = 1 where tsruom_is_number= 126 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lumens',CONVERSION_FACTOR = 1 where tsruom_is_number= 133 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lumens',CONVERSION_FACTOR = 1 where tsruom_is_number= 132 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lumens',CONVERSION_FACTOR = 1 where tsruom_is_number= 131 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ppb',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 267 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ppb',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 44 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ppb',CONVERSION_FACTOR = 1000 where tsruom_is_number= 43 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ppb',CONVERSION_FACTOR = 1 where tsruom_is_number= 42 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'lb/in',CONVERSION_FACTOR = 1 where tsruom_is_number= 125 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '% sediment',CONVERSION_FACTOR = 1 where tsruom_is_number= 216 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'gpm/ft',CONVERSION_FACTOR = 1 where tsruom_is_number= 124 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'Langleys',CONVERSION_FACTOR = 1 where tsruom_is_number= 123 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'amps',CONVERSION_FACTOR = 1 where tsruom_is_number= 113 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'volts',CONVERSION_FACTOR = 1 where tsruom_is_number= 112 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'volts',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 210 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 1 where tsruom_is_number= 111 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 1000000 where tsruom_is_number= 110 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 1000 where tsruom_is_number= 207 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 1 where tsruom_is_number= 206 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 10000 where tsruom_is_number= 262 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mrem/day',CONVERSION_FACTOR = 1 where tsruom_is_number= 215 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mrem/day',CONVERSION_FACTOR = 0.0027378507871321 where tsruom_is_number= 214 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 3.22 where tsruom_is_number= 272 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 1 where tsruom_is_number= 211 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 1000 where tsruom_is_number= 248 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 1000 where tsruom_is_number= 271 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 213 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'pCi/g',CONVERSION_FACTOR = 1 where tsruom_is_number= 212 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'pCi/m2',CONVERSION_FACTOR = 1 where tsruom_is_number= 209 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '% Cover',CONVERSION_FACTOR = 1 where tsruom_is_number= 203 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'MPN',CONVERSION_FACTOR = 1 where tsruom_is_number= 73 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'count',CONVERSION_FACTOR = 1 where tsruom_is_number= 72 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'Plate cnt',CONVERSION_FACTOR = 1 where tsruom_is_number= 90 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'cfu/100ml',CONVERSION_FACTOR = 1 where tsruom_is_number= 257 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'CFU',CONVERSION_FACTOR = 1 where tsruom_is_number= 74 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 0.2 where tsruom_is_number= 251 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 0.0002641721 where tsruom_is_number= 250 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 100 where tsruom_is_number= 75 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 1 where tsruom_is_number= 76 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 0.1 where tsruom_is_number= 77 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 1 where tsruom_is_number= 78 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 100 where tsruom_is_number= 79 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 0.0001 where tsruom_is_number= 80 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 0.0000003861022 where tsruom_is_number= 89 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 0.0002471043692253 where tsruom_is_number= 88 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 1.19599004630108 where tsruom_is_number= 87 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 10.7639104167097 where tsruom_is_number= 86 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 1550.0031000062 where tsruom_is_number= 85 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 0.0001 where tsruom_is_number= 84 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 83 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 1 where tsruom_is_number= 82 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 10000 where tsruom_is_number= 81 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'deg C',CONVERSION_FACTOR = 1 where tsruom_is_number= 200 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'deg C',CONVERSION_FACTOR = 1,
   ADJUSTMENT_FACTOR = 273.15 where tsruom_is_number= 202 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'deg C',CONVERSION_FACTOR = 0.555555555555555,
   ADJUSTMENT_FACTOR = 32 where tsruom_is_number= 201 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 0.0000166666666667 where tsruom_is_number= 91 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 60 where tsruom_is_number= 94 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 10080 where tsruom_is_number= 96 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 525960 where tsruom_is_number= 98 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 43830 where tsruom_is_number= 97 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 1440 where tsruom_is_number= 95 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 1 where tsruom_is_number= 93 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 0.0166666666666667 where tsruom_is_number= 92 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.01 where tsruom_is_number= 166 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.277777777777777 where tsruom_is_number= 171 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.514444444444444 where tsruom_is_number= 173 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.0000035277777778 where tsruom_is_number= 174 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.44704 where tsruom_is_number= 172 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.00508 where tsruom_is_number= 170 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 1 where tsruom_is_number= 167 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 1000 where tsruom_is_number= 168 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.3048 where tsruom_is_number= 169 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mm3/l',CONVERSION_FACTOR = 0.000000001 where tsruom_is_number= 269 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mm3/l',CONVERSION_FACTOR = 1000 where tsruom_is_number= 276 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mm3/l',CONVERSION_FACTOR = 1 where tsruom_is_number= 275 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'drops',CONVERSION_FACTOR = 1 where tsruom_is_number= 178 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 175 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 176 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 1233.489 where tsruom_is_number= 189 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.00454609 where tsruom_is_number= 188 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.003785412 where tsruom_is_number= 187 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.0009463529 where tsruom_is_number= 186 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.0004731765 where tsruom_is_number= 185 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.764544857984 where tsruom_is_number= 184 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.028316846592 where tsruom_is_number= 183 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.000016387064 where tsruom_is_number= 182 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.0001 where tsruom_is_number= 177 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.000001 where tsruom_is_number= 180 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 1 where tsruom_is_number= 181 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'pfu/100ml',CONVERSION_FACTOR = 1 where tsruom_is_number= 281 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = '% CaCO3',CONVERSION_FACTOR = 1 where tsruom_is_number= 282 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'mg/l CaCO3',CONVERSION_FACTOR = 1 where tsruom_is_number= 283 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'kg/t CaCO3',CONVERSION_FACTOR = 1 where tsruom_is_number= 284 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'tCaCO3/Kt',CONVERSION_FACTOR = 1 where tsruom_is_number= 285 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'ppb',CONVERSION_FACTOR = 0.001 where tsruom_is_number= 287 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'MPN/100ml',CONVERSION_FACTOR = 1 where tsruom_is_number= 288 and target_unit is null;
UPDATE storet.TSRUOM SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 0.06479891 where tsruom_is_number= 289 and target_unit is null;

COMMIT;

--set to default values when no target_unit or conversion factor has been specified
UPDATE storet.TSRUOM SET TARGET_UNIT = short_form_name, CONVERSION_FACTOR = 1 where target_unit is null;

COMMIT;

-- The following alter statement will cause the Reference Table Application T2.0 (COOL:Gen) 
-- to abend due the constraints.
alter table storet.TSRUOM
	modify (TARGET_UNIT NOT NULL, CONVERSION_FACTOR  NOT NULL, ADJUSTMENT_FACTOR  NOT NULL);

COMMIT;

--Post Statistics
describe storet.TSRUOM;
select count (*) from storet.TSRUOM;
select count (*) from storet.TSRUOM where target_unit is not null;
select count (*) from storet.TSRUOM where conversion_factor is not null;
select count (*) from storet.TSRUOM where adjustment_factor is not null;
select count (*) from storet.TSRUOM where adjustment_factor <> 0;

--disconnect;

SPOOL OFF
