/******************************************************* 
Filename		:  alter_station_project_table.sql 
Description		:  Adds station weight columns to station_project				   
Author			:  Sree Rayankula 
Date			:  05/16/2006 
Comments        :  Modified on 06/01/2007 to move the grants
				   to ws_grants.sql, added station_id, project_cd 
				   columns
**********************************************************/ 
spool alter_station_project.log

alter table station_project 
add (STATION_WEIGHT 		  	VARCHAR2(256 CHAR), 
	 WEIGHT_UNIT_CODE 			VARCHAR2(256 CHAR),
	 STRATUM 					VARCHAR2(256 CHAR), 
	 STATION_WEIGHT_CATEGORY	VARCHAR2(256 CHAR), 
	 SITE_STATUS 				VARCHAR2(256 CHAR));
	 
alter table station_project
add	 ORGANIZATION_ID	VARCHAR2(256 BYTE);

alter table station_project
add	 STATION_ID	VARCHAR2(256 BYTE);

alter table station_project 
add	 PROJECT_CD	VARCHAR2(256 CHAR);	 
		
COMMENT ON COLUMN STATION_PROJECT.STATION_WEIGHT IS 'Project station weight';
COMMENT ON COLUMN STATION_PROJECT.WEIGHT_UNIT_CODE IS 'Station weight unit code.';
COMMENT ON COLUMN STATION_PROJECT.STRATUM IS 'Station weight stratum';
COMMENT ON COLUMN STATION_PROJECT.STATION_WEIGHT_CATEGORY IS 'Station weight category';
COMMENT ON COLUMN STATION_PROJECT.SITE_STATUS IS 'Station weight site status';
COMMENT ON COLUMN STATION_PROJECT.ORGANIZATION_ID IS 'Organization identifier of the station';
COMMENT ON COLUMN STATION_PROJECT.STATION_ID IS 'Station identifier';
COMMENT ON COLUMN STATION_PROJECT.PROJECT_CD IS 'Project code';

update station_project
set station_project.organization_id =  
(select fa_station.organization_id
from fa_station
where station_project.fk_station = fa_station.pk_isn);

commit;

update station_project
set station_project.station_id =  
(select fa_station.station_id
from fa_station
where station_project.fk_station = fa_station.pk_isn);

commit;

update station_project
set station_project.project_cd =
(select di_project.project_cd 
from di_project
where di_project.pk_isn = station_project.fk_project);

commit;

create index ISP_ORGANIZATION_ID 
on station_project(ORGANIZATION_ID)
tablespace storetindx
storage (INITIAL 5M NEXT 5M);

create index ISP_STATION_ID 
on station_project(STATION_ID)
tablespace storetindx
storage (INITIAL 5M NEXT 5M);

spool off;
