spool create_ws_huc_act_char_summary.log


--create table
drop TABLE WS_HUC_ACT_CHAR_SUMMARY  ;
CREATE TABLE WS_HUC_ACT_CHAR_SUMMARY  
 (HYDROLOGIC_UNIT_CODE		VARCHAR2(12 CHAR) NOT NULL,  
 ORGANIZATION_ID		VARCHAR2(256 BYTE) NOT NULL,  
  ACTIVITY_ID			varchar2 (256 byte),
  ACTIVITY_TYPE		  	varchar2 (256 byte),
  STATION_ID			varchar2 (256 byte),
  STATION_TYPE			varchar2 (256 byte),
  ACTIVITY_MEDIUM		varchar2 (20 char),
  ACTIVITY_START_DATE		date,
 CHARACTERISTIC_ID		NUMBER(12) NOT NULL,  
 CHARTYPE_ID			NUMBER(12) NOT NULL,  
 CHAR_DISPLAY_NAME		VARCHAR2(256 CHAR),  
 CHARTYPE_NAME			VARCHAR2(256 CHAR),  
 RESULT_COUNT			NUMBER(12))  
tablespace storetdata  
storage(initial 10M next 5M)
nologging;

--alter table
ALTER TABLE WS_HUC_ACT_CHAR_SUMMARY 
ADD CONSTRAINT PK_WS_HUC_ACT_CHAR_SUMMARY  
PRIMARY KEY (ORGANIZATION_ID, HYDROLOGIC_UNIT_CODE, CHARACTERISTIC_ID, CHARTYPE_ID)  
using index  
tablespace storetindx  
storage (initial 2M next 2M);

--comments;
comment on table WS_HUC_ACT_CHAR_SUMMARY is 'Watershed Hydrologic Oganization Char Summary table';
comment on column WS_HUC_ACT_CHAR_SUMMARY.HYDROLOGIC_UNIT_CODE is 'Hydrologic Unit code';
comment on column WS_HUC_ACT_CHAR_SUMMARY.ORGANIZATION_ID is 'Organization Identifier';
comment on column WS_HUC_ACT_CHAR_SUMMARY.CHARACTERISTIC_ID is 'Characteristic Identifier';
comment on column WS_HUC_ACT_CHAR_SUMMARY.CHARTYPE_ID is 'Chartype Identifier';
comment on column WS_HUC_ACT_CHAR_SUMMARY.CHAR_DISPLAY_NAME is 'Characteristic Display Name';
comment on column WS_HUC_ACT_CHAR_SUMMARY.CHARTYPE_NAME is 'Chartype Name';
comment on column WS_HUC_ACT_CHAR_SUMMARY.RESULT_COUNT is 'Results count';



create or replace PROCEDURE  SP_REFRESH_WS_ORG_CHAR_SUMMARY AS
cursor station_data_cur is
SELECT a.hydrologic_unit_code, a.organization_id,
	   a.characteristic_id, lu_chartype.pk_isn AS chartype_id,
	   a.char_display_name,
	   lu_chartype.chartype AS chartype_name, a.result_count
FROM characteristic_chartype, lu_chartype,
(SELECT hydrologic_unit_code, organization_id,
	   characteristic_id,
	   char_display_name,
	   sum(char_result_count) AS result_count
FROM WS_STATION_DATA
WHERE hydrologic_unit_code IS NOT NULL
GROUP BY hydrologic_unit_code, organization_id,
	  	 characteristic_id, char_display_name) a
WHERE a.characteristic_id = characteristic_chartype.fk_characteristic
	  and characteristic_chartype.fk_chartype = lu_chartype.pk_isn;

  v_huc									varchar2(12 char);
  v_organization_id						varchar2(256 byte);
  v_char_id								number(12);
  v_chartype_id							number(12);
  v_char_display_name					varchar2(256 char);
  v_chartype							varchar2(256 char);
  v_result_count						number(12);
  v_insert_count						number(12);
  v_create_stmt							varchar2(800 char);
  v_insert_stmt							varchar2(800 char);


begin

--create WS_HUC_ACT_CHAR_SUMMARY

begin
execute immediate 'drop index IWS_HOC_HUC';
exception when others then Null;
end;

begin
execute immediate 'drop index IWS_HOC_HUC_ORGID_CHARTYPEID';
exception when others then Null;
end;

begin
  execute immediate 'truncate table WS_HUC_ACT_CHAR_SUMMARY';
exception when others then
  null;
end;

--grants
begin
dbms_output.put_line('Granting select to storetweb on WS_HUC_ACT_CHAR_SUMMARY ...');
execute immediate 'grant select on WS_HUC_ACT_CHAR_SUMMARY to storetweb';
exception when others then null;
end;


-- populate while comitting after every 1000 insertions
dbms_output.put_line('Populating WS_HUC_ACT_CHAR_SUMMARY table ...');
v_insert_count := 0;
open station_data_cur;
loop
	fetch station_data_cur into
	v_huc, v_organization_id,
    v_char_id, v_chartype_id,
	v_char_display_name, v_chartype,
	v_result_count;
	exit when station_data_cur%NOTFOUND;

	insert into WS_HUC_ACT_CHAR_SUMMARY
	(hydrologic_unit_code, organization_id,
	 characteristic_id,chartype_id,
	 char_display_name, chartype_name,
	 result_count)
	values
	(v_huc, v_organization_id,
	v_char_id, v_chartype_id,
	v_char_display_name, v_chartype,
	v_result_count);

	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;
end loop;
close station_data_cur;
commit;

--create indexes on WS_HUC_ACT_CHAR_SUMMARY
dbms_output.put_line('Creating indexes on WS_HUC_ACT_CHAR_SUMMARY table ...');
begin
execute immediate 'CREATE INDEX IWS_HOC_HUC ON WS_HUC_ACT_CHAR_SUMMARY ' ||
'(TRIM(HYDROLOGIC_UNIT_CODE)) ' ||
'tablespace storetindx ' ||
'storage (initial 2M next 2M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX IWS_HOC_HUC_ORGID_CHARTYPEID ON WS_HUC_ACT_CHAR_SUMMARY ' ||
'(TRIM(HYDROLOGIC_UNIT_CODE), LOWER(TRIM(ORGANIZATION_ID)), LOWER(TRIM(CHARTYPE_NAME))) ' ||
'tablespace storetindx ' ||
'storage (initial 2M next 2M)';
exception when others then null;
end;

BEGIN
execute immediate 'ANALYZE TABLE WS_HUC_ACT_CHAR_SUMMARY COMPUTE STATISTICS FOR TABLE FOR ALL INDEXES';
exception when others then null;
end;


end;
/
show errors;

select count(*) from WS_HUC_ACT_CHAR_SUMMARY;
set serveroutput on size 60000;
exec SP_REFRESH_WS_ORG_CHAR_SUMMARY;
select count(*) from WS_HUC_ACT_CHAR_SUMMARY;

spool off;
/***********************************************************************
Script			: ws_org_activity.sql 
Description		: Populates data into ws_org_activity 
Author			: Sree Rayankula 
Created Date	: 06/13/2007  
Comments		:  
***********************************************************************/ 
spool 'ws_org_activity.log'
set serveroutput on;

drop table ws_org_activity;

create table ws_org_activity
(ORGANIZATION_ID 	varchar2 (256 byte),
ACTIVITY_ID			varchar2 (256 byte),
ACTIVITY_TYPE		varchar2 (256 byte),
STATION_ID			varchar2 (256 byte),
STATION_TYPE		varchar2 (256 byte),
ACTIVITY_MEDIUM		varchar2 (20 char),
ACTIVITY_START_DATE	date)
tablespace storetdata  
storage (initial 20M next 5M)
nologging;

create or replace procedure sp_refresh_ws_org_activity as
--regular result cursor 
cursor regular_result_data_cur is 
select distinct organization_id, station_id, activity_id,
activity_type, activity_medium, min(activity_start_date_time) as activity_start_date_time,
di_statn_types.primary_type as station_type 
from fa_regular_result left join di_statn_types
on fa_regular_result.fk_statn_types = di_statn_types.pk_isn
group by organization_id, station_id, activity_id, activity_type, activity_medium, primary_type
order by organization_id, station_id, activity_id;

--biological result cursor 
cursor biological_result_data_cur is 
select distinct Organization_id, station_id, activity_id,
Activity_Type, Activity_Medium, min(Activity_Start_Date_Time) as Activity_Start_Date_Time,
di_statn_types.primary_type as station_type 
from fa_biological_result left join di_statn_types
on fa_biological_result.fk_statn_types = di_statn_types.pk_isn
group by Organization_id, station_id, activity_id, activity_type, activity_medium, primary_type
order by organization_id, station_id, activity_id;

--habitat result cursor 
cursor habitat_result_data_cur is 
select distinct Organization_id, station_id, activity_id,
Activity_Type, null as Activity_Medium, min(Activity_Start_Date_Time) as Activity_Start_Date_Time,
di_statn_types.primary_type as station_type 
from fa_habitat_result left join di_statn_types
on fa_habitat_result.fk_statn_types = di_statn_types.pk_isn
group by Organization_id, station_id, activity_id, activity_type, primary_type
order by organization_id, station_id, activity_id;

v_organization_id		varchar2(256 byte);
v_station_id			varchar2(256 byte);
v_station_type			varchar2(256 byte);
v_activity_id			varchar2(256 byte);
v_activity_type			varchar2(256 byte);
v_activity_medium		varchar2(20 char);
v_activity_start_date	date;
v_insert_count			number(12);

begin

-- truncate ws_org_activity  
begin
execute immediate 'truncate table ws_org_activity';
exception when others then null;
end;

-- drop indexes 
begin
execute immediate 'drop index iws_org_activity_org_id';
execute immediate 'drop index iws_org_activity_org_id_stn_id';
execute immediate 'drop index iws_org_activity_stn_type';
execute immediate 'drop index iws_org_activity_activity_type';
execute immediate 'drop index iws_org_activity_activity_id';
execute immediate 'drop index iws_org_activity_start_date';
execute immediate 'drop index IWS_ORG_ACT_FN_STN_ID2';
execute immediate 'drop index IWS_ORG_ACTIVITY_ORG_ID2';
exception when others then null;
end;

--insert data into ws_org_activity, while committing after every 1000 inserts 
v_insert_count := 0;

-- insert regualr data into ws_org_activity 
open regular_result_data_cur;
loop
	fetch regular_result_data_cur into
	v_organization_id, v_station_id,
	v_activity_id, v_activity_type,
	v_activity_medium, v_activity_start_date,
	v_station_type;
	exit when regular_result_data_cur%NOTFOUND;
	
	insert into ws_org_activity
	(organization_id, station_id, 
	station_type, activity_id, activity_type,
	activity_medium, activity_start_date)
	values
	(v_organization_id, v_station_id, 
	 v_station_type, v_activity_id, v_activity_type,
	 v_activity_medium, v_activity_start_date);
	
	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;	
	
end loop;
close regular_result_data_cur;
commit;

-- insert biological data into ws_org_activity 
open biological_result_data_cur;
loop
	fetch biological_result_data_cur into
	v_organization_id, v_station_id,
	v_activity_id, v_activity_type,
	v_activity_medium, v_activity_start_date,
	v_station_type;
	exit when biological_result_data_cur%NOTFOUND;
	
	insert into ws_org_activity
	(organization_id, station_id, 
	station_type, activity_id, activity_type,
	activity_medium, activity_start_date)
	values
	(v_organization_id, v_station_id, 
	 v_station_type, v_activity_id, v_activity_type,
	 v_activity_medium, v_activity_start_date);
	
	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;	
	
end loop;
close biological_result_data_cur;
commit;

-- insert habitat data in to ws_org_activity 
open habitat_result_data_cur;
loop
	fetch habitat_result_data_cur into
	v_organization_id, v_station_id,
	v_activity_id, v_activity_type,
	v_activity_medium, v_activity_start_date, 
	v_station_type;
	exit when habitat_result_data_cur%NOTFOUND;
	
	insert into ws_org_activity
	(organization_id, station_id, 
	station_type, activity_id, activity_type,
	activity_medium, activity_start_date)
	values
	(v_organization_id, v_station_id, 
	 v_station_type, v_activity_id, v_activity_type,
	 v_activity_medium, v_activity_start_date);
	
	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;	
	
end loop;
close habitat_result_data_cur;
commit;

begin
execute immediate 'create index iws_org_activity_org_id on ws_org_activity(lower(trim(organization_id))) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;

begin
execute immediate 'create index iws_org_activity_org_id_stn_id on ws_org_activity(lower(trim(oganization_id)), ' ||
'lower(trim(station_id))) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;


begin
execute immediate 'create index iws_org_activity_stn_type on ws_org_activity(lower(trim(station_type))) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;

begin
execute immediate 'create index iws_org_activity_activity_type on ws_org_activity(lower(trim(activity_type))) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;

begin
execute immediate 'create index iws_org_activity_activity_id on ws_org_activity(lower(trim(organization_id)), ' ||
'lower(trim(activity_id))) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;

begin
execute immediate 'create index iws_org_activity_start_date on ws_org_activity(activity_start_date) ' ||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX IWS_ORG_ACT_FN_STN_ID2 ON WS_ORG_ACTIVITY(lower(trim(STATION_ID))) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX IWS_ORG_ACTIVITY_ORG_ID2 ON WS_ORG_ACTIVITY(ORGANIZATION_ID) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX I_DI_ORG_FN_ORG_ID ON DI_ORG (lower(trim(ORGANIZATION_ID))) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then null;
end;

end;
/
show errors;

select count(*) from ws_org_activity;
exec sp_refresh_ws_org_activity;
select count(*) from ws_org_activity; 

spool off;
