spool create_ws_huc_org_char_summary.log


--create table
drop TABLE WS_HUC_ORG_CHAR_SUMMARY  ;
CREATE TABLE WS_HUC_ORG_CHAR_SUMMARY  
 (HYDROLOGIC_UNIT_CODE	  VARCHAR2(12 CHAR) NOT NULL,  
 ORGANIZATION_ID		  VARCHAR2(256 BYTE) NOT NULL,  
 CHARACTERISTIC_ID		  NUMBER(12) NOT NULL,  
 CHARTYPE_ID			  NUMBER(12) NOT NULL,  
 CHAR_DISPLAY_NAME		  VARCHAR2(256 CHAR),  
 CHARTYPE_NAME			  VARCHAR2(256 CHAR),  
 RESULT_COUNT	  		  NUMBER(12))  
tablespace storetdata  
storage(initial 10M next 5M)
nologging;

--alter table
ALTER TABLE WS_HUC_ORG_CHAR_SUMMARY 
ADD CONSTRAINT PK_WS_HUC_ORG_CHAR_SUMMARY  
PRIMARY KEY (ORGANIZATION_ID, HYDROLOGIC_UNIT_CODE, CHARACTERISTIC_ID, CHARTYPE_ID)  
using index  
tablespace storetindx  
storage (initial 2M next 2M);

--comments;
comment on table WS_HUC_ORG_CHAR_SUMMARY is 'Watershed Hydrologic Oganization Char Summary table';
comment on column WS_HUC_ORG_CHAR_SUMMARY.HYDROLOGIC_UNIT_CODE is 'Hydrologic Unit code';
comment on column WS_HUC_ORG_CHAR_SUMMARY.ORGANIZATION_ID is 'Organization Identifier';
comment on column WS_HUC_ORG_CHAR_SUMMARY.CHARACTERISTIC_ID is 'Characteristic Identifier';
comment on column WS_HUC_ORG_CHAR_SUMMARY.CHARTYPE_ID is 'Chartype Identifier';
comment on column WS_HUC_ORG_CHAR_SUMMARY.CHAR_DISPLAY_NAME is 'Characteristic Display Name';
comment on column WS_HUC_ORG_CHAR_SUMMARY.CHARTYPE_NAME is 'Chartype Name';
comment on column WS_HUC_ORG_CHAR_SUMMARY.RESULT_COUNT is 'Results count';



create or replace PROCEDURE  SP_REFRESH_WS_ORG_CHAR_SUMMARY AS
cursor station_data_cur is
SELECT a.hydrologic_unit_code, a.organization_id,
	   a.characteristic_id, lu_chartype.pk_isn AS chartype_id,
	   a.char_display_name,
	   lu_chartype.chartype AS chartype_name, a.result_count
FROM characteristic_chartype, lu_chartype,
(SELECT hydrologic_unit_code, organization_id,
	   characteristic_id,
	   char_display_name,
	   sum(char_result_count) AS result_count
FROM WS_STATION_DATA
WHERE hydrologic_unit_code IS NOT NULL
GROUP BY hydrologic_unit_code, organization_id,
	  	 characteristic_id, char_display_name) a
WHERE a.characteristic_id = characteristic_chartype.fk_characteristic
	  and characteristic_chartype.fk_chartype = lu_chartype.pk_isn;

  v_huc									varchar2(12 char);
  v_organization_id						varchar2(256 byte);
  v_char_id								number(12);
  v_chartype_id							number(12);
  v_char_display_name					varchar2(256 char);
  v_chartype							varchar2(256 char);
  v_result_count						number(12);
  v_insert_count						number(12);
  v_create_stmt							varchar2(800 char);
  v_insert_stmt							varchar2(800 char);


begin

--create ws_huc_org_char_summary

begin
execute immediate 'drop index IWS_HOC_HUC';
exception when others then Null;
end;

begin
execute immediate 'drop index IWS_HOC_HUC_ORGID_CHARTYPEID';
exception when others then Null;
end;

begin
  execute immediate 'truncate table WS_HUC_ORG_CHAR_SUMMARY';
exception when others then
  null;
end;

--grants
begin
dbms_output.put_line('Granting select to storetweb on ws_huc_org_char_summary ...');
execute immediate 'grant select on WS_HUC_ORG_CHAR_SUMMARY to storetweb';
exception when others then null;
end;


-- populate while comitting after every 1000 insertions
dbms_output.put_line('Populating ws_huc_org_char_summary table ...');
v_insert_count := 0;
open station_data_cur;
loop
	fetch station_data_cur into
	v_huc, v_organization_id,
    v_char_id, v_chartype_id,
	v_char_display_name, v_chartype,
	v_result_count;
	exit when station_data_cur%NOTFOUND;

	insert into ws_huc_org_char_summary
	(hydrologic_unit_code, organization_id,
	 characteristic_id,chartype_id,
	 char_display_name, chartype_name,
	 result_count)
	values
	(v_huc, v_organization_id,
	v_char_id, v_chartype_id,
	v_char_display_name, v_chartype,
	v_result_count);

	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;
end loop;
close station_data_cur;
commit;

--create indexes on ws_huc_org_char_summary
dbms_output.put_line('Creating indexes on ws_huc_org_char_summary table ...');
begin
execute immediate 'CREATE INDEX IWS_HOC_HUC ON WS_HUC_ORG_CHAR_SUMMARY ' ||
'(TRIM(HYDROLOGIC_UNIT_CODE)) ' ||
'tablespace storetindx ' ||
'storage (initial 2M next 2M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX IWS_HOC_HUC_ORGID_CHARTYPEID ON WS_HUC_ORG_CHAR_SUMMARY ' ||
'(TRIM(HYDROLOGIC_UNIT_CODE), LOWER(TRIM(ORGANIZATION_ID)), LOWER(TRIM(CHARTYPE_NAME))) ' ||
'tablespace storetindx ' ||
'storage (initial 2M next 2M)';
exception when others then null;
end;

BEGIN
execute immediate 'ANALYZE TABLE WS_HUC_ORG_CHAR_SUMMARY COMPUTE STATISTICS FOR TABLE FOR ALL INDEXES';
exception when others then null;
end;


end;
/
show errors;

select count(*) from ws_huc_org_char_summary;
set serveroutput on size 60000;
exec SP_REFRESH_WS_ORG_CHAR_SUMMARY;
select count(*) from ws_huc_org_char_summary;

spool off;