spool create_ws_station_summary.log

drop TABLE WS_STATION_SUMMARY;
CREATE TABLE WS_STATION_SUMMARY ( 
  ORGANIZATION_ID 		VARCHAR2(256 BYTE) NOT NULL, 
  STATION_ID  			VARCHAR2(256 BYTE)  NOT NULL, 
  CHARACTERISTIC_ID		NUMBER(12) 		   NOT NULL, 
  CHARTYPE_ID			NUMBER(12)		   NOT NULL,
  HYDROLOGIC_UNIT_CODE		VARCHAR2(12 CHAR), 
  ORGANIZATION_NAME     	VARCHAR2(256 BYTE),  
  STATION_NAME          	VARCHAR2(256 BYTE),  
  MIN_ACTIVITY_START_DATE_TIME	DATE,  
  MAX_ACTIVITY_STOP_DATE_TIME   DATE,  
  CHARTYPE			VARCHAR2(256 CHAR), 
  CHAR_DISPLAY_NAME             VARCHAR2(256 CHAR), 
  CHARACTERISTIC_RESULT_COUNT	NUMBER(12), 
  UNIQUE_STATION_IDENTIFIER  	VARCHAR2(280 CHAR)) 
tablespace storetdata  
storage(initial 20M next 5M)
nologging;

comment on table WS_STATION_SUMMARY is 'Watershed Station Summary table.' ;
comment on column WS_STATION_SUMMARY.ORGANIZATION_ID is 'Organization Identifier'   ;
comment on column WS_STATION_SUMMARY.STATION_ID is 'Station Identifier'   ;
comment on column WS_STATION_SUMMARY.CHARACTERISTIC_ID is  'Characteristic Identifier'  ;
comment on column WS_STATION_SUMMARY.CHARTYPE_ID is  'Chartype Identifier'  ;
comment on column WS_STATION_SUMMARY.HYDROLOGIC_UNIT_CODE is  'Hydrologic Unit code'  ;
comment on column WS_STATION_SUMMARY.ORGANIZATION_NAME is  'Organization Name'  ;
comment on column WS_STATION_SUMMARY.STATION_NAME is   'Station Name' ;
comment on column WS_STATION_SUMMARY.MIN_ACTIVITY_START_DATE_TIME is 'Minimum Activity Start Date Time';
comment on column WS_STATION_SUMMARY.MAX_ACTIVITY_STOP_DATE_TIME is  'Maximum Acivity Stop Date Time';
comment on column WS_STATION_SUMMARY.CHARTYPE is  'CharType';
comment on column WS_STATION_SUMMARY.CHAR_DISPLAY_NAME is  'Characteristic Display Name';
comment on column WS_STATION_SUMMARY.CHARACTERISTIC_RESULT_COUNT is  'Characteristic Result Count';
comment on column WS_STATION_SUMMARY.UNIQUE_STATION_IDENTIFIER is 'Unique Station Identifier generated for application purposes';



create or replace PROCEDURE  storetw.SP_REFRESH_WS_STATION_SUMMARY AS
cursor station_data_cur is
SELECT ORGANIZATION_ID, STATION_ID, CHARACTERISTIC_ID,  lu_chartype.PK_ISN AS CHARTYPE_ID,
   HYDROLOGIC_UNIT_CODE, ORGANIZATION_NAME, STATION_NAME, 
   first_value( min_activity_start_date_time)
    over(PARTITION BY hydrologic_unit_code, organization_id, station_id
        order by min_activity_start_date_time asc NULLS LAST) as MIN_ACTIVITY_START_DATE_TIME,
   first_value(max_activity_stop_date_time)
    over(PARTITION BY hydrologic_unit_code, organization_id, station_id
       order by max_activity_stop_date_time desc NULLS LAST) as MAX_ACTIVITY_STOP_DATE_TIME, 
   CHARTYPE, CHAR_DISPLAY_NAME,
   CHAR_RESULT_COUNT AS CHARACTERISTIC_RESULT_COUNT, UNIQUE_STATION_IDENTIFIER
  FROM storetw.WS_STATION_DATA, storetw.lu_chartype, storetw.characteristic_chartype
  WHERE WS_STATION_DATA.CHARACTERISTIC_ID = characteristic_chartype.FK_CHARACTERISTIC
       AND characteristic_chartype.FK_CHARTYPE = lu_chartype.PK_ISN;

/*SELECT ORGANIZATION_ID, STATION_ID, CHARACTERISTIC_ID,  lu_chartype.PK_ISN AS CHARTYPE_ID,
		HYDROLOGIC_UNIT_CODE, ORGANIZATION_NAME, STATION_NAME, MIN_ACTIVITY_START_DATE_TIME,
		MAX_ACTIVITY_STOP_DATE_TIME, CHARTYPE, CHAR_DISPLAY_NAME,
		CHAR_RESULT_COUNT AS CHARACTERISTIC_RESULT_COUNT, UNIQUE_STATION_IDENTIFIER
	FROM WS_STATION_DATA, lu_chartype, characteristic_chartype
	WHERE WS_STATION_DATA.CHARACTERISTIC_ID = characteristic_chartype.FK_CHARACTERISTIC
	  	  AND characteristic_chartype.FK_CHARTYPE = lu_chartype.PK_ISN;
*/
  v_organization_id						varchar2(256 byte);
  v_station_id							varchar2(256 byte);
  v_char_id								number(12);
  v_chartype_id							number(12);
  v_huc									varchar2(12 char);
  v_org_name							varchar2(256 byte);
  v_station_name						varchar2(256 byte);
  v_min_act_start_date					date;
  v_max_act_stop_date					date;
  v_chartype							varchar2(256 char);
  v_char_display_name					varchar2(256 char);
  v_char_result_count					number(12);
  v_unique_station_identifier			varchar2(280 char);
  v_insert_count						number(12);
  v_create_stmt							varchar2(800 char);
  v_insert_stmt							varchar2(800 char);
  v_min_min_act_start_datetime date;
  v_max_max_act_stop_date_time date;
/*
  CURSOR C_UPd_min_max (cp_huc in varchar2, cp_org_id in varchar2, cp_stn_id in varchar2)is
  select min(min_activity_start_date_time) as min_min_act_start_datetime,
	max(max_activity_stop_date_time) as max_max_act_stop_date_time
from WS_STATION_DATA b
 where hydrologic_unit_code=cp_huc
   and organization_id=cp_org_id
   and station_id=cp_stn_id;
*/
begin

--create ws_station_summary
dbms_output.put_line('Creating ws_station_summary table ...');

begin
execute immediate 'drop index IWS_SS_UNIQUE_STATION_ID';
exception when others then Null;
end;

begin
execute immediate 'drop index IWS_SS_HUC';
exception when others then Null;
end;

begin
execute immediate 'drop index IWS_SS_CHARTYPE_STATION_ORG';
exception when others then Null;
end;

begin
execute immediate 'drop index IWS_SS_HUC_STATION_ORG';
exception when others then Null;
end;

begin
execute immediate 'drop index IWS_SS_HUC_ORG_ID';
exception when others then Null;
end;



begin
  execute immediate 'truncate table ws_station_summary';
exception when others then
  null;
end;

--grants
begin
dbms_output.put_line('Granting select to storetweb ws_station_summary ...');
execute immediate 'grant select on WS_STATION_SUMMARY to storetweb';
exception when others then null;
end;


-- populate while comitting after every 1000 insertions
dbms_output.put_line('Populating ws_station_summary table ...');
v_insert_count := 0;
open station_data_cur;
loop
	fetch station_data_cur into
		  v_organization_id, v_station_id,  v_char_id, v_chartype_id, v_huc,
		  v_org_name, v_station_name, v_min_act_start_date, v_max_act_stop_date,
		  v_chartype, v_char_display_name, v_char_result_count,
		  v_unique_station_identifier;
	exit when station_data_cur%NOTFOUND;

/*
	 --v_min_min_act_start_datetime:=null;
	 -- v_max_max_act_stop_date_time :=null;

	 begin
	  v_min_min_act_start_datetime:=null;
	  v_max_max_act_stop_date_time :=null;

	  open C_UPd_min_max(cp_huc => v_huc, cp_org_id => v_organization_id, cp_stn_id => v_station_id);
	  fetch C_UPd_min_max into v_min_min_act_start_datetime, v_max_max_act_stop_date_time;
	  exit when C_UPd_min_max%NOTFOUND;
	  close C_UPd_min_max;
	 exception when others then
	   null;
	 end;


	insert into ws_station_summary (ORGANIZATION_ID, STATION_ID, CHARACTERISTIC_ID,CHARTYPE_ID,
	HYDROLOGIC_UNIT_CODE,ORGANIZATION_NAME, STATION_NAME, MIN_ACTIVITY_START_DATE_TIME,
    MAX_ACTIVITY_STOP_DATE_TIME, CHARTYPE, CHAR_DISPLAY_NAME,CHARACTERISTIC_RESULT_COUNT,
	UNIQUE_STATION_IDENTIFIER)
	 values ( v_organization_id , v_station_id, v_char_id ,
		  v_chartype_id ,v_huc,v_org_name, v_station_name, v_min_min_act_start_datetime,
		  v_max_max_act_stop_date_time,v_chartype,v_char_display_name,v_char_result_count ,
		  v_unique_station_identifier);

*/


	insert into ws_station_summary (ORGANIZATION_ID, STATION_ID, CHARACTERISTIC_ID,CHARTYPE_ID,
	HYDROLOGIC_UNIT_CODE,ORGANIZATION_NAME, STATION_NAME, MIN_ACTIVITY_START_DATE_TIME,
    MAX_ACTIVITY_STOP_DATE_TIME, CHARTYPE, CHAR_DISPLAY_NAME,CHARACTERISTIC_RESULT_COUNT,
	UNIQUE_STATION_IDENTIFIER)
	 values ( v_organization_id , v_station_id, v_char_id ,
		  v_chartype_id ,v_huc,v_org_name, v_station_name, v_min_act_start_date,
		  v_max_act_stop_date,v_chartype,v_char_display_name,v_char_result_count ,
		  v_unique_station_identifier);



	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;
end loop;
close station_data_cur;
commit;

--create indexes on ws_station_summary
dbms_output.put_line('Creating indexes on ws_station_summary table ...');
begin
execute immediate 'CREATE INDEX IWS_SS_UNIQUE_STATION_ID ON WS_STATION_SUMMARY
(LOWER(TRIM(UNIQUE_STATION_IDENTIFIER)))
tablespace storetindx
storage (initial 2M next 2M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX IWS_SS_HUC_ORG_ID ON WS_STATION_SUMMARY
(TRIM(HYDROLOGIC_UNIT_CODE), LOWER(TRIM(ORGANIZATION_ID)))
tablespace storetindx
storage (initial 2M next 2M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX IWS_SS_HUC ON WS_STATION_SUMMARY
(TRIM(HYDROLOGIC_UNIT_CODE))
tablespace storetindx
storage (initial 2M next 2M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX IWS_SS_CHARTYPE_STATION_ORG ON WS_STATION_SUMMARY
(LOWER(TRIM(CHARTYPE)), LOWER(TRIM(STATION_ID)), LOWER(TRIM(ORGANIZATION_ID)))
tablespace storetindx
storage (initial 2M next 2M)';
exception when others then null;
end;

begin
execute immediate 'ANALYZE TABLE WS_STATION_SUMMARY COMPUTE STATISTICS  FOR TABLE FOR ALL INDEXES';
exception when others then null;
end;

end;
/
show errors;

select count(*) from storetw.ws_station_summary;

set serveroutput on
exec storetw.SP_REFRESH_WS_STATION_SUMMARY
select count(*) from storetw.ws_station_summary;
spool off;