/******************************************************* 
Name	  	  : insert_web_methods_data.sql 
Author	  	  : Sree Rayankula  
Date	  	  : 03/19/2007 
Description	  :  creates lu_ws_service, ws_web_method and 
			  	 ws_web_method_input_param tables and 
				 populates data.
Comments	  :  Modified on 06/01/2007 to move grants 
			  	 to ws_grants.sql  
*******************************************************/ 

spool insert_web_methods_data.log

--drop tables  
show user;
drop table ws_web_method_input_param; 
drop table ws_web_method;
drop table lu_ws_service;


/****************************************************************************
Create lu_ws_service table and populate data into it  
****************************************************************************/
--create lu_ws_service 
create table lu_ws_service
(pk_isn number, web_service_name varchar2(256));

--enforce primary key on lu_ws_service 
alter table lu_ws_service
add constraint cpk_ws_service primary Key (pk_isn)
using index
tablespace storetindx
storage (initial 256k next 256K);

--provide comments on lu_ws_service and its columns  
comment on table lu_ws_service is 'Web services lookup table.' ;
comment on column lu_ws_service.pk_isn is 'Primary key for lu_ws_service table' ;
comment on column lu_ws_service.web_service_name is 'Web service name' ;

--insert data into lu_ws_service 
insert into lu_ws_service (pk_isn, web_service_name)
values (1,'StationCatalogService');

insert into lu_ws_service (pk_isn, web_service_name)
values (2,'WatershedSummaryService');

insert into lu_ws_service(pk_isn, web_service_name)
values (3, 'StationService');

commit;

--create index on lu_ws_service.web_service_name  
create index iws_service_name on lu_ws_service(upper(web_service_name))
tablespace storetindx
storage (initial 256k next 256K);

/***************************************************************************
Create ws_web_method table and populate data into it 
****************************************************************************/ 

--create ws_web_method table  
create table ws_web_method
(pk_isn number, 
fk_service number not null, 
web_method_name varchar2(256 char) not null,
web_method_id varchar2(256 char),
enviromapper_flag varchar2(10) default 'Y',
service_protocol varchar2(60 char) default 'HTTP',
submit_method varchar2(60 char) default 'GET',
output_format varchar2(60 char) default 'XML');

--enforce primary key on ws_web_method  
alter table ws_web_method
add constraint cpk_ws_web_method primary Key (pk_isn)
using index
tablespace storetindx
storage (initial 256k next 256K);

alter table ws_web_method 
add constraint cfk_web_method_ws_service 
foreign key (fk_service) referencing lu_ws_service(pk_isn);

--provide comments on ws_web_method and its columns 
comment on table ws_web_method is 'Web methods table.' ;
comment on column ws_web_method.pk_isn is 'Primary key for ws_web_method table' ;
comment on column ws_web_method.fk_service is 'Foreign key referencing lu_ws_service.pk_isn' ;
comment on column ws_web_method.web_method_name is 'Name of the web method' ;
comment on column ws_web_method.web_method_id is 'Identifier for the web method' ;
comment on column ws_web_method.enviromapper_flag is 'Enviromapper flag' ;
comment on column ws_web_method.service_protocol is 'Service protocol used by the web method' ;
comment on column ws_web_method.submit_method is 'Submit method for the web method' ;
comment on column ws_web_method.output_format is 'Format of the output generated by the web method' ;

--insert data into ws_web_method  
insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag, 
service_protocol, submit_method, output_format)
values 
(1, 1, 'getStationCharacteristicSummary', 'StationCatalogService_1', 'Y',
'HTTP', 'GET', 'XML');

insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag,
service_protocol, submit_method, output_format)
values 
(2, 1, 'getStationCharTypeSummaryUsingStringInput', 'StationCatalogService_2', 'Y', 
'HTTP', 'GET', 'XML');

--insert into ws_web_method 
--(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag,
--service_protocol, submit_method, output_format)
--values 
--(3, 1, 'getStationCharTypeSummaryUsingXMLInput', 'StationCatalogService_5', 'Y',
--'HTTP', 'POST', 'XML');

insert into ws_web_method 
(pk_isn, fk_service, web_method_name,  web_method_id, enviromapper_flag,
service_protocol, submit_method, output_format)
values 
(3, 1, 'getWatershedOrgStationCharTypeSummary', 'StationCatalogService_3', 'Y',
'HTTP', 'GET', 'XML');

insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag,
service_protocol, submit_method, output_format)
values 
(4, 1, 'getWatershedStationCharTypeSummary', 'StationCatalogService_4', 'Y',
'HTTP', 'GET', 'XML');

-- insert web methods for WatershedSummaryService 
insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag,
service_protocol, submit_method, output_format)
values 
(5, 2, 'getCharacteristicSummary', 'WatershedSummaryService_1', 'Y',
'HTTP', 'GET', 'XML');

insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag, 
service_protocol, submit_method, output_format)
values 
(6, 2, 'getCharTypeCharacteristicSummary', 'WatershedSummaryService_2', 'Y', 
'HTTP', 'GET', 'XML');

insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag, 
service_protocol, submit_method, output_format)
values 
(7, 2, 'getCharTypeSummary', 'WatershedSummaryService_3', 'Y',
'HTTP', 'GET', 'XML');

insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag,
service_protocol, submit_method, output_format)
values 
(8, 2, 'getOrganizationCharTypeCharacteristicSummary', 'WatershedSummaryService_4', 'Y', 
'HTTP', 'GET', 'XML');

insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag,
service_protocol, submit_method, output_format)
values 
(9, 2, 'getOrganizationCharTypeSummary', 'WatershedSummaryService_5', 'Y',
'HTTP', 'GET', 'XML');

insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag,
service_protocol, submit_method, output_format)
values 
(10, 2, 'getOrganizationSummary', 'WatershedSummaryService_6', 'Y',
'HTTP', 'GET', 'XML');

insert into ws_web_method 
(pk_isn, fk_service, web_method_name, web_method_id, enviromapper_flag, 
service_protocol, submit_method, output_format)
values 
(11, 3, 'getStations', 'StationService_1', 'Y',
'HTTP', 'GET', 'XML');

commit;

--create index on ws_web_method.fk_service   
create index iws_web_method_fk_service on ws_web_method(fk_service)
tablespace storetindx
storage (initial 256k next 256K);

/***************************************************************************
Create ws_web_method_input_param table and populate data into it 
****************************************************************************/ 

--create ws_web_method_input_param 
create table ws_web_method_input_param
(pk_isn number, 
fk_web_method number(8) not null, 
param_name varchar2(256 char) not null, 
title varchar2(60 char),
data_type varchar2(60 char),
max_length number(12),
multiplicity varchar2(60 char) default 'SINGLE',
sequence_number number(2) not null);

--enforce primary key on ws_web_method_input_param   
alter table ws_web_method_input_param
add constraint cpk_ws_web_method_input_param primary Key (pk_isn)
using index
tablespace storetindx
storage (initial 256k next 256K);

--specify foreign keys 
alter table ws_web_method_input_param
add constraint cfk_input_param_web_method 
foreign key (fk_web_method) referencing ws_web_method(pk_isn);

--provide comments on ws_web_method_input_param and its columns 
comment on table ws_web_method_input_param is 'Web method input parameters table.' ;
comment on column ws_web_method_input_param.pk_isn is 'Primary key on ws_web_method_input_param table.';
comment on column ws_web_method_input_param.fk_web_method is 'Foreign key referencing pk of ws_web_method.';
comment on column ws_web_method_input_param.param_name is 'Name of the input parameter.';
comment on column ws_web_method_input_param.title is 'Label used with the input parameter.';
comment on column ws_web_method_input_param.data_type is 'Data type of the input param.';
comment on column ws_web_method_input_param.max_length is 'Maximum length of data allowed.';
comment on column ws_web_method_input_param.multiplicity is 'Maximum Number of values allowed.';
comment on column ws_web_method_input_param.sequence_number is 'Ordinal position of the paramater, within the procedure call.';

--create sequence 
drop sequence seq_ws_web_method_input_param;

create sequence seq_ws_web_method_input_param
minvalue 1
start with 1
increment by 1
cache 20;

--insert data into ws_web_method_input_param
--######## StationCatalogService ############# 
--getStationCharacteristicSummary  
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 1, 'CharType',
'Characteristic Type', 'String', '256', 1);

insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 1, 'StationId',
'Station Id', 'String', '256', 2);

insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 1, 'OrganizationId',
'Organization Id', 'String', '256', 3);

--getStationCharTypeSummaryUsingStringInput 
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 2, 'StationIdentifiersInputString',
'Station Identifiers Input String', 'String', 2048, 1);

--getStationCharTypeSummaryUsingXMLInput 
--insert into ws_web_method_input_param
--(pk_isn, fk_web_method, param_name, 
--title, data_type, max_length, sequence_number)
--values
--(seq_ws_web_method_input_param.nextval, 3, 'StationIdentifiersInputXML',
--'Station Identifiers Input XML', 'Element', 2048, 1);

--getWatershedOrgStationCharTypeSummary 
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 3, 'HydrologicUnitCode',
'Hydrologic Unit Code', 'String', 256, 1);

insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 3, 'OrganizationId',
'Organization Id', 'String', 2048, 2);

--getWatershedStationCharTypeSummary  
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 4, 'HydrologicUnitCode',
'Hydrologic Unit Code', 'String', 256, 1);


--######## StationCatalogService ############# 
--getCharacteristicSummary 
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 5, 'HydrologicUnitCode',
'Hydrologic Unit Code', 'String', 256, 1);

--getCharTypeCharacteristicSummary 
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 6, 'CharType',
'Characteristic Type', 'String', 256, 1);

insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 6, 'HydrologicUnitCode',
'Hydrologic Unit Code', 'String', 256, 2);

--getCharTypeSummary 
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 7, 'HydrologicUnitCode',
'Hydrologic Unit Code', 'String', 256, 1);

--getOrganizationCharTypeCharacteristicSummary 
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 8, 'CharType',
'Characteristic Type', 'String', 256, 1);

insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 8, 'OrganizationId',
'Organization Id', 'String', 256, 2);

insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 8, 'HydrologicUnitCode',
'Hydrologic Unit Code', 'String', 256, 3);

--getOrganizationCharTypeSummary 
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 9, 'HydrologicUnitCode',
'Hydrologic Unit Code', 'String', 256, 1);

--getOrganizationSummary 
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 10, 'HydrologicUnitCode',
'Hydrologic Unit Code', 'String', 256, 1);

--StationService 
insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 11, 'MinimumLatitude',
'Minimum Latitude', 'Decimal', null, 1);

insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 11, 'MaximumLatitude',
'Maximum Latitude', 'Decimal', null, 2);

insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 11, 'MinimumLongitude',
'Minimum Longitude', 'Decimal', null, 3);

insert into ws_web_method_input_param
(pk_isn, fk_web_method, param_name, 
title, data_type, max_length, sequence_number)
values
(seq_ws_web_method_input_param.nextval, 11, 'MaximumLongitude',
'Maximum Longitude', 'Decimal', null, 4);

commit;

--create index on ws_web_method_input_param.fk_web_method   
create index iws_ip_param_fk_web_method on ws_web_method_input_param(fk_web_method)
tablespace storetindx
storage (initial 256k next 256K);

spool off;

