spool project_char.log

drop table project_char;

create table project_char (fk_char number(12,0),
                          fk_project number(12,0),
                          fk_org number(12,0),
                          organization_id varchar2(256 char),
                          project_id varchar2(256 char),
                          project_name varchar2(256 char),
                          characteristic_name varchar2(256 char),
                          hydrologic_unit_code varchar2(256 char),
                          act_min_start_date date,
                          act_max_start_date date,
                          act_max_start_stop_date date,
                          regular_count number,
                          biological_count number,
                          habitat_count number,
                          result_count number)tablespace STORETDATA
                     storage(initial 20M next 20M PCTINCREASE 0 minextents 2 maxextents 200 )
                     nologging
                     pctused 40 pctfree 60;	
truncate table project_char;

select count(*) from project_char;


alter table di_project drop column Project_POR_start;
alter table di_project drop column Project_POR_end ;

alter table di_project add Project_POR_start date;
alter table di_project add Project_POR_end  date;


set serveroutput on
CREATE OR REPLACE PROCEDURE SP_REFRESH_PROJ_CHAR  AS


   cursor regular_cursor is 
   select fr.fk_char, 
        rr.fk_project,
        fr.fk_org,
        fr.organization_id,
        dp.project_cd,
        dp.project_name,
        cr.display_name,
        fr.hydrologic_unit_code,
        min(activity_start_date_time) as act_min_start_date,
        max(activity_start_date_time) as act_max_start_date,
        case 
			when max(activity_stop_date_time) > max(activity_start_date_time)
			then max(activity_stop_date_time) 
			else max(activity_start_date_time)
		end as act_max_start_stop_date,
		count(*) as regular_count
	       
	from fa_regular_result fr, di_characteristic cr,regular_result_project rr, di_project dp
        where fk_char is not null
        and rr.fk_project is not null
        and fr.pk_isn = rr.fk_result
        and dp.pk_isn = rr.fk_project
        and cr.pk_isn = fr.fk_char
        group by fr.fk_char,cr.display_name,fr.fk_org,fr.organization_id,rr.fk_project,dp.project_cd,dp.project_name,fr.hydrologic_unit_code;

        
       
	cursor biological_cursor is 
	   select fb.fk_char, 
	        br.fk_project,
	        fb.fk_org,
	        fb.organization_id,
	        dp.project_cd,
	        dp.project_name,
	        cr.display_name,
	        fb.hydrologic_unit_code,
	        min(activity_start_date_time) as act_min_start_date,
	        max(activity_start_date_time) as act_max_start_date,
	        case when max(activity_stop_date_time) > max(activity_start_date_time)
		then max(activity_stop_date_time) else max(activity_start_date_time)
		end as act_max_start_stop_date,
	        count(*) as biological_count
		       
		from fa_biological_result fb,di_characteristic cr,biological_result_project br, di_project dp
	        where fk_char is not null
	        and br.fk_project is not null
	        and fb.pk_isn = br.fk_result
	        and dp.pk_isn = br.fk_project
	        and cr.pk_isn = fb.fk_char
	        group by fb.fk_char,cr.display_name,fb.fk_org,fb.organization_id,br.fk_project,dp.project_cd,dp.project_name,fb.hydrologic_unit_code;

	cursor habitat_cursor is 
	   select fh.fk_char, 
	        hr.fk_project,
	        fh.fk_org,
	        fh.organization_id,
	        dp.project_cd,
	        dp.project_name,
	        cr.display_name,
	        fh.hydrologic_unit_code,
	        min(activity_start_date_time) as act_min_start_date,
	        max(activity_start_date_time) as act_max_start_date,
	        case when max(activity_stop_date_time) > max(activity_start_date_time)
		then max(activity_stop_date_time) else max(activity_start_date_time)
		end as act_max_start_stop_date,
	        count(*) as habitat_count
		       
		from fa_habitat_result fh, di_characteristic cr,habitat_result_project hr, di_project dp
	        where fk_char is not null
	        and hr.fk_project is not null
	        and fh.pk_isn = hr.fk_result
	        and dp.pk_isn = hr.fk_project
	        and cr.pk_isn = fh.fk_char
	        group by fh.fk_char,cr.display_name,fh.fk_org,fh.organization_id,hr.fk_project,dp.project_cd,dp.project_name,fh.hydrologic_unit_code;


                
	v_fk_char number(12);
	v_fk_project  number(12);
	v_fk_org number(12);
	v_commit_count    number;
	v_org_id  varchar2(256 char);
	v_regular_count number;
	v_act_min_start_date date;
	v_act_max_start_date date;
	v_act_max_start_stop_date date;
	v_result_count number;
	v_characteristic_name varchar2(256 char);
	v_huc varchar2(256 char);
	v_project_id varchar2(256 char);
	v_project_name varchar2(256 char);
        
begin
	--status := 'successful';


	--truncate project_char and drop all indexes   
	execute immediate 'truncate table project_char';
        
        begin
	    execute immediate 'drop index ICP_ORGID';
	  exception when others then
	    Null;
	  end;
          
        begin
	    execute immediate 'drop index ICP_ORGID_PROJ';
	  exception when others then
	    Null;
	  end;
        
         begin
	    execute immediate 'drop index ICP_HUC';
	  exception when others then
	    Null;
	  end;
         
          
           begin
	    execute immediate 'drop index ICP_ORG_HUC';
	  exception when others then
	    Null;
	  end;
               
        
         begin
	    execute immediate 'drop index ICP_FK_ORG';
	  exception when others then
	    Null;
	  end;
       
        
	  begin
	    execute immediate 'drop index ICP_FK_CHAR';
	  exception when others then
	    Null;
	  end;

	  begin
	    execute immediate 'drop index ICP_FK_PROJECT';
	  exception when others then
	    Null;
	  end;

	  begin
	    execute immediate 'drop index ICP_FK_CHAR_FK_PROJECT';
	  exception when others then
	    Null;
	  end;


	--process regular result data 
	dbms_output.put_line('processing Regular results...');
	v_commit_count := 0;
	open regular_cursor;
	loop
		fetch regular_cursor into v_fk_char,v_fk_project,v_fk_org, v_org_id,v_project_id,v_project_name,v_characteristic_name,v_huc,v_act_min_start_date,v_act_max_start_date,v_act_max_start_stop_date,v_result_count;
	     	exit when regular_cursor%NOTFOUND;
		
		 	v_commit_count := v_commit_count + 1;
		 	insert into project_char(fk_char,
	                fk_project,
	                fk_org,
	                organization_id,
	                project_id,
	                project_name,
	                characteristic_name,
	                hydrologic_unit_code,
	                act_min_start_date,
	                act_max_start_date,
	                act_max_start_stop_date,
	                regular_count,
	                result_count)
		 	values
		 	(v_fk_char,
	                 v_fk_project,
	                 v_fk_org,
	                 v_org_id,
	                 v_project_id,
	                 v_project_name,
	                 v_characteristic_name,
	                 v_huc,
	                 v_act_min_start_date,
	                 v_act_max_start_date,
	                 v_act_max_start_stop_date,
	                 v_result_count,
	                 v_result_count);
			
			if (v_commit_count=1000) then
			   v_commit_count := 0;
			   commit;
			end if;
		
		 	 -- get min_act_start_date, max_act_start_date, max_act_start_stop_date 
			 --from project_char
	end loop;
	close regular_cursor;
	commit;


	--index project_char on (fk_char, fk_project) 
	execute immediate
	'CREATE INDEX ICP_FK_CHAR_FK_PROJECT ON project_char(FK_CHAR, FK_PROJECT)
	TABLESPACE storetindx
	STORAGE (INITIAL 2M NEXT 1M)';




	--process biological result data 
	dbms_output.put_line('processing Biological results...');
	v_commit_count := 0;
	open biological_cursor;
	loop
		fetch biological_cursor into v_fk_char,v_fk_project,v_fk_org,v_org_id,v_project_id,v_project_name,v_characteristic_name,v_huc,v_act_min_start_date,v_act_max_start_date,v_act_max_start_stop_date,v_result_count;
	     	exit when biological_cursor%NOTFOUND;
		
		 	v_commit_count := v_commit_count + 1;
		 	insert into project_char(fk_char,
	                fk_project,
	                fk_org,
	                organization_id,
	                project_id,
	                project_name,
	                characteristic_name,
	                hydrologic_unit_code,
	                act_min_start_date,
	                act_max_start_date,
	                act_max_start_stop_date,
	                biological_count,
	                result_count)
		 	values
		 	(v_fk_char,
	                 v_fk_project,
	                 v_fk_org,
	                 v_org_id,
	                 v_project_id,
	                 v_project_name,
	                 v_characteristic_name,
	                 v_huc,
	                 v_act_min_start_date,
	                 v_act_max_start_date,
	                 v_act_max_start_stop_date,
	                 v_result_count,
	                 v_result_count);
			
			if (v_commit_count=1000) then
			   v_commit_count := 0;
			   commit;
			end if;
		
		 	 -- get min_act_start_date, max_act_start_date, max_act_start_stop_date 
			 --from project_char
	end loop;
	close biological_cursor;
	commit;

	--process habitat result data 
	dbms_output.put_line('processing habitat results...');
	v_commit_count := 0;
	open habitat_cursor;
	loop
		fetch habitat_cursor into v_fk_char,v_fk_project,v_fk_org,v_org_id,v_project_id,v_project_name,v_characteristic_name,v_huc,v_act_min_start_date,v_act_max_start_date,v_act_max_start_stop_date,v_result_count;
	     	exit when habitat_cursor%NOTFOUND;
		
		 	v_commit_count := v_commit_count + 1;
		 	insert into project_char(fk_char,
	                fk_project,
	                fk_org,
	                organization_id,
	                project_id,
	                project_name,
	                characteristic_name,
	                hydrologic_unit_code,
	                act_min_start_date,
	                act_max_start_date,
	                act_max_start_stop_date,
	                habitat_count,
	                result_count)
		 	values
		 	(v_fk_char,
	                 v_fk_project,
	                 v_fk_org,
	                 v_org_id,
	                 v_project_id,
	                 v_project_name,
	                 v_characteristic_name,
	                 v_huc,
	                 v_act_min_start_date,
	                 v_act_max_start_date,
	                 v_act_max_start_stop_date,
	                 v_result_count,
	                 v_result_count);
			
			if (v_commit_count=1000) then
			   v_commit_count := 0;
			   commit;
			end if;
		
		 	 -- get min_act_start_date, max_act_start_date, max_act_start_stop_date 
			 --from project_char
	end loop;
	close habitat_cursor;
	commit;




	--create indexes on project_char 
        execute immediate 
	'CREATE INDEX ICP_ORGID ON project_char(ORGANIZATION_ID)
	TABLESPACE storetindx
	STORAGE (INITIAL 2M NEXT 1M)';
        
        execute immediate 
	'CREATE INDEX ICP_ORGID_PROJ ON project_char(ORGANIZATION_ID, PROJECT_ID)
	TABLESPACE storetindx
	STORAGE (INITIAL 2M NEXT 1M)';
        
         execute immediate 
	'CREATE INDEX ICP_HUC ON project_char(HYDROLOGIC_UNIT_CODE)
	TABLESPACE storetindx
	STORAGE (INITIAL 2M NEXT 1M)';
        
        execute immediate 
	'CREATE INDEX ICP_ORG_HUC ON project_char(ORGANIZATION_ID,HYDROLOGIC_UNIT_CODE)
	TABLESPACE storetindx
	STORAGE (INITIAL 2M NEXT 1M)';
        
        
        
        
        
        execute immediate 
	'CREATE INDEX ICP_FK_ORG ON project_char(FK_ORG)
	TABLESPACE storetindx
	STORAGE (INITIAL 2M NEXT 1M)';
        
        
	execute immediate 
	'CREATE INDEX ICP_FK_CHAR ON project_char(FK_CHAR)
	TABLESPACE storetindx
	STORAGE (INITIAL 2M NEXT 1M)';

	execute immediate 
	'CREATE INDEX ICP_FK_PROJECT ON project_char(FK_PROJECT)
	TABLESPACE storetindx
	STORAGE (INITIAL 2M NEXT 1M)';
        
	update di_project p
	set (Project_POR_start, Project_POR_end)= (select min(act_min_start_date),max(act_max_start_stop_date)
	           from project_char pc
	           where pc.fk_project = p.pk_isn);
	commit;
	dbms_output.put_line('Processed DI_PROJECT update ...');
        

	exception when OTHERS then
	--status := 'failed';
	dbms_output.put_line(sqlcode ||' ' ||sqlerrm);
        
end;
/
show errors


EXEC SP_REFRESH_PROJ_CHAR;

        
        
        
