
/***********************************************************************
Script			: ws_org_activity.sql 
Description		: Populates data into ws_org_activity 
Author			: Jyothi Lavisetty 
Created Date	: 05/15/2009  
Comments		:  
Alter ws_org_activity table to add more columns for getResults outbound service.
Modified the refresh script for additional data columns.
***********************************************************************/ 
spool ws_org_activity.log
set serveroutput on;

alter table ws_org_activity add (activity_matrix varchar2(256), activity_depth varchar2(256),
activity_depth_unit varchar2(256), activity_upper_depth varchar2(256), upr_lwr_depth_unit varchar2(256),
activity_lower_depth varchar2(256), activity_depth_ref_point varchar2(256),
activity_cond_org_text varchar2(256));

CREATE OR REPLACE
procedure sp_refresh_ws_org_activity as
--regular result cursor
cursor regular_result_data_cur is
select distinct organization_id, station_id, activity_id,
activity_type, activity_medium, activity_start_date_time as activity_start_date_time,
di_statn_types.primary_type as station_type, activity_matrix, activity_depth, 
activity_depth_unit, activity_upper_depth, upr_lwr_depth_unit, activity_lower_depth, 
activity_depth_ref_point, activity_cond_org_text
from fa_regular_result left join di_statn_types
on fa_regular_result.fk_statn_types = di_statn_types.pk_isn
order by organization_id, station_id, activity_id;

--biological result cursor
cursor biological_result_data_cur is
select distinct Organization_id, station_id, activity_id,
Activity_Type, Activity_Medium, Activity_Start_Date_Time as Activity_Start_Date_Time,
di_statn_types.primary_type as station_type, null as activity_matrix, activity_depth,
activity_depth_unit, activity_upper_depth, upr_lwr_depth_unit, activity_lower_depth,
activity_depth_ref_point, activity_cond_org_text
from fa_biological_result left join di_statn_types
on fa_biological_result.fk_statn_types = di_statn_types.pk_isn
order by organization_id, station_id, activity_id;

--habitat result cursor
cursor habitat_result_data_cur is
select distinct Organization_id, station_id, activity_id,
Activity_Type, null as Activity_Medium, Activity_Start_Date_Time as Activity_Start_Date_Time,
di_statn_types.primary_type as station_type, null as activity_matrix, null as activity_depth,
null as activity_depth_unit, null as activity_upper_depth, null as upr_lwr_depth_unit, 
null as activity_lower_depth, activity_depth_ref_point, activity_cond_org_text
from fa_habitat_result left join di_statn_types
on fa_habitat_result.fk_statn_types = di_statn_types.pk_isn
order by organization_id, station_id, activity_id;


v_organization_id		varchar2(256 byte);
v_station_id			varchar2(256 byte);
v_station_type			varchar2(256 byte);
v_activity_id			varchar2(256 byte);
v_activity_type			varchar2(256 byte);
v_activity_medium		varchar2(20 char);
v_activity_start_date	date;
v_insert_count			number(12);  
v_activity_matrix               varchar2(256 byte);
v_activity_depth                varchar2(256 byte);
v_activity_depth_unit           varchar2(256 byte);
v_activity_upper_depth          varchar2(256 byte);
v_upr_lwr_depth_unit            varchar2(256 byte);
v_activity_lower_depth          varchar2(256 byte);
v_activity_depth_ref_point      varchar2(256 byte);
v_activity_cond_org_text        varchar2(256 byte);

begin

-- truncate ws_org_activity
begin
execute immediate 'truncate table ws_org_activity';
exception when others then null;
end;

-- drop indexes
begin

execute immediate 'drop index IWS_ORG_ACTIVITY_FN_ORG_ACT';
execute immediate 'drop index IWS_ORG_ACT_FN_ORG_STN_ACT';

exception when others then null;
end;

--insert data into ws_org_activity, while committing after every 1000 inserts
v_insert_count := 0;

-- insert regualr data into ws_org_activity
open regular_result_data_cur;
loop
	fetch regular_result_data_cur into
	v_organization_id, v_station_id,
	v_activity_id, v_activity_type,
	v_activity_medium, v_activity_start_date,
	v_station_type, v_activity_matrix,
        v_activity_depth, v_activity_depth_unit,
        v_activity_upper_depth, v_upr_lwr_depth_unit,
        v_activity_lower_depth, v_activity_depth_ref_point,
        v_activity_cond_org_text;
	exit when regular_result_data_cur%NOTFOUND;

	insert into ws_org_activity
	(organization_id, station_id,
	station_type, activity_id, activity_type,
	activity_medium, activity_start_date, Result_Type,
        activity_matrix, activity_depth, activity_depth_unit,
        activity_upper_depth, upr_lwr_depth_unit, activity_lower_depth,
        activity_depth_ref_point, activity_cond_org_text)
	values
	(v_organization_id, v_station_id,
	 v_station_type, v_activity_id, v_activity_type,
	 v_activity_medium, v_activity_start_date, 'R',
         v_activity_matrix, v_activity_depth, v_activity_depth_unit,
         v_activity_upper_depth, v_upr_lwr_depth_unit,
         v_activity_lower_depth, v_activity_depth_ref_point, v_activity_cond_org_text);

	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;

end loop;
close regular_result_data_cur;
commit;

-- insert biological data into ws_org_activity
open biological_result_data_cur;
loop
	fetch biological_result_data_cur into
	v_organization_id, v_station_id,
	v_activity_id, v_activity_type,
	v_activity_medium, v_activity_start_date,
	v_station_type, v_activity_matrix,
        v_activity_depth, v_activity_depth_unit,
        v_activity_upper_depth, v_upr_lwr_depth_unit,
        v_activity_lower_depth, v_activity_depth_ref_point,
        v_activity_cond_org_text;
	exit when biological_result_data_cur%NOTFOUND;

	insert into ws_org_activity
	(organization_id, station_id,
	station_type, activity_id, activity_type,
	activity_medium, activity_start_date, Result_Type,
        activity_matrix, activity_depth, activity_depth_unit,
        activity_upper_depth, upr_lwr_depth_unit, activity_lower_depth,
        activity_depth_ref_point, activity_cond_org_text)
	values
	(v_organization_id, v_station_id,
	 v_station_type, v_activity_id, v_activity_type,
	 v_activity_medium, v_activity_start_date, 'B',
         v_activity_matrix, v_activity_depth, v_activity_depth_unit,
         v_activity_upper_depth, v_upr_lwr_depth_unit,
         v_activity_lower_depth, v_activity_depth_ref_point, v_activity_cond_org_text);

	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;

end loop;
close biological_result_data_cur;
commit;

-- insert habitat data in to ws_org_activity
open habitat_result_data_cur;
loop
	fetch habitat_result_data_cur into
	v_organization_id, v_station_id,
	v_activity_id, v_activity_type,
	v_activity_medium, v_activity_start_date,
	v_station_type, v_activity_matrix,
        v_activity_depth, v_activity_depth_unit,
        v_activity_upper_depth, v_upr_lwr_depth_unit,
        v_activity_lower_depth, v_activity_depth_ref_point,
        v_activity_cond_org_text;
	exit when habitat_result_data_cur%NOTFOUND;

	insert into ws_org_activity
	(organization_id, station_id,
	station_type, activity_id, activity_type,
	activity_medium, activity_start_date, Result_Type,
        activity_matrix, activity_depth, activity_depth_unit,
        activity_upper_depth, upr_lwr_depth_unit, activity_lower_depth,
        activity_depth_ref_point, activity_cond_org_text)
	values
	(v_organization_id, v_station_id,
	 v_station_type, v_activity_id, v_activity_type,
	 v_activity_medium, v_activity_start_date, 'H',
         v_activity_matrix, v_activity_depth, v_activity_depth_unit,
         v_activity_upper_depth, v_upr_lwr_depth_unit,
         v_activity_lower_depth, v_activity_depth_ref_point, v_activity_cond_org_text);

	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;

end loop;
close habitat_result_data_cur;
commit;

begin
execute immediate 'CREATE INDEX IWS_ORG_ACTIVITY_FN_ORG_ACT ON WS_ORG_ACTIVITY (LOWER(TRIM(ORGANIZATION_ID)), ACTIVITY_ID) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;


begin
execute immediate 'CREATE INDEX IWS_ORG_ACT_FN_ORG_STN_ACT ON WS_ORG_ACTIVITY (LOWER(TRIM(ORGANIZATION_ID)), LOWER(TRIM(STATION_ID)), ACTIVITY_ID) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;

end;
/
show errors;

select count(*) from ws_org_activity;
exec sp_refresh_ws_org_activity;
select count(*) from ws_org_activity; 

spool off;
