/***********************************************************************
Script			: ws_org_activity_project.sql 
Description		: Populates data into ws_org_activity_project  
Author			: Sree Rayankula 
Created Date	: 06/13/2007 
Comments		: 
***********************************************************************/ 
spool 'ws_org_activity_project.log'
set serveroutput on;

drop table ws_org_activity_project;

create table ws_org_activity_project
(ORGANIZATION_ID 	varchar2 (256 byte),
ACTIVITY_ID			varchar2 (256 byte),
PROJECT_CD			varchar2 (256 char))
tablespace storetdata  
storage (initial 20M next 5M)
nologging;

create or replace procedure sp_refresh_ws_org_act_proj as
--regular result cursor 
cursor regular_result_data_cur is 
select distinct fa_regular_result.organization_id, 
	   fa_regular_result.activity_id, di_project.project_cd
from fa_regular_result, regular_result_project, di_project
where fa_regular_result.pk_isn = regular_result_project.fk_result
  and di_project.pk_isn = regular_result_project.fk_project
group by organization_id, activity_id, project_cd
order by organization_id, activity_id, project_cd;

--biological result cursor 
cursor biological_result_data_cur is 
select distinct fa_biological_result.organization_id, 
	   fa_biological_result.activity_id, di_project.project_cd
from fa_biological_result, biological_result_project, di_project
where fa_biological_result.pk_isn = biological_result_project.fk_result
  and di_project.pk_isn = biological_result_project.fk_project
group by organization_id, activity_id, project_cd
order by organization_id, activity_id, project_cd;

--habitat result cursor 
cursor habitat_result_data_cur is 
select distinct fa_habitat_result.organization_id, 
	   fa_habitat_result.activity_id, di_project.project_cd
from fa_habitat_result, habitat_result_project, di_project
where fa_habitat_result.pk_isn = habitat_result_project.fk_result
  and di_project.pk_isn = habitat_result_project.fk_project
group by organization_id, activity_id, project_cd
order by organization_id, activity_id, project_cd;

v_organization_id		varchar2(256 byte);
v_activity_id			varchar2(256 byte);
v_project_cd			varchar2(256 char);
v_insert_count			number(12);

begin

-- truncate ws_org_activity_project 
begin
execute immediate 'truncate table ws_org_activity_project';
exception when others then null;
end;

-- drop indexes 
begin
execute immediate 'drop index iws_org_act_proj_org_id_act_id';
execute immediate 'drop index iws_org_act_proj_org_id_proj_cd';
execute immediate 'drop index iws_org_act_proj_org_proj_cd';
execute immediate 'drop index IWS_ORG_ACT_PROJ_FN_ORG_ID';
exception when others then null;
end;

--insert data into ws_org_activity_project, while committing after every 1000 inserts 
v_insert_count := 0;

-- insert regualr data into ws_org_activity_project 
open regular_result_data_cur;
loop
	fetch regular_result_data_cur into
	v_organization_id, v_activity_id, v_project_cd;
	exit when regular_result_data_cur%NOTFOUND;
	
	insert into ws_org_activity_project
	(organization_id, activity_id, project_cd)
	values
	(v_organization_id,	v_activity_id, v_project_cd);
	
	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;	
	
end loop;
close regular_result_data_cur;
commit;

-- insert biological data into ws_org_activity 
open biological_result_data_cur;
loop
	fetch biological_result_data_cur into
	v_organization_id, v_activity_id, v_project_cd;
	exit when biological_result_data_cur%NOTFOUND;
	
	insert into ws_org_activity_project
	(organization_id, activity_id, project_cd)
	values
	(v_organization_id,	v_activity_id, v_project_cd);
	
	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;	
	
end loop;
close biological_result_data_cur;
commit;

-- insert habitat data in to ws_org_activity 
open habitat_result_data_cur;
loop
	fetch habitat_result_data_cur into
	v_organization_id, v_activity_id, v_project_cd;
	exit when habitat_result_data_cur%NOTFOUND;
	
	insert into ws_org_activity_project
	(organization_id, activity_id, project_cd)
	values
	(v_organization_id,	v_activity_id, v_project_cd);
	
	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;	
	
end loop;
close habitat_result_data_cur;
commit;

begin
execute immediate 'create index iws_org_act_proj_org_id_act_id on ' ||
'ws_org_activity_project(organization_id, activity_id) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;

begin
execute immediate 'create index iws_org_act_proj_org_id_proj_cd on ' ||
'ws_org_activity_project(lower(trim(organization_id)), lower(trim(project_cd))) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;

begin
execute immediate 'create index iws_org_act_proj_org_proj_cd on ' ||
'ws_org_activity_project(organization_id, lower(trim(project_cd))) '||
'tablespace storetindx ' ||
'storage (initial 5M next 5M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX IWS_ORG_ACT_PROJ_FN_ORG_ID ON WS_ORG_ACTIVITY_PROJECT(lower(trim(ORGANIZATION_ID))) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then null;
end;

end;
/
show errors;

select count(*) from ws_org_activity_project;
exec sp_refresh_ws_org_act_proj;
select count(*) from ws_org_activity_project; 

spool off;
